/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.service.impl.UsaCitDeclareReportHideImpl;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service.DeclareReportImportService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.helper.TaxcCombineBusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcyear.TaxcYearDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class AbstractOverseasReportImportService
implements DeclareReportImportService {
    public static final String DRAFT_PURPOSE_KEY = "tpo_declare_main_tsd#draftpurpose";
    public static final List<String> ZZS = Arrays.asList("USA-SUT", "USA-GRT", "GBR-VAT", "DEU-VAT", "JAP-CT", "SGP-GST", "AUS-GST");
    public static final List<String> SDS = Arrays.asList("GBR-CIT", "DEU-CIT", "JAP-CIT", "SGP-CIT", "AUS-CIT", "HKG-CIT", "USA-CIT");

    @Override
    public void initImportData(ImportDataVo importDataVo, Map<String, String> resultMap) {
        if (!resultMap.containsKey(DRAFT_PURPOSE_KEY)) {
            resultMap.put(DRAFT_PURPOSE_KEY, "nssb");
        }
    }

    @Override
    public ValidDataResultVo validExcelData(Map<String, String> excelDataMap, DynamicObject templateContent) {
        StringBuilder buffer = this.chekExcelData(excelDataMap, templateContent);
        if (StringUtils.isNotBlank((CharSequence)buffer)) {
            return ValidDataResultVo.fail((String)buffer.toString());
        }
        return ValidDataResultVo.success();
    }

    private StringBuilder chekExcelData(Map<String, String> excelDataMap, DynamicObject templateContent) {
        QFilter taxCategoryFilter;
        DynamicObject taxtypeDyo;
        String orgNumKey = "tpo_declare_main_tsd#orgnumber";
        String orgIdKey = "tpo_declare_main_tsd#org";
        String taxSystemKey = "tpo_declare_main_tsd#taxsystem";
        String taxtypeKey = "tpo_declare_main_tsd#taxtype";
        String taxareagroupKey = "tpo_declare_main_tsd#taxareagroup";
        String orgNum = excelDataMap.get(orgNumKey);
        String taxsystem = excelDataMap.get(taxSystemKey);
        String taxtype = excelDataMap.get(taxtypeKey);
        String taxareagroup = excelDataMap.get(taxareagroupKey);
        String purpose = excelDataMap.get(DRAFT_PURPOSE_KEY);
        String orgId = excelDataMap.get(orgIdKey);
        StringBuilder buffer = new StringBuilder();
        if (StringUtil.isEmpty((CharSequence)orgNum)) {
            buffer.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractOverseasReportImportService_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return buffer;
        }
        if (StringUtil.isEmpty((CharSequence)taxsystem)) {
            buffer.append(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractOverseasReportImportService_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return buffer;
        }
        if (StringUtil.isEmpty((CharSequence)taxtype)) {
            buffer.append(ResManager.loadKDString((String)"\u7a0e\u79cd\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractOverseasReportImportService_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return buffer;
        }
        if (StringUtil.isEmpty((CharSequence)taxareagroup)) {
            buffer.append(ResManager.loadKDString((String)"\u7a0e\u6536\u8f96\u533a\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractOverseasReportImportService_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return buffer;
        }
        if (StringUtil.isEmpty((CharSequence)purpose)) {
            buffer.append(ResManager.loadKDString((String)"\u5e95\u7a3f\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractOverseasReportImportService_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return buffer;
        }
        List<Long> taxorgIds = AbstractOverseasReportImportService.queryValidTaxOrg();
        if (!taxorgIds.contains(Long.parseLong(orgId))) {
            buffer.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u4e0d\u53ef\u7528\u6216\u65e0\u6743\u9650", (String)"AbstractOverseasReportImportService_5", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgNum));
            return buffer;
        }
        List<Long> sysByBasTaxOrg = AbstractOverseasReportImportService.queryTaxcMainByOrgIds(Long.parseLong(orgId), TaxationsysMappingEnum.CHN.getId(), false);
        if (!sysByBasTaxOrg.contains(Long.parseLong(taxsystem))) {
            buffer.append(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u7a0e\u6536\u5236\u5ea6", (String)"AbstractOverseasReportImportService_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return buffer;
        }
        List<Long> taxCategories = AbstractOverseasReportImportService.queryHwsCategoryByOrgId(Long.parseLong(orgId), Long.parseLong(taxsystem));
        if (!taxCategories.contains(Long.parseLong(taxtype))) {
            buffer.append(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5bf9\u5e94\u7684\u7a0e\u6536\u5236\u5ea6\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u7a0e\u79cd", (String)"AbstractOverseasReportImportService_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return buffer;
        }
        List<Long> sysTaxAreaIds = AbstractOverseasReportImportService.queryHwsTaxAreaByOrgId(Long.parseLong(orgId), Long.parseLong(taxsystem), Long.parseLong(taxtype));
        if (Long.parseLong(taxsystem) == 1636078644810086400L && Long.parseLong(taxtype) == 1641488655174373376L && Long.parseLong(taxareagroup) != 1616686278185582592L) {
            buffer.append(ResManager.loadKDString((String)"\u7a0e\u6536\u8f96\u533a\u9700\u4e3a\u7f8e\u56fd", (String)"AbstractOverseasReportImportService_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return buffer;
        }
        if (Long.parseLong(taxsystem) == 1636078644810086400L && Long.parseLong(taxtype) == 1641488655174373376L && Long.parseLong(taxareagroup) == 1616686278185582592L) {
            List<Long> longs = AbstractOverseasReportImportService.queryHwsTaxAreaByOrgId(Long.parseLong(orgId), Long.parseLong(taxsystem), 1682650334692126720L);
            if (longs.contains(1681071243350195200L)) {
                sysTaxAreaIds.add(1681071243350195200L);
            }
            QFilter filter = new QFilter("id", "in", sysTaxAreaIds);
            DynamicObjectCollection taxareagroupList = QueryServiceHelper.query((String)"bastax_taxareagroup", (String)"id,name", (QFilter[])filter.toArray());
            Map<String, Long> taxareagroupMap = taxareagroupList.stream().collect(Collectors.toMap(k -> k.getString("name"), v -> v.getLong("id"), (k1, k2) -> k1));
            Set sheetNameFromExcel = excelDataMap.keySet().stream().filter(m -> m.contains("#")).map(m -> m.split("#")[0]).collect(Collectors.toSet());
            List excelSheetNames = UsaCitDeclareReportHideImpl.ALL_VALUEABLE_AREA_LIST.stream().filter(sheetNameFromExcel::contains).collect(Collectors.toList());
            excelSheetNames.remove("Federation");
            excelSheetNames.remove("State income tax overview");
            if (excelSheetNames.remove("Texas (FT)")) {
                excelSheetNames.add("Texas");
            }
            if (!taxareagroupMap.keySet().containsAll(excelSheetNames)) {
                buffer.append(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5bf9\u5e94\u7684\u7a0e\u6536\u5236\u5ea6\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u7a0e\u6536\u8f96\u533a", (String)"AbstractOverseasReportImportService_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return buffer;
            }
        } else if (CollectionUtils.isEmpty(sysTaxAreaIds) || !sysTaxAreaIds.contains(Long.parseLong(taxareagroup))) {
            buffer.append(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5bf9\u5e94\u7684\u7a0e\u6536\u5236\u5ea6\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u7a0e\u6536\u8f96\u533a", (String)"AbstractOverseasReportImportService_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return buffer;
        }
        if ((taxtypeDyo = QueryServiceHelper.queryOne((String)"bd_taxcategory", (String)"number", (QFilter[])new QFilter[]{taxCategoryFilter = new QFilter("id", "=", (Object)Long.parseLong(taxtype))})) != null) {
            List<String> numbers;
            String number = taxtypeDyo.getString("number");
            String typeNumber = templateContent.getString("type.number");
            List<String> list = numbers = "Overseas_CIT".equalsIgnoreCase(typeNumber) || "USA_CIT".equalsIgnoreCase(typeNumber) ? SDS : ZZS;
            if (!numbers.contains(number)) {
                buffer.append(ResManager.loadKDString((String)"\u7a0e\u79cd\u586b\u5199\u6709\u8bef", (String)"AbstractOverseasReportImportService_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return buffer;
            }
        }
        String skssqq = excelDataMap.get(MultiTableEnum.TSD001.getDeclareMainTable() + "#skssqq");
        String skssqz = excelDataMap.get(MultiTableEnum.TSD001.getDeclareMainTable() + "#skssqz");
        Date startDate = DateUtils.stringToDate((String)skssqq);
        Date endDate = DateUtils.stringToDate((String)skssqz);
        Date newStartDate = AbstractOverseasReportImportService.getTaxPeriodStartDate(Long.parseLong(orgId), Long.parseLong(taxsystem), Long.parseLong(taxtype));
        ImmutablePair<Date, Date> dateImmutablePair = this.calDate(newStartDate, startDate, endDate, purpose);
        if ("nssb".equalsIgnoreCase(purpose)) {
            List<String> taxLimits = AbstractOverseasReportImportService.queryHwsTaxlimitByOrgId(Long.parseLong(orgId), Long.parseLong(taxsystem), Long.parseLong(taxtype), Long.parseLong(taxareagroup));
            boolean validDate = this.checkPeriod(taxLimits, (Date)dateImmutablePair.left, (Date)dateImmutablePair.right);
            if (!validDate) {
                buffer.append(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u4e0e\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7684\u7eb3\u7a0e\u5468\u671f\u4e0d\u4e00\u81f4", (String)"AbstractOverseasReportImportService_11", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return buffer;
            }
        } else if ("sjjt".equalsIgnoreCase(purpose)) {
            boolean validDate;
            List<String> jtPlanList = AbstractOverseasReportImportService.queryAllJtPlanBySharePlan(Long.parseLong(orgId), Long.parseLong(taxsystem), Long.parseLong(taxtype), Long.parseLong(taxareagroup), startDate, endDate);
            if (CollectionUtils.isEmpty(jtPlanList)) {
                buffer.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u8ba1\u63d0\u65b9\u6848\u3002", (String)"AbstractOverseasReportImportService_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return buffer;
            }
            ArrayList<String> taxLimits = new ArrayList<String>(8);
            if (ObjectUtils.isNotEmpty(jtPlanList)) {
                if (jtPlanList.contains("month")) {
                    taxLimits.add("month");
                }
                if (jtPlanList.contains("season")) {
                    taxLimits.add("season");
                }
                if (jtPlanList.contains("halfyear")) {
                    taxLimits.add("halfyear");
                }
                if (jtPlanList.contains("year")) {
                    taxLimits.add("year");
                }
            }
            if (!(validDate = this.checkPeriod(taxLimits, (Date)dateImmutablePair.left, (Date)dateImmutablePair.right))) {
                buffer.append(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u4e0e\u8ba1\u63d0\u65b9\u6848\u7684\u8ba1\u63d0\u5468\u671f\u4e0d\u4e00\u81f4", (String)"AbstractOverseasReportImportService_13", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return buffer;
            }
        }
        return buffer;
    }

    public static List<String> queryAllJtPlanBySharePlan(Long orgId, Long taxationsysId, Long categoryId, Long taxareaId, Date skssqq, Date skssqz) {
        ArrayList<String> jtPlanList = new ArrayList<String>(3);
        if (ObjectUtils.isEmpty((Object)orgId) || ObjectUtils.isEmpty((Object)taxationsysId) || ObjectUtils.isEmpty((Object)categoryId) || ObjectUtils.isEmpty((Object)taxareaId) || ObjectUtils.isEmpty((Object)skssqq) || ObjectUtils.isEmpty((Object)skssqz)) {
            return jtPlanList;
        }
        Map<String, Set<Long>> planByOrgIds = AbstractOverseasReportImportService.querySharePlanByOrgIds(Collections.singletonList(orgId), taxationsysId, categoryId, taxareaId, skssqq, skssqz);
        Set<Map.Entry<String, Set<Long>>> entries = planByOrgIds.entrySet();
        for (Map.Entry<String, Set<Long>> next : entries) {
            Set<Long> longSet = next.getValue();
            if (!longSet.contains(orgId)) continue;
            String nextKey = next.getKey();
            String[] split = nextKey.split("-");
            jtPlanList.add(split[3]);
        }
        return jtPlanList;
    }

    public static Map<String, Set<Long>> querySharePlanByOrgIds(List<Long> orgList, Long taxationsysId, Long categoryId, Long taxareaId, Date skssqq, Date skssqz) {
        HashMap<String, Set<Long>> planMap = new HashMap<String, Set<Long>>(12);
        if (ObjectUtils.isEmpty(orgList) || ObjectUtils.isEmpty((Object)taxationsysId) || ObjectUtils.isEmpty((Object)categoryId) || ObjectUtils.isEmpty((Object)taxareaId) || ObjectUtils.isEmpty((Object)skssqq) || ObjectUtils.isEmpty((Object)skssqz)) {
            return planMap;
        }
        List sharePlans = (List)ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIds(orgList).getData();
        for (DynamicObject sharePlan : sharePlans) {
            DynamicObjectCollection orgentity = sharePlan.getDynamicObjectCollection("orgentity");
            ArrayList<Long> orgs = new ArrayList<Long>(8);
            for (DynamicObject org : orgentity) {
                if (!orgList.contains(org.getDynamicObject("org").getLong("id"))) continue;
                orgs.add(org.getDynamicObject("org").getLong("id"));
            }
            DynamicObjectCollection ruleentity = sharePlan.getDynamicObjectCollection("ruleentity");
            for (DynamicObject rule : ruleentity) {
                DynamicObject plan = rule.getDynamicObject("rule");
                String taxsystem = plan.getString("taxsystem.id");
                String taxarea = plan.getString("taxarea.id");
                String taxtype = plan.getString("taxtype.id");
                Date beginTime = kd.taxc.bdtaxr.common.utils.date.DateUtils.trunc((Date)plan.getDate("startdate"), (String)"yyyy-MM-dd");
                Date endTime = kd.taxc.bdtaxr.common.utils.date.DateUtils.trunc((Date)plan.getDate("enddate"), (String)"yyyy-MM-dd");
                Date[] dates = kd.taxc.bdtaxr.common.utils.date.DateUtils.getIntersectionDate((Date)beginTime, (Date)endTime, (Date)skssqq, (Date)skssqz);
                if (!taxationsysId.toString().equalsIgnoreCase(taxsystem) || !taxareaId.toString().equalsIgnoreCase(taxarea) || !categoryId.toString().equalsIgnoreCase(taxtype) || !ObjectUtils.isNotEmpty((Object)dates)) continue;
                String cycle = plan.getString("cycle");
                String planMapKey = String.format("%s-%s-%s-%s", taxsystem, taxarea, taxtype, cycle);
                Set planOrgs = planMap.computeIfAbsent(planMapKey, d -> new HashSet());
                planOrgs.addAll(orgs);
            }
        }
        return planMap;
    }

    private boolean checkPeriod(List<String> periodTypes, Date skssqq, Date skssqz) {
        boolean validDate = false;
        Iterator<String> iterator = periodTypes.iterator();
        block12: while (iterator.hasNext()) {
            String type;
            switch (type = iterator.next()) {
                case "year": {
                    Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)skssqz);
                    Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)skssqq);
                    if (firstDateOfYear.compareTo(skssqq) != 0 || !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfYear))) continue block12;
                    validDate = true;
                    continue block12;
                }
                case "halfyear": {
                    Date firstDateOfHalfYear = DateUtils.getFirstDateOfHalfYear((Date)skssqq);
                    Date lastDateOfHalfYear = DateUtils.getLastDateOfHalfYear((Date)skssqq);
                    if (firstDateOfHalfYear.compareTo(skssqq) != 0 || !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfHalfYear))) continue block12;
                    validDate = true;
                    continue block12;
                }
                case "season": {
                    Date firstDateOfSeason = DateUtils.getFirstDateOfSeason((Date)skssqq);
                    Date lastDateOfSeason = DateUtils.getLastDateOfSeason((Date)skssqq);
                    if (!DateUtils.format((Date)skssqq).equals(DateUtils.format((Date)firstDateOfSeason)) || !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfSeason))) continue block12;
                    validDate = true;
                    continue block12;
                }
                case "first_three_quarter": {
                    Date firstDate = DateUtils.getFirstDateOfYear((Date)skssqq);
                    Date endDate = DateUtils.addMonth((Date)firstDate, (int)8);
                    endDate = DateUtils.getDayFirst((Date)DateUtils.getLastDateOfMonth((Date)endDate));
                    if (!DateUtils.format((Date)skssqq).equals(DateUtils.format((Date)firstDate)) || !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)endDate))) continue block12;
                    validDate = true;
                    continue block12;
                }
            }
            Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)skssqq);
            if (!DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfMonth))) continue;
            validDate = true;
        }
        return validDate;
    }

    private ImmutablePair<Date, Date> calDate(Date taxYearStartDate, Date modelStartDate, Date modelEndDate, String draftpouse) {
        if (taxYearStartDate == null || modelStartDate == null || modelEndDate == null) {
            return ImmutablePair.of(null, null);
        }
        if ("sjjt".equals(draftpouse)) {
            return ImmutablePair.of((Object)modelStartDate, (Object)modelEndDate);
        }
        int monthInt = 1 - DateUtils.getMonthOfDate((Date)taxYearStartDate);
        int dataInt = 1 - DateUtils.getDayOfDate((Date)taxYearStartDate);
        Date offSetStartDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)modelStartDate, (int)monthInt), (int)dataInt);
        Integer monthBetweenInOneYear = this.getMonthBetweenInOneYear(modelStartDate, modelEndDate);
        if (monthBetweenInOneYear != null) {
            Date offSetEndDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)offSetStartDate, (int)monthBetweenInOneYear), (int)-1);
            return ImmutablePair.of((Object)offSetStartDate, (Object)offSetEndDate);
        }
        return ImmutablePair.of(null, null);
    }

    public Integer getMonthBetweenInOneYear(Date minDate, Date maxDate) {
        int result;
        if (minDate == null || maxDate == null || maxDate.compareTo(minDate) <= 0) {
            return null;
        }
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        min.setTime(minDate);
        max.setTime(maxDate);
        for (result = 0; min.before(max) && result < 12; ++result) {
            min.add(2, 1);
        }
        min.add(5, -1);
        if (result <= 12 && min.equals(max)) {
            return result;
        }
        return null;
    }

    public static Date getTaxPeriodStartDate(Long orgId, Long taxSysId, Long taxTypeId) {
        Map rowMap;
        List resultList;
        Date newStartDate = null;
        if (orgId == 0L || taxSysId == null || taxSysId == 0L) {
            return newStartDate;
        }
        ArrayList list = new ArrayList();
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("key_orgId", orgId);
        map.put("key_taxationsysId", taxSysId);
        map.put("key_taxcategoryId", taxTypeId);
        list.add(map);
        TaxResult taxResult = TaxcYearDataServiceHelper.queryTaxcyearsByPriority(list);
        if (taxResult.isSuccess() && ObjectUtils.isNotEmpty((Object)(resultList = (List)taxResult.getData())) && ObjectUtils.isNotEmpty((Object)(rowMap = (Map)resultList.get(0))) && ObjectUtils.isNotEmpty(rowMap.get("key_taxyear"))) {
            newStartDate = ((DynamicObject)rowMap.get("key_taxyear")).getDate("startdate");
        }
        return newStartDate;
    }

    public static List<String> queryHwsTaxlimitByOrgId(Long orgId, Long taxationsysId, Long categoryId, Long taxAreaId) {
        ArrayList<String> resultList = new ArrayList<String>(4);
        if (categoryId == 1641488655174373376L) {
            return Collections.singletonList("year");
        }
        TaxResult listTaxResult = TaxcMainDataServiceHelper.queryHwsTaxlimitByOrgId((Long)orgId, (Long)taxationsysId, (Long)categoryId, (Long)taxAreaId, (boolean)true);
        if (ObjectUtils.isNotEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && ObjectUtils.isNotEmpty((Object)listTaxResult.getData())) {
            String[] splits = ((String)((List)listTaxResult.getData()).get(0)).split(",");
            Arrays.stream(splits).forEach(s -> {
                if (ObjectUtils.isNotEmpty((Object)s)) {
                    resultList.add((String)s);
                }
            });
        }
        return resultList;
    }

    public static List<Long> queryValidTaxOrg() {
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId(), (Long)1L, (boolean)false);
        if (StringUtil.equalsIgnoreCase((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            return (List)taxResult.getData();
        }
        return new ArrayList<Long>();
    }

    public static List<Long> queryTaxcMainByOrgIds(Long orgIds, Long taxationsysId, boolean isIncludeTaxationsys) {
        ArrayList<Long> resultList = new ArrayList<Long>(12);
        TaxResult listTaxResult = TaxcCombineBusinessDataServiceHelper.queryTaxcMaintaxationsysIdsByOrgIds(Collections.singletonList(orgIds));
        if (!ObjectUtils.isEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
            List sysIds = (List)listTaxResult.getData();
            if (!isIncludeTaxationsys) {
                sysIds.remove(taxationsysId);
            }
            return sysIds;
        }
        return resultList;
    }

    public static List<Long> queryHwsCategoryByOrgId(Long orgId, Long taxationsysId) {
        if (orgId == null || orgId == 0L || taxationsysId == null || taxationsysId == 0L) {
            return new ArrayList<Long>();
        }
        TaxResult taxResult = TaxcMainDataServiceHelper.queryHwsCategoryByOrgId((Long)orgId, (Long)taxationsysId);
        if (ObjectUtils.isNotEmpty((Object)taxResult) && taxResult.isSuccess() && ObjectUtils.isNotEmpty((Object)taxResult.getData())) {
            DynamicObject tctbTaxMain = (DynamicObject)taxResult.getData();
            DynamicObjectCollection hwsentryentity = tctbTaxMain.getDynamicObjectCollection("hwsentryentity");
            Set collect = hwsentryentity.stream().filter(o -> o.getBoolean("hwsenable")).map(o -> o.getLong("hwstaxtype.id")).collect(Collectors.toSet());
            return new ArrayList<Long>(collect);
        }
        return new ArrayList<Long>();
    }

    public static List<Long> queryHwsTaxAreaByOrgId(Long orgId, Long taxationsysId, Long taxTypeId) {
        if (orgId == null || orgId == 0L || taxationsysId == null || taxationsysId == 0L || taxTypeId == null || taxTypeId == 0L) {
            return new ArrayList<Long>();
        }
        TaxResult taxResult = TaxcMainDataServiceHelper.queryHwsCategoryByOrgId((Long)orgId, (Long)taxationsysId);
        if (ObjectUtils.isNotEmpty((Object)taxResult) && taxResult.isSuccess() && ObjectUtils.isNotEmpty((Object)taxResult.getData())) {
            DynamicObject tctbTaxMain = (DynamicObject)taxResult.getData();
            HashSet<Long> ids = new HashSet<Long>();
            DynamicObjectCollection hwsentryentity = tctbTaxMain.getDynamicObjectCollection("hwsentryentity");
            for (DynamicObject entity : hwsentryentity) {
                String status = entity.getString("hwsenable");
                Long value = entity.getLong("hwstaxarea.id");
                Long hwsTaxTypeId = entity.getLong("hwstaxtype.id");
                if (!"1".equals(status) || hwsTaxTypeId.compareTo(taxTypeId) != 0) continue;
                ids.add(value);
            }
            return new ArrayList<Long>(ids);
        }
        return new ArrayList<Long>();
    }

    public boolean filterMap(String sheetName, Map.Entry<String, String> entry) {
        if (!entry.getKey().contains(sheetName + "#")) {
            return true;
        }
        if (Arrays.asList(entry.getKey().split("#")).size() != 3) {
            return true;
        }
        return !"0".equals(entry.getKey().split("#")[2]);
    }
}

