/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service.DeclareReportImportService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractSdsjtDeclareReportImportServiceImpl
implements DeclareReportImportService {
    private static Log logger = LogFactory.getLog(AbstractSdsjtDeclareReportImportServiceImpl.class);
    private static final String MAINTABLE = "tpo_declare_main_tsd";
    private static final Map<String, String> cycleMap = new HashMap<String, String>(4);
    private static final Map<String, String> ztType = new HashMap<String, String>(2);

    @Override
    public boolean validateDates(String orgid, String typeId, long templateId, Date skssqq, Date skssqz, Date fregistertime, Map<String, String> resultMap) {
        String isadjustperiod = resultMap.get("tpo_declare_main_tsd#isadjustperiod");
        if (ObjectUtils.isEmpty((Object)isadjustperiod) || !"true".equals(isadjustperiod) && !"false".equals(isadjustperiod)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u8c03\u6574\u671f\u3002", (String)"AbstractSdsjtDeclareReportImportServiceImpl_16", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if (ObjectUtils.isNotEmpty((Object)isadjustperiod) && "true".equals(isadjustperiod)) {
            if (orgid == null || skssqq == null || skssqz == null) {
                return false;
            }
            if (ObjectUtils.isEmpty((Object)resultMap.get("tpo_declare_main_tsd#adjustperiod"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u8c03\u6574\u671f\u95f4\u3002", (String)"AbstractSdsjtDeclareReportImportServiceImpl_15", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            if (skssqq.getTime() == skssqz.getTime() && DateUtils.getLastDateOfYear((Date)skssqq).getTime() == skssqz.getTime()) {
                return true;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u8ba1\u63d0\u671f\u95f4\uff0c\u8c03\u6574\u671f=\u662f\u65f6\uff0c\u8ba1\u63d0\u671f\u95f4\u5e94\u4e3a12\u670831\u65e5~12\u670831\u65e5\u3002", (String)"AbstractSdsjtDeclareReportImportServiceImpl_17", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if (!ObjectUtils.isEmpty((Object)resultMap.get("tpo_declare_main_tsd#adjustperiod"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u8c03\u6574\u671f\u95f4\u3002", (String)"AbstractSdsjtDeclareReportImportServiceImpl_15", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        return false;
    }

    @Override
    public void initImportData(ImportDataVo importDataVo, Map<String, String> resultMap) {
        boolean isadjustperiodFlag;
        String taxSystemKey = "tpo_declare_main_tsd#taxsystem";
        String orgId = importDataVo.getOrgId();
        String taxSystemId = resultMap.get(taxSystemKey);
        String accountSetTypeKey = "tpo_declare_main_tsd#accountsettype";
        resultMap.put("tpo_declare_main_tsd#taxtype", "3");
        String zt = resultMap.get(accountSetTypeKey);
        String isadjustperiod = resultMap.get("tpo_declare_main_tsd#isadjustperiod");
        String skssqq = resultMap.get("tpo_declare_main_tsd#skssqq");
        String skssqz = resultMap.get("tpo_declare_main_tsd#skssqz");
        boolean bl = isadjustperiodFlag = ObjectUtils.isNotEmpty((Object)isadjustperiod) && "true".equals(isadjustperiod);
        if (!isadjustperiodFlag && ObjectUtils.isNotEmpty((Object)taxSystemId) && ObjectUtils.isNotEmpty((Object)orgId) && ObjectUtils.isNotEmpty((Object)zt)) {
            try {
                List<String> planList = this.querySharePlanByOrgIdsAndTaxsystemZt(Collections.singletonList(Long.parseLong(orgId)), Long.parseLong(taxSystemId.toString()), "3", zt, DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz));
                if (!ObjectUtils.isNotEmpty(planList)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u8ba1\u63d0\u65b9\u6848\u3002", (String)"AbstractSdsjtDeclareReportImportServiceImpl_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
                resultMap.put("tpo_declare_main_tsd#taxareagroup", planList.get(0));
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u8ba1\u63d0\u65b9\u6848\u3002", (String)"AbstractSdsjtDeclareReportImportServiceImpl_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public Map<String, String> getDynMapper(String sheetName, List<Map.Entry<String, EntityField>> datas, List<String> dynRowNoList) {
        HashMap<String, String> dynMapper = new HashMap<String, String>(dynRowNoList.size());
        for (Map.Entry<String, EntityField> entry : datas) {
            if (!dynRowNoList.contains(entry.getValue().getEntityId() + "#1")) continue;
            dynMapper.put(entry.getKey(), entry.getValue().getFieldId());
        }
        return dynMapper;
    }

    @Override
    public List<String> getDynRows(Map<String, String> mapper) {
        return mapper.entrySet().stream().map(s -> (String)s.getValue()).collect(Collectors.toList());
    }

    @Override
    public ValidDataResultVo validExcelData(Map<String, String> excelDataMap, DynamicObject templateContent) {
        String OrgNumKey = "tpo_declare_main_tsd#orgnumber";
        String taxSystemKey = "tpo_declare_main_tsd#taxsystem";
        String accountSetTypeKey = "tpo_declare_main_tsd#accountsettype";
        String skssqqKey = "tpo_declare_main_tsd#skssqq";
        String skssqzKey = "tpo_declare_main_tsd#skssqz";
        String templatetypeKey = "tpo_declare_main_tsd#templatetype";
        String orgNum = excelDataMap.get(OrgNumKey);
        String taxsystem = excelDataMap.get(taxSystemKey);
        String accountsettype = excelDataMap.get(accountSetTypeKey);
        String skssqq = excelDataMap.get(skssqqKey);
        String skssqz = excelDataMap.get(skssqzKey);
        String templatetype = excelDataMap.get(templatetypeKey);
        boolean isvalidTaxationsys = true;
        try {
            if (StringUtil.isNotEmpty((CharSequence)taxsystem)) {
                List<Long> validTaxationsys = this.getValidTaxationsys();
                isvalidTaxationsys = validTaxationsys.contains(Long.valueOf(taxsystem));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        StringBuilder buffer = new StringBuilder();
        if (StringUtil.isEmpty((CharSequence)orgNum)) {
            buffer.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractSdsjtDeclareReportImportServiceImpl_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if (!isvalidTaxationsys) {
            buffer.append(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u8f93\u5165\u6709\u8bef\u3002", (String)"AbstractSdsjtDeclareReportImportServiceImpl_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if (StringUtil.isEmpty((CharSequence)accountsettype) || !this.getAccountSetType().contains(accountsettype)) {
            if (StringUtil.isNotBlank((CharSequence)buffer)) {
                buffer.append("\r\n");
            }
            buffer.append(ResManager.loadKDString((String)"\u8d26\u5957\u7c7b\u578b\u8f93\u5165\u6709\u8bef\u3002", (String)"AbstractSdsjtDeclareReportImportServiceImpl_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)buffer)) {
            return ValidDataResultVo.fail((String)buffer.toString());
        }
        String isadjustperiod = excelDataMap.get("tpo_declare_main_tsd#isadjustperiod");
        String adjustperiod = excelDataMap.get("tpo_declare_main_tsd#adjustperiod");
        boolean isadjustperiodFlag = ObjectUtils.isNotEmpty((Object)isadjustperiod) && "true".equals(isadjustperiod);
        TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgNum(Collections.singletonList(orgNum));
        if (ObjectUtils.isNotEmpty((Object)taxResult) && taxResult.isSuccess() && ObjectUtils.isNotEmpty((Object)taxResult.getData())) {
            boolean anIntersection;
            DynamicObject dyn;
            Long orgId = ((DynamicObject)((List)taxResult.getData()).get(0)).getLong("org.id");
            List<String> jtPlanList = this.querySharePlanByOrgIdsAndTaxsystemZt(Collections.singletonList(orgId), Long.parseLong(taxsystem), "3", accountsettype, DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz));
            if (ObjectUtils.isNotEmpty(jtPlanList) && !isadjustperiodFlag) {
                String plan = jtPlanList.get(1);
                StringBuilder resultMsg = new StringBuilder();
                boolean b = this.checkDateIsValid(DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz), plan, resultMsg);
                if (!b) {
                    return ValidDataResultVo.fail((String)resultMsg.toString());
                }
            }
            QFilter defaultQfilter = new QFilter("org", "=", (Object)orgId).and("templatetype", "=", (Object)templatetype).and("taxsystem", "=", (Object)Long.valueOf(taxsystem)).and("accountsettype", "=", (Object)accountsettype).and("isadjustperiod", "=", (Object)isadjustperiodFlag);
            if (isadjustperiodFlag) {
                defaultQfilter.and("adjustperiod", "=", (Object)adjustperiod);
            }
            if ((dyn = BusinessDataServiceHelper.loadSingle((String)MAINTABLE, (String)"id,org,billno", (QFilter[])new QFilter[]{defaultQfilter, new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)skssqq)).and("skssqz", "=", (Object)DateUtils.stringToDate((String)skssqz))})) != null) {
                return ValidDataResultVo.fail((String)String.format(ResManager.loadKDString((String)"%1$s %2$s - %3$s %4$s \u5df2\u5b58\u5728\u8ba1\u63d0\u5e95\u7a3f\uff1a%5$s\u3002", (String)"AbstractSdsjtDeclareReportImportServiceImpl_9", (String)"taxc-bdtaxr", (Object[])new Object[0]), ((DynamicObject)((List)taxResult.getData()).get(0)).getString("org.name"), skssqq, skssqz, ztType.get(accountsettype), dyn.getString("billno")));
            }
            if (!isadjustperiodFlag && (anIntersection = this.isAnIntersection(((DynamicObject)((List)taxResult.getData()).get(0)).getLong("org.id"), Long.valueOf(taxsystem), DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz), accountsettype, templatetype, isadjustperiodFlag))) {
                return ValidDataResultVo.fail((String)String.format(ResManager.loadKDString((String)"\u8ba1\u63d0\u5e95\u7a3f\u7684\u8ba1\u63d0\u671f\u95f4\u4e0d\u5141\u8bb8\u5b58\u5728\u4ea4\u96c6\u3002", (String)"AbstractSdsjtDeclareReportImportServiceImpl_10", (String)"taxc-bdtaxr", (Object[])new Object[0]), new Object[0]));
            }
        } else {
            return ValidDataResultVo.fail((String)ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u4fe1\u606f\uff01", (String)"AbstractSdsjtDeclareReportImportServiceImpl_11", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        return ValidDataResultVo.success();
    }

    private String getProvisionPeriod(long taxsystemId, String taxtypenumber) {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        qFilter.and("taxsystem", "=", (Object)taxsystemId);
        qFilter.and("taxtype.number", "=", (Object)taxtypenumber);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"itp_proviston_plan", (String)"id,cycle", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject != null) {
            return dynamicObject.getString("cycle");
        }
        return null;
    }

    private boolean checkDateIsValid(Date skssqq, Date skssqz, String plan, StringBuilder msg) {
        boolean ischeckresult = true;
        if (plan != null) {
            if ("month".equals(plan)) {
                ischeckresult = DateUtils.getMonthOfDate((Date)skssqz) - DateUtils.getMonthOfDate((Date)skssqq) == 0;
            } else if ("season".equals(plan)) {
                Date firstDateOfSeason = DateUtils.getFirstDateOfSeason((Date)skssqq);
                Date lastDateOfSeason = DateUtils.getDayFirst((Date)DateUtils.getLastDateOfSeason((Date)skssqq));
                ischeckresult = skssqq.equals(firstDateOfSeason) && DateUtils.getDayFirst((Date)skssqz).equals(lastDateOfSeason);
            } else if ("year".equals(plan)) {
                Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)skssqq);
                Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)skssqq);
                boolean bl = ischeckresult = skssqq.equals(firstDateOfYear) && skssqz.equals(lastDateOfYear);
            }
            if (!ischeckresult) {
                msg.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u8ba1\u63d0\u5468\u671f\u4e3a%s,\u8bf7\u4fee\u6539\u8ba1\u63d0\u671f\u95f4\u3002", (String)"AbstractSdsjtDeclareReportImportServiceImpl_12", (String)"taxc-bdtaxr", (Object[])new Object[0]), cycleMap.get(plan)));
            }
        }
        return ischeckresult;
    }

    private boolean isAnIntersection(Long orgId, Long taxsystemId, Date sksqq, Date sksqz, String zt, String templateType, boolean isadjustperiodFlag) {
        QFilter defaultQfilter = new QFilter("org", "=", (Object)orgId).and("templatetype", "=", (Object)templateType).and("taxsystem", "=", (Object)taxsystemId).and("accountsettype", "=", (Object)zt).and("isadjustperiod", "=", (Object)isadjustperiodFlag);
        QFilter dateQfilter = new QFilter("skssqq", ">=", (Object)sksqq).and("skssqq", "<=", (Object)sksqz);
        QFilter q1 = new QFilter("skssqq", "<=", (Object)sksqq).and("skssqz", ">=", (Object)sksqz);
        QFilter q2 = new QFilter("skssqz", ">=", (Object)sksqq).and("skssqz", "<=", (Object)sksqz);
        dateQfilter.or(q1);
        dateQfilter.or(q2);
        return QueryServiceHelper.exists((String)MAINTABLE, (QFilter[])new QFilter[]{defaultQfilter, dateQfilter});
    }

    private List<Long> getValidTaxationsys() {
        DynamicObject[] bd_taxationsys;
        ArrayList<Long> bids = new ArrayList<Long>();
        QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE).and("activedate", "<=", (Object)new Date());
        for (DynamicObject bd : bd_taxationsys = BusinessDataServiceHelper.load((String)"bd_taxationsys", (String)"id,number,expdate", (QFilter[])new QFilter[]{filter})) {
            if (bd.getDate("expdate") != null && bd.getDate("expdate").getTime() < new Date().getTime()) continue;
            bids.add(bd.getLong("id"));
        }
        return bids;
    }

    public abstract String getAccountSetType();

    public static Map<String, Set<Long>> queryProvisionSharePlanByOrgIdsAndCategoryId(List<Long> orgIds, long taxsystemId, Long categoryId, Date startDate, Date endDate) {
        HashMap<String, Set<Long>> planMap = new HashMap<String, Set<Long>>(12);
        if (ObjectUtils.isEmpty((Object)startDate) || ObjectUtils.isEmpty((Object)endDate)) {
            return planMap;
        }
        TaxResult querySharePlan = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryId(orgIds, (Long)categoryId, (Long)taxsystemId, (Date)startDate, (Date)endDate);
        if (ObjectUtils.isNotEmpty((Object)querySharePlan) && querySharePlan.isSuccess() && ObjectUtils.isNotEmpty((Object)querySharePlan.getData())) {
            DynamicObjectCollection sharePlans = (DynamicObjectCollection)querySharePlan.getData();
            for (DynamicObject sharePlan : sharePlans) {
                DynamicObjectCollection orgentity = sharePlan.getDynamicObjectCollection("orgentity");
                ArrayList<Long> orgs = new ArrayList<Long>(8);
                for (DynamicObject org : orgentity) {
                    if (!orgIds.contains(org.getDynamicObject("org").getLong("id"))) continue;
                    orgs.add(org.getDynamicObject("org").getLong("id"));
                }
                DynamicObjectCollection ruleentity = sharePlan.getDynamicObjectCollection("ruleentity");
                for (DynamicObject rule : ruleentity) {
                    DynamicObject plan = rule.getDynamicObject("rule");
                    if (ObjectUtils.isEmpty((Object)plan)) continue;
                    String booktype = plan.getString("booktype");
                    ArrayList accountsettypes = new ArrayList(8);
                    if (EmptyCheckUtils.isNotEmpty((Object)booktype)) {
                        String[] split = booktype.substring(1, booktype.length() - 1).split(",");
                        Arrays.stream(split).forEach(type -> {
                            if (EmptyCheckUtils.isNotEmpty((Object)type)) {
                                accountsettypes.add(type);
                            }
                        });
                    }
                    for (String accountsettype : accountsettypes) {
                        String taxsystem = plan.getString("taxsystem.id");
                        String taxarea = plan.getString("taxarea.id");
                        String taxtype = plan.getString("taxtype.id");
                        String cycle = plan.getString("cycle");
                        String planMapKey = String.format("%s-%s-%s-%s-%s", taxsystem, taxarea, taxtype, cycle, accountsettype);
                        Set planOrgs = planMap.computeIfAbsent(planMapKey, d -> new HashSet());
                        planOrgs.addAll(orgs);
                    }
                }
            }
        }
        return planMap;
    }

    public List<String> querySharePlanByOrgIdsAndTaxsystemZt(List<Long> orgList, long taxsystemId, String taxtype, String zt, Date startDate, Date endDate) {
        ArrayList<String> resultList = new ArrayList<String>(2);
        if (ObjectUtils.isEmpty(orgList) || ObjectUtils.isEmpty((Object)taxsystemId) || ObjectUtils.isEmpty((Object)taxtype) || ObjectUtils.isEmpty((Object)zt) || ObjectUtils.isEmpty((Object)startDate) || ObjectUtils.isEmpty((Object)endDate)) {
            return resultList;
        }
        Map<String, Set<Long>> sharePlanByOrgIds = AbstractSdsjtDeclareReportImportServiceImpl.queryProvisionSharePlanByOrgIdsAndCategoryId(orgList, taxsystemId, Long.valueOf(taxtype), startDate, endDate);
        if (ObjectUtils.isEmpty(sharePlanByOrgIds)) {
            return resultList;
        }
        for (Map.Entry<String, Set<Long>> next : sharePlanByOrgIds.entrySet()) {
            String nextKey = next.getKey();
            String[] split = nextKey.split("-");
            if (!String.valueOf(taxsystemId).equalsIgnoreCase(split[0]) || !taxtype.equalsIgnoreCase(split[2]) || !zt.equalsIgnoreCase(split[4])) continue;
            resultList.add(split[1]);
            resultList.add(split[3]);
            break;
        }
        return resultList;
    }

    static {
        cycleMap.put("month", ResManager.loadKDString((String)"\u6708", (String)"AbstractSdsjtDeclareReportImportServiceImpl_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        cycleMap.put("season", ResManager.loadKDString((String)"\u5b63\u5ea6", (String)"AbstractSdsjtDeclareReportImportServiceImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        cycleMap.put("year", ResManager.loadKDString((String)"\u5e74", (String)"AbstractSdsjtDeclareReportImportServiceImpl_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        ztType.put("bdzt", ResManager.loadKDString((String)"\u672c\u5730\u8d26\u7c3f", (String)"AbstractSdsjtDeclareReportImportServiceImpl_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        ztType.put("jtzt", ResManager.loadKDString((String)"\u96c6\u56e2\u8d26\u7c3f", (String)"AbstractSdsjtDeclareReportImportServiceImpl_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
    }
}

