/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service.DeclareReportImportService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;

public class DiscountsInfoDeclareReportImportServiceImpl
implements DeclareReportImportService {
    private static Log logger = LogFactory.getLog(DiscountsInfoDeclareReportImportServiceImpl.class);
    private static final String MAINTABLE = "tpo_declare_main_tsd";
    private String OrgNumKey = "tpo_declare_main_tsd#orgnumber";
    private String orgIdKey = "tpo_declare_main_tsd#org";
    private String accountSetTypeKey = "tpo_declare_main_tsd#accountsettype";
    private String skssqqKey = "tpo_declare_main_tsd#skssqq";
    private String skssqzKey = "tpo_declare_main_tsd#skssqz";
    private String templatetypeKey = "tpo_declare_main_tsd#templatetype";

    @Override
    public ValidDataResultVo validExcelData(Map<String, String> excelDataMap, DynamicObject templateContent) {
        QFilter defaultQfilter;
        DynamicObject obj;
        String orgid = excelDataMap.get(this.orgIdKey);
        String orgNum = excelDataMap.get(this.OrgNumKey);
        String version = excelDataMap.get(this.accountSetTypeKey);
        String skssqq = excelDataMap.get(this.skssqqKey);
        String skssqz = excelDataMap.get(this.skssqzKey);
        String templatetype = excelDataMap.get(this.templatetypeKey);
        QFilter q1 = new QFilter("taxorg", "=", (Object)Long.valueOf(orgid));
        QFilter q2 = new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)skssqq));
        QFilter q3 = new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)skssqz));
        QFilter q4 = new QFilter("version", "=", (Object)version);
        QFilter q5 = new QFilter("billstatus", "=", (Object)"C");
        boolean exists = QueryServiceHelper.exists((String)"rdesd_draft_main", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.valueOf(orgid))});
        if (!exists) {
            return ValidDataResultVo.fail((String)String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s\u8f85\u52a9\u8d26\u672a\u521b\u5efa\uff0c\u8bf7\u5148\u7f16\u5236\u8f85\u52a9\u8d26\u3002", (String)"DiscountsInfoDeclareReportImportServiceImpl_0", (String)"taxc-bdtaxr", (Object[])new Object[0]), dynamicObject.getString("org.name"), DateUtils.format((Date)DateUtils.stringToDate((String)skssqq)), DateUtils.format((Date)DateUtils.stringToDate((String)skssqz))));
        }
        TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgNum(Collections.singletonList(orgNum));
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)taxResult) && taxResult.isSuccess() && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)taxResult.getData()) && (obj = BusinessDataServiceHelper.loadSingle((String)MAINTABLE, (String)"id,org,billno", (QFilter[])new QFilter[]{defaultQfilter = new QFilter("org", "=", (Object)((DynamicObject)((List)taxResult.getData()).get(0)).getLong("org.id")).and("templatetype", "=", (Object)templatetype).and("accountsettype", "=", (Object)version), new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)skssqq)).and("skssqz", "=", (Object)DateUtils.stringToDate((String)skssqz))})) != null) {
            return ValidDataResultVo.fail((String)String.format(ResManager.loadKDString((String)"%1$s %2$s - %3$s \u5df2\u5b58\u5728\u5e95\u7a3f\uff1a%4$s\u3002", (String)"DiscountsInfoDeclareReportImportServiceImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), obj.getString("org.name"), skssqq, skssqz, obj.getString("billno")));
        }
        return ValidDataResultVo.success();
    }

    @Override
    public void initImportData(ImportDataVo importDataVo, Map<String, String> resultMap) {
        String skssqq = resultMap.get(this.skssqqKey);
        String skssqz = resultMap.get(this.skssqzKey);
        String version = "hsqj";
        this.validateDates(DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz));
        Date firstDate = DateUtils.getFirstDateOfYear((Date)DateUtils.stringToDate((String)skssqq));
        Date endDate = DateUtils.addMonth((Date)firstDate, (int)8);
        endDate = DateUtils.getDayFirst((Date)DateUtils.getLastDateOfMonth((Date)endDate));
        if (skssqq.equals(DateUtils.format((Date)firstDate)) && skssqz.equals(DateUtils.format((Date)endDate))) {
            version = "dsyj";
        }
        resultMap.put(this.accountSetTypeKey, version);
        if ("hsqj".equals(version) && (ObjectUtils.isEmpty((Object)resultMap.get("yhmxb_jjkcbljff#yhmxb_jczl")) || "0".equals(resultMap.get("yhmxb_jjkcbljff#yhmxb_jczl")) || !this.getValueTccitBizdefId().contains(resultMap.get("yhmxb_jjkcbljff#yhmxb_jczl")))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e74\u6bb5\u6c47\u7b97\u6e05\u7f34\u7684\u201c\u52a0\u8ba1\u6263\u9664\u6bd4\u4f8b\u53ca\u8ba1\u7b97\u65b9\u6cd5\u4e0d\u53ef\u7528\u201d", (String)"DiscountsInfoDeclareReportImportServiceImpl_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    private List<String> getValueTccitBizdefId() {
        QFilter filter = new QFilter("bizdef", "=", (Object)1642679715473184768L);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tpo_tccit_bizdef_entry", (String)"id,parent", (QFilter[])new QFilter[]{filter});
        List parentIds = objects.stream().map(o -> o.getLong("parent")).collect(Collectors.toList());
        filter.and("id", "not in", parentIds);
        DynamicObjectCollection resultObjs = QueryServiceHelper.query((String)"tpo_tccit_bizdef_entry", (String)"id", (QFilter[])new QFilter[]{filter});
        if (!ObjectUtils.isEmpty((Object)resultObjs)) {
            return resultObjs.stream().map(o -> o.getString("id")).collect(Collectors.toList());
        }
        return new ArrayList<String>(1);
    }

    private void validateDates(Date skssqq, Date skssqz) {
        logger.info("skssqq:" + skssqq);
        logger.info("skssqz:" + skssqz);
        if (skssqq == null || skssqz == null || skssqq.compareTo(skssqz) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\uff01", (String)"DiscountsInfoDeclareReportImportServiceImpl_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)skssqq);
        if (skssqq.compareTo(firstDateOfMonth) != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\uff01", (String)"DiscountsInfoDeclareReportImportServiceImpl_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        String[] types = new String[]{"year", "first_three_quarter"};
        boolean validDate = false;
        String[] stringArray = types;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String type;
            switch (type = stringArray[i]) {
                case "year": {
                    Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)skssqz);
                    Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)skssqq);
                    if (firstDateOfYear.compareTo(skssqq) != 0 || !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfYear))) continue block8;
                    validDate = true;
                    continue block8;
                }
                case "first_three_quarter": {
                    Date firstDate = DateUtils.getFirstDateOfYear((Date)skssqq);
                    Date endDate = DateUtils.addMonth((Date)firstDate, (int)8);
                    endDate = DateUtils.getDayFirst((Date)DateUtils.getLastDateOfMonth((Date)endDate));
                    if (!DateUtils.format((Date)skssqq).equals(DateUtils.format((Date)firstDate)) || !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)endDate))) continue block8;
                    validDate = true;
                    continue block8;
                }
                default: {
                    Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)skssqq);
                    if (!DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfMonth))) continue block8;
                    validDate = true;
                }
            }
        }
        if (!validDate) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\uff01", (String)"DiscountsInfoDeclareReportImportServiceImpl_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }
}

