/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service.DeclareReportImportService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class FinanceDeclareReportImportImpl
implements DeclareReportImportService {
    public static final String TAX_LIMIT_YEAR = "year";
    public static final String TAX_LIMIT_SEASON = "season";
    public static final String TAX_LIMIT_MONTH = "month";
    private static final List<String> TAX_LIMITS = Lists.newArrayList((Object[])new String[]{"month", "season", "year"});
    private static final String ENTITY_TEMPLATE = "bdtaxr_template_main";
    public static final String TCVAT_NSRXX = "tcvat_nsrxx";
    public static final String SPLITSTRING = "#";
    public static final String EWBLXH = "ewblxh";
    public static final String SBBID = "sbbid";
    private static final String ORGID = "org";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String NSRTYPE = "type";
    private static final String TAXLIMIT = "taxlimit";
    private static final List<String> TEMPALTE_TYPE = Arrays.asList("FR0001", "FR0002", "FR0003", "FR0004", "FR0011");
    private static final List<String> provinces = new ArrayList<String>();

    @Override
    public void sendImportSheets(DeclareRequestModel requestModel, List<String> sheetNames) {
        String templatetype = requestModel.getTemplateType();
        Long templateId = requestModel.getTemplateId();
        Long orgid = requestModel.getOrgId();
        Date startDate = DateUtils.stringToDate2((String)requestModel.getSkssqq());
        Date endDate = DateUtils.stringToDate2((String)requestModel.getSkssqz());
        if (templatetype.startsWith("FR")) {
            this.deleteTempTable(String.valueOf(orgid), startDate, endDate);
            TaxResult taxcMainDyo = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdAndIsTaxpayer((Long)orgid);
            DynamicObject template = TemplateUtils.getTemplateObjectById((String)String.valueOf(templateId));
            String templateNumber = "";
            if (!ObjectUtils.isEmpty((Object)template)) {
                templateNumber = template.getString("number");
            }
            String registeraddress = "";
            if (!ObjectUtils.isEmpty((Object)taxcMainDyo)) {
                registeraddress = ((DynamicObject)taxcMainDyo.getData()).getString("registeraddress");
            }
            String reportType = this.getReportType(startDate, endDate);
            String taxLimit = this.getReportType(reportType);
            this.saveMessageData(String.valueOf(orgid), startDate, endDate, taxLimit, templateNumber, registeraddress, sheetNames);
        }
    }

    private void saveMessageData(String orgid, Date startdate, Date enddate, String taxlimit, String type, String registeraddress, List<String> selectedTableList) {
        DynamicObject stepTwoMessage = BusinessDataServiceHelper.newDynamicObject((String)"tcvvt_message");
        stepTwoMessage.set("status", (Object)2);
        stepTwoMessage.set("orgid", (Object)Long.parseLong(orgid));
        stepTwoMessage.set("startdate", (Object)startdate);
        stepTwoMessage.set("enddate", (Object)enddate);
        stepTwoMessage.set("reporttype", (Object)this.getReportType(taxlimit));
        stepTwoMessage.set("registeraddress", (Object)registeraddress);
        DynamicObject template = FinanceDeclareReportImportImpl.getTemplateType(orgid, startdate, enddate);
        stepTwoMessage.set(NSRTYPE, (Object)(ObjectUtils.isNotEmpty((Object)template) ? template.getString("type.number") : ""));
        stepTwoMessage.set("templateid", (Object)(ObjectUtils.isNotEmpty((Object)template) ? template.getString("id") : ""));
        QFilter orgFilter = new QFilter("orgrow.orgid", "=", (Object)Long.valueOf(orgid));
        QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)"qysds");
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.id,orgrow.pid,orgrow.orgid,orgrow.shareid as share,orgrow.declaration as declare,orgrow.kdqjyqylx as kdqjyqylx", (QFilter[])new QFilter[]{taxtypeFilter, orgFilter, statusFilter, OrgUtils.getQFilter((Date)enddate)});
        if (!CollectionUtils.isEmpty((Collection)objects)) {
            DynamicObject dynamicObject = (DynamicObject)objects.get(0);
            String kdqjyqylx = dynamicObject.getString("kdqjyqylx");
            stepTwoMessage.set("declaretype", (Object)kdqjyqylx);
        } else {
            stepTwoMessage.set("declaretype", (Object)100);
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcvvt_check_report", (String)"iconsurl,fitid,mainname,introname,id", (QFilter[])new QFilter[]{new QFilter(NSRTYPE, "=", (Object)type)}, (String)"id");
        stepTwoMessage.set("accountingstandards", ((DynamicObject)dynamicObjects.get(0)).get("fitid"));
        if ("FR0001".equalsIgnoreCase(type)) {
            stepTwoMessage.set("newrule", (Object)"no");
        }
        if ("FR0002".equalsIgnoreCase(type) || "FR0005".equalsIgnoreCase(type)) {
            stepTwoMessage.set("newrule", (Object)"yes");
        }
        List selectIds = dynamicObjects.stream().filter(m -> selectedTableList.contains(m.getString("mainname"))).map(m -> m.getLong("id")).sorted().collect(Collectors.toList());
        DynamicObjectCollection entryentityAdd = stepTwoMessage.getDynamicObjectCollection("entryentity");
        for (Long selectId : selectIds) {
            entryentityAdd.addNew().set("selectid", (Object)selectId);
        }
        OperationServiceHelper.executeOperate((String)"save", (String)"tcvvt_message", (DynamicObject[])new DynamicObject[]{stepTwoMessage}, (OperateOption)OperateOption.create());
    }

    private String getReportType(String taxlimit) {
        if (TAX_LIMIT_SEASON.equals(taxlimit)) {
            return "ajsb";
        }
        if (TAX_LIMIT_YEAR.equals(taxlimit)) {
            return "ansb";
        }
        if (TAX_LIMIT_MONTH.equals(taxlimit)) {
            return "aysb";
        }
        return " ";
    }

    private String getReportType(Date startDate, Date endDate) {
        int dayDiff = DateUtils.getDayDiff((Date)startDate, (Date)endDate);
        if (dayDiff > 366) {
            return null;
        }
        for (String taxLimit : TAX_LIMITS) {
            if (!DateUtils.validDateRange((String)taxLimit, (Date)startDate, (Date)endDate)) continue;
            return this.getReportType(taxLimit);
        }
        return null;
    }

    public static DynamicObject getTemplateType(String orgid, Date sksqq, Date sksqz) {
        String enddateStr;
        QFilter orgIdFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgid));
        DynamicObject taxMainInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"tctb_tax_main", (QFilter[])new QFilter[]{orgIdFilter});
        if (null == taxMainInfo) {
            return null;
        }
        String startdateStr = DateUtils.format((Date)sksqq, (String)"yyyy-MM-dd");
        DynamicObjectCollection collection = FinanceDeclareReportImportImpl.queryYbnsr(orgid, TEMPALTE_TYPE, startdateStr, enddateStr = DateUtils.format((Date)sksqz, (String)"yyyy-MM-dd"), Collections.emptyMap());
        if (collection.size() == 1) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)collection.get(0)).getLong("templateid"), (String)ENTITY_TEMPLATE);
            return dynamicObject;
        }
        if (collection.size() > 1) {
            return null;
        }
        String projectname = taxMainInfo.getString("accountingstandards.projectname");
        String newrule = taxMainInfo.getString("newrule");
        Long registeraddress = taxMainInfo.getLong("registeraddress");
        long accountingstandards = taxMainInfo.getLong("accountingstandards.id");
        if (accountingstandards == 1072508277482326016L && (StringUtil.isEmpty((CharSequence)newrule) || "empty".equalsIgnoreCase(newrule))) {
            ErrorCode errorCode = new ErrorCode("allRequiredField", ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u57fa\u7840\u8bbe\u7f6e-\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u9009\u62e9\u7ef4\u62a4\u201c\u6267\u884c\u65b0\u51c6\u5219\u201d\u7684\u76f8\u5173\u4fe1\u606f\uff0c\u518d\u8fdb\u884c\u586b\u62a5", (String)"FinanceDeclareReportImportImpl_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            throw new KDBizException(errorCode, new Object[0]);
        }
        DynamicObject admindivisionObject = BusinessDataServiceHelper.loadSingleFromCache((Object)registeraddress, (String)"bd_admindivision");
        FinanceDeclareReportImportImpl.allRequiredFieldValidator(orgid);
        String registeraddressName = admindivisionObject.getString("fullname");
        String templateNumber = "";
        if (ResManager.loadKDString((String)"\u4e00\u822c\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"FinanceDeclareReportImportImpl_8", (String)"taxc-bdtaxr", (Object[])new Object[0]).equals(projectname) && "no".equalsIgnoreCase(newrule)) {
            templateNumber = "FR0001";
        }
        if (ResManager.loadKDString((String)"\u4e00\u822c\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"FinanceDeclareReportImportImpl_8", (String)"taxc-bdtaxr", (Object[])new Object[0]).equals(projectname) && "yes".equalsIgnoreCase(newrule)) {
            templateNumber = "FR0002";
            Object registeraddressInProvinces = FinanceDeclareReportImportImpl.registeraddressInProvinces(registeraddressName);
            if (((Boolean)registeraddressInProvinces).booleanValue()) {
                templateNumber = "FR0005";
            }
        }
        if (ResManager.loadKDString((String)"\u5c0f\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"FinanceDeclareReportImportImpl_9", (String)"taxc-bdtaxr", (Object[])new Object[0]).equals(projectname)) {
            templateNumber = "FR0003";
        }
        if (ResManager.loadKDString((String)"\u4f01\u4e1a\u4f1a\u8ba1\u5236\u5ea6", (String)"FinanceDeclareReportImportImpl_10", (String)"taxc-bdtaxr", (Object[])new Object[0]).equals(projectname)) {
            templateNumber = "FR0004";
        }
        if (ResManager.loadKDString((String)"\u94f6\u884c\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"FinanceDeclareReportImportImpl_11", (String)"taxc-bdtaxr", (Object[])new Object[0]).equals(projectname)) {
            templateNumber = "FR0011";
        }
        if (FinanceDeclareReportImportImpl.isZeroDeclareOrg(orgid)) {
            switch (templateNumber) {
                case "FR0001": {
                    templateNumber = "FR0006";
                    break;
                }
                case "FR0002": {
                    templateNumber = "FR0007";
                    break;
                }
                case "FR0003": {
                    templateNumber = "FR0008";
                    break;
                }
                case "FR0004": {
                    templateNumber = "FR0009";
                    break;
                }
                case "FR0005": {
                    templateNumber = "FR0010";
                }
            }
        }
        QFilter numberFilter = new QFilter("number", "=", (Object)templateNumber);
        return BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_TEMPLATE, (QFilter[])new QFilter[]{numberFilter});
    }

    public static Boolean registeraddressInProvinces(String registeraddress) {
        for (String province : provinces) {
            if (!registeraddress.contains(province)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean isZeroDeclareOrg(String orgId) {
        boolean isZeroDeclareOrg = false;
        Boolean temp = (Boolean)SystemParamUtil.getAppParameter((String)"tcvvt", (String)"zerodeclare", (long)Long.parseLong(orgId));
        if (ObjectUtils.isNotEmpty((Object)temp) && temp.booleanValue()) {
            isZeroDeclareOrg = true;
        }
        return isZeroDeclareOrg;
    }

    public static DynamicObjectCollection queryYbnsr(String orgid, List<String> stype, String startData, String endData, Map<String, Object> extendParams) {
        List<QFilter> qFilters = FinanceDeclareReportImportImpl.getQFilters(orgid, stype, startData, endData, 0, false, extendParams);
        String allFieldString = MetadataUtil.getAllFieldToQuery((String)TCVAT_NSRXX);
        QFilter[] qFilterArr = new QFilter[qFilters.size()];
        return QueryServiceHelper.query((String)TCVAT_NSRXX, (String)allFieldString, (QFilter[])qFilters.toArray(qFilterArr));
    }

    public static List<QFilter> getQFilters(String orgid, List<String> stype, String startData, String endData, int month, boolean dateRange, Map<String, Object> extendParams) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(ORGID, "=", (Object)Long.parseLong(orgid)));
        qFilters.add(new QFilter(NSRTYPE, "in", stype));
        if (dateRange) {
            qFilters.add(new QFilter(SKSSQQ, ">=", (Object)DateUtils.addMonth((Date)DateUtils.stringToDate((String)startData), (int)month)));
        } else {
            qFilters.add(new QFilter(SKSSQQ, "=", (Object)DateUtils.addMonth((Date)DateUtils.stringToDate((String)startData), (int)month)));
        }
        qFilters.add(new QFilter(SKSSQZ, "<=", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)DateUtils.stringToDate((String)endData), (int)month))));
        qFilters.add(new QFilter(TAXLIMIT, "=", (Object)DateUtils.getTaxLimit((Date)DateUtils.stringToDate((String)startData), (Date)DateUtils.stringToDate((String)endData))));
        return qFilters;
    }

    public static void allRequiredFieldValidator(String orgId) {
        QFilter orgFilter;
        DynamicObject dTctb;
        if (StringUtils.isNotBlank((CharSequence)orgId) && (dTctb = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"maincompany,taxoffice,accountingstandards,registertype,registertime,registeraddress,actualaddress,codeandname", (QFilter[])new QFilter[]{orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId))})) != null) {
            String orgname = dTctb.getString("maincompany");
            String taxoffice = dTctb.getString("taxoffice");
            String registertype = dTctb.getString("registertype");
            String registertime = dTctb.getString("registertime");
            String registeraddress = dTctb.getString("registeraddress");
            String codeandname = dTctb.getString("codeandname");
            String actualaddress = dTctb.getString("actualaddress");
            String admindivisionObject = dTctb.getString("accountingstandards");
            if (StringUtils.isEmpty((CharSequence)registeraddress) || "0".equalsIgnoreCase(admindivisionObject) || "0".equalsIgnoreCase(taxoffice) || "0".equalsIgnoreCase(registertype) || StringUtils.isEmpty((CharSequence)registertime) || "0".equalsIgnoreCase(codeandname) || StringUtils.isEmpty((CharSequence)actualaddress)) {
                ErrorCode errorCode = new ErrorCode("allRequiredField", String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5148\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"FinanceDeclareReportImportImpl_12", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgname));
                throw new KDBizException(errorCode, new Object[0]);
            }
        }
    }

    private void deleteTempTable(String orgid, Date startdate, Date enddate) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)Long.parseLong(orgid));
        QFilter skssqqzFilter = new QFilter(SKSSQQ, "=", (Object)startdate).and(new QFilter(SKSSQZ, "=", (Object)enddate));
        DeleteServiceHelper.delete((String)"tcvvt_main_account", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        DeleteServiceHelper.delete((String)"tcvvt_main_detail", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        DeleteServiceHelper.delete((String)"tcvvt_main_adjust", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        DeleteServiceHelper.delete((String)"tcvvt_main_adjust_tp", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("startdate", "=", (Object)startdate));
        list.add(new QFilter("enddate", "=", (Object)enddate));
        list.add(new QFilter("orgid", "=", (Object)Long.parseLong(orgid)));
        DynamicObject template = FinanceDeclareReportImportImpl.getTemplateType(orgid, startdate, enddate);
        QFilter nsrtypeQ = new QFilter(NSRTYPE, "=", ObjectUtils.isNotEmpty((Object)template) ? template.getString("type.number") : null);
        QFilter templateidQ = new QFilter("templateid", "=", ObjectUtils.isNotEmpty((Object)template) ? template.getString("id") : null);
        list.add(nsrtypeQ);
        list.add(templateidQ);
        DeleteServiceHelper.delete((String)"tcvvt_message", (QFilter[])list.toArray(new QFilter[0]));
    }

    static {
        provinces.add(ResManager.loadKDString((String)"\u5c71\u897f\u7701", (String)"FinanceDeclareReportImportImpl_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u5317\u4eac\u5e02", (String)"FinanceDeclareReportImportImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u8d35\u5dde\u7701", (String)"FinanceDeclareReportImportImpl_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u5e7f\u897f\u58ee\u65cf\u81ea\u6cbb\u533a", (String)"FinanceDeclareReportImportImpl_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u6e56\u5317\u7701", (String)"FinanceDeclareReportImportImpl_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u6cb3\u5357\u7701", (String)"FinanceDeclareReportImportImpl_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u9655\u897f\u7701", (String)"FinanceDeclareReportImportImpl_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u6c5f\u82cf\u7701", (String)"FinanceDeclareReportImportImpl_13", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u5e7f\u4e1c\u7701", (String)"FinanceDeclareReportImportImpl_14", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u798f\u5efa\u7701", (String)"FinanceDeclareReportImportImpl_15", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u9752\u6d77\u7701", (String)"FinanceDeclareReportImportImpl_16", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u5929\u6d25\u5e02", (String)"FinanceDeclareReportImportImpl_17", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u6c5f\u897f\u7701", (String)"FinanceDeclareReportImportImpl_18", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a", (String)"FinanceDeclareReportImportImpl_19", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u6e56\u5357\u7701", (String)"FinanceDeclareReportImportImpl_20", (String)"taxc-bdtaxr", (Object[])new Object[0]));
    }
}

