/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service.DeclareReportImportService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.vo.DynRowVo;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;

public class NcpDeclareReportImportServiceImpl
implements DeclareReportImportService {
    private static Log logger = LogFactory.getLog(NcpDeclareReportImportServiceImpl.class);
    private final List<String> cpmc = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u6295\u5165\u4ea7\u51fa\u6cd5\u6838\u5b9a\u519c\u4ea7\u54c1\u589e\u503c\u7a0e\u8fdb\u9879\u7a0e\u989d\u8ba1\u7b97\u8868#", (String)"NcpDeclareReportImportServiceImpl_6", (String)"taxc-bdtaxr", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d2d\u8fdb\u519c\u4ea7\u54c1\u76f4\u63a5\u9500\u552e\u6838\u5b9a\u519c\u4ea7\u54c1\u589e\u503c\u7a0e\u8fdb\u9879\u7a0e\u989d\u8ba1\u7b97\u8868#", (String)"NcpDeclareReportImportServiceImpl_7", (String)"taxc-bdtaxr", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d2d\u8fdb\u519c\u4ea7\u54c1\u7528\u4e8e\u751f\u4ea7\u7ecf\u8425\u4e14\u4e0d\u6784\u6210\u8d27\u7269\u5b9e\u4f53\u6838\u5b9a\u519c\u4ea7\u54c1\u589e\u503c\u7a0e\u8fdb\u9879\u7a0e\u989d#", (String)"NcpDeclareReportImportServiceImpl_8", (String)"taxc-bdtaxr", (Object[])new Object[0])});
    private final List<String> hymc = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u6295\u5165\u4ea7\u51fa\u6cd5\u6838\u5b9a\u519c\u4ea7\u54c1\u589e\u503c\u7a0e\u8fdb\u9879\u7a0e\u989d\u8ba1\u7b97\u8868#", (String)"NcpDeclareReportImportServiceImpl_6", (String)"taxc-bdtaxr", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d2d\u8fdb\u519c\u4ea7\u54c1\u7528\u4e8e\u751f\u4ea7\u7ecf\u8425\u4e14\u4e0d\u6784\u6210\u8d27\u7269\u5b9e\u4f53\u6838\u5b9a\u519c\u4ea7\u54c1\u589e\u503c\u7a0e\u8fdb\u9879\u7a0e\u989d#", (String)"NcpDeclareReportImportServiceImpl_8", (String)"taxc-bdtaxr", (Object[])new Object[0])});

    @Override
    public ValidDataResultVo validExcelType(Map<String, String> excelDataMap, DynamicObject templateContent) {
        String startTime = excelDataMap.get(ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u6838\u5b9a\u6263\u9664\u589e\u503c\u7a0e\u8fdb\u9879\u7a0e\u989d\u8ba1\u7b97\u8868\uff08\u6c47\u603b\u8868\uff09#0#2", (String)"NcpDeclareReportImportServiceImpl_14", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        String endTime = excelDataMap.get(ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u6838\u5b9a\u6263\u9664\u589e\u503c\u7a0e\u8fdb\u9879\u7a0e\u989d\u8ba1\u7b97\u8868\uff08\u6c47\u603b\u8868\uff09#0#4", (String)"NcpDeclareReportImportServiceImpl_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        if (StringUtil.isBlank((CharSequence)startTime) || StringUtil.isBlank((CharSequence)endTime)) {
            return ValidDataResultVo.fail((String)ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\uff01", (String)"NcpDeclareReportImportServiceImpl_20", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        String nsrsbh = excelDataMap.get(ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u6838\u5b9a\u6263\u9664\u589e\u503c\u7a0e\u8fdb\u9879\u7a0e\u989d\u8ba1\u7b97\u8868\uff08\u6c47\u603b\u8868\uff09#1#2", (String)"NcpDeclareReportImportServiceImpl_18", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        if (StringUtil.isBlank((CharSequence)nsrsbh)) {
            return ValidDataResultVo.fail((String)ResManager.loadKDString((String)"\u5f15\u5165\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"NcpDeclareReportImportServiceImpl_21", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainOrgIdsByUnifiedsocialCodes((List)Lists.newArrayList((Object[])new String[]{nsrsbh}));
        if (taxResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)taxResult.getData()))) {
            Long orgid = (Long)((List)taxResult.getData()).get(0);
            if (!SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"ncpjzjtsbbyr", (long)orgid)) {
                return ValidDataResultVo.fail((String)ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u8bbe\u7f6e\u4e3a\u901a\u8fc7\u65b0\u589e\u65b9\u5f0f\u751f\u6210\u519c\u4ea7\u54c1\u6838\u5b9a\u6263\u9664\u8ba1\u7b97\u62b5\u6263\u5e95\u7a3f\uff0c\u5982\u9700\u53d8\u66f4\u8bf7\u524d\u5f80\u3010\u57fa\u7840\u670d\u52a1\u4e91\u3011\u2192\u3010\u516c\u5171\u8bbe\u7f6e\u3011\u2192\u3010\u53c2\u6570\u914d\u7f6e\u3011\u2192\u3010\u7cfb\u7edf\u53c2\u6570\u3011\u589e\u503c\u7a0e\u5e94\u7528\u4e2d\u4fee\u6539\u53c2\u6570\u8bbe\u7f6e\u3002", (String)"NcpDeclareReportImportServiceImpl_13", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            Date startDate = DateUtils.stringToDate2((String)startTime, (String)"yyyy-MM-dd");
            Date endDate = DateUtils.stringToDate2((String)endTime, (String)"yyyy-MM-dd");
            DynamicObject dynamicObject = OrgChangeRecordUtil.loadChangeRecord((String)orgid.toString(), (Date)endDate);
            if (!Objects.nonNull(dynamicObject) || !"in-out".equalsIgnoreCase(dynamicObject.getString("farmdeducttype"))) {
                return ValidDataResultVo.fail((String)ResManager.loadKDString((String)"\u5f15\u5165\u7a0e\u52a1\u7ec4\u7ec7\u7684\u519c\u4ea7\u54c1\u6838\u5b9a\u6263\u9664\u53c2\u6570\u672a\u542f\u7528\uff0c\u8bf7\u524d\u5f80\u3010\u57fa\u7840\u8bbe\u7f6e\u3011\u2192\u3010\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406\u3011\u2192\u3010\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3011\u2192\u3010\u589e\u503c\u7a0e\u5361\u7247\u3011\u4e2d\u4fee\u6539\u519c\u4ea7\u54c1\u6838\u5b9a\u6263\u9664\u53c2\u6570\u4fe1\u606f\u3002", (String)"NcpDeclareReportImportServiceImpl_11", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(orgid));
            if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData())) || EmptyCheckUtils.isEmpty((Object)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"))) {
                return ValidDataResultVo.fail((String)ResManager.loadKDString((String)"\u5f15\u5165\u7a0e\u52a1\u7ec4\u7ec7\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u4e2d\u7684\u589e\u503c\u7a0e\u5361\u7247\u4e0d\u4e3a\u542f\u7528\u72b6\u6001\uff0c\u8bf7\u524d\u5f80\u3010\u57fa\u7840\u8bbe\u7f6e\u3011\u2192\u3010\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406\u3011\u2192\u3010\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3011\u4e2d\u542f\u7528\u5361\u7247\u3002", (String)"NcpDeclareReportImportServiceImpl_22", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            boolean flag = false;
            DynamicObjectCollection categoryentryentity = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity");
            for (DynamicObject one : categoryentryentity) {
                if (!"zzs".equals(one.getString("taxtype")) || !"1".equals(one.getString("enable"))) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return ValidDataResultVo.fail((String)ResManager.loadKDString((String)"\u5f15\u5165\u7a0e\u52a1\u7ec4\u7ec7\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u4e2d\u7684\u589e\u503c\u7a0e\u5361\u7247\u4e0d\u4e3a\u542f\u7528\u72b6\u6001\uff0c\u8bf7\u524d\u5f80\u3010\u57fa\u7840\u8bbe\u7f6e\u3011\u2192\u3010\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406\u3011\u2192\u3010\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3011\u4e2d\u542f\u7528\u5361\u7247\u3002", (String)"NcpDeclareReportImportServiceImpl_22", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            String deadLine = TaxBaseDataUtils.getDeadLine((Long)orgid, (String)"zzs", (Date)startDate);
            logger.info("validExcelType deadLine:{},orgid:{},startDate:{},endDate:{}", new Object[]{deadLine, orgid, startDate, endDate});
            int diff = DateUtils.getMonthDiff2((String)startTime, (String)endTime);
            if (!(diff == 0 && "month".equals(deadLine) || diff == 2 && "season".equals(deadLine))) {
                return ValidDataResultVo.fail((String)ResManager.loadKDString((String)"\u7f34\u7eb3\u671f\u9650\u4e0e\u57fa\u7840\u8bbe\u7f6e-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-\u589e\u503c\u7a0e\u5361\u7247\u4e2d\u7ef4\u62a4\u7684\u7f34\u7eb3\u671f\u9650\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"NcpDeclareReportImportServiceImpl_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            String verifyEnableCpmc = this.verifyEnableCpmc(excelDataMap, startDate, endDate, orgid);
            if (verifyEnableCpmc != null) {
                return ValidDataResultVo.fail((String)verifyEnableCpmc);
            }
        } else {
            return ValidDataResultVo.fail((String)ResManager.loadKDString((String)"\u5f15\u5165\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u6709\u8bef\u6216\u7eb3\u7a0e\u4e3b\u4f53\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"NcpDeclareReportImportServiceImpl_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        return ValidDataResultVo.success();
    }

    @Override
    public List<DynRowVo> getDynRowList(String sheetName, Map<String, String> excelDataMap) {
        int secondRow;
        int firstRow;
        ArrayList<DynRowVo> dynRowList = new ArrayList<DynRowVo>();
        if (ResManager.loadKDString((String)"\u6295\u5165\u4ea7\u51fa\u6cd5\u6838\u5b9a\u519c\u4ea7\u54c1\u589e\u503c\u7a0e\u8fdb\u9879\u7a0e\u989d\u8ba1\u7b97\u8868", (String)"NcpDeclareReportImportServiceImpl_0", (String)"taxc-bdtaxr", (Object[])new Object[0]).equals(sheetName)) {
            firstRow = 0;
            secondRow = 0;
            for (Map.Entry<String, String> entry : excelDataMap.entrySet()) {
                if (!entry.getKey().contains(sheetName + "#")) continue;
                if (entry.getValue().equals(ResManager.loadKDString((String)"\u8017\u7528\u519c\u4ea7\u54c1\u540d\u79f0", (String)"NcpDeclareReportImportServiceImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]))) {
                    firstRow = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if (!entry.getValue().equals(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"NcpDeclareReportImportServiceImpl_2", (String)"taxc-bdtaxr", (Object[])new Object[0]))) continue;
                secondRow = Integer.parseInt(entry.getKey().split("#")[1]);
            }
            dynRowList.add(new DynRowVo(0, "ncphdkcjsdk2_dth", secondRow - firstRow - 2));
        }
        if (ResManager.loadKDString((String)"\u8d2d\u8fdb\u519c\u4ea7\u54c1\u76f4\u63a5\u9500\u552e\u6838\u5b9a\u519c\u4ea7\u54c1\u589e\u503c\u7a0e\u8fdb\u9879\u7a0e\u989d\u8ba1\u7b97\u8868", (String)"NcpDeclareReportImportServiceImpl_3", (String)"taxc-bdtaxr", (Object[])new Object[0]).equals(sheetName)) {
            firstRow = 0;
            secondRow = 0;
            for (Map.Entry<String, String> entry : excelDataMap.entrySet()) {
                if (!entry.getKey().contains(sheetName + "#")) continue;
                if (entry.getValue().equals(ResManager.loadKDString((String)"\u4ea7\u54c1\u540d\u79f0", (String)"NcpDeclareReportImportServiceImpl_4", (String)"taxc-bdtaxr", (Object[])new Object[0]))) {
                    firstRow = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if (!entry.getValue().equals(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"NcpDeclareReportImportServiceImpl_2", (String)"taxc-bdtaxr", (Object[])new Object[0]))) continue;
                secondRow = Integer.parseInt(entry.getKey().split("#")[1]);
            }
            dynRowList.add(new DynRowVo(0, "ncphdkcjsdk3_dth", secondRow - firstRow - 2));
        }
        if (ResManager.loadKDString((String)"\u8d2d\u8fdb\u519c\u4ea7\u54c1\u7528\u4e8e\u751f\u4ea7\u7ecf\u8425\u4e14\u4e0d\u6784\u6210\u8d27\u7269\u5b9e\u4f53\u6838\u5b9a\u519c\u4ea7\u54c1\u589e\u503c\u7a0e\u8fdb\u9879\u7a0e\u989d", (String)"NcpDeclareReportImportServiceImpl_5", (String)"taxc-bdtaxr", (Object[])new Object[0]).equals(sheetName)) {
            firstRow = 0;
            secondRow = 0;
            for (Map.Entry<String, String> entry : excelDataMap.entrySet()) {
                if (!entry.getKey().contains(sheetName + "#")) continue;
                if (entry.getValue().equals(ResManager.loadKDString((String)"\u8017\u7528\u519c\u4ea7\u54c1\u540d\u79f0", (String)"NcpDeclareReportImportServiceImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]))) {
                    firstRow = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if (!entry.getValue().equals(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"NcpDeclareReportImportServiceImpl_2", (String)"taxc-bdtaxr", (Object[])new Object[0]))) continue;
                secondRow = Integer.parseInt(entry.getKey().split("#")[1]);
            }
            dynRowList.add(new DynRowVo(0, "ncphdkcjsdk4_dth", secondRow - firstRow - 2));
        }
        return dynRowList;
    }

    private String verifyEnableCpmc(Map<String, String> excelDataMap, Date startDate, Date endDate, Long orgid) {
        Object aLong;
        Object aLong2;
        LinkedHashMap cpmcs_id = new LinkedHashMap();
        LinkedHashMap cpmcs_name = new LinkedHashMap();
        this.cpmc.forEach(o -> {
            int startNum = 3;
            while (startNum < 10000) {
                String key = o + startNum + "#1";
                String value = (String)excelDataMap.get(key);
                ++startNum;
                if (Objects.isNull(value) || "--".equals(value)) break;
                if (startNum == 10000) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e\u603b\u6570\u8fc7\u5927\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"NcpDeclareReportImportServiceImpl_15", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
                try {
                    cpmcs_id.put(key, Long.parseLong(value));
                }
                catch (Exception e) {
                    cpmcs_name.put(key, value);
                }
            }
        });
        HashSet cpmcidSet = Sets.newHashSet(cpmcs_id.values());
        HashSet cpmcnameSet = Sets.newHashSet(cpmcs_name.values());
        LinkedHashMap hycpmcids = new LinkedHashMap();
        LinkedHashMap hycpmcnames = new LinkedHashMap();
        this.hymc.forEach(o -> {
            int startNum = 3;
            while (startNum < 10000) {
                String key = o + startNum + "#2";
                String value = (String)excelDataMap.get(key);
                ++startNum;
                if (Objects.isNull(value) || "--".equals(value)) break;
                if (startNum == 10000) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e\u603b\u6570\u8fc7\u5927\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"NcpDeclareReportImportServiceImpl_15", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
                try {
                    hycpmcids.put(key, Long.parseLong(value));
                }
                catch (Exception e) {
                    hycpmcnames.put(key, value);
                }
            }
        });
        HashSet hymcidSet = Sets.newHashSet(hycpmcids.values());
        HashSet hymcnameSet = Sets.newHashSet(hycpmcnames.values());
        QFilter ncp = new QFilter("startdate", "<=", (Object)startDate).and(new QFilter("enddate", ">=", (Object)endDate).or("enddate", "is null", null));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid).and("enable", "=", (Object)"1");
        QFilter fid = new QFilter("id", "in", (Object)cpmcidSet);
        QFilter fname = new QFilter("name", "in", (Object)cpmcnameSet);
        QFilter type1 = new QFilter("nametype", "=", (Object)"cpmc");
        QFilter type2 = new QFilter("nametype", "=", (Object)"hymc");
        DynamicObjectCollection cpmcidquery = QueryServiceHelper.query((String)"tcvat_ncp_declare_name", (String)"id", (QFilter[])new QFilter[]{ncp, orgFilter, fid, type1});
        Set cpmcids = cpmcidquery.stream().map(o -> o.get("id")).collect(Collectors.toSet());
        DynamicObjectCollection cpmcnamequery = QueryServiceHelper.query((String)"tcvat_ncp_declare_name", (String)"name", (QFilter[])new QFilter[]{ncp, orgFilter, fname, type1});
        Set cpmcnameids = cpmcnamequery.stream().map(o -> o.get("name")).collect(Collectors.toSet());
        cpmcidSet.removeAll(cpmcids);
        cpmcnameSet.removeAll(cpmcnameids);
        if (CollectionUtils.isNotEmpty((Collection)cpmcnameSet)) {
            for (Map.Entry key : cpmcs_name.entrySet()) {
                aLong2 = (String)key.getValue();
                if (!cpmcnameSet.contains(aLong2)) continue;
                return this.getErrorString((String)key.getKey());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)cpmcidSet)) {
            for (Map.Entry key : cpmcs_id.entrySet()) {
                aLong2 = (Long)key.getValue();
                if (!cpmcidSet.contains(aLong2)) continue;
                return this.getErrorString((String)key.getKey());
            }
        }
        fid = new QFilter("id", "in", (Object)hymcidSet);
        DynamicObjectCollection hymcidquery = QueryServiceHelper.query((String)"tcvat_ncp_declare_name", (String)"id", (QFilter[])new QFilter[]{ncp, orgFilter, fid, type2});
        Set hyids = hymcidquery.stream().map(o -> o.get("id")).collect(Collectors.toSet());
        fname = new QFilter("name", "in", (Object)hymcnameSet);
        DynamicObjectCollection hymcnamequery = QueryServiceHelper.query((String)"tcvat_ncp_declare_name", (String)"name", (QFilter[])new QFilter[]{ncp, orgFilter, fname, type2});
        Set hynames = hymcnamequery.stream().map(o -> o.get("name")).collect(Collectors.toSet());
        hymcidSet.removeAll(hyids);
        hymcnameSet.removeAll(hynames);
        if (CollectionUtils.isNotEmpty((Collection)hymcnameSet)) {
            for (Map.Entry hykey : hycpmcnames.entrySet()) {
                aLong = (String)hykey.getValue();
                if (!hymcnameSet.contains(aLong)) continue;
                return this.getErrorString((String)hykey.getKey());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)hymcidSet)) {
            for (Map.Entry hykey : hycpmcids.entrySet()) {
                aLong = (Long)hykey.getValue();
                if (!hymcidSet.contains(aLong)) continue;
                return this.getErrorString((String)hykey.getKey());
            }
        }
        return null;
    }

    private String getErrorString(String para) {
        String[] split = para.split("#");
        int errorNum = Integer.parseInt(split[1]) - 2;
        String result = ResManager.loadKDString((String)"\u672a\u67e5\u5230\u3010%1$s\u3011\u7b2c%2$s\u884c\u7684\u4ea7\u54c1\u540d\u79f0/\u8017\u7528\u519c\u4ea7\u54c1\u540d\u79f0\uff0c\u8bf7\u524d\u5f80\u3010\u589e\u503c\u7a0e\u3011\u2192\u3010\u57fa\u7840\u8bbe\u7f6e\u3011\u2192\u3010\u519c\u4ea7\u54c1\u7533\u62a5\u540d\u79f0\u914d\u7f6e\u3011\u68c0\u67e5\u914d\u7f6e\u3002", (String)"NcpDeclareReportImportServiceImpl_16", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        if (para.startsWith(ResManager.loadKDString((String)"\u8d2d\u8fdb\u519c\u4ea7\u54c1\u76f4\u63a5\u9500\u552e", (String)"NcpDeclareReportImportServiceImpl_19", (String)"taxc-bdtaxr", (Object[])new Object[0]))) {
            result = ResManager.loadKDString((String)"\u672a\u67e5\u5230\u3010%1$s\u3011\u7b2c%2$s\u884c\u7684\u4ea7\u54c1\u540d\u79f0\uff0c\u8bf7\u524d\u5f80\u3010\u589e\u503c\u7a0e\u3011\u2192\u3010\u57fa\u7840\u8bbe\u7f6e\u3011\u2192\u3010\u519c\u4ea7\u54c1\u7533\u62a5\u540d\u79f0\u914d\u7f6e\u3011\u68c0\u67e5\u914d\u7f6e\u3002", (String)"NcpDeclareReportImportServiceImpl_17", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        }
        return String.format(result, split[0], errorNum);
    }
}

