/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service.impl.AbstractOverseasReportImportService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.vo.DynRowVo;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OverseasUsaCitReportImportServiceImpl
extends AbstractOverseasReportImportService {
    private static final List<String> AREA_LIST = Arrays.asList("Alabama", "Alaska", "Arizona", "Arkansas", "California", "Colorado", "Connecticut", "Delaware", "Florida", "Georgia", "Hawaii", "Idaho", "Illinois", "Indiana", "Iowa", "Kansas", "Kentucky", "Louisiana", "Maryland", "Massachusetts", "Michigan", "Minnesota", "Mississippi", "Missouri", "Montana", "Nebraska", "New Hampshire", "New Jersey", "New Mexico", "New York", "North Carolina", "North Dakota", "Oklahoma", "Oregon", "Pennsylvania", "Rhode Island", "South Carolina", "Tennessee", "Utah", "Vermont", "Virginia", "West Virginia", "Wisconsin", "Washington D.C.");
    private static final String regex = "6.3.\\d+";

    @Override
    public List<DynRowVo> getDynRowList(String sheetName, Map<String, String> excelDataMap) {
        ArrayList<DynRowVo> dynRowList = new ArrayList<DynRowVo>(8);
        int row1 = 0;
        int row2 = 0;
        boolean row_2_2_2_1 = false;
        boolean row_2_2_3 = false;
        boolean row_2_2_3_x = false;
        int row3 = 0;
        int row3_1 = 0;
        int row4 = 0;
        int row5 = 0;
        int row6 = 0;
        int row7 = 0;
        int row7_1 = 0;
        int row8 = 0;
        int row9 = 0;
        int row10 = 0;
        int row11 = 0;
        int row12 = 0;
        int row14 = 0;
        int row15 = 0;
        int row16 = 0;
        int row17 = 0;
        int row18 = 0;
        int row19 = 0;
        int row20 = 0;
        int row21 = 0;
        int row22 = 0;
        int row_6_2_1 = 0;
        int row_6_3 = 0;
        int row_6_3_x = 0;
        if ("Federation".equals(sheetName)) {
            for (Map.Entry<String, String> entry : excelDataMap.entrySet()) {
                if (this.filterMap(sheetName, entry)) continue;
                if ("1".equals(entry.getValue().trim())) {
                    row1 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("2".equals(entry.getValue().trim())) {
                    row2 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("4".equals(entry.getValue().trim())) {
                    row4 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("6.2.1".equals(entry.getValue().trim())) {
                    row_6_2_1 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("6.3".equals(entry.getValue().trim())) {
                    row_6_3 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)entry.getValue().trim()) && entry.getValue().trim().matches(regex)) {
                    int i = Integer.parseInt(entry.getKey().split("#")[1]);
                    row_6_3_x = Math.max(row_6_3_x, i);
                    continue;
                }
                if ("3".equals(entry.getValue().trim())) {
                    row3 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("5".equals(entry.getValue().trim())) {
                    row5 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("6".equals(entry.getValue().trim())) {
                    row6 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("7".equals(entry.getValue().trim())) {
                    row7 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("14".equals(entry.getValue().trim())) {
                    row14 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("15".equals(entry.getValue().trim())) {
                    row15 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("16".equals(entry.getValue().trim())) {
                    row16 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("17".equals(entry.getValue().trim())) {
                    row17 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("19".equals(entry.getValue().trim())) {
                    row19 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if (!"20".equals(entry.getValue().trim())) continue;
                row20 = Integer.parseInt(entry.getKey().split("#")[1]);
            }
            row_6_3_x = row_6_3_x != 0 ? row_6_3_x : row_6_3;
            dynRowList.add(new DynRowVo(0, "Income_dyn", row2 - row1 - 1));
            dynRowList.add(new DynRowVo(1, "Deductions_dyn", row3 - row2 - 1));
            dynRowList.add(new DynRowVo(2, "GAAPAudit_adjustment_dyn", row5 - row4 - 1));
            dynRowList.add(new DynRowVo(3, "Texas_dyn", row_6_3 - row_6_2_1 - 1));
            dynRowList.add(new DynRowVo(4, "Other_state_taxes_dyn", row_6_3_x + 1 - row_6_3 - 1));
            dynRowList.add(new DynRowVo(5, "Tax_adjustment_dyn", row7 - row_6_3_x - 1));
            dynRowList.add(new DynRowVo(6, "Non_refundable_credit_fe_dyn", row15 - row14 - 1));
            dynRowList.add(new DynRowVo(7, "Other_levy_fe_dyn", row17 - row16 - 1));
            dynRowList.add(new DynRowVo(8, "Tax_paid_and_refundable_credit_fe_dyn", row20 - row19 - 1));
        } else if ("Maine".equals(sheetName)) {
            for (Map.Entry<String, String> entry : excelDataMap.entrySet()) {
                if (this.filterMap(sheetName, entry)) continue;
                if ("3".equals(entry.getValue().trim())) {
                    row3 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("4".equals(entry.getValue().trim())) {
                    row4 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("9".equals(entry.getValue().trim())) {
                    row9 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("10".equals(entry.getValue().trim())) {
                    row10 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("11".equals(entry.getValue().trim())) {
                    row11 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if (!"12".equals(entry.getValue().trim())) continue;
                row12 = Integer.parseInt(entry.getKey().split("#")[1]);
            }
            dynRowList.add(new DynRowVo(0, "Income_modifications_dyn", row4 - row3 - 1));
            dynRowList.add(new DynRowVo(1, "Non_refundable_credit_maine_dyn", row10 - row9 - 1));
            dynRowList.add(new DynRowVo(2, "Tax_paid_and_refundable_credit_maine_dyn", row12 - row11 - 1));
        } else if (AREA_LIST.contains(sheetName)) {
            for (Map.Entry<String, String> entry : excelDataMap.entrySet()) {
                if (this.filterMap(sheetName, entry)) continue;
                if ("3.1".equals(entry.getValue().trim())) {
                    row3_1 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("4".equals(entry.getValue().trim())) {
                    row4 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("7.1".equals(entry.getValue().trim())) {
                    row7_1 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("8".equals(entry.getValue().trim())) {
                    row8 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("9".equals(entry.getValue().trim())) {
                    row9 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("10".equals(entry.getValue().trim())) {
                    row10 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("17".equals(entry.getValue().trim())) {
                    row17 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("18".equals(entry.getValue().trim())) {
                    row18 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("19".equals(entry.getValue().trim())) {
                    row19 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("20".equals(entry.getValue().trim())) {
                    row20 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if ("21".equals(entry.getValue().trim())) {
                    row21 = Integer.parseInt(entry.getKey().split("#")[1]);
                    continue;
                }
                if (!"22".equals(entry.getValue().trim())) continue;
                row22 = Integer.parseInt(entry.getKey().split("#")[1]);
            }
            String prefix = !sheetName.contains(" ") ? sheetName : ("Washington D.C.".equals(sheetName) ? "Washington_DC" : sheetName.replaceAll(" ", "_"));
            dynRowList.add(new DynRowVo(0, prefix.concat("_Federal_income_tax_deduction_dyn"), row4 - row3_1 - 1));
            dynRowList.add(new DynRowVo(1, prefix.concat("_Federal_income_tax_deduction_common_dyn"), row8 - row7_1 - 1));
            dynRowList.add(new DynRowVo(2, prefix.concat("_Unutilised_losses_dyn"), row10 - row9 - 1));
            dynRowList.add(new DynRowVo(3, prefix.concat("_Non_refundable_credit_dyn"), row18 - row17 - 1));
            dynRowList.add(new DynRowVo(4, prefix.concat("_Other_levy_dyn"), row20 - row19 - 1));
            dynRowList.add(new DynRowVo(5, prefix.concat("_Tax_paid_and_refundable_credit_dyn"), row22 - row21 - 1));
        } else if ("USA Unutilised\u00a0losses".equalsIgnoreCase(sheetName)) {
            for (Map.Entry<String, String> entry : excelDataMap.entrySet()) {
                if (this.filterMap(sheetName, entry)) continue;
                if ("Tax Jurisdiction".equals(entry.getValue().trim())) {
                    row1 = Integer.parseInt(entry.getKey().split("#")[1]);
                }
                if (!"Taxable income".equals(entry.getValue().trim())) continue;
                row2 = Integer.parseInt(entry.getKey().split("#")[1]);
            }
            dynRowList.add(new DynRowVo(0, "Federation_dyn", row2 - row1 - 1));
        }
        return dynRowList;
    }

    @Override
    public void sendImportSheets(DeclareRequestModel requestModel, List<String> sheetNames) {
        super.sendImportSheets(requestModel, sheetNames);
        Long id = requestModel.getId();
        QFilter filter = new QFilter("id", "is not null", null);
        DynamicObjectCollection taxareagroupList = QueryServiceHelper.query((String)"bastax_taxareagroup", (String)"id,name", (QFilter[])filter.toArray());
        Map<String, Long> map = taxareagroupList.stream().collect(Collectors.toMap(k -> k.getString("name"), v -> v.getLong("id"), (k1, k2) -> k1));
        DeleteServiceHelper.delete((String)"gtcp_draft_tab", (QFilter[])new QFilter[]{new QFilter("draftid", "=", (Object)id)});
        List<DynamicObject> tableInfoList = sheetNames.stream().map(tabName -> {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gtcp_draft_tab");
            dynamicObject.set("tab", tabName);
            dynamicObject.set("draftid", (Object)id);
            Long taxareagroupId = (Long)map.get(tabName);
            if ("Texas (FT)".equals(tabName)) {
                taxareagroupId = 1681071243350195200L;
            } else if ("State income tax overview".equalsIgnoreCase((String)tabName)) {
                taxareagroupId = 1616686278185582592L;
            } else if ("Federation".equals(tabName)) {
                taxareagroupId = 1681073516923009024L;
            }
            if (taxareagroupId != null) {
                dynamicObject.set("taxareagroup", (Object)taxareagroupId);
            }
            return dynamicObject;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(tableInfoList)) {
            SaveServiceHelper.save((DynamicObject[])tableInfoList.toArray(new DynamicObject[0]));
        }
    }
}

