/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportopen.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.business.multidideclare.MultiDeclareBizBusiness;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportopen.service.DeclareReportOpenService;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.taxdeclare.enums.TaxDeclareMetaRouteEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class GtcpDeclareReportOpenService
implements DeclareReportOpenService {
    @Override
    public DynamicObject loadDecalre(String type, Long id, String number, Map<String, Object> params, boolean isHistory) {
        return this.queryDeclare(id);
    }

    protected DynamicObject queryDeclare(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"gtcp_normal_draft_list");
    }

    @Override
    public Map<String, Object> getExtendParams(String type, DynamicObject object, boolean isHistory) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(10);
        customParams.put("sbbid", object.getString("id"));
        customParams.put("billno", object.getString("billno"));
        customParams.put("orgid", object.getDynamicObject("org").getString("id"));
        customParams.put("orgname", object.getDynamicObject("org").getString("name"));
        Date skssqq = object.getDate("skssqq");
        Date skssqz = object.getDate("skssqz");
        String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
        customParams.put("skssqq", startDate);
        customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
        customParams.put("readonly", Boolean.TRUE);
        customParams.put("modifytime", object.getDate("modifytime"));
        String dataType = object.getString("datatype");
        customParams.put("datatype", dataType);
        customParams.put("templatetype", type);
        this.setExtendParamByVersion(object, customParams);
        return customParams;
    }

    private void setExtendParamByVersion(DynamicObject object, Map<String, Object> customParams) {
        Long taxTypeId = object.get("taxtype") == null ? 0L : ((DynamicObject)object.get("taxtype")).getLong("id");
        Long taxareagroupId = object.get("taxareagroup") == null ? 0L : ((DynamicObject)object.get("taxareagroup")).getLong("id");
        customParams.put("papers_status", object.get("billstatus"));
        customParams.put("taxationsys", ((DynamicObject)object.get("taxsystem")).getLong("id"));
        customParams.put("taxtype", taxTypeId);
        customParams.put("taxcategory", taxTypeId);
        customParams.put("taxareagroup", taxareagroupId);
        customParams.put("remarks", object.getString("remarks"));
    }

    @Override
    public String getDeclareFormId(String type, DynamicObject object, boolean isHistory) {
        boolean isUpdated = MultiDeclareBizBusiness.isModelUpdated(type);
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        boolean isDeclare = templateEnum.isDeclare();
        String editPage = templateEnum.getEditPage();
        if (isUpdated) {
            if (isHistory && isDeclare) {
                editPage = "multi_declare_show";
            } else {
                TaxDeclareMetaRouteEnum metaRouteEnum = TaxDeclareMetaRouteEnum.getEnumByDeclarePage((String)editPage);
                if (metaRouteEnum != null) {
                    editPage = metaRouteEnum.getThreeMetaEntity();
                }
            }
        } else if (isHistory && isDeclare) {
            editPage = templateEnum.getDeclareShowPage();
        }
        return editPage;
    }

    @Override
    public String getDecalreListFormId(String type, Map<String, Object> customParams, boolean isHistory) {
        return null;
    }
}

