/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.DeclareReportSaveService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.ObjectUtils;

public class GtcpOverSeasCitDeclareReportSaveImpl
implements DeclareReportSaveService {
    private static Log logger = LogFactory.getLog(GtcpOverSeasCitDeclareReportSaveImpl.class);

    @Override
    public BaseResult saveTeeData(DeclareRequestModel requestModel, Map<String, String> treeData) {
        return null;
    }

    @Override
    public BaseResult saveBusinessData(Map<String, Object> requestParams, Map<String, Object> resultData) {
        Long id = requestParams.containsKey("Id") ? (Long)requestParams.get("Id") : 0L;
        if (ObjectUtils.isNotEmpty((Object)requestParams.get("skssqq")) && ObjectUtils.isNotEmpty((Object)requestParams.get("skssqz"))) {
            Date skssqq = DateUtils.stringToDate((String)requestParams.get("skssqq").toString());
            Date skssqz = DateUtils.stringToDate((String)requestParams.get("skssqz").toString());
            boolean year = DateUtils.validDateRange((String)"year", (Date)skssqq, (Date)skssqz);
            BigDecimal accrual = BigDecimal.ZERO;
            BigDecimal reporting = BigDecimal.ZERO;
            BigDecimal differences = BigDecimal.ZERO;
            if (year) {
                accrual = ObjectUtils.isNotEmpty((Object)resultData.get("generalincome_net_tax_payable#generalincome_rta_accrual")) ? new BigDecimal(resultData.get("generalincome_net_tax_payable#generalincome_rta_accrual").toString()) : BigDecimal.ZERO;
                reporting = ObjectUtils.isNotEmpty((Object)resultData.get("generalincome_net_tax_payable#generalincome_rta_reporting")) ? new BigDecimal(resultData.get("generalincome_net_tax_payable#generalincome_rta_reporting").toString()) : BigDecimal.ZERO;
            } else {
                accrual = ObjectUtils.isNotEmpty((Object)resultData.get("generalincome_amount_tobe_accrued#generalincome_rta_accrual")) ? new BigDecimal(resultData.get("generalincome_amount_tobe_accrued#generalincome_rta_accrual").toString()) : BigDecimal.ZERO;
                reporting = ObjectUtils.isNotEmpty((Object)resultData.get("generalincome_amount_due_overp#generalincome_rta_reporting")) ? new BigDecimal(resultData.get("generalincome_amount_due_overp#generalincome_rta_reporting").toString()) : BigDecimal.ZERO;
            }
            differences = reporting.subtract(accrual);
            logger.info("accrual", (Object)accrual);
            logger.info("reportingg", (Object)reporting);
            logger.info("differences", (Object)differences);
            boolean doSaveData = this.doSaveData(id, accrual, reporting, differences);
            if (doSaveData) {
                logger.info("GtcpOverSeasCitDeclareReportSaveImpl save success");
                return BaseResult.ok();
            }
        }
        return BaseResult.fail((String)"save error");
    }

    private boolean doSaveData(Long id, BigDecimal accrual, BigDecimal reporting, BigDecimal differences) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"gtcp_compare_entry_info", (String)"id,sseq,draftid,taxaccrual,declaretax,difference", (QFilter[])new QFilter[]{new QFilter("draftid", "=", (Object)id)});
        DynamicObject dynObject = BusinessDataServiceHelper.newDynamicObject((String)"gtcp_compare_entry_info");
        if (ObjectUtils.isEmpty((Object)dynamicObject)) {
            dynamicObject = dynObject;
            dynamicObject.set("sseq", (Object)1);
        }
        dynamicObject.set("draftid", (Object)id);
        dynamicObject.set("taxaccrual", (Object)accrual);
        dynamicObject.set("declaretax", (Object)reporting);
        dynamicObject.set("difference", (Object)differences);
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return save.length == 1;
    }
}

