/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.DeclareReportSaveService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class OverseasUsaCitRtaDeclareReportSaveImpl
implements DeclareReportSaveService {
    @Override
    public BaseResult saveTeeData(DeclareRequestModel requestModel, Map<String, String> treeData) {
        return BaseResult.ok();
    }

    @Override
    public BaseResult saveBusinessData(Map<String, Object> requestParams, Map<String, Object> resultData) {
        if (ObjectUtils.isNotEmpty(requestParams) && ObjectUtils.isNotEmpty((Object)requestParams.get("allshowTabList"))) {
            List tabList = (List)SerializationUtils.fromJsonString((String)requestParams.get("allshowTabList").toString(), List.class);
            long id = Long.parseLong(requestParams.get("Id").toString());
            if (ObjectUtils.isNotEmpty((Object)tabList)) {
                DeleteServiceHelper.delete((String)"gtcp_jtandbd_tab", (QFilter[])new QFilter[]{new QFilter("draftid", "=", (Object)id)});
                List<DynamicObject> tableInfoList = tabList.stream().map(tabName -> {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gtcp_jtandbd_tab");
                    dynamicObject.set("tab", tabName);
                    dynamicObject.set("draftid", (Object)id);
                    return dynamicObject;
                }).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(tableInfoList)) {
                    SaveServiceHelper.save((DynamicObject[])tableInfoList.toArray(new DynamicObject[0]));
                }
            }
            if (ObjectUtils.isNotEmpty((Object)requestParams.get("accrualItemList")) && ObjectUtils.isNotEmpty((Object)requestParams.get("reportingItemList"))) {
                BigDecimal decimal;
                List accrualItemList = (List)SerializationUtils.fromJsonString((String)requestParams.get("accrualItemList").toString(), List.class);
                List reportingItemList = (List)SerializationUtils.fromJsonString((String)requestParams.get("reportingItemList").toString(), List.class);
                BigDecimal accrual = BigDecimal.ZERO;
                BigDecimal reporting = BigDecimal.ZERO;
                BigDecimal differences = BigDecimal.ZERO;
                for (String accrualStr : accrualItemList) {
                    decimal = ObjectUtils.isNotEmpty((Object)resultData.get(accrualStr)) ? new BigDecimal(resultData.get(accrualStr).toString()) : BigDecimal.ZERO;
                    accrual = accrual.add(decimal);
                }
                for (String reportingStr : reportingItemList) {
                    decimal = ObjectUtils.isNotEmpty((Object)resultData.get(reportingStr)) ? new BigDecimal(resultData.get(reportingStr).toString()) : BigDecimal.ZERO;
                    reporting = reporting.add(decimal);
                }
                differences = reporting.subtract(accrual);
                boolean doSaveData = this.doSaveData(id, accrual, reporting, differences);
                if (doSaveData) {
                    return BaseResult.ok();
                }
            }
        }
        return BaseResult.ok();
    }

    private boolean doSaveData(Long id, BigDecimal accrual, BigDecimal reporting, BigDecimal differences) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"gtcp_compare_entry_info", (String)"id,sseq,draftid,taxaccrual,declaretax,difference", (QFilter[])new QFilter[]{new QFilter("draftid", "=", (Object)id)});
        DynamicObject dynObject = BusinessDataServiceHelper.newDynamicObject((String)"gtcp_compare_entry_info");
        if (ObjectUtils.isEmpty((Object)dynamicObject)) {
            dynamicObject = dynObject;
            dynamicObject.set("sseq", (Object)1);
        }
        dynamicObject.set("draftid", (Object)id);
        dynamicObject.set("taxaccrual", (Object)accrual);
        dynamicObject.set("declaretax", (Object)reporting);
        dynamicObject.set("difference", (Object)differences);
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return save.length == 1;
    }
}

