/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttemplate.service;

import java.util.List;
import java.util.Map;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttemplate.service.DeclareReportTemplateService;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.vo.TemplateVo;

public class TccitYjReportTemplateServiceImp
implements DeclareReportTemplateService {
    @Override
    public TemplateVo parseTemplateByData(TemplateVo template, Map<String, String> data, List<DynamicRowModel> dynRowList) {
        if ("CITQR2023".equals(template.getTemplateNumber())) {
            List rows = (List)template.getDynamicRow().get("tccit_qysds_ext_dyn3#1");
            for (List row : rows) {
                for (Cell cell : row) {
                    if (cell.getText() == null || !cell.getText().matches("\\$\\{tccit_qysds_ext_dyn3#\\d+#sprate}") || cell.getStyle() == null) continue;
                    cell.getStyle().setLocked(this.lockDyn3Rate(cell.getText(), data, dynRowList));
                }
            }
        }
        return template;
    }

    private Boolean lockDyn3Rate(String text, Map<String, String> data, List<DynamicRowModel> dynRowList) {
        String dyn3HeaderKey = "tccit_qysds_ext_dyn3#1";
        String spItemId = "1408002055339105280";
        if (dynRowList == null || dynRowList.stream().noneMatch(s -> dyn3HeaderKey.equals(s.getDynRowNo()))) {
            return Boolean.TRUE;
        }
        String[] split = text.replaceAll("\\$\\{", "").replaceAll("\\}", "").split("#");
        String s1 = split[0];
        String s2 = split[1];
        Boolean lock = Boolean.TRUE;
        if (spItemId.equals(data.get(s1 + "#" + s2 + "#item"))) {
            lock = Boolean.FALSE;
        }
        return lock;
    }
}

