/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttree.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttree.service.DeclareReportTreeService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;

public class IctmDraftTreeImpl
implements DeclareReportTreeService {
    @Override
    public Map<String, Object> loadTree(DeclareRequestModel requestModel, String selectNode, String sourceFrom) {
        String draftNumber = "";
        if (requestModel.getBusinessMap() != null) {
            draftNumber = (String)requestModel.getBusinessMap().get("billno");
        }
        List<TreeNode> lightTreeNode = this.createLightTreeNode(draftNumber);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("treeData", lightTreeNode);
        return data;
    }

    public List<TreeNode> createLightTreeNode(String draftNumber) {
        DynamicObject[] tabNodes;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"ictm_declare_query_list", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)draftNumber)});
        DynamicObject[] tabs = null;
        if (dynamicObject != null) {
            long id = dynamicObject.getLong("id");
            tabs = BusinessDataServiceHelper.load((String)"ictm_drawup_tab", (String)"draftid,tab", (QFilter[])new QFilter[]{new QFilter("draftid", "=", (Object)id)});
        }
        Set tabIds = null;
        if (tabs == null || tabs.length == 0) {
            tabNodes = BusinessDataServiceHelper.load((String)"tpo_gljysb_tab", (String)"id,number,name,parent", null, (String)"number asc");
            tabIds = Arrays.stream(tabNodes).map(o -> o.getLong("id")).collect(Collectors.toSet());
        } else {
            tabIds = Arrays.stream(tabs).map(o -> o.getDynamicObject("tab").getLong("id")).collect(Collectors.toSet());
        }
        tabNodes = BusinessDataServiceHelper.load((String)"tpo_gljysb_tab", (String)"id,number,name,parent", (QFilter[])new QFilter[]{new QFilter("id", "in", tabIds)}, (String)"number asc");
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(16);
        for (int i = 0; i < tabNodes.length; ++i) {
            TreeNode leftRoot = new TreeNode();
            String id = tabNodes[i].getString("id");
            String name = tabNodes[i].getString("name");
            String number = tabNodes[i].getString("name");
            String parentid = tabNodes[i].getString("parent.id");
            leftRoot.setId(id);
            leftRoot.setText(name);
            leftRoot.setType(number);
            leftRoot.setParentid(parentid);
            nodeList.add(leftRoot);
        }
        List treeNodes = TreeUtils.buildWithChildren(nodeList);
        return treeNodes;
    }
}

