/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.taxbureau.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.taxbureau.service.TaxbureauDeclareService;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.db.DataSaveService;
import kd.taxc.bdtaxr.common.declare.helper.TemplateFormulaServiceHelper;
import kd.taxc.bdtaxr.common.enums.FinanceCheckReportEnum;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.util.CompareUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.finance.DeclareCheckFacility;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.utils.ObjectUtils;

public class TcvvtFinanceDeclareCompareAndConvertServiceImpl
implements TaxbureauDeclareService {
    private static List<String> noNeedHadleSheetsName = Arrays.asList("tcvvt_finance_scjyxxb", "tcvvt_finance_qykjzzfz");

    @Override
    public boolean compare(Long templateId, Map<String, String> data1, Map<String, String> data2) {
        Map metaMap = TemplateFormulaServiceHelper.getMetaDataListByTmpId((Long)templateId);
        Map entityFieldMap = TemplateUtils.getAllEntity((Map)metaMap);
        Map templateKeys = TemplateFormulaServiceHelper.getTemplateKeys((Long)templateId);
        List<String> noNeedSheetNames = this.getSheetNames(data1, false);
        noNeedSheetNames.addAll(noNeedHadleSheetsName);
        String org = data1.get("tcvat_nsrxx#1#org");
        Date skssqq = DateUtils.stringToDate2((String)data1.get("tcvat_nsrxx#1#skssqq"));
        Date skssqz = DateUtils.stringToDate2((String)data1.get("tcvat_nsrxx#1#skssqz"));
        boolean b = this.issameSheet(data1, skssqq, skssqz, org);
        if (!b) {
            return false;
        }
        for (String key : templateKeys.keySet()) {
            EntityField entityField;
            String sheetName = key.split("#")[0];
            if (noNeedSheetNames.contains(sheetName) || !CompareUtils.isDiff((String)key, data1, data2, (EntityField)(entityField = (EntityField)entityFieldMap.get(key)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void convert(Map<String, String> newdata, Map<String, String> metaMap, DynamicObject nsrxx) {
        Date skssqq = nsrxx.getDate("skssqq");
        Date skssqz = nsrxx.getDate("skssqz");
        String org = nsrxx.getString("org");
        for (Map.Entry<String, String> entry : metaMap.entrySet()) {
            if ("tcvat_nsrxx".equals(entry.getKey())) continue;
            QFilter qFilter = DeclareConstant.LONG_SBBID_ENTITIES.contains(entry.getKey()) ? new QFilter("sbbid", "=", (Object)nsrxx.getLong("id")) : new QFilter("sbbid", "=", (Object)nsrxx.getString("id"));
            DeleteServiceHelper.delete((String)entry.getKey(), (QFilter[])new QFilter[]{qFilter});
        }
        DynamicObject templateType = DeclareCheckFacility.getTemplateType((String)org, (Date)skssqq, (Date)skssqz);
        if (!ObjectUtils.isEmpty((Object)templateType)) {
            String templatenum = templateType.getString("number");
            String templateid = templateType.getString("id");
            List<String> needSheetNames = this.getSheetNames(newdata, true);
            ArrayList<Long> sheetIdsList = new ArrayList<Long>();
            for (FinanceCheckReportEnum value : FinanceCheckReportEnum.values()) {
                if (!needSheetNames.contains(value.getName())) continue;
                Map templateNumToCheckReportId = value.getTemplateNumToCheckReportId();
                Long sheetId = (Long)templateNumToCheckReportId.get(templatenum);
                sheetIdsList.add(sheetId);
            }
            this.getSelectSheet(templateid, Long.parseLong(org), skssqq, skssqz, sheetIdsList);
            this.deleteTempTable(org, skssqq, skssqz);
            DataSaveService.mapToTable((String)"tcvat_nsrxx", newdata, new HashMap(), metaMap);
        }
    }

    private List<String> getSheetNames(Map<String, String> data, boolean isNeedSheet) {
        HashMap map = new HashMap(512);
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String sheetname = entry.getKey().split("#")[0];
            if ("tcvat_nsrxx".equals(sheetname) || noNeedHadleSheetsName.contains(sheetname)) continue;
            Map valueMap = map.containsKey(sheetname) ? (Map)map.get(sheetname) : new HashMap();
            valueMap.put(entry.getKey(), entry.getValue());
            map.put(sheetname, valueMap);
        }
        ArrayList<String> noNeedSheetName = new ArrayList<String>();
        ArrayList<String> needSheetName = new ArrayList<String>();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            boolean flag = false;
            Map value = (Map)entry.getValue();
            for (String s : value.values()) {
                if (ObjectUtils.isEmpty((Object)s)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                noNeedSheetName.add(key);
                continue;
            }
            needSheetName.add(key);
        }
        if (isNeedSheet) {
            return needSheetName;
        }
        return noNeedSheetName;
    }

    private void getSelectSheet(String templateid, Long orgId, Date skssqq, Date skssqz, List<Long> sheetIdsList) {
        QFilter templateidf = new QFilter("templateid", "=", (Object)templateid);
        QFilter orgf = new QFilter("orgid", "=", (Object)orgId);
        QFilter skssqqf = new QFilter("startdate", "=", (Object)skssqq);
        QFilter skssqzf = new QFilter("enddate", "=", (Object)skssqz);
        DynamicObject message = BusinessDataServiceHelper.loadSingleFromCache((String)"tcvvt_message", (QFilter[])new QFilter[]{templateidf, orgf, skssqqf, skssqzf});
        DynamicObjectCollection entryentity = null;
        if (!ObjectUtils.isEmpty((Object)message)) {
            entryentity = message.getDynamicObjectCollection("entryentity");
        }
        if (entryentity != null && !ObjectUtils.isEmpty((Object)entryentity)) {
            entryentity.clear();
            for (Long l : sheetIdsList) {
                DynamicObject entryObject = entryentity.addNew();
                entryObject.set("selectid", (Object)l);
            }
        }
        message.set("entryentity", (Object)entryentity);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{message});
    }

    private boolean issameSheet(Map<String, String> data, Date skssqq, Date skssqz, String org) {
        boolean flag = false;
        DynamicObject templateType = DeclareCheckFacility.getTemplateType((String)org, (Date)skssqq, (Date)skssqz);
        String templateid = "";
        if (!ObjectUtils.isEmpty((Object)templateType)) {
            templateid = templateType.getString("id");
        }
        QFilter templateidf = new QFilter("templateid", "=", (Object)templateid);
        QFilter orgf = new QFilter("orgid", "=", (Object)Long.parseLong(org));
        QFilter skssqqf = new QFilter("startdate", "=", (Object)skssqq);
        QFilter skssqzf = new QFilter("enddate", "=", (Object)skssqz);
        List<String> sheetNames = this.getSheetNames(data, true);
        DynamicObject message = BusinessDataServiceHelper.loadSingleFromCache((String)"tcvvt_message", (QFilter[])new QFilter[]{templateidf, orgf, skssqqf, skssqzf});
        if (!ObjectUtils.isEmpty((Object)message)) {
            DynamicObjectCollection entryentity = message.getDynamicObjectCollection("entryentity");
            List sheetIds = entryentity.stream().map(o -> o.getLong("selectid")).collect(Collectors.toList());
            QFilter idsf = new QFilter("id", "in", sheetIds);
            DynamicObjectCollection entitytable = QueryServiceHelper.query((String)"tcvvt_check_report", (String)"entitytable", (QFilter[])new QFilter[]{idsf});
            if (!ObjectUtils.isEmpty((Object)entitytable)) {
                List selectSheetName = entitytable.stream().map(o -> o.getString("entitytable")).collect(Collectors.toList());
                Collections.sort(sheetNames);
                Collections.sort(selectSheetName);
                if (sheetNames.equals(selectSheetName)) {
                    flag = true;
                }
            }
        }
        return flag;
    }

    private void deleteTempTable(String orgid, Date startdate, Date enddate) {
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        QFilter skssqqzFilter = new QFilter("skssqq", "=", (Object)startdate).and(new QFilter("skssqz", "=", (Object)enddate));
        DeleteServiceHelper.delete((String)"tcvvt_main_account", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        DeleteServiceHelper.delete((String)"tcvvt_main_detail", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        DeleteServiceHelper.delete((String)"tcvvt_main_adjust", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
        DeleteServiceHelper.delete((String)"tcvvt_main_adjust_tp", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
    }
}

