/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.update;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.update.DeclareDataUpdService;
import kd.taxc.bdtaxr.business.template.impl.TemplateServiceImpl;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.upgrade.UpdConstant;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public abstract class AbstractDeclareDataUpdService
extends AbstractUpgradeFormPlugin
implements DeclareDataUpdService {
    private static final String DELETE_MAIN_SQL = "DELETE FROM t_tpo_declare_main_tsc WHERE FID = ?";
    private static final String INSERT_MAIN_SQL = "INSERT INTO t_tpo_declare_main_tsc (%s) VALUES (%s);";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            String appid = this.getAppid();
            DynamicObject updConfig = QueryServiceHelper.queryOne((String)"tpo_sbmodel_update_conf", (String)" * ", (QFilter[])new QFilter("taxappid", "=", (Object)appid).toArray());
            boolean isAutoUpd = updConfig.getBoolean("isautoupd");
            boolean isUpdated = updConfig.getBoolean("isupdated");
            if (!isAutoUpd) {
                this.logs.append("The tax type doesn't need to upgrade");
            } else if (isUpdated) {
                this.logs.append("The tax type already update");
            } else {
                List templateTypes = UpdConstant.getTemplateTypeByApp((String)appid);
                this.update(templateTypes, this.getRefresh(), appid);
            }
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + StringUtil.getStackTraceMessage((Throwable)t);
            this.getLogger().error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    protected void update(List<String> templateTypes, boolean refresh, String appid) {
        this.addLog(INFO, "DATA UPGRADE APPID:" + appid);
        if (EmptyCheckUtils.isEmpty(templateTypes)) {
            this.logs.append("The template types is empty");
            return;
        }
        DynamicObject updConfig = QueryServiceHelper.queryOne((String)"tpo_sbmodel_update_conf", (String)" * ", (QFilter[])new QFilter("taxappid", "=", (Object)appid).toArray());
        boolean isAutoUpd = updConfig.getBoolean("isautoupd");
        boolean isUpdated = updConfig.getBoolean("isupdated");
        if (!isAutoUpd) {
            this.logs.append("The tax type doesn't need to upgrade");
        } else if (isUpdated) {
            this.logs.append("The tax type already update");
        } else {
            this.doUpdate(templateTypes, refresh, appid);
        }
    }

    /*
     * Exception decompiling
     */
    protected void doUpdate(List<String> templateTypes, boolean refresh, String appid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getInsertSql() {
        String fields = UpdConstant.NSRXX_DB_FIELD_MAP.values().stream().collect(Collectors.joining(","));
        String presitFlag = UpdConstant.NSRXX_DB_FIELD_MAP.keySet().stream().map(a -> "?").collect(Collectors.joining(","));
        return String.format(INSERT_MAIN_SQL, fields, presitFlag);
    }

    protected void saveAfter(String appid) {
        DynamicObject updConfig = QueryServiceHelper.queryOne((String)"tpo_sbmodel_update_conf", (String)" id ", (QFilter[])new QFilter("taxappid", "=", (Object)appid).toArray());
        Object id = updConfig.get("id");
        updConfig = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tpo_sbmodel_update_conf");
        updConfig.set("isupdated", (Object)Boolean.TRUE);
        updConfig.set("modifydate", (Object)new Date());
        updConfig.set("modifier", (Object)RequestContext.get().getCurrUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{updConfig});
    }

    protected Map<String, List<DynamicObject>> updMainDataAndRecord(DynamicObject[] sbbArr, String updRecordType, List<Object[]> maindataDbPars) {
        HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>();
        ArrayList<DynamicObject> maindata = new ArrayList<DynamicObject>(sbbArr.length * 2);
        ArrayList<DynamicObject> updRecordData = new ArrayList<DynamicObject>(sbbArr.length * 2);
        Date date = new Date();
        for (DynamicObject oldOBject : sbbArr) {
            DynamicObject newSbObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tpo_declare_main_tsc"));
            for (Map.Entry entry : UpdConstant.NSRXX_FIELD_MAP.entrySet()) {
                newSbObject.set((String)entry.getValue(), oldOBject.get((String)entry.getKey()));
            }
            maindata.add(newSbObject);
            this.addMainDataDbPar(maindataDbPars, oldOBject);
            DynamicObject updRecord = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bdtaxr_plugin_upgrade"));
            updRecord.set("table", (Object)"t_tctb_declare_main");
            updRecord.set("key", (Object)oldOBject.getString("id"));
            updRecord.set("type", (Object)updRecordType);
            updRecord.set("success", (Object)"1");
            updRecord.set("createtime", (Object)date);
            updRecordData.add(updRecord);
        }
        resultMap.put("maindata", maindata);
        resultMap.put("updRecordData", updRecordData);
        return resultMap;
    }

    private void addMainDataDbPar(List<Object[]> maindataDbPars, DynamicObject oldOBject) {
        Object[] params = new Object[UpdConstant.NSRXX_DB_FIELD_MAP.size()];
        int i = 0;
        for (Map.Entry entry : UpdConstant.NSRXX_DB_FIELD_MAP.entrySet()) {
            Object obj = oldOBject.get((String)entry.getKey());
            if (obj instanceof DynamicObject) {
                obj = ((DynamicObject)obj).get("id");
            }
            if ("ftemplateid".equalsIgnoreCase((String)entry.getValue()) && StringUtil.isNotBlank((CharSequence)((String)obj))) {
                obj = Long.parseLong((String)obj);
            }
            if (obj == null) {
                obj = UpdConstant.NSRXX_DB_FIELD_DEFAULT_MAP.get(entry.getKey());
            }
            params[i] = obj;
            ++i;
        }
        maindataDbPars.add(params);
    }

    private List<DynamicObject> updDetailData(Map<String, List<DynamicObject>> ewbDatas, Map<String, DynamicObject> dynRowNoMap) {
        ArrayList<DynamicObject> detailDatas = new ArrayList<DynamicObject>();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tpo_rowcol_mapping", (String)"id", (QFilter[])new QFilter("number", "in", ewbDatas.keySet()).toArray());
        List mappingIds = query.stream().map(a -> a.get("id")).collect(Collectors.toList());
        DynamicObject[] mappingArr = BusinessDataServiceHelper.load((Object[])mappingIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tpo_rowcol_mapping"));
        Map<String, DynamicObject> mappingMap = Arrays.stream(mappingArr).collect(Collectors.toMap(a -> a.getString("number"), b -> b));
        for (Map.Entry<String, List<DynamicObject>> entry : ewbDatas.entrySet()) {
            String metaNum = entry.getKey();
            List<DynamicObject> ewbData = entry.getValue();
            DynamicObject mapping = mappingMap.get(metaNum);
            if (mapping == null) {
                throw new KDBizException(String.format("The %s Mapping is not exist, Please upgrade the template", metaNum));
            }
            DynamicObjectCollection rowentity = mapping.getDynamicObjectCollection("rowentity");
            DynamicObjectCollection columnentity = mapping.getDynamicObjectCollection("columnentity");
            Map<String, DynamicObject> rowMap = rowentity.stream().collect(Collectors.toMap(a -> a.getString("row"), b -> b, (m, n) -> m));
            for (DynamicObject ewbDataRow : ewbData) {
                boolean isDynrow = AbstractDeclareDataUpdService.isDynrow(dynRowNoMap, metaNum);
                String ewblxh = isDynrow ? "1" : ewbDataRow.getString("ewblxh");
                String sbbid = ewbDataRow.getString("sbbid");
                String dynrowno = isDynrow ? AbstractDeclareDataUpdService.getDynRowKey(metaNum) : "";
                int index = isDynrow ? Integer.parseInt(ewbDataRow.getString("ewblxh")) : 0;
                String rowNumber = String.format("%s_%s", metaNum, ewblxh);
                DynamicObject row = rowMap.get(ewblxh);
                if (row == null) {
                    throw new KDBizException(String.format("The row %s.%s of member is not exist", metaNum, ewblxh));
                }
                for (DynamicObject column : columnentity) {
                    String colNumber = String.format("%s_%s", metaNum, column.getString("column"));
                    String cellnumber = String.format("%s#%s", rowNumber, colNumber);
                    if (column.getDynamicObject("columnmember") == null) {
                        throw new KDBizException(String.format("The column %s.%s of member is not exist", metaNum, column.getString("column")));
                    }
                    DynamicObject detailObj = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tpo_declare_detail_tsc"));
                    detailObj.set("cellnumber", (Object)cellnumber);
                    detailObj.set("row", row.get("id"));
                    detailObj.set("column", column.get("columnmember.id"));
                    detailObj.set("dynrowno", (Object)dynrowno);
                    detailObj.set("index", (Object)index);
                    detailObj.set("value", (Object)AbstractDeclareDataUpdService.convertData(ewbDataRow.get(column.getString("column")), column.getDynamicObject("columnmember")));
                    detailObj.set("valuetype", (Object)column.getDynamicObject("columnmember").getString("datatype"));
                    detailObj.set("entryid", (Object)Long.parseLong(sbbid));
                    detailObj.set("version", (Object)"");
                    detailDatas.add(detailObj);
                }
            }
        }
        return detailDatas;
    }

    public static String convertData(Object value, DynamicObject columnmember) {
        String datatype = columnmember.getString("datatype");
        String format = columnmember.getString("format");
        EntityField entityField = new EntityField();
        entityField.setFormatStr(format);
        entityField.setFieldType(datatype);
        if (value instanceof DynamicObject) {
            value = ((DynamicObject)value).get("id");
        }
        return DataFormatUtils.dataToDbTypeFormat((Object)value, (EntityField)entityField);
    }

    public static boolean isDynrow(Map<String, DynamicObject> dynRowNoMap, String metaNum) {
        if (dynRowNoMap != null) {
            Set<String> keySet = dynRowNoMap.keySet();
            String key = AbstractDeclareDataUpdService.getDynRowKey(metaNum);
            return keySet.contains(key);
        }
        return false;
    }

    public static String getDynRowKey(String metaNum) {
        return String.format("%s-1#1", metaNum);
    }

    protected static Map<String, List<DynamicObject>> getEwbData(List<Long> sbbids, Set<String> tempMetadata) {
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(tempMetadata.size() * 2);
        List sbbidList = sbbids.stream().map(String::valueOf).collect(Collectors.toList());
        for (String tempMetadatum : tempMetadata) {
            if ("tcvat_nsrxx".equalsIgnoreCase(tempMetadatum)) continue;
            DynamicProperty sbbid = MetadataUtil.getProp((String)tempMetadatum, (String)tempMetadatum, (String)"sbbid");
            QFilter qFilter = sbbid instanceof LongProp || sbbid instanceof DecimalProp ? new QFilter("sbbid", "in", sbbids) : new QFilter("sbbid", "in", sbbidList);
            DynamicObject[] ewbDatas = AbstractDeclareDataUpdService.getOneEwbData(tempMetadatum, qFilter);
            result.put(tempMetadatum, Arrays.stream(ewbDatas).collect(Collectors.toList()));
        }
        return result;
    }

    public static DynamicObject[] getOneEwbData(String tempMetadatum, QFilter qFilter) {
        DynamicObjectCollection id = QueryServiceHelper.query((String)tempMetadatum, (String)"id", (QFilter[])qFilter.toArray());
        List idList = id.stream().map(a -> a.get("id")).collect(Collectors.toList());
        return BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)tempMetadatum));
    }

    public static Set<String> getTempMetadata(long templateId) {
        Map<String, String> metadata = new TemplateServiceImpl().getMetadata(templateId);
        return new HashSet<String>(metadata.values());
    }
}

