/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.update.impl;

import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.business.multidideclare.MultiDeclareBizBusiness;
import kd.taxc.bdtaxr.business.paramconfig.ParamConfigBusiness;
import kd.taxc.bdtaxr.business.taxdeclare.update.DeclareMainTableSyncService;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareUpgradeLogTypeEnum;
import kd.taxc.bdtaxr.common.upgrade.UpdConstant;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;

public abstract class AbstractDeclareMainTableSyncService
implements DeclareMainTableSyncService {
    private static final String INSERT_MAIN_SQL = "INSERT INTO t_tpo_declare_main_tsc (%s) VALUES (%s);";
    private static final String UPDATE_MAIN_SQL = "UPDATE t_tpo_declare_main_tsc SET %s WHERE FID = ?";
    private static final String INSERT_LOG_SQL = "INSERT INTO t_bdtaxr_plugin_upgrade (FID,FTABLE,FKEY,FTYPE,FCREATETIME,FSUCCESS,FLOG) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private Map<String, Object> extConfig = new HashMap<String, Object>(10);

    @Override
    public void execute(List<Object> model2Ids, Map<String, Object> params) {
        this.beforeExecute(model2Ids, params);
        this.doExecute(model2Ids, params);
        this.afterExecute(model2Ids, params);
    }

    private void beforeExecute(List<Object> model2Ids, Map<String, Object> params) {
        this.extConfig = this.getExtConfig();
    }

    protected abstract void doExecute(List<Object> var1, Map<String, Object> var2);

    private void afterExecute(List<Object> model2Ids, Map<String, Object> extParam) {
    }

    protected List<Object> handleAbnormalData(List<Object> queryModel2Ids, List<Object> model2Ids) {
        String collectDelayLogs;
        List<Object> idRepeatModel2Ids;
        List<Object> numberRepeatModel2Ids = this.queryNumberRepeatModel2Ids(queryModel2Ids);
        if (!CollectionUtils.isEmpty(numberRepeatModel2Ids)) {
            this.insertLogByModel2Ids(numberRepeatModel2Ids, DeclareUpgradeLogTypeEnum.NUMBER_REPEAT.getType(), "0");
            queryModel2Ids.removeAll(numberRepeatModel2Ids);
        }
        if (!CollectionUtils.isEmpty(idRepeatModel2Ids = this.queryIDRepeatModel2Ids(queryModel2Ids))) {
            this.insertLogByModel2Ids(idRepeatModel2Ids, DeclareUpgradeLogTypeEnum.ID_REPEAT.getType(), "0");
            queryModel2Ids.removeAll(idRepeatModel2Ids);
        }
        if (CollectionUtils.isEmpty(model2Ids) && !CollectionUtils.isEmpty(queryModel2Ids) && StringUtil.isNotEmpty((CharSequence)(collectDelayLogs = (String)this.extConfig.get("collectDelayLogs"))) && "1".equals(collectDelayLogs)) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid FROM t_tpo_declare_main_tsc WHERE fsourcebillid <> 0 and fsourcebillid is not null", new Object[0]);
            try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)sqlBuilder);){
                if (!dataSet.isEmpty()) {
                    this.insertLogByModel2Ids(queryModel2Ids, DeclareUpgradeLogTypeEnum.DELAY.getType(), "1");
                }
            }
        }
        return queryModel2Ids;
    }

    protected void insertLogByModel2Ids(List<Object> numberRepeatModel2Ids, String log, String success) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("DELETE FROM t_bdtaxr_plugin_upgrade WHERE ftype = ? AND ", new Object[]{"DeclareMainTableSync"});
        sqlBuilder.appendIn("fkey", numberRepeatModel2Ids.stream().map(v -> String.valueOf(v)).collect(Collectors.toList()));
        DB.execute((DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)sqlBuilder);
        String insertLogSQL = INSERT_LOG_SQL;
        List batchList = Lists.partition(numberRepeatModel2Ids, (int)this.getBatchSize());
        for (List batchIds : batchList) {
            this.insertBatchLogByIds(insertLogSQL, batchIds, log, success);
        }
    }

    protected void insertBatchLogByIds(String insertLogSQL, List<Object> batchIds, String log, String success) {
        ArrayList<Object[]> insertLogParamList = new ArrayList<Object[]>(this.getBatchSize());
        long[] ids = DB.genLongIds((String)"t_bdtaxr_plugin_upgrade", (int)batchIds.size());
        int size = batchIds.size();
        for (int i = 0; i < size; ++i) {
            Object[] insertLogParam = this.buildLogInsertParams(batchIds.get(i), log, success);
            insertLogParam[0] = ids[i];
            insertLogParamList.add(insertLogParam);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)insertLogSQL, insertLogParamList);
    }

    protected Object[] buildLogInsertParams(Object model2Id, String log, String success) {
        Object[] objects = new Object[7];
        objects[1] = "t_tctb_declare_main";
        objects[2] = String.valueOf(model2Id);
        objects[3] = "DeclareMainTableSync";
        objects[4] = new Timestamp(new Date().getTime());
        objects[5] = success;
        objects[6] = log;
        return objects;
    }

    protected List<Object> queryNumberRepeatModel2Ids(List<Object> model2Ids) {
        if (CollectionUtils.isEmpty(model2Ids)) {
            return Collections.emptyList();
        }
        SqlBuilder model2QuerySql = new SqlBuilder();
        model2QuerySql.append("SELECT fid FROM t_tctb_declare_main WHERE fbillno IN ( ", new Object[0]);
        model2QuerySql.append(" SELECT fbillno FROM t_tctb_declare_main WHERE ", new Object[0]).appendIn("fid", model2Ids).append(" GROUP BY fbillno HAVING count(1)>1) AND ", new Object[0]);
        model2QuerySql.appendIn("fid", model2Ids);
        HashSet<Long> todoModel2Ids = new HashSet<Long>(this.getBatchSize());
        try (DataSet model2DataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)model2QuerySql);){
            while (model2DataSet.hasNext()) {
                Row row = model2DataSet.next();
                todoModel2Ids.add(row.getLong("fid"));
            }
        }
        SqlBuilder model3QuerySql = new SqlBuilder();
        model3QuerySql.append("SELECT model2.fid AS fid FROM t_tctb_declare_main model2 INNER JOIN t_tpo_declare_main_tsc model3 ON model2.fbillno = model3.fbillno ", new Object[0]);
        model3QuerySql.append("WHERE model3.fsourcebillid <> model2.fid AND", new Object[0]);
        model3QuerySql.appendIn("model2.fid", model2Ids);
        try (DataSet model3DataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)model3QuerySql);){
            while (model3DataSet.hasNext()) {
                Row row = model3DataSet.next();
                todoModel2Ids.add(row.getLong("fid"));
            }
        }
        return new ArrayList<Object>(todoModel2Ids);
    }

    protected List<Object> queryIDRepeatModel2Ids(List<Object> model2Ids) {
        if (CollectionUtils.isEmpty(model2Ids)) {
            return Collections.emptyList();
        }
        HashSet<Long> todoModel2Ids = new HashSet<Long>(this.getBatchSize());
        SqlBuilder model3QuerySql = new SqlBuilder();
        model3QuerySql.append("SELECT model2.fid AS fid FROM t_tctb_declare_main model2 INNER JOIN t_tpo_declare_main_tsc model3 ON model2.fid = model3.fid ", new Object[0]);
        model3QuerySql.append("WHERE model3.fsourcebillid <> model2.fid AND", new Object[0]);
        model3QuerySql.appendIn("model2.fid", model2Ids);
        try (DataSet model3DataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)model3QuerySql);){
            while (model3DataSet.hasNext()) {
                Row row = model3DataSet.next();
                todoModel2Ids.add(row.getLong("fid"));
            }
        }
        return new ArrayList<Object>(todoModel2Ids);
    }

    protected List<String> getExcludeTemplateTypes() {
        List<String> extExcludeTemplateTypes;
        List excludeTemplateTypes = UpdConstant.model2DraftTemplateTypes;
        List<String> modelUpdatedTemplateTypes = MultiDeclareBizBusiness.getModelUpdatedTemplateTypes();
        if (!CollectionUtils.isEmpty(modelUpdatedTemplateTypes)) {
            excludeTemplateTypes.addAll(modelUpdatedTemplateTypes);
        }
        if (!CollectionUtils.isEmpty(extExcludeTemplateTypes = this.getExtExcludeTemplateTypes())) {
            excludeTemplateTypes.addAll(extExcludeTemplateTypes);
        }
        return excludeTemplateTypes;
    }

    protected Map<String, Object> getExtConfig() {
        DynamicObject[] dynamicObjects = ParamConfigBusiness.queryParamConfigByType((String)"DeclareMainTableSync");
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            return Arrays.stream(dynamicObjects).collect(Collectors.toMap(k -> k.getString("configkey"), v -> v.getString("configvalue"), (k1, k2) -> k2));
        }
        return Collections.emptyMap();
    }

    protected List<String> getExtExcludeTemplateTypes() {
        String extExcludeTemplateTypes = (String)this.extConfig.get("extExcludeTemplateTypes");
        if (StringUtil.isNotEmpty((CharSequence)extExcludeTemplateTypes)) {
            return Arrays.stream(extExcludeTemplateTypes.split(",")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected SqlBuilder getFilterByParams(Map<String, Object> params) {
        Date[] dates;
        if (params == null) {
            return null;
        }
        String createTimeRange = (String)params.get("createTimeRange");
        if (StringUtil.isNotEmpty((CharSequence)createTimeRange) && (dates = DateUtils.getDateRangeByFlag((String)createTimeRange)) != null && dates.length == 2) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append(" fcreatetime >= ? and fcreatetime <= ?", new Object[]{dates[0], dates[1]});
            return sqlBuilder;
        }
        return null;
    }

    protected String getExtFilter() {
        return (String)this.extConfig.get("extFilter");
    }

    protected String getModel2SelectFields() {
        return UpdConstant.NSRXX_DB_FIELD_MAP.keySet().stream().collect(Collectors.joining(","));
    }

    protected String getModel3InsertSql() {
        String fields = UpdConstant.NSRXX_DB_FIELD_MAP.values().stream().collect(Collectors.joining(","));
        String presitFlag = UpdConstant.NSRXX_DB_FIELD_MAP.keySet().stream().map(a -> "?").collect(Collectors.joining(","));
        return String.format(INSERT_MAIN_SQL, this.getJoinKey(fields, ",fsourcebillid,fsourcebillno"), this.getJoinKey(presitFlag, ",?,?"));
    }

    protected Object[] buildModel3InsertParam(Row row) {
        Object[] params = new Object[UpdConstant.NSRXX_DB_FIELD_MAP.size() + 2];
        int i = 0;
        for (Map.Entry entry : UpdConstant.NSRXX_DB_FIELD_MAP.entrySet()) {
            Object obj = row.get((String)entry.getKey());
            if (obj == null) {
                obj = UpdConstant.NSRXX_DB_FIELD_DEFAULT_MAP.get(entry.getKey());
            }
            if ("ftemplateid".equalsIgnoreCase((String)entry.getValue())) {
                obj = StringUtil.isNotBlank((CharSequence)((String)obj)) ? Long.valueOf(Long.parseLong((String)obj)) : Long.valueOf(0L);
            }
            params[i] = obj;
            ++i;
        }
        params[i] = row.getLong("id");
        params[++i] = row.getString("billno");
        return params;
    }

    protected String getModel3UpdateSql() {
        String presitFlag = UpdConstant.NSRXX_DB_FIELD_MAP.values().stream().map(v -> this.getJoinKey((String)v, "=?")).collect(Collectors.joining(","));
        return String.format(UPDATE_MAIN_SQL, presitFlag);
    }

    protected Object[] buildModel3UpdateParam(Row row) {
        Object[] params = new Object[UpdConstant.NSRXX_DB_FIELD_MAP.size() + 1];
        int i = 0;
        for (Map.Entry entry : UpdConstant.NSRXX_DB_FIELD_MAP.entrySet()) {
            Object obj = row.get((String)entry.getKey());
            if (obj == null) {
                obj = UpdConstant.NSRXX_DB_FIELD_DEFAULT_MAP.get(entry.getKey());
            }
            if ("ftemplateid".equalsIgnoreCase((String)entry.getValue())) {
                obj = StringUtil.isNotBlank((CharSequence)((String)obj)) ? Long.valueOf(Long.parseLong((String)obj)) : Long.valueOf(0L);
            }
            params[i] = obj;
            ++i;
        }
        params[i] = row.getLong("id");
        return params;
    }

    protected int[] executeBatch(String sql, List<Object[]> paramList) {
        if (paramList == null || paramList.size() == 0) {
            return null;
        }
        int[] result = DBUtils.executeBatch((String)sql, paramList);
        paramList.clear();
        return result;
    }

    protected int getBatchSize() {
        return 2000;
    }

    protected String getJoinKey(String ... args) {
        StringBuilder str = new StringBuilder();
        for (String arg : args) {
            str.append(arg);
        }
        return str.toString();
    }
}

