/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.update.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.update.impl.AbstractDeclareMainTableSyncService;

public class DeclareMainTableSyncAddService
extends AbstractDeclareMainTableSyncService {
    private static Log logger = LogFactory.getLog(DeclareMainTableSyncAddService.class);

    @Override
    protected void doExecute(List<Object> model2Ids, Map<String, Object> params) {
        List<Object> queryModel2Ids = this.querySyncAddModel2Ids(model2Ids, params);
        List<Object> newModel2Ids = this.handleAbnormalData(queryModel2Ids, model2Ids);
        if (CollectionUtils.isEmpty(newModel2Ids)) {
            logger.info("syscAdd : not model2 data to do.");
            return;
        }
        logger.info("syscAdd : size: {}", (Object)newModel2Ids.size());
        QFilter model2QFilter = new QFilter("id", "in", newModel2Ids);
        try (DataSet model2DataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"tcvat_nsrxx", (String)this.getModel2SelectFields(), (QFilter[])new QFilter[]{model2QFilter}, null);){
            String model3InsertSql = this.getModel3InsertSql();
            ArrayList<Object[]> insertParamList = new ArrayList<Object[]>(this.getBatchSize());
            while (model2DataSet.hasNext()) {
                Row row = model2DataSet.next();
                insertParamList.add(this.buildModel3InsertParam(row));
                if (insertParamList.size() != this.getBatchSize()) continue;
                this.executeBatch(model3InsertSql, insertParamList);
            }
            if (insertParamList.size() > 0) {
                this.executeBatch(model3InsertSql, insertParamList);
            }
        }
    }

    protected List<Object> querySyncAddModel2Ids(List<Object> model2Ids, Map<String, Object> params) {
        String extFilter;
        SqlBuilder paramFilter;
        if (!CollectionUtils.isEmpty(model2Ids)) {
            return model2Ids;
        }
        SqlBuilder model2QuerySql = new SqlBuilder();
        model2QuerySql.append("SELECT fid FROM t_tctb_declare_main WHERE fid NOT IN (SELECT fsourcebillid FROM t_tpo_declare_main_tsc WHERE (fsourcebillid<>0 and fsourcebillid is not null)) ", new Object[0]);
        List<String> excludeTemplateTypes = this.getExcludeTemplateTypes();
        if (excludeTemplateTypes.size() > 0) {
            model2QuerySql.append(" AND fnsrtype NOT IN (", new Object[0]).append(excludeTemplateTypes.stream().map(v -> this.getJoinKey("'", (String)v, "'")).collect(Collectors.joining(",")), new Object[0]).append(")", new Object[0]);
        }
        if ((paramFilter = this.getFilterByParams(params)) != null) {
            model2QuerySql.append(" AND ", new Object[0]).appendSqlBuilder(paramFilter);
        }
        if (StringUtils.isNotEmpty((CharSequence)(extFilter = this.getExtFilter()))) {
            model2QuerySql.append(" AND ", new Object[0]).append(extFilter, new Object[0]);
        }
        ArrayList<Object> todoModel2Ids = new ArrayList<Object>(this.getBatchSize());
        try (DataSet model2DataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)model2QuerySql);){
            while (model2DataSet.hasNext()) {
                Row row = model2DataSet.next();
                todoModel2Ids.add(row.getLong("fid"));
            }
        }
        return todoModel2Ids;
    }
}

