/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.update.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.update.impl.AbstractDeclareMainTableSyncService;
import kd.taxc.bdtaxr.business.taxdeclare.update.impl.DeclareMainTableSyncAddService;

public class DeclareMainTableSyncUpdateService
extends AbstractDeclareMainTableSyncService {
    private static Log logger = LogFactory.getLog(DeclareMainTableSyncAddService.class);

    @Override
    protected void doExecute(List<Object> model2Ids, Map<String, Object> params) {
        List<Object> queryModel2Ids = this.querySyncUpdateModel2Ids(model2Ids, params);
        List<Object> newModel2Ids = this.handleAbnormalData(queryModel2Ids, model2Ids);
        if (CollectionUtils.isEmpty(newModel2Ids)) {
            logger.info("syscUpdate : not model2 data to do.");
            return;
        }
        logger.info("syncUpdate : size: {}", (Object)newModel2Ids.size());
        HashMap<Long, Long> model2ToModel3Map = new HashMap<Long, Long>(this.getBatchSize());
        QFilter model3QFilter = new QFilter("sourcebillid", "in", newModel2Ids);
        try (DataSet model3DataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"tpo_declare_main_tsc", (String)"id,sourcebillid", (QFilter[])new QFilter[]{model3QFilter}, null);){
            while (model3DataSet.hasNext()) {
                Row row = model3DataSet.next();
                model2ToModel3Map.put(row.getLong("sourcebillid"), row.getLong("id"));
            }
        }
        QFilter model2QFilter = new QFilter("id", "in", newModel2Ids);
        try (DataSet model2DataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"tcvat_nsrxx", (String)this.getModel2SelectFields(), (QFilter[])new QFilter[]{model2QFilter}, null);){
            String model3InsertSql = this.getModel3InsertSql();
            ArrayList<Object[]> insertParamList = new ArrayList<Object[]>(this.getBatchSize());
            String model3UpdateSql = this.getModel3UpdateSql();
            ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(this.getBatchSize());
            while (model2DataSet.hasNext()) {
                Row row = model2DataSet.next();
                Long id = row.getLong("id");
                if (model2ToModel3Map.containsKey(id)) {
                    updateParamList.add(this.buildModel3UpdateParam(row));
                    if (updateParamList.size() != this.getBatchSize()) continue;
                    this.executeBatch(model3UpdateSql, updateParamList);
                    continue;
                }
                insertParamList.add(this.buildModel3InsertParam(row));
                if (insertParamList.size() != this.getBatchSize()) continue;
                this.executeBatch(model3InsertSql, insertParamList);
            }
            if (insertParamList.size() > 0) {
                this.executeBatch(model3InsertSql, insertParamList);
            }
            if (updateParamList.size() > 0) {
                this.executeBatch(model3UpdateSql, updateParamList);
            }
        }
    }

    protected List<Object> querySyncUpdateModel2Ids(List<Object> model2Ids, Map<String, Object> params) {
        String extFilter;
        SqlBuilder paramFilter;
        if (!CollectionUtils.isEmpty(model2Ids)) {
            return model2Ids;
        }
        SqlBuilder model2QuerySql = new SqlBuilder();
        model2QuerySql.append("SELECT fid FROM t_tctb_declare_main  WHERE fid in ( ", new Object[0]);
        model2QuerySql.append("SELECT model2.fid FROM t_tctb_declare_main model2 INNER JOIN t_tpo_declare_main_tsc model3 ON model2.fid = model3.fsourcebillid ", new Object[0]);
        model2QuerySql.append("WHERE (model3.fsourcebillid<>0 and model3.fsourcebillid is not null) and model2.fmodifytime <> model3.fmodifytime )", new Object[0]);
        List<String> excludeTemplateTypes = this.getExcludeTemplateTypes();
        if (excludeTemplateTypes.size() > 0) {
            model2QuerySql.append(" AND fnsrtype NOT IN (", new Object[0]).append(excludeTemplateTypes.stream().map(v -> this.getJoinKey("'", (String)v, "'")).collect(Collectors.joining(",")), new Object[0]).append(")", new Object[0]);
        }
        if ((paramFilter = this.getFilterByParams(params)) != null) {
            model2QuerySql.append(" AND ", new Object[0]).appendSqlBuilder(paramFilter);
        }
        if (StringUtils.isNotEmpty((CharSequence)(extFilter = this.getExtFilter()))) {
            model2QuerySql.append(extFilter, new Object[0]);
        }
        ArrayList<Object> todoModel2Ids = new ArrayList<Object>(this.getBatchSize());
        try (DataSet model2DataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)model2QuerySql);){
            while (model2DataSet.hasNext()) {
                Row row = model2DataSet.next();
                todoModel2Ids.add(row.getLong("fid"));
            }
        }
        return todoModel2Ids;
    }
}

