/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.billconfigs;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.formplugin.billconfigs.BillFieldBean;

public class BillFieldsListPlugin
extends AbstractTreeListPlugin {
    private static final String BILL_NUMBER = "billNumber";
    private static final String BDTAXR_BILL_FIELDS = "bdtaxr_where_fields";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String ADMIN_DIVISION_PROP = "AdminDivisionProp";
    private static final String MUL_BASEDATA_PROP = "MulBasedataProp";
    private static final String META_SELECT_FIELDS = "id,number,name,createdate,modifydate";
    private static final String BILL_SELECT_FIELDS = "id,number,name,billname,longnumber,modifytime,fieldtype,refentitykey,enable";

    public void preOpenForm(PreOpenFormEventArgs e) {
        int totalLevel = 2;
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        showParameter.setCustomParam("level", (Object)totalLevel);
        String billNumber = (String)showParameter.getCustomParams().get(BILL_NUMBER);
        if (StringUtils.isNotBlank((CharSequence)billNumber) && this.isUpdateFields(billNumber, totalLevel)) {
            List<BillFieldBean> billFieldList = this.getEntityAllFields(billNumber, totalLevel, 1, null);
            this.updateFieldProperty(billNumber, billFieldList);
        }
    }

    public boolean isUpdateFields(String billNumber, int totalLevel) {
        DynamicObjectCollection list = QueryServiceHelper.query((String)BDTAXR_BILL_FIELDS, (String)"id,modifytime,level", (QFilter[])new QFilter[]{new QFilter("billnumber", "=", (Object)billNumber)}, (String)"level DESC,modifytime DESC");
        if (EmptyCheckUtils.isEmpty((Object)list)) {
            return true;
        }
        QFilter[] queryFilters = new QFilter[]{new QFilter("number", "=", (Object)billNumber)};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)BOS_FORMMETA, (String)META_SELECT_FIELDS, (QFilter[])queryFilters);
        if (!EmptyCheckUtils.isEmpty((Object)dynamicObject)) {
            Date fieldModifyTime = (Date)((DynamicObject)list.get(0)).get("modifytime");
            int itemLevel = (Integer)((DynamicObject)list.get(0)).get("level");
            Date metaModifyTime = (Date)dynamicObject.get("modifydate");
            if (fieldModifyTime != null && metaModifyTime != null && itemLevel >= totalLevel && fieldModifyTime.compareTo(metaModifyTime) > 0) {
                return false;
            }
        }
        return true;
    }

    public List<BillFieldBean> getEntityAllFields(String billNumber, int totalLevel, int currentLevel, BillFieldBean parentField) {
        ArrayList<BillFieldBean> fieldList = new ArrayList<BillFieldBean>();
        if (StringUtils.isBlank((CharSequence)billNumber)) {
            return fieldList;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
        Map entityMap = mainEntityType.getAllEntities();
        String billName = mainEntityType.getDisplayName().getLocaleValue();
        for (Map.Entry entry : entityMap.entrySet()) {
            DataEntityPropertyCollection pros = ((EntityType)entry.getValue()).getProperties();
            for (IDataEntityProperty property : pros) {
                if (property.getDisplayName() == null) continue;
                BillFieldBean billField = this.getFieldProperty(billNumber, billName, property, parentField, currentLevel);
                fieldList.add(billField);
                if (totalLevel <= currentLevel || property.getPropertyType() == null || !StringUtils.isNotBlank((CharSequence)billField.getRefEntityKey())) continue;
                fieldList.addAll(this.getEntityAllFields(billField.getRefEntityKey(), totalLevel, currentLevel + 1, billField));
            }
        }
        return fieldList;
    }

    private BillFieldBean getFieldProperty(String billNumber, String billName, IDataEntityProperty property, BillFieldBean parentField, int currentLevel) {
        BillFieldBean billField = new BillFieldBean();
        billField.setBillNumber(billNumber);
        billField.setBillName(billName);
        StringBuilder numberBuilder = new StringBuilder();
        StringBuilder nameBuilder = new StringBuilder();
        boolean isleaf = false;
        billField.setLevel(currentLevel);
        if (parentField != null) {
            numberBuilder.append((CharSequence)parentField.getFieldNumber()).append('.');
            nameBuilder.append(parentField.getFieldName().toString()).append('.');
        }
        this.setParentProperty(billNumber, numberBuilder, nameBuilder, property.getParent());
        numberBuilder.append(property.getName());
        nameBuilder.append(property.getDisplayName().getLocaleValue());
        billField.setFieldNumber(numberBuilder);
        billField.setFieldName(nameBuilder);
        billField.setIsleaf(isleaf);
        Class<?> propertyClass = property.getClass();
        String className = propertyClass.getName().substring(propertyClass.getName().lastIndexOf(46) + 1);
        billField.setFieldType(className);
        billField.setRefEntityKey(this.getEntityKeyByType(className, property));
        return billField;
    }

    private void setParentProperty(String billNumber, StringBuilder numberBuilder, StringBuilder nameBuilder, IDataEntityType entryType) {
        if (entryType != null && !billNumber.equals(entryType.getName())) {
            this.setParentProperty(billNumber, numberBuilder, nameBuilder, entryType.getParent());
            numberBuilder.append(entryType.getName()).append('.');
            nameBuilder.append(entryType.getDisplayName().getLocaleValue()).append('.');
        }
    }

    private String getEntityKeyByType(String fieldType, IDataEntityProperty property) {
        if (property instanceof BasedataProp) {
            return ((BasedataProp)property).getBaseEntityId();
        }
        switch (fieldType) {
            case "MulBasedataProp": {
                return ((MulBasedataProp)property).getBaseEntityId();
            }
            case "AdminDivisionProp": {
                return "bd_admindivision";
            }
        }
        return "";
    }

    public void updateFieldProperty(String billNumber, List<BillFieldBean> billFieldList) {
        ArrayList<DynamicObject> createList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        HashMap<String, Long> parentIdMap = new HashMap<String, Long>();
        Date currentDate = new Date();
        QFilter filter = new QFilter("billnumber", "=", (Object)billNumber);
        DynamicObject[] objectArray = BusinessDataServiceHelper.load((String)BDTAXR_BILL_FIELDS, (String)BILL_SELECT_FIELDS, (QFilter[])new QFilter[]{filter});
        HashMap<String, Object> oldFieldMap = new HashMap<String, Object>();
        if (!EmptyCheckUtils.isEmpty((Object)objectArray)) {
            for (DynamicObject object : objectArray) {
                oldFieldMap.put(object.getString("longnumber"), object);
            }
        }
        for (BillFieldBean billField : billFieldList) {
            String longNumber = billField.getFieldNumber().toString();
            if (oldFieldMap.containsKey(longNumber)) {
                DynamicObject dynamicObject = (DynamicObject)oldFieldMap.remove(longNumber);
                parentIdMap.put(longNumber, dynamicObject.getLong("id"));
                dynamicObject.set("name", (Object)billField.getFieldName().toString());
                dynamicObject.set("billname", (Object)billField.getBillName());
                dynamicObject.set("modifytime", (Object)currentDate);
                dynamicObject.set("fieldtype", (Object)billField.getFieldType());
                dynamicObject.set("refentitykey", (Object)billField.getRefEntityKey());
                updateList.add(dynamicObject);
                continue;
            }
            long id = DBUtils.getLongId((String)BDTAXR_BILL_FIELDS);
            parentIdMap.put(longNumber, id);
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)BDTAXR_BILL_FIELDS);
            object.set("id", (Object)id);
            object.set("number", (Object)longNumber);
            object.set("name", (Object)billField.getFieldName().toString());
            object.set("billname", (Object)billField.getBillName());
            object.set("billnumber", (Object)billNumber);
            object.set("enable", (Object)Character.valueOf('1'));
            object.set("status", (Object)Character.valueOf('C'));
            object.set("isleaf", (Object)billField.isIsleaf());
            object.set("level", (Object)billField.getLevel());
            object.set("longnumber", (Object)longNumber);
            object.set("createtime", (Object)currentDate);
            object.set("modifytime", (Object)currentDate);
            object.set("fieldtype", (Object)billField.getFieldType());
            object.set("refentitykey", (Object)billField.getRefEntityKey());
            if (longNumber.lastIndexOf(46) > 0 && parentIdMap.containsKey(longNumber.substring(0, longNumber.lastIndexOf(46)))) {
                object.set("parent", parentIdMap.get(longNumber.substring(0, longNumber.lastIndexOf(46))));
            }
            createList.add(object);
        }
        if (oldFieldMap.size() > 0) {
            oldFieldMap.forEach((k, oldField) -> {
                oldField.set("modifytime", (Object)currentDate);
                oldField.set("enable", (Object)Character.valueOf('0'));
                updateList.add((DynamicObject)oldField);
            });
        }
        if (createList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])createList.toArray(new DynamicObject[0]));
        }
        if (updateList.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
    }

    public void initializeTree(EventObject e) {
        QFilter qFilter = this.getCustomFilter();
        if (qFilter == null) {
            return;
        }
        this.getTreeModel().getTreeFilter().add(qFilter);
    }

    public void setFilter(SetFilterEvent e) {
        QFilter qFilter = this.getCustomFilter();
        if (qFilter == null) {
            return;
        }
        e.getQFilters().add(qFilter);
    }

    private QFilter getCustomFilter() {
        QFilter qFilter = null;
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object billNumber = map.get(BILL_NUMBER);
        if (billNumber != null) {
            qFilter = new QFilter("billnumber", "=", (Object)map.get(BILL_NUMBER).toString());
            Boolean level = map.containsKey("level");
            if (level != null) {
                qFilter.and(new QFilter("level", "<=", (Object)Integer.valueOf(map.get("level").toString())));
            }
        }
        return qFilter;
    }

    public void afterBindData(EventObject e) {
        TreeNode root = this.getTreeModel().getRoot();
        List childrenRoot = root.getChildren();
        this.setNodeText(childrenRoot);
    }

    private void setNodeText(List<TreeNode> childrenRoot) {
        if (null != childrenRoot) {
            for (TreeNode treeNode : childrenRoot) {
                String nodeText = treeNode.getText();
                if (StringUtils.isNotBlank((CharSequence)nodeText)) {
                    nodeText = nodeText.substring(nodeText.lastIndexOf(46) + 1);
                    treeNode.setText(nodeText);
                }
                if (treeNode.getChildren() == null || treeNode.getChildren().size() <= 0) continue;
                this.setNodeText(treeNode.getChildren());
            }
        }
    }
}

