/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.billtaxconfigs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.formplugin.billtaxconfigs.enums.BillTaxConfigsConfirmEnum;
import kd.taxc.bdtaxr.formplugin.billtaxconfigs.enums.BillTaxConfigsSettingEnum;

public class BillTaxConfigsEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener,
TabSelectListener {
    private static final String CALLBILL = "callbill";
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String CALLCONDITION_ENTITY = "callcondition_entity";
    private static final String CALLCONDITION_SETTTING = "callcondition_settting";
    private static final String CONDITION = "condition";
    private static final String PRODUCT_FIELD = "productfield";
    private static final String ADDRESS_FIELD = "addressfield";
    private static final String SPECIFIC_FIELD = "specificfield";
    private static final String PRODUCT_SOURCE = "productsource";
    private static final String ADDRESS_SOURCE = "addresssource";
    private static final String SPECIFIC_SOURCE = "specificsource";
    private static final String BASTAX_DRC_COUNTRY = "bastax_drccountry";
    public static final List<String> FIELD = Collections.unmodifiableList(Arrays.asList("productfield", "addressfield", "specificfield"));
    private static final String TABAP = "tabap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit productfieldEdit = (BasedataEdit)this.getControl(PRODUCT_FIELD);
        productfieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        productfieldEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit bill = (BasedataEdit)this.getControl(CALLBILL);
        bill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit addressfieldEdit = (BasedataEdit)this.getControl(ADDRESS_FIELD);
        addressfieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        addressfieldEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit specificfieldEdit = (BasedataEdit)this.getControl(SPECIFIC_FIELD);
        specificfieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        specificfieldEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit productEdit = (BasedataEdit)this.getControl("product");
        productEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit partyEdit = (BasedataEdit)this.getControl("party");
        partyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit processEdit = (BasedataEdit)this.getControl("process");
        processEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit valuerulesEdit = (BasedataEdit)this.getControl("valuerules");
        valuerulesEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit specificproductEdit = (BasedataEdit)this.getControl("specificproduct");
        specificproductEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab tab = (Tab)this.getView().getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.createCallconditionEntity();
        this.showSpecificProduct();
    }

    public void afterBindData(EventObject e) {
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (FIELD.contains(key)) {
            DynamicObject billObject = (DynamicObject)this.getModel().getValue(PRODUCT_SOURCE);
            if (StringUtils.equalsIgnoreCase((CharSequence)evt.getProperty().getName(), (CharSequence)ADDRESS_FIELD)) {
                billObject = (DynamicObject)this.getModel().getValue(ADDRESS_SOURCE);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)evt.getProperty().getName(), (CharSequence)SPECIFIC_FIELD)) {
                billObject = (DynamicObject)this.getModel().getValue(SPECIFIC_SOURCE);
            }
            if (billObject != null) {
                String billNumber = billObject.getString("number");
                ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u8981\u7d20\u5b57\u6bb5", (String)"BillTaxConfigsEdit_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                formShowParameter.setCustomParam("billNumber", (Object)billNumber);
                QFilter billNumberQ = new QFilter("billnumber", "=", (Object)billNumber);
                formShowParameter.getListFilterParameter().getQFilters().add(billNumberQ);
                if (StringUtils.equalsIgnoreCase((CharSequence)evt.getProperty().getName(), (CharSequence)ADDRESS_FIELD)) {
                    QFilter refentitykeyFilter = new QFilter("refentitykey", "in", (Object)new String[]{"bd_country", "bd_admindivision"});
                    formShowParameter.getListFilterParameter().getQFilters().add(refentitykeyFilter);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u8981\u7d20\u6765\u6e90\uff01", (String)"BillTaxConfigsEdit_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"product") || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"valuerules") || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"specificproduct")) {
            Long countryId = ((DynamicObject)this.getModel().getValue("country")).getLong("id");
            QFilter filter = new QFilter("country", "=", (Object)countryId);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
        } else if (BillTaxConfigsSettingEnum.getOperateKeylist().contains(key)) {
            BillTaxConfigsSettingEnum settingEnum = BillTaxConfigsSettingEnum.getEnumByOperateKey(key);
            EntryGrid entryentity = (EntryGrid)this.getControl(settingEnum.getEntity());
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(settingEnum.getSource(), focusRow);
            if (ObjectUtils.isEmpty((Object)dynamicObject)) {
                this.getView().showTipNotification(settingEnum.getShowConfirm());
                evt.setCancel(true);
                return;
            }
            Object type = dynamicObject.get("id");
            QFilter groupFilter = new QFilter("group", "=", type);
            Long country = ((DynamicObject)this.getModel().getValue("country")).getLong("id");
            QFilter filter = new QFilter("country", "=", (Object)country);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(filter.and(groupFilter));
            formShowParameter.setFormId("bos_listf7");
            DynamicObject object = (DynamicObject)this.getModel().getValue(settingEnum.getOperateKey(), focusRow);
            Long selectRow = ObjectUtils.isEmpty((Object)object) ? null : Long.valueOf(object.getLong("id"));
            formShowParameter.setSelectedRow((Object)selectRow);
        } else if (CALLBILL.equals(key)) {
            DynamicObject[] collection = BusinessDataServiceHelper.load((String)"bastax_bill_interface", (String)"bill", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
            ArrayList<String> billNumbers = new ArrayList<String>(16);
            for (DynamicObject dyo : collection) {
                billNumbers.add(String.valueOf(dyo.getDynamicObject("bill").get("number")));
            }
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("number", "in", billNumbers));
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        BasedataEdit basedataEdit;
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        Object object = afterF7SelectEvent.getSource();
        if (object instanceof BasedataEdit && StringUtils.equalsIgnoreCase((CharSequence)(basedataEdit = (BasedataEdit)object).getFieldKey(), (CharSequence)CALLBILL)) {
            DynamicObject callBill = (DynamicObject)this.getModel().getValue(CALLBILL);
            String entityNumber = callBill.getString("id");
            filterGrid.setEntityNumber(entityNumber);
            this.getView().updateView(FILTERGRIDAP);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (BillTaxConfigsConfirmEnum.getKeys().contains(fieldKey)) {
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            this.showConfirmTips(fieldKey, oldValue);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)BillTaxConfigsSettingEnum.BEFOREF7_ELEMENT.getSource())) {
            this.getModel().setValue(BillTaxConfigsSettingEnum.BEFOREF7_ELEMENT.getOperateKey(), null);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)BillTaxConfigsSettingEnum.BEFOREF7_PARTY.getSource())) {
            this.getModel().setValue(BillTaxConfigsSettingEnum.BEFOREF7_PARTY.getOperateKey(), null);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)BillTaxConfigsSettingEnum.PRODUCT.getSource())) {
            this.getModel().setValue(PRODUCT_FIELD, null);
            this.getModel().setValue(BillTaxConfigsSettingEnum.PRODUCT.getCondition(), null);
            this.getModel().setValue(BillTaxConfigsSettingEnum.PRODUCT.getConditionjson(), null);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)BillTaxConfigsSettingEnum.PARTY.getSource())) {
            this.getModel().setValue(BillTaxConfigsSettingEnum.PARTY.getCondition(), null);
            this.getModel().setValue(BillTaxConfigsSettingEnum.PARTY.getConditionjson(), null);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)BillTaxConfigsSettingEnum.ELEMENT.getSource())) {
            this.getModel().setValue(BillTaxConfigsSettingEnum.ELEMENT.getCondition(), null);
            this.getModel().setValue(BillTaxConfigsSettingEnum.ELEMENT.getConditionjson(), null);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)BillTaxConfigsSettingEnum.SPECIFIC.getSource())) {
            this.getModel().setValue(SPECIFIC_FIELD, null);
            this.getModel().setValue(BillTaxConfigsSettingEnum.SPECIFIC.getCondition(), null);
            this.getModel().setValue(BillTaxConfigsSettingEnum.SPECIFIC.getConditionjson(), null);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)ADDRESS_SOURCE)) {
            this.getModel().setValue(ADDRESS_FIELD, null);
        }
    }

    private void createCallconditionEntity() {
        this.getModel().deleteEntryData(CALLCONDITION_ENTITY);
        int rowIndex = this.getModel().createNewEntryRow(CALLCONDITION_ENTITY);
        this.getModel().setValue(CONDITION, this.getModel().getValue("callcondition"), rowIndex);
    }

    private void showConfirmTips(String fieldKey, DynamicObject oldValue) {
        if (BillTaxConfigsConfirmEnum.getKeys().contains(fieldKey)) {
            BillTaxConfigsConfirmEnum confirmEnum = BillTaxConfigsConfirmEnum.getEnumByKey(fieldKey);
            if (!"true".equals(this.getPageCache().get(confirmEnum.getChange()))) {
                Object callcondition;
                this.getPageCache().put(fieldKey, ObjectUtils.isEmpty((Object)oldValue) ? "" : oldValue.getString("id"));
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(fieldKey, (IFormPlugin)this);
                if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)BillTaxConfigsConfirmEnum.COUNTRY.getKey())) {
                    DynamicObjectCollection productrows = this.getModel().getEntryEntity("product_entity");
                    DynamicObjectCollection addressrows = this.getModel().getEntryEntity("address_entity");
                    DynamicObjectCollection partyrows = this.getModel().getEntryEntity("party_entity");
                    DynamicObjectCollection elementrows = this.getModel().getEntryEntity("element_entity");
                    DynamicObjectCollection specificrows = this.getModel().getEntryEntity("specific_entity");
                    if (!ObjectUtils.isEmpty((Object)productrows) && productrows.size() > 0 || !ObjectUtils.isEmpty((Object)partyrows) && partyrows.size() > 0 || !ObjectUtils.isEmpty((Object)addressrows) && addressrows.size() > 0 || !ObjectUtils.isEmpty((Object)elementrows) && elementrows.size() > 0 || !ObjectUtils.isEmpty((Object)specificrows) && specificrows.size() > 0) {
                        this.getView().showConfirm(confirmEnum.getShowConfirm(), MessageBoxOptions.OKCancel, confirmCallBackListener);
                    } else {
                        this.showSpecificProduct();
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)BillTaxConfigsConfirmEnum.CALLBILL.getKey()) && !ObjectUtils.isEmpty((Object)(callcondition = this.getModel().getValue("callconditionjson")))) {
                    this.getView().showConfirm(confirmEnum.getShowConfirm(), MessageBoxOptions.OKCancel, confirmCallBackListener);
                }
            } else {
                this.getPageCache().put(confirmEnum.getChange(), "false");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if (BillTaxConfigsConfirmEnum.getKeys().contains(fieldKey)) {
            BillTaxConfigsConfirmEnum billTaxConfigsEnum = BillTaxConfigsConfirmEnum.getEnumByKey(fieldKey);
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put(billTaxConfigsEnum.getChange(), "false");
                if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)BillTaxConfigsConfirmEnum.COUNTRY.getKey())) {
                    this.getModel().deleteEntryData("product_entity");
                    this.getModel().deleteEntryData("address_entity");
                    this.getModel().deleteEntryData("party_entity");
                    this.getModel().deleteEntryData("element_entity");
                    this.getModel().deleteEntryData("specific_entity");
                } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)BillTaxConfigsConfirmEnum.CALLBILL.getKey())) {
                    this.getModel().setValue("callcondition", null);
                    this.getModel().setValue("callconditionjson", null);
                    this.getModel().setValue(CONDITION, null, 0);
                }
            } else {
                this.getPageCache().put(billTaxConfigsEnum.getChange(), "true");
                this.getModel().setValue(fieldKey, (Object)this.getPageCache().get(fieldKey));
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)BillTaxConfigsConfirmEnum.COUNTRY.getKey())) {
                this.showSpecificProduct();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            String operateKey = ((Donothing)args.getSource()).getOperateKey();
            if (BillTaxConfigsSettingEnum.getOperateKeylist().contains(operateKey)) {
                BillTaxConfigsSettingEnum settingEnum = BillTaxConfigsSettingEnum.getEnumByOperateKey(operateKey);
                EntryGrid entryentity = (EntryGrid)this.getControl(settingEnum.getEntity());
                int focusRow = entryentity.getEntryState().getFocusRow();
                DynamicObject source = (DynamicObject)this.getModel().getValue(settingEnum.getSource(), focusRow);
                if (ObjectUtils.isEmpty((Object)source)) {
                    this.getView().showTipNotification(settingEnum.getShowConfirm());
                    args.setCancel(true);
                    return;
                }
                String entityNumber = source.getString("id");
                this.openSettingPage(focusRow, entityNumber, settingEnum.getEntity(), settingEnum.getConditionjson(), settingEnum.getOperateKey());
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)CALLCONDITION_SETTTING)) {
                Object callbill = this.getModel().getValue(CALLBILL);
                Object conditionjson = this.getModel().getValue("callconditionjson");
                if (ObjectUtils.isEmpty((Object)callbill)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8c03\u7528\u5355\u636e", (String)"BillTaxConfigsEdit_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String entityNumber = ((DynamicObject)callbill).getString("id");
                this.openCallSettingPage(entityNumber, conditionjson, CALLCONDITION_SETTTING);
            }
        } else if (!(args.getSource() instanceof Save) && args.getSource() instanceof NewEntry) {
            String operateKey = ((NewEntry)args.getSource()).getOperateKey();
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue("country")) && (StringUtils.equalsIgnoreCase((CharSequence)"newentry_product", (CharSequence)operateKey) || StringUtils.equalsIgnoreCase((CharSequence)"newentry_party", (CharSequence)operateKey) || StringUtils.equalsIgnoreCase((CharSequence)"newentry_element", (CharSequence)operateKey) || StringUtils.equalsIgnoreCase((CharSequence)"newentry_specific", (CharSequence)operateKey))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u57fa\u672c\u4fe1\u606f\u533a\u57df\u7684\u56fd\u5bb6\u6216\u5730\u533a\u3002", (String)"BillTaxConfigsEdit_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getSource() instanceof Save) {
            this.createCallconditionEntity();
            this.getModel().setDataChanged(false);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map filterData;
        super.closedCallBack(evt);
        String key = evt.getActionId();
        if (BillTaxConfigsSettingEnum.getOperateKeylist().contains(key)) {
            BillTaxConfigsSettingEnum settingEnum = BillTaxConfigsSettingEnum.getEnumByOperateKey(key);
            Map filterData2 = (Map)evt.getReturnData();
            if (filterData2 != null) {
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex(settingEnum.getEntity());
                this.getModel().setValue(settingEnum.getCondition(), filterData2.get("callcondition"), currentRowIndex);
                this.getModel().setValue(settingEnum.getConditionjson(), filterData2.get("callconditionjson"), currentRowIndex);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)CALLCONDITION_SETTTING) && (filterData = (Map)evt.getReturnData()) != null) {
            this.getModel().setValue("callcondition", filterData.get("callcondition"));
            this.getModel().setValue("callconditionjson", filterData.get("callconditionjson"));
            this.getModel().setValue(CONDITION, filterData.get("callcondition"), 0);
        }
    }

    private List<FilterField> getBillFilterFields(String entityNumber, String billfieldnumber) {
        List<Object> list = new ArrayList<FilterField>();
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        List filterFields = entityTypeUtil.getFilterFields((IDataEntityType)mainType);
        if (!ObjectUtils.isEmpty((Object)billfieldnumber)) {
            String[] numbers = billfieldnumber.split(",");
            List<String> fieldNumbers = Arrays.asList(numbers);
            list = filterFields.stream().filter(filterField -> fieldNumbers.contains(filterField.getFullFieldName())).collect(Collectors.toList());
        }
        return list;
    }

    protected void openSettingPage(int rowIndex, String entityNumber, String entityfield, String conditionjson, String actionId) {
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(entityfield, rowIndex);
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_billtax_filter");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCaption(ResManager.loadKDString((String)"\u8f6c\u6362\u6761\u4ef6\u914d\u7f6e", (String)"BillTaxConfigsEdit_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        formshowParameter.setCustomParam("billNumber", (Object)entityNumber);
        formshowParameter.setCustomParam("callconditionjson", selectedRow.get(conditionjson));
        if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)BillTaxConfigsSettingEnum.SPECIFIC.getOperateKey())) {
            formshowParameter.setCustomParam("display_header", (Object)Boolean.TRUE);
        } else {
            formshowParameter.setCustomParam("display_header", (Object)Boolean.FALSE);
        }
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    private void openCallSettingPage(String entityNumber, Object conditionjson, String actionId) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_billtax_filter");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCaption(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u914d\u7f6e", (String)"BillTaxConfigsEdit_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        formshowParameter.setCustomParam("display_header", (Object)Boolean.TRUE);
        formshowParameter.setCustomParam("billNumber", (Object)entityNumber);
        formshowParameter.setCustomParam("callconditionjson", conditionjson);
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    private List<String> getFilterColunms(String entityNumber) {
        List<String> list = new ArrayList<String>(10);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bdtaxr_bill_configs", (String)"billfieldnumber", (QFilter[])new QFilter[]{new QFilter("billentity", "=", (Object)entityNumber)});
        if (!ObjectUtils.isEmpty((Object)dynamicObject)) {
            String billfieldnumber = dynamicObject.getString("billfieldnumber");
            list = Stream.of(billfieldnumber.split(",")).collect(Collectors.toList());
        }
        return list;
    }

    private void showSpecificProduct() {
        Object country = this.getModel().getValue("country");
        QFilter countryFilter = new QFilter("country", "=", ObjectUtils.isEmpty((Object)country) ? null : ((DynamicObject)country).get("id"));
        QFilter STATUS = new QFilter("status", "=", (Object)"C");
        QFilter ENABLE = new QFilter("enable", "=", (Object)"1");
        QFilter startDate = new QFilter("startdate", "<=", (Object)new Date());
        QFilter endDate = new QFilter("enddate", "is null", null).or(new QFilter("enddate", ">=", (Object)new Date()));
        if (QueryServiceHelper.exists((String)BASTAX_DRC_COUNTRY, (QFilter[])new QFilter[]{STATUS, ENABLE, startDate, endDate, countryFilter})) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"specific_tab"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"specific_tab"});
            this.getModel().deleteEntryData("specific_entity");
            Tab tab = (Tab)this.getControl(TABAP);
            tab.activeTab("tabpageap");
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
    }
}

