/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.billtaxconfigs.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.CommonConstant;
import kd.taxc.bdtaxr.common.util.FilterFields.FilterFieldsUtil;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.vo.BillTaxFilterVo;
import kd.taxc.bdtaxr.common.vo.FieldsColumnVo;
import kd.taxc.bdtaxr.formplugin.billconfigs.BillFieldBean;
import kd.taxc.bdtaxr.formplugin.billconfigs.BillFieldsListPlugin;

public class BillTaxFilterOperPlugin
extends AbstractFormPlugin
implements CellClickListener,
BeforeF7SelectListener {
    private static final String BTNOK = "btnok";
    private static final String BTCANCEL = "btncancel";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String LEFT_BRACKET = "leftbracket";
    private static final String FIELD = "field";
    private static final String CONDITION = "condition";
    private static final String VALUE = "value";
    private static final String TRUEVALUE = "truevalue";
    private static final String RIGHT_BRACKET = "rightbracket";
    private static final String LOGIC = "logic";
    private static final String FIELDS_TYPE = "fieldtype";
    private static final String EQUAL_ID = "equalId";
    public static final String BILLNUMBER = "billNumber";
    public static final String CALLCONDITION = "callcondition";
    public static final String CALLCONDITIONJSON = "callconditionjson";
    public static final String FILTERCOLUNMS = "filterColunms";
    public static final String DISPLAY_HEADER = "display_header";
    private static final String SETTING = "setting";
    private static final String SETTING_BASEDATA = "settingBasedata";
    private static final String SETTING_COMBO = "settingCombo";
    private static final String DATE_SETTING = "dateSetting";

    private String getOrCn() {
        return ResManager.loadKDString((String)"\u6216\u8005", (String)"BillTaxFilterOperPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]);
    }

    private String getAndCn() {
        return ResManager.loadKDString((String)"\u5e76\u4e14", (String)"BillTaxFilterOperPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        int totalLevel = 2;
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String billNumber = (String)showParameter.getCustomParams().get(BILLNUMBER);
        BillFieldsListPlugin billFieldsListPlugin = new BillFieldsListPlugin();
        if (StringUtils.isEmpty((CharSequence)billNumber)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u5339\u914d\u5355\u636e\u7f16\u7801\u3002", (String)"BillTaxFilterOperPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)billNumber) && billFieldsListPlugin.isUpdateFields(billNumber, totalLevel)) {
            List<BillFieldBean> billFieldList = billFieldsListPlugin.getEntityAllFields(billNumber, totalLevel, 1, null);
            billFieldsListPlugin.updateFieldProperty(billNumber, billFieldList);
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK, BTCANCEL});
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        grid.addCellClickListener((CellClickListener)this);
        BasedataEdit field = (BasedataEdit)this.getControl(FIELD);
        field.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit conditionfield = (BasedataEdit)this.getControl(CONDITION);
        conditionfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String json = (String)this.getView().getFormShowParameter().getCustomParams().get(CALLCONDITIONJSON);
        if (StringUtils.isEmpty((CharSequence)json)) {
            return;
        }
        List dtos = JsonUtil.fromJsonList((String)json, BillTaxFilterVo.class);
        DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity(ENTRY_ENTITY).getDynamicObjectType();
        for (int i = 0; i < dtos.size(); ++i) {
            if (this.getModel().getEntryRowCount(ENTRY_ENTITY) <= i) {
                this.getModel().createNewEntryRow(ENTRY_ENTITY);
            }
            DynamicObject dyo = this.getModel().getEntryRowEntity(ENTRY_ENTITY, i);
            BillTaxFilterVo dto = (BillTaxFilterVo)dtos.get(i);
            dynamicObjectType.getProperty(LEFT_BRACKET).setValueFast((Object)dyo, (Object)dto.getLeftBracket());
            dynamicObjectType.getProperty(FIELD).setValueFast((Object)dyo, (Object)dto.getField());
            dynamicObjectType.getProperty(CONDITION).setValueFast((Object)dyo, (Object)dto.getConditon());
            this.getModel().setValue(LEFT_BRACKET, (Object)dto.getLeftBracket(), i);
            this.getModel().setValue(FIELD, (Object)dto.getField(), i);
            this.getModel().setValue(CONDITION, (Object)dto.getConditon(), i);
            if ("is null".equals(dto.getConditonNumber()) || "is not null".equals(dto.getConditonNumber())) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{VALUE});
            }
            dynamicObjectType.getProperty(VALUE).setValueFast((Object)dyo, (Object)dto.getValueCn());
            dynamicObjectType.getProperty(TRUEVALUE).setValueFast((Object)dyo, (Object)String.join((CharSequence)(CommonConstant.COMMA + ""), dto.getValue()));
            dynamicObjectType.getProperty(RIGHT_BRACKET).setValueFast((Object)dyo, (Object)dto.getRightBracket());
            dynamicObjectType.getProperty(LOGIC).setValueFast((Object)dyo, (Object)dto.getLogic());
            dynamicObjectType.getProperty(FIELDS_TYPE).setValueFast((Object)dyo, (Object)dto.getFieldType());
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        Map<String, FieldsColumnVo> filterColumns = this.getFilterColumns();
        String key = cellClickEvent.getFieldKey();
        int index = cellClickEvent.getRow();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)VALUE)) {
            Object field = this.getModel().getEntryRowEntity(ENTRY_ENTITY, index).get(FIELD);
            if (ObjectUtils.isEmpty((Object)field)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5\u3002", (String)"BillTaxFilterOperPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            String fieldNumber = ((DynamicObject)field).getString("number");
            String fieldName = ((DynamicObject)field).getString("name");
            Object value = this.getModel().getEntryRowEntity(ENTRY_ENTITY, index).get(VALUE);
            FieldsColumnVo fieldsColumnVo = filterColumns.get(fieldNumber);
            if (ObjectUtils.isEmpty((Object)fieldsColumnVo)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u5df2\u53d1\u751f\u6539\u53d8\u6216\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"BillTaxFilterOperPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), fieldName));
                return;
            }
            IDataEntityProperty fieldProperty = fieldsColumnVo.getFieldEntityProperty();
            if (fieldProperty instanceof BasedataProp) {
                this.openSettingPage("settingBasedata#" + index, ((BasedataProp)fieldProperty).getBaseEntityId(), false, null);
            } else if (fieldProperty instanceof ComboProp) {
                this.insertValue2AssistTable((ComboProp)fieldProperty);
                this.openSettingPage("settingCombo#" + index, "bdtaxr_combo_assist", false, null);
            } else if (fieldProperty instanceof DateTimeProp) {
                this.openDateSetting("dateSetting#" + index, "bdtaxr_date_assist", value);
            } else if (fieldProperty instanceof AdminDivisionProp) {
                this.openSettingPage("settingBasedata#" + index, fieldsColumnVo.getBaseEntityId(), false, null);
            } else if (fieldProperty instanceof BooleanProp) {
                this.insertValue2AssistTable(this.createComboProp());
                this.openSettingPage("settingCombo#" + index, "bdtaxr_combo_assist", false, null);
            }
            if (null != fieldProperty.getPropertyType()) {
                this.getModel().setValue(FIELDS_TYPE, (Object)fieldProperty.getPropertyType().getSimpleName(), index);
            }
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        this.cellClick(cellClickEvent);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        int index = e.getChangeSet()[0].getRowIndex();
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)FIELD)) {
            this.getModel().setValue(CONDITION, (Object)this.getEqualId(), index);
            this.getView().setEnable(Boolean.TRUE, index, new String[]{VALUE});
            this.getModel().setValue(VALUE, null, index);
            this.getModel().setValue(TRUEVALUE, null, index);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)CONDITION)) {
            this.getModel().setValue(VALUE, null, index);
            this.getModel().setValue(TRUEVALUE, null, index);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)VALUE)) {
            this.getModel().setValue(TRUEVALUE, e.getChangeSet()[0].getNewValue(), index);
        }
    }

    private ComboProp createComboProp() {
        ComboProp comboProp = new ComboProp();
        ArrayList<ValueMapItem> comboItems = new ArrayList<ValueMapItem>();
        ValueMapItem itemOne = new ValueMapItem();
        itemOne.setName(new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"BillTaxFilterOperPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0])));
        itemOne.setValue("1");
        ValueMapItem itemTwo = new ValueMapItem();
        itemTwo.setName(new LocaleString(ResManager.loadKDString((String)"\u5426", (String)"BillTaxFilterOperPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0])));
        itemTwo.setValue("0");
        comboItems.add(itemOne);
        comboItems.add(itemTwo);
        comboProp.setComboItems(comboItems);
        return comboProp;
    }

    private Long getEqualId() {
        String id = this.getPageCache().get(EQUAL_ID);
        if (StringUtils.isEmpty((CharSequence)id)) {
            DynamicObject dyo = QueryServiceHelper.queryOne((String)"bdtaxr_comparetype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"=")});
            if (null != dyo) {
                this.getPageCache().put(EQUAL_ID, String.valueOf(dyo.getLong("id")));
                return dyo.getLong("id");
            }
            return null;
        }
        return Long.parseLong(id);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (actionId.startsWith(SETTING)) {
            ListSelectedRowCollection collection = (ListSelectedRowCollection)evt.getReturnData();
            if (null == collection || collection.size() == 0) {
                return;
            }
            String[] subs = evt.getActionId().split("#");
            int index = Integer.parseInt(subs[1]);
            for (int i = 0; i < collection.size(); ++i) {
                String value = "";
                String trueValue = "";
                String pkId = String.valueOf(collection.get(i).getPrimaryKeyValue());
                this.getModel().setValue(VALUE, (Object)(value + collection.get(i).getName()), index);
                if (StringUtils.isEmpty((CharSequence)collection.get(i).getName())) {
                    this.getModel().setValue(VALUE, (Object)(value + pkId), index);
                }
                if (actionId.contains("Basedata")) {
                    this.getModel().setValue(TRUEVALUE, (Object)(trueValue + pkId), index);
                    continue;
                }
                if (!actionId.contains("Combo")) continue;
                this.getModel().setValue(TRUEVALUE, (Object)(trueValue + collection.get(i).getNumber()), index);
            }
        } else if (actionId.startsWith(DATE_SETTING)) {
            String[] subs = evt.getActionId().split("#");
            int index = Integer.parseInt(subs[1]);
            Map map = (Map)evt.getReturnData();
            if (!ObjectUtils.isEmpty((Object)map)) {
                String date = DateUtils.format((Date)((Date)map.get("datetime")));
                this.getModel().setValue(VALUE, (Object)date, index);
                this.getModel().setValue(TRUEVALUE, (Object)date, index);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTNOK.equalsIgnoreCase(key)) {
            if (this.checkBeforeReturn()) {
                return;
            }
            Map<String, Object> ret = this.getConfig();
            this.getView().returnDataToParent(ret);
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)FIELD)) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter numberFilter = new QFilter("billnumber", "=", (Object)this.getEntityNumber());
            formShowParameter.setCustomParam(BILLNUMBER, (Object)this.getEntityNumber());
            numberFilter.and("number", "not like", (Object)"%.number").and("number", "not like", (Object)"%.name");
            if (this.getView().getFormShowParameter().getCustomParam(DISPLAY_HEADER) instanceof Boolean && ((Boolean)this.getView().getFormShowParameter().getCustomParam(DISPLAY_HEADER)).booleanValue()) {
                formShowParameter.getListFilterParameter().getQFilters().add(this.addHeaderQFilter(this.getEntityNumber()));
            }
            formShowParameter.getListFilterParameter().getQFilters().add(numberFilter);
        }
    }

    private void insertValue2AssistTable(ComboProp current) {
        DeleteServiceHelper.delete((String)"bdtaxr_combo_assist", null);
        ArrayList<DynamicObject> dyos = new ArrayList<DynamicObject>(10);
        for (ValueMapItem item : current.getComboItems()) {
            if (item.getName().isEmpty()) continue;
            DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_combo_assist");
            dyo.set("name", (Object)item.getName());
            dyo.set("number", (Object)item.getValue());
            dyos.add(dyo);
        }
        SaveServiceHelper.save((DynamicObject[])dyos.toArray(new DynamicObject[dyos.size()]));
    }

    private void openSettingPage(String actionId, String entityName, boolean isMultiSelect, ListFilterParameter listFilterParameter) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(entityName);
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)entityName);
        if (ObjectUtils.isEmpty((Object)formConfig)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6253\u5f00\u5f02\u5e38\u3002", (String)"BillTaxFilterOperPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (ObjectUtils.isEmpty((Object)entityType.getAlias())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u7684\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillTaxFilterOperPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        parameter.setFormId(formConfig.getF7ListFormId());
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(false);
        parameter.setMultiSelect(isMultiSelect);
        parameter.setLookUp(true);
        parameter.setCustomParam("selectaction", (Object)"doOpenParent");
        parameter.setCustomParam("modeltype", (Object)"BaseFormModel");
        parameter.setCustomParam("isShowAllNoOrg", (Object)"true");
        parameter.setListFilterParameter(listFilterParameter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void openDateSetting(String actionId, String entityName, Object date) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(entityName);
        parameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f", (String)"BillTaxFilterOperPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        parameter.setCustomParam("datetime", date);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        parameter.setCloseCallBack(closeCallBack);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private String getEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(BILLNUMBER);
    }

    private Map<String, FieldsColumnVo> getFilterColumns() {
        return FilterFieldsUtil.getFilterColumns((String)this.getEntityNumber());
    }

    private boolean checkBeforeReturn() {
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        for (int i = 0; i < rowCount; ++i) {
            if (null != this.getModel().getValue(FIELD, i) && null != this.getModel().getValue(CONDITION, i) && !this.checkValue((DynamicObject)this.getModel().getValue(CONDITION, i), (String)this.getModel().getValue(VALUE, i))) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u8bbe\u7f6e\u3002", (String)"BillTaxFilterOperPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]), i + 1));
            return true;
        }
        return false;
    }

    private boolean checkValue(DynamicObject condition, String value) {
        String qCp = condition.getString("number");
        if ("is null".equals(qCp) || "is not null".equals(qCp)) {
            return false;
        }
        return StringUtils.isEmpty((CharSequence)value);
    }

    private List<BillTaxFilterVo> buildFilterDto() {
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        ArrayList<BillTaxFilterVo> filterDtos = new ArrayList<BillTaxFilterVo>(10);
        for (int i = 0; i < rowCount; ++i) {
            BillTaxFilterVo dto = new BillTaxFilterVo();
            dto.setLeftBracket((String)this.getModel().getValue(LEFT_BRACKET, i));
            DynamicObject condition = (DynamicObject)this.getModel().getValue(CONDITION, i);
            dto.setConditon(Long.valueOf(condition.getLong("id")));
            dto.setConditonCn(condition.getString("name"));
            dto.setConditonNumber(condition.getString("number"));
            DynamicObject field = (DynamicObject)this.getModel().getValue(FIELD, i);
            dto.setField(Long.valueOf(field.getLong("id")));
            dto.setFieldCn(field.getString("name"));
            dto.setFieldNumber(field.getString("number"));
            dto.setRightBracket((String)this.getModel().getValue(RIGHT_BRACKET, i));
            dto.setLogic((String)this.getModel().getValue(LOGIC, i));
            String truevalue = (String)this.getModel().getValue(TRUEVALUE, i);
            ArrayList<String> filterValues = new ArrayList<String>(Arrays.asList(truevalue.split(CommonConstant.COMMA + "")));
            if (filterValues.size() == 1 && StringUtils.isEmpty((CharSequence)((CharSequence)filterValues.get(0)))) {
                filterValues.add(0, (String)this.getModel().getValue(VALUE, i));
            }
            dto.setValue(filterValues);
            dto.setValueCn((String)this.getModel().getValue(VALUE, i));
            dto.setFieldType((String)this.getModel().getValue(FIELDS_TYPE, i));
            filterDtos.add(dto);
        }
        return filterDtos;
    }

    private Map<String, Object> getConfig() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        List<BillTaxFilterVo> dto = this.buildFilterDto();
        if (dto == null || dto.size() == 0) {
            return data;
        }
        data.put(CALLCONDITIONJSON, JsonUtil.toJson(dto));
        data.put(CALLCONDITION, this.getFilterDesc(dto));
        return data;
    }

    private String getFilterDesc(List<BillTaxFilterVo> dtos) {
        StringBuilder sb = new StringBuilder();
        for (BillTaxFilterVo dto : dtos) {
            sb.append(dto.toCnString()).append(' ');
        }
        String desc = sb.toString().trim();
        if (desc.endsWith(this.getAndCn()) || desc.endsWith(this.getOrCn())) {
            desc = desc.substring(0, desc.length() - 2);
        }
        return desc;
    }

    private QFilter addHeaderQFilter(String entityNumber) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection collection = mainEntityType.getProperties();
        List list = collection.stream().map(o -> o.getName()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("number", "in", (Object)list.toArray());
        return qFilter;
    }
}

