/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.datadetails;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.DateListColumn;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.FlexListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.business.datadetails.DataSourceDetailsService;
import kd.taxc.bdtaxr.business.datadetails.filter.DateFilterService;
import kd.taxc.bdtaxr.business.datadetails.filter.DateFilterServiceFactory;
import kd.taxc.bdtaxr.business.filter.FilterService;
import kd.taxc.bdtaxr.common.dto.RuleTimeFilterDto;
import kd.taxc.bdtaxr.common.rule.util.RuleAccessUtil;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineCalcFilterService;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.RuleConfigUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class DataSourceDetailsPlugin
extends AbstractFormPlugin
implements CreateListColumnsListener,
SetFilterListener {
    private static final Log logger = LogFactory.getLog(DataSourceDetailsPlugin.class);
    private DataSourceDetailsService dataSourceDetailsService = new DataSourceDetailsService();
    private FilterService filterService = new FilterService();

    public void preOpenForm(PreOpenFormEventArgs e) {
        Map params = e.getFormShowParameter().getCustomParams();
        try {
            this.dataSourceDetailsService.validate(params);
        }
        catch (KDBizException e1) {
            e.setCancel(true);
            e.setCancelMessage(e1.getMessage());
        }
    }

    public void initialize() {
        super.initialize();
        BillList billlistap = (BillList)this.getControl("billlistap");
        String entityname = (String)this.getView().getFormShowParameter().getCustomParam("entityname");
        billlistap.setEntityId(entityname);
        billlistap.addSetFilterListener((SetFilterListener)this);
        billlistap.addCreateListColumnsListener((CreateListColumnsListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String datasourceid = String.valueOf(customParams.get("tableid"));
        String amountField = (String)customParams.get("amountField");
        DynamicObjectCollection dataSource = this.dataSourceDetailsService.queryCustomSourceById(Long.valueOf(datasourceid));
        if (CollectionUtils.isNotEmpty((Collection)dataSource)) {
            args.getListColumns().clear();
            ListColumn seqColumn = new ListColumn();
            seqColumn.setKey("seq");
            seqColumn.setListFieldKey("fseq");
            seqColumn.setUserConfigColumnSettings(null);
            seqColumn.setSeqColumnType("EntitySeq");
            seqColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"DataSourceDetailsPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0])));
            args.getListColumns().add(seqColumn);
            for (DynamicObject object : dataSource) {
                boolean isAmountField;
                String fieldName = object.getString("fieldname");
                String entityname = object.getString("entityname");
                MainEntityType det = MetadataServiceHelper.getDataEntityType((String)entityname);
                if ("gl_balance".equals(entityname) && "period.begindate".equals(fieldName)) {
                    fieldName = "period";
                }
                ListColumn e = new ListColumn();
                DynamicProperty property = (DynamicProperty)det.getAllFields().get(fieldName);
                if (property != null && EmptyCheckUtils.isEmpty((Object)property.getAlias())) continue;
                boolean mark = "gl_balance".equals(entityname) && StringUtils.startsWith((CharSequence)amountField, (CharSequence)"begin");
                boolean bl = isAmountField = StringUtils.equals((CharSequence)fieldName, (CharSequence)amountField) || mark && amountField.replace("begin", "end").equals(fieldName);
                if (property instanceof DecimalProp) {
                    e = new DecimalListColumn();
                    ((DecimalListColumn)e).setZeroShow(true);
                    if (isAmountField) {
                        ((DecimalListColumn)e).setSummary(1);
                        e.setBackColor("#DCFAE4");
                    }
                } else if (property instanceof FlexProp) {
                    e = new FlexListColumn();
                } else if (property instanceof DateProp) {
                    e = new DateListColumn();
                } else if (property instanceof BasedataProp) {
                    fieldName = fieldName + "." + ((BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)((BasedataProp)property).getBaseEntityId())).getNameProperty();
                }
                e.setCaption(new LocaleString(object.getString("bizsubname")));
                e.setKey(fieldName);
                e.setListFieldKey(fieldName);
                args.getListColumns().add(e);
            }
        }
        args.getListColumns();
    }

    public void setFilter(SetFilterEvent evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entryName = (String)customParams.get("entityname");
        String amountField = (String)customParams.get("amountField");
        String orgid = String.valueOf(customParams.get("orgid"));
        String taxorg = (String)customParams.get("taxorg");
        long orgId = EmptyCheckUtils.isNotEmpty((Object)taxorg) ? Long.parseLong(taxorg) : Long.parseLong(orgid);
        String conditionjson = (String)customParams.get("conditionjson");
        String advancedconfjson = (String)customParams.get("advancedconfjson");
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        String itemnumber = (String)customParams.get("itemnumber");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        Date start = DateUtils.stringToDate2((String)skssqq);
        Date end = DateUtils.stringToDate2((String)skssqz);
        Long datasourceid = Long.valueOf(String.valueOf(customParams.get("tableid")));
        Map fieldMap = RuleConfigUtils.get((Long)datasourceid);
        RuleTimeFilterDto ruleTimeFilterDto = new RuleTimeFilterDto(advancedconfjson, start, end, filterList, "", fieldMap, entryName, "", amountField);
        ruleTimeFilterDto.setOrgId(Long.valueOf(orgId));
        if (EmptyCheckUtils.isNotEmpty(customParams.get("businessParams"))) {
            Map businessParams = (Map)customParams.get("businessParams");
            if (EmptyCheckUtils.isNotEmpty(businessParams.get("taxationsys"))) {
                ruleTimeFilterDto.setTaxationsys(Long.valueOf(Long.parseLong(String.valueOf(businessParams.get("taxationsys")))));
            }
            if (EmptyCheckUtils.isNotEmpty(businessParams.get("taxcategory"))) {
                ruleTimeFilterDto.setTaxcategory(Long.valueOf(Long.parseLong(String.valueOf(businessParams.get("taxcategory")))));
            }
            if (EmptyCheckUtils.isNotEmpty((Object)"draftpurpose")) {
                ruleTimeFilterDto.setDraftpurpose(String.valueOf(businessParams.get("draftpurpose")));
            }
            if (EmptyCheckUtils.isNotEmpty((Object)"templatetype")) {
                ruleTimeFilterDto.setTemplateType(String.valueOf(businessParams.get("templatetype")));
            }
        }
        DateFilterService dateService = DateFilterServiceFactory.create(ruleTimeFilterDto.getTemplateType());
        dateService.build(ruleTimeFilterDto);
        String baseTaxId = (String)customParams.get("basetaxid");
        this.addOrgFilter(fieldMap, baseTaxId, datasourceid, orgId, start, end, filterList);
        QFilter conditionFilters = this.dataSourceDetailsService.parseCondition(conditionjson, entryName, orgId);
        if (conditionFilters != null) {
            filterList.add(conditionFilters);
        }
        this.filterService.setGLQFeilter(ruleTimeFilterDto);
        this.filterService.setQysdsRuleFilter(ruleTimeFilterDto, filterList, itemnumber);
        logger.info("\u53d6\u6570\u91d1\u989d\u4e0b\u94bb\u660e\u7ec6\u67e5\u8be2\u6570\u636e\u65f6\u8fc7\u6ee4\u6761\u4ef6\uff1a" + ((Object)filterList).toString());
        evt.getQFilters().addAll(filterList);
    }

    private void addOrgFilter(Map<String, String> fieldMap, String baseTaxId, Long datasourceid, long orgId, Date start, Date end, List<QFilter> filterList) {
        QFilter mappingQfilter;
        if (fieldMap.get("orgstate") != null) {
            List<Long> orgIds = this.getOrgListByRelation(Collections.singletonList(orgId), start, end, datasourceid);
            QFilter qfilter = new QFilter(fieldMap.get("orgstate"), "in", orgIds);
            filterList.add(qfilter);
        }
        if (EmptyCheckUtils.isNotEmpty((Object)baseTaxId) && (mappingQfilter = EngineCalcFilterService.getMappingQfilter((Long)Long.valueOf(baseTaxId), (Long)datasourceid, Collections.singletonList(orgId), (Date)start, (Date)end)) != null) {
            filterList.add(mappingQfilter);
        }
    }

    protected List<Long> getOrgListByRelation(List<Long> orgList, Date skssqq, Date skssqz, Long tableId) {
        DynamicObject dataSourceObject = BusinessDataServiceHelper.loadSingleFromCache((Object)tableId, (String)"tctb_custom_datasource");
        String entryName = dataSourceObject.getString("entityname");
        Map orgRelationMap = TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs(orgList, (Date)skssqq, (Date)skssqz);
        Map fieldMap = RuleAccessUtil.getTableFields((Long)tableId);
        String org = (String)fieldMap.get("orgstate");
        if (null != org) {
            String entityKey = entryName;
            String orgFieldName = org;
            if (org.contains(".")) {
                String[] split = org.split("\\.");
                entityKey = split[0];
                orgFieldName = split[1];
            }
            orgList = EngineCalcFilterService.getOrgListByRelation((Map)orgRelationMap, orgList, (String)entryName, (String)entityKey, (String)orgFieldName);
        }
        return orgList;
    }
}

