/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.exportsql;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.exportsql.CompareLogVo;
import kd.taxc.bdtaxr.formplugin.exportsql.HttpConnectionUtil;
import kd.taxc.bdtaxr.formplugin.exportsql.SqlScript;
import kd.taxc.bdtaxr.formplugin.exportsql.XStreamUtils;
import kd.taxc.bdtaxr.formplugin.exportsql.ZipUtils;
import org.apache.commons.io.FilenameUtils;

public class CompareScriptService {
    private static final Pattern CREATE_TABLE_DDL_PATTERN = Pattern.compile("\\s*(create\\s+table|ALTER\\s+TABLE)\\s+(?<tableName>\\S+)", 2);
    private static final Pattern OPERATE_TABLE_DML_PATTERN = Pattern.compile("\\s*(INSERT\\s+INTO|DELETE\\s+FROM|UPDATE|[^{M\\[{S\\[]SELECT.+\\s+FROM)\\s+(?<tableName>\\S+)", 2);
    private static final Log LOGGER = LogFactory.getLog(CompareScriptService.class);
    private static final String SEPARATOR = File.separator;
    private static final String WORK = System.getProperty("java.io.tmpdir") + SEPARATOR;
    private static final String CODE_STORE = "aHR0cHM6Ly9mZWF0dXJlLmtpbmdkZWUuY29tOjEwMjYvY29zbWljLWNkLXNjbS9wYXRjaHNjbS90ZXN0L3ByZXBhcmUvcnVudGltZS9kYXRhbW9kZWwv";
    private static final String ROOT_PATH = SEPARATOR + "datamodel" + SEPARATOR + "1.5" + SEPARATOR + "main" + SEPARATOR + "%s";
    private static final String DBSCHEMA_PATH = SEPARATOR + "datamodel" + SEPARATOR + "1.5" + SEPARATOR + "main" + SEPARATOR + "%s" + SEPARATOR + "dbschema";
    private static final String PREINSDATA_PATH = SEPARATOR + "datamodel" + SEPARATOR + "1.5" + SEPARATOR + "main" + SEPARATOR + "%s" + SEPARATOR + "preinsdata";
    private static final String SPLIT_STAR_STR = "**************************************************************************************************************************************************";
    private static final String NEW_LINE = "\t\n";
    private static final String DBSCHEMA = "dbschema";
    private static final String PREINSDATA = "preinsdata";
    private static final String TAXC = "taxc";
    private static final String BASEDATA = "basedata";
    private static Properties properties;

    public StringBuilder runCheck() {
        StringBuilder builder = new StringBuilder(SPLIT_STAR_STR);
        ArrayList appids = Lists.newArrayList((Object[])new String[]{"tctb", "tpo", "til", "tdm", "tcvat", "tctsa", "totf", "tccit", "tcsd", "tcret", "bastax", "bdtaxr", "tsate", "tcvvt", "tctrc", "itp", "tcnfep", "tcetr", "tam", "rdesd"});
        ArrayList<String> nonTaxcTables = new ArrayList<String>();
        for (String appid : appids) {
            ArrayList<CompareLogVo> compareLogVoLists = new ArrayList<CompareLogVo>();
            long scriptCount = 0L;
            HashSet preTables = new HashSet();
            String zipName = String.format("taxc-%s-dm-1.x.zip", appid);
            String downloadUrl = CompareScriptService.getDecode(CODE_STORE) + zipName;
            LOGGER.info("downloadUrl---" + downloadUrl);
            LOGGER.info("zipUrl---" + WORK + zipName);
            try {
                HttpConnectionUtil.downloadFile(downloadUrl, WORK, zipName);
                String destDir = zipName.replace(".x.zip", "");
                String decompressUrl = WORK + destDir;
                LOGGER.info("decompressUrl---" + decompressUrl);
                ZipUtils.decompress(new File(FilenameUtils.normalize((String)(WORK + FilenameUtils.getName((String)zipName)))), decompressUrl);
                List<String> lists = this.readAllLines(ROOT_PATH, destDir, appid, appid + ".xml");
                for (String srcipt : lists) {
                    boolean isSqlScript = StringUtil.isNotEmpty((CharSequence)srcipt) && srcipt.trim().startsWith("<SqlScript");
                    if (!isSqlScript) continue;
                    ++scriptCount;
                    try {
                        String[] sqls;
                        SqlScript sqlScript = XStreamUtils.xmlToObject(srcipt, SqlScript.class);
                        String srcPath = sqlScript.getPath();
                        String sqlScriptName = srcPath.split("\\/")[1];
                        if (srcPath.trim().startsWith(DBSCHEMA)) {
                            if (sqlScriptName.endsWith("constraint.sql")) continue;
                            String content = this.readAllContent(DBSCHEMA_PATH, destDir, appid, sqlScriptName);
                            Arrays.stream(content.split(";")).map(s -> CompareScriptService.getTable(CREATE_TABLE_DDL_PATTERN, s + ";")).filter(table -> !table.isEmpty()).forEach(s -> preTables.addAll(s));
                        }
                        if (!srcPath.trim().startsWith(PREINSDATA)) continue;
                        String dbkey = sqlScript.getDbkey();
                        String content = this.readAllContent(PREINSDATA_PATH, destDir, appid, sqlScriptName);
                        for (String sql : sqls = content.split(";")) {
                            for (String table2 : CompareScriptService.getTable(OPERATE_TABLE_DML_PATTERN, sql)) {
                                String diffFieldNames;
                                String limitFields;
                                if (TAXC.equals(dbkey)) {
                                    if (!StringUtil.isNotEmpty((CharSequence)table2) || preTables.contains(table2)) continue;
                                    this.addIfNotExists(compareLogVoLists, appid, sqlScriptName, dbkey, table2, null);
                                    continue;
                                }
                                if (!nonTaxcTables.contains(table2)) {
                                    nonTaxcTables.add(table2);
                                }
                                if (!StringUtil.isNotEmpty((CharSequence)table2) || preTables.contains(table2) || StringUtil.isEmpty((CharSequence)(limitFields = properties.getProperty(table2))) || StringUtil.isEmpty((CharSequence)(diffFieldNames = this.getDiffFieldNames(sql, limitFields)))) continue;
                                this.addIfNotExists(compareLogVoLists, appid, sqlScriptName, dbkey, table2, diffFieldNames);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("error script:" + e);
                    }
                }
                ZipUtils.delDir(WORK, zipName);
                ZipUtils.delDir(WORK, destDir);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
            compareLogVoLists.sort(Comparator.comparing(s -> s.getDbKey()));
            builder.append(NEW_LINE).append("appid\uff1a").append(appid).append("\uff0cscript count\uff1a").append(scriptCount).append("\uff0ctable count\uff1a").append(preTables.size()).append(NEW_LINE).append(this.printLog(compareLogVoLists)).append(NEW_LINE).append(SPLIT_STAR_STR).append(NEW_LINE);
        }
        builder.append("non tax tables:").append(NEW_LINE).append(nonTaxcTables.stream().collect(Collectors.joining(",")));
        return builder;
    }

    public void addIfNotExists(List<CompareLogVo> compareLogVoLists, String appid, String sqlScriptName, String dbkey, String table, String o) {
        CompareLogVo compareLogVo = new CompareLogVo(appid, dbkey, sqlScriptName, table, o);
        if (!compareLogVoLists.contains(compareLogVo)) {
            compareLogVoLists.add(compareLogVo);
        }
    }

    private String getDiffFieldNames(String inputSql, String limitFields) {
        List limitFieldNames = Arrays.stream(limitFields.split(",")).map(s -> s.trim().toUpperCase()).collect(Collectors.toList());
        if (!inputSql.startsWith("INSERT INTO")) {
            return null;
        }
        List inputFieldNames = Arrays.stream(inputSql.substring(inputSql.indexOf("(") + 1, inputSql.indexOf(")")).split(",")).map(s -> s.trim().toUpperCase()).collect(Collectors.toList());
        return inputFieldNames.stream().filter(s -> !limitFieldNames.contains(s)).collect(Collectors.joining(","));
    }

    private static String getDecode(String str) {
        return new String(Base64.getDecoder().decode(str));
    }

    private String printLog(List<CompareLogVo> compareLogVoLists) {
        return compareLogVoLists.stream().map(s -> s.toString()).collect(Collectors.joining());
    }

    public static Set<String> getTable(Pattern pattern, String sql) {
        Matcher matcher = pattern.matcher(sql);
        HashSet<String> tables = new HashSet<String>();
        while (matcher.find()) {
            String tableName = matcher.group("tableName");
            if (StringUtil.isNotEmpty((CharSequence)tableName)) {
                tableName = tableName.split("\\(")[0].replaceAll("'|`|\"|\\(|\\)", "");
            }
            if (tableName.startsWith("t_") || tableName.startsWith("T_")) {
                tables.add(tableName.toUpperCase());
            }
            if (!sql.startsWith("INSERT INTO") && !sql.startsWith("insert into")) continue;
            break;
        }
        return tables;
    }

    private List<String> readAllLines(String typePath, String destDir, String appid, String fileName) throws IOException {
        String filePath = String.format(WORK + destDir + typePath, appid);
        String normalize = FilenameUtils.normalize((String)(filePath + SEPARATOR + FilenameUtils.getName((String)fileName)));
        Path path = Paths.get(normalize, new String[0]);
        boolean readContinue = true;
        ArrayList<String> result = new ArrayList<String>();
        List<String> scripts = Files.readAllLines(path);
        for (String script : scripts) {
            if (script == null || StringUtil.isEmpty((CharSequence)script.trim())) continue;
            if (StringUtil.startsWith((CharSequence)(script = script.trim()), (CharSequence)"<!--")) {
                readContinue = false;
            }
            if (StringUtil.endsWith((CharSequence)script, (CharSequence)"-->")) {
                readContinue = true;
                continue;
            }
            if (!readContinue) continue;
            result.add(script);
        }
        return result;
    }

    private String readAllContent(String typePath, String destDir, String appid, String fileName) throws IOException {
        String filePath = String.format(WORK + destDir + typePath, appid);
        String normalize = FilenameUtils.normalize((String)(filePath + SEPARATOR + FilenameUtils.getName((String)fileName)));
        Path path = Paths.get(normalize, new String[0]);
        try (Stream<String> lines = Files.lines(path);){
            String string = lines.collect(Collectors.joining());
            return string;
        }
    }

    static {
        LOGGER.error("start load config......");
        String proFilePath = "/properties/limit.properties";
        properties = new Properties();
        try (InputStream in = CompareScriptService.class.getResourceAsStream(proFilePath);){
            properties.load(in);
            LOGGER.error("end load config......");
        }
        catch (Exception e) {
            LOGGER.error("load config error");
        }
    }
}

