/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.exportsql;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;

public class ZipUtils {
    public static boolean delDir(String path, String fileName) throws IOException {
        File file = new File(FilenameUtils.normalize((String)(path + FilenameUtils.getName((String)fileName))));
        if (file.isFile()) {
            Files.delete(Paths.get(file.getPath(), new String[0]));
            return true;
        }
        File[] f = file.listFiles();
        if (null != f) {
            for (File ff : f) {
                ZipUtils.delFile(ff);
            }
        }
        Files.delete(Paths.get(file.getPath(), new String[0]));
        return true;
    }

    public static boolean delFile(File file) throws IOException {
        File[] files;
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            Files.delete(Paths.get(file.getPath(), new String[0]));
            return true;
        }
        for (File f : files = file.listFiles()) {
            ZipUtils.delFile(f);
        }
        Files.delete(Paths.get(file.getPath(), new String[0]));
        return true;
    }

    public static boolean decompress(File originFile, String targetDir) throws IOException {
        boolean flag;
        block2: {
            flag = false;
            try {
                flag = ZipUtils.decompress(originFile, targetDir, Charset.forName("UTF-8"));
            }
            catch (IllegalArgumentException e) {
                if (!"MALFORMED".equals(e.getMessage())) break block2;
                flag = ZipUtils.decompress(originFile, targetDir, Charset.forName("GBK"));
            }
        }
        return flag;
    }

    public static boolean decompress(File originFile, String targetDir, Charset charset) throws IOException {
        if (!"ZIP".equals(ZipUtils.getFileType(originFile))) {
            return false;
        }
        if (!targetDir.endsWith(File.separator)) {
            targetDir = targetDir + File.separator;
        }
        try (ZipFile zipFile = new ZipFile(originFile, charset);){
            Enumeration<? extends ZipEntry> entry = zipFile.entries();
            while (entry.hasMoreElements()) {
                ZipEntry zipEntry = entry.nextElement();
                String fileName = zipEntry.getName();
                File outputFile = new File(FilenameUtils.normalize((String)(targetDir + fileName)));
                if (zipEntry.isDirectory()) {
                    ZipUtils.forceMkdirs(outputFile);
                    continue;
                }
                if (!outputFile.getParentFile().exists()) {
                    ZipUtils.forceMkdirs(outputFile.getParent());
                }
                FileOutputStream outputStream = new FileOutputStream(outputFile);
                Throwable throwable = null;
                try {
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Throwable throwable2 = null;
                    try {
                        int len;
                        byte[] buffer = new byte[8192];
                        while (-1 != (len = inputStream.read(buffer))) {
                            ((OutputStream)outputStream).write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (outputStream == null) continue;
                    if (throwable != null) {
                        try {
                            ((OutputStream)outputStream).close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    ((OutputStream)outputStream).close();
                }
            }
        }
        return true;
    }

    public static String getFileType(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        return ZipUtils.getFileType(inputStream);
    }

    public static String getFileType(InputStream inputStream) throws IOException {
        byte[] head = new byte[4];
        if (-1 == inputStream.read(head)) {
            inputStream.close();
            return "UNKNOWN";
        }
        inputStream.close();
        int headHex = 0;
        for (byte b : head) {
            headHex <<= 8;
            headHex |= b & 0xFF;
        }
        switch (headHex) {
            case 1347093252: {
                return "ZIP";
            }
        }
        return "UNKNOWN";
    }

    public static File forceMkdirs(File file) throws IOException {
        if (!file.exists()) {
            file.mkdirs();
        } else if (!file.isDirectory()) {
            Files.delete(Paths.get(file.getPath(), new String[0]));
            file.mkdirs();
        }
        return file;
    }

    public static File forceMkdirs(String pathName) throws IOException {
        return ZipUtils.forceMkdirs(new File(pathName));
    }
}

