/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.formula;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;

public class FormulaTempPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String KEY_EXPRESSIONTEXT = "formula";
    private static final String KEY_EXPRESSIONTEXTNAME = "formulaname";
    private static final String R_FORMULA_FORMAT = "{R[values]}";
    private static final String C_FORMULA_FORMAT = "{C[values]}";
    private static final String P_FORMULA_FORMAT = "{P[values]}";
    private static final String Q_FORMULA_FORMAT = "{Q[values]}";
    private static final String CHECK_PREFIX = "check_";
    private static final String TITLE = "title";
    private static final String CONTENT = "content";
    private static final String BDTAXR_FORMULA_CONSTANT = "bdtaxr_formula_constant";
    private static final String SETTIING_FORM_ID = "bdtaxr_entity_select";
    private String selectedTabType;
    private static final Map<String, String> operationCharacter = new HashMap<String, String>(){
        {
            this.put("plus", "+");
            this.put("subtract", "-");
            this.put("multiple", "*");
            this.put("divide", "/");
            this.put("equal", "==");
            this.put("less", "<");
            this.put("lessequal", "<=");
            this.put("leftparentheses", "(");
            this.put("greater", ">");
            this.put("greaterequal", ">=");
            this.put("squarebrackets", "<>");
            this.put("rightparentheses", ")");
            this.put("and", "&&");
            this.put("or", "||");
            this.put("clr", "CLR");
            this.put("constant", "constant");
            this.put("if", "if(");
            this.put("comma", ",");
            this.put("qushu", "qushu");
            this.put("param", "param");
            this.put("sum", "sum");
            this.put("cell", "cell");
            this.put("seqno", "seq()");
        }
    };

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnok"});
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String subTabKey = tabSelectEvent.getTabKey();
        if ("tabpageap_formula".equals(subTabKey)) {
            this.selectedTabType = "1";
        } else if ("tabpageap_check".equals(subTabKey)) {
            this.selectedTabType = "2";
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        Map paramMap = e.getFormShowParameter().getCustomParams();
        String selectedCellKey = "";
        if (paramMap != null && paramMap.get("selectCellKey") != null) {
            selectedCellKey = (String)paramMap.get("selectCellKey");
        }
        e.getFormShowParameter().setCaption(String.format(ResManager.loadKDString((String)"%s\u5355\u5143\u683c\u516c\u5f0f\u914d\u7f6e", (String)"FormulaTempPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]), selectedCellKey));
    }

    public void initialize() {
        Button btn = null;
        for (Map.Entry<String, String> entry : operationCharacter.entrySet()) {
            String key = entry.getKey().toString().toLowerCase();
            btn = (Button)this.getControl(key);
            btn.addClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.selectedTabType = "1";
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONObject jsonObject = (JSONObject)customParams.get("calculate");
        JSONObject checkFormulaObj = (JSONObject)customParams.get("validate");
        if (jsonObject != null) {
            FormulaVo formulaVo = (FormulaVo)jsonObject.toJavaObject(FormulaVo.class);
            this.getModel().setValue(KEY_EXPRESSIONTEXT, (Object)formulaVo.getFormula());
            this.getModel().setValue(KEY_EXPRESSIONTEXTNAME, (Object)formulaVo.getFormulaName());
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.startsWith("btnok")) {
            this.setReturnData();
        } else if ("qushu".equals(key) || "check_qushu".equals(key)) {
            this.showQushuForm(this.getView().getFormShowParameter().getCustomParams());
        } else if ("param".equals(key)) {
            this.showRuleListForm(this.getView().getFormShowParameter().getCustomParams());
        } else if ("cell".equals(key)) {
            this.settingClick("cellCallback");
        } else if (null != operationCharacter.get(key)) {
            this.operation(key, KEY_EXPRESSIONTEXT, KEY_EXPRESSIONTEXTNAME);
        }
    }

    private void settingClick(String callbackName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(SETTIING_FORM_ID);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String entityid = (String)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"entityid", String.class);
        String entityName = (String)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"entityname", String.class);
        showParameter.setCustomParam("entityid", (Object)entityid);
        showParameter.setCustomParam("entityname", (Object)entityName);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, callbackName);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void setReturnData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String formulaKey = (String)customParams.get("selectCellKey");
        HashMap<String, FormulaVo> returnData = new HashMap<String, FormulaVo>();
        FormulaVo formulaVo = null;
        String formula = (String)this.getModel().getValue(KEY_EXPRESSIONTEXT);
        if (StringUtils.isNotBlank((CharSequence)formula) || customParams.get("calculate") != null) {
            formulaVo = new FormulaVo();
            formulaVo.setFormulaType("1");
            formulaVo.setFormulaKey(formulaKey);
            String formulaName = (String)this.getModel().getValue(KEY_EXPRESSIONTEXTNAME);
            formulaVo.setFormula(formula);
            formulaVo.setFormulaName(formulaName);
        }
        returnData.put("calculate", formulaVo);
        this.getView().setReturnData((Object)formulaVo);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void showQushuForm(Map<String, Object> customParams) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bdtaxr_rule_set", (boolean)false, (int)0);
        parameter.setStatus(OperationStatus.EDIT);
        if (EmptyCheckUtils.isNotEmpty(customParams)) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(customParams.size());
            qFilterList.add(new QFilter("enable", "=", (Object)"1"));
            parameter.getListFilterParameter().setQFilters(qFilterList);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectQushu");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showRuleListForm(Map<String, Object> customParams) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bdtaxr_datasource_entry", (boolean)false, (int)0);
        parameter.setStatus(OperationStatus.EDIT);
        if (EmptyCheckUtils.isNotEmpty(customParams)) {
            ArrayList qFilterList = new ArrayList(customParams.size());
            parameter.getListFilterParameter().setQFilters(qFilterList);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "callbackRuleList");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void operation(String key, String formulaText, String formulaTextName) {
        String character;
        if ("2".equals(this.selectedTabType)) {
            formulaText = CHECK_PREFIX + formulaText;
            formulaTextName = CHECK_PREFIX + formulaTextName;
        }
        if ((character = operationCharacter.get(key)).equalsIgnoreCase("clr")) {
            this.getModel().setValue(formulaText, (Object)"");
            this.getModel().setValue(formulaTextName, (Object)"");
            FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)formulaText, (int)0);
            FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)formulaTextName, (int)0);
        } else if ("backspace".equalsIgnoreCase(character)) {
            FormulaEditHelper.backSpaceExpression((IFormView)this.getView(), (String)key, (String)formulaText);
            FormulaEditHelper.backSpaceExpression((IFormView)this.getView(), (String)key, (String)formulaTextName);
        } else if ("constant".equalsIgnoreCase(character)) {
            this.showConstantForm();
        } else {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)key, (String)formulaText, (String)character);
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)key, (String)formulaTextName, (String)character);
        }
    }

    private void showConstantForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(BDTAXR_FORMULA_CONSTANT);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectConstant");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map<String, String> value;
        Map returnData;
        if ("selectQushu".equals(event.getActionId())) {
            ListSelectedRow row;
            String id;
            QFilter q1;
            QFilter[] filters;
            DynamicObject d;
            ListSelectedRowCollection list = (ListSelectedRowCollection)event.getReturnData();
            if (list != null && list.size() > 0 && null != (d = QueryServiceHelper.queryOne((String)"bdtaxr_rule_set", (String)"id,name", (QFilter[])(filters = new QFilter[]{q1 = new QFilter("id", "=", (Object)Long.parseLong(id = (row = list.get(0)).getPrimaryKeyValue().toString()))})))) {
                String name = d.get("name").toString();
                this.setFormulaValue(id, name, "qushu");
            }
        } else if ("callbackRuleList".equals(event.getActionId())) {
            ListSelectedRow row;
            String id;
            QFilter q1;
            QFilter[] filters;
            DynamicObject d;
            ListSelectedRowCollection list = (ListSelectedRowCollection)event.getReturnData();
            if (list != null && list.size() > 0 && null != (d = QueryServiceHelper.queryOne((String)"bdtaxr_datasource_entry", (String)"fieldsubname,fieldname,bizsubname", (QFilter[])(filters = new QFilter[]{q1 = new QFilter("id", "=", (Object)Long.parseLong(id = (row = list.get(0)).getPrimaryKeyValue().toString()))})))) {
                String fieldsubname = d.get("fieldsubname").toString();
                String fieldname = d.get("fieldname").toString();
                String bizsubname = d.get("bizsubname").toString();
                this.setFormulaValue(fieldsubname + '#' + fieldname, fieldsubname + '#' + bizsubname, "param");
            }
        } else if ("selectConstant".equals(event.getActionId())) {
            String constantValue = (String)event.getReturnData();
            this.setFormulaValue(constantValue, constantValue, "constant");
        } else if ("cellCallback".equals(event.getActionId()) && (returnData = (Map)event.getReturnData()) != null && (value = this.getValue(returnData)) != null) {
            this.setFormulaValue(value.get("id"), value.get("name"), "cell");
        }
    }

    private Map<String, String> getValue(Map<String, Object> returnData) {
        HashMap<String, String> data = new HashMap<String, String>();
        Boolean rowfill = (Boolean)returnData.get("rowfill");
        Boolean columnfill = (Boolean)returnData.get("columnfill");
        List column = (List)returnData.get("column");
        List row = (List)returnData.get("row");
        String entityid = (String)returnData.get("entityid");
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"entityid", (Object)entityid);
        String entityname = (String)returnData.get("entityname");
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"entityname", (Object)entityname);
        for (Map rowMap : row) {
            String rowValueId = (String)rowMap.get("id");
            if ("ROOT".equals(rowValueId)) continue;
            for (Map colMap : column) {
                String colValueId = (String)rowMap.get("id");
                if ("ROOT".equals(colValueId)) continue;
                String valText = entityname + '#' + (String)colMap.get("text") + '#' + (String)rowMap.get("text");
                if (rowValueId.startsWith(entityid)) {
                    valText = (String)rowMap.get("id") + '#' + (String)colMap.get("id");
                    data.put("id", valText);
                    valText = entityname + "#" + (String)rowMap.get("text") + "#" + (String)colMap.get("text");
                    data.put("name", valText);
                }
                if (StringUtils.isNotBlank((CharSequence)valText)) {
                    return data;
                }
                if (columnfill.booleanValue()) continue;
                break;
            }
            if (rowfill.booleanValue()) continue;
            break;
        }
        return null;
    }

    private void setFormulaValue(String id, String name, String formulaType) {
        String prefix = "";
        String formulaText = KEY_EXPRESSIONTEXT;
        String formulaTextName = KEY_EXPRESSIONTEXTNAME;
        String btnName = formulaType;
        if ("2".equals(this.selectedTabType)) {
            prefix = CHECK_PREFIX;
            btnName = prefix + btnName;
            formulaText = prefix + formulaText;
            formulaTextName = prefix + formulaTextName;
        }
        if ("qushu".equals(formulaType)) {
            this.setValue(R_FORMULA_FORMAT.replace("values", id), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)btnName, (String)formulaText), formulaText);
            this.setValueName(R_FORMULA_FORMAT.replace("values", name), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)btnName, (String)formulaTextName), formulaTextName);
        } else if ("param".equals(formulaType)) {
            this.setValue(P_FORMULA_FORMAT.replace("values", id), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)btnName, (String)formulaText), formulaText);
            this.setValueName(P_FORMULA_FORMAT.replace("values", name), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)btnName, (String)formulaTextName), formulaTextName);
        } else if ("cell".equals(formulaType)) {
            this.setValue(Q_FORMULA_FORMAT.replace("values", id), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)btnName, (String)formulaText), formulaText);
            this.setValueName(Q_FORMULA_FORMAT.replace("values", name), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)btnName, (String)formulaTextName), formulaTextName);
        } else if ("constant".equals(formulaType) && StringUtils.isNotBlank((CharSequence)name)) {
            this.setValue(C_FORMULA_FORMAT.replace("values", id), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)btnName, (String)formulaText), formulaText);
            this.setValueName(C_FORMULA_FORMAT.replace("values", name), FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)btnName, (String)formulaTextName), formulaTextName);
        }
    }

    private void setValue(String values, int index, String key) {
        String currentFormular = (String)this.getModel().getValue(key);
        StringBuilder sb = new StringBuilder();
        sb.append(currentFormular);
        sb.insert(index, values);
        this.getModel().setValue(key, (Object)sb.toString());
        FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)key, (int)(index + values.length()));
    }

    private void setValueName(String values, int index, String key) {
        String currentFormular = (String)this.getModel().getValue(key);
        StringBuilder sb = new StringBuilder();
        sb.append(currentFormular);
        if (StringUtils.isBlank((CharSequence)currentFormular)) {
            index = 0;
        }
        sb.insert(index, values);
        this.getModel().setValue(key, (Object)sb.toString());
        FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)key, (int)(index + values.length()));
    }
}

