/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.formula;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;

public class FormulaTempTipPlugin
extends AbstractFormPlugin {
    private static final String EWBLXH = "ewblxh";
    private static final String ENTITY_SELECT = "entity_select";
    private static final String ROW_TREE = "rowtree";
    private static final String COLUMN_TREE = "columntree";
    private static final String BUTTON_CHANGE = "button_change";
    private static final Set<String> BASE_FIELD_LAST = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("id");
            this.add(FormulaTempTipPlugin.EWBLXH);
            this.add("ewblname");
            this.add("sbbid");
        }
    };

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_CHANGE});
        this.addClickListeners(new String[]{"btn_cancel", "btn_submit", "add", "minu", "miv", "div", "khz", "khs", "wh", "mh", "formulaadd", "buttonap", "buttonap1", "buttonap2", "buttonap3", "buttonap4", "buttonap5", "buttonap6", "buttonap7", "buttonap8", "buttonap9"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"tablecontent", "tableid", "fieldid", "filterjson", "mainid", "ischild", "condition"});
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityid");
        if (entityId != null) {
            this.getModel().setValue(ENTITY_SELECT, (Object)entityId);
        }
        String templateType = (String)this.getView().getFormShowParameter().getCustomParam("templateType");
        Map tableMap = TemplateUtils.queryEntityByTypeId((String)templateType);
        Iterator it = tableMap.entrySet().iterator();
        int index = 0;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(tableMap.size());
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ComboItem item = new ComboItem();
            item.setId((String)entry.getKey());
            item.setValue((String)entry.getKey());
            item.setCaption(new LocaleString((String)entry.getValue()));
            combos.add(item);
            if (index == 0) {
                this.getModel().setValue(ENTITY_SELECT, entry.getKey());
            }
            if (((String)entry.getKey()).equals(entityId)) {
                this.getModel().setValue(ENTITY_SELECT, (Object)entityId);
            }
            ++index;
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(ENTITY_SELECT);
        comboEdit.setComboItems(combos);
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)BUTTON_CHANGE, (Object)Boolean.TRUE);
        this.initTree(Boolean.TRUE);
    }

    public void click(EventObject evt) {
        String templateType;
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BUTTON_CHANGE.equals(key)) {
            this.changeClick();
        }
        if ("btn_submit".equals(key)) {
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("largetextfield", this.getView().getModel().getValue("largetextfield"));
            this.getView().setReturnData(returnData);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else if ("formulaadd".equals(key) && null != (templateType = (String)this.getView().getFormShowParameter().getCustomParam("templateType"))) {
            TreeView rowTreeView = (TreeView)this.getView().getControl(ROW_TREE);
            TreeView columnTreeView = (TreeView)this.getView().getControl(COLUMN_TREE);
            List rowListMap = rowTreeView.getTreeState().getSelectedNodes();
            List columnListMap = columnTreeView.getTreeState().getSelectedNodes();
            if (rowListMap.size() > 0 && columnListMap.size() > 0) {
                String row = (String)((Map)rowListMap.get(0)).get("id");
                String column = (String)((Map)columnListMap.get(0)).get("id");
                String formulatype = (String)this.getView().getFormShowParameter().getCustomParam("formulatype");
                if (null != formulatype && formulatype.equals("2")) {
                    this.setValue("{F[{Q[" + row + "#" + column + "]}]}");
                } else {
                    this.setValue("{{" + row.replace('#', '_') + '_' + column + "}}");
                }
            }
        }
    }

    private void setValue(String values) {
        this.getModel().setValue("largetextfield", (Object)(this.getModel().getValue("largetextfield") + values));
    }

    private void initTree(Boolean showType) {
        TreeView columnTreeView;
        TreeView rowTreeView;
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)BUTTON_CHANGE, (Object)showType);
        String entityId = (String)this.getView().getModel().getValue(ENTITY_SELECT);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
        ComboProp ewblxhProp = (ComboProp)mainPros.get((Object)EWBLXH);
        TreeNode rowRoot = new TreeNode();
        rowRoot.setId("ROOT");
        rowRoot.setText(ResManager.loadKDString((String)"\u6839\u8282\u70b9", (String)"FormulaTempTipPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        rowRoot.setParentid("");
        ArrayList<TreeNode> ewblNodeList = new ArrayList<TreeNode>();
        if (ewblxhProp != null) {
            List listItem = ewblxhProp.getComboItems();
            for (Object item : listItem) {
                TreeNode node = new TreeNode();
                node.setParentid("");
                node.setId(entityId + "#" + item.getValue());
                node.setText(item.getName().getLocaleValue());
                ewblNodeList.add(node);
            }
        }
        rowRoot.addChildren(ewblNodeList);
        ArrayList<TreeNode> childListNode = new ArrayList<TreeNode>();
        TreeNode columnRoot = new TreeNode();
        columnRoot.setId("ROOT");
        columnRoot.setText(ResManager.loadKDString((String)"\u6839\u8282\u70b9", (String)"FormulaTempTipPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        columnRoot.setParentid("");
        for (IDataEntityProperty property : mainPros) {
            if (BASE_FIELD_LAST.contains(property.getName()) || property.getDisplayName() == null) continue;
            TreeNode node = new TreeNode();
            node.setId(property.getName());
            node.setParentid("");
            node.setText(property.getDisplayName().getLocaleValue());
            childListNode.add(node);
        }
        columnRoot.addChildren(childListNode);
        if (showType.booleanValue()) {
            rowTreeView = (TreeView)this.getView().getControl(ROW_TREE);
            rowTreeView.deleteAllNodes();
            rowTreeView.addNode(rowRoot);
            columnTreeView = (TreeView)this.getView().getControl(COLUMN_TREE);
            columnTreeView.deleteAllNodes();
            columnTreeView.addNode(columnRoot);
            TreeUtils.expandAll((TreeView)rowTreeView, (TreeNode)rowRoot);
            TreeUtils.expandAll((TreeView)columnTreeView, (TreeNode)columnRoot);
        } else {
            rowTreeView = (TreeView)this.getView().getControl(COLUMN_TREE);
            rowTreeView.deleteAllNodes();
            rowTreeView.addNode(rowRoot);
            TreeUtils.expandAll((TreeView)rowTreeView, (TreeNode)rowRoot);
            columnTreeView = (TreeView)this.getView().getControl(ROW_TREE);
            columnTreeView.deleteAllNodes();
            columnTreeView.addNode(columnRoot);
            TreeUtils.expandAll((TreeView)columnTreeView, (TreeNode)columnRoot);
        }
    }

    public void changeClick() {
        Boolean showType = (Boolean)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)BUTTON_CHANGE, Boolean.class);
        this.initTree(showType == false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (ENTITY_SELECT.equals(name)) {
            String entityId = (String)this.getView().getModel().getValue(ENTITY_SELECT);
            if (StringUtils.isNotBlank((CharSequence)entityId)) {
                TreeUtils.putCache((IPageCache)this.getPageCache(), (String)BUTTON_CHANGE, (Object)Boolean.TRUE);
                this.initTree(Boolean.TRUE);
                TreeUtils.putCache((IPageCache)this.getPageCache(), (String)ENTITY_SELECT, (Object)entityId);
            }
        } else if ("type".equals(name)) {
            String type = (String)this.getModel().getValue("type");
            if ("{S[values]}".equals(type)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"tablecontent"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap3"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"tablecontent"});
            }
        }
    }
}

