/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.formula.update;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.upload.UploadOption;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.formplugin.formula.update.XmlCto;
import org.codehaus.stax2.ri.evt.AttributeEventImpl;

public class BigDataImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static Log LOGGER = LogFactory.getLog(BigDataImportPlugin.class);
    private static final String BT_TRANS = "bt_trans";

    public void registerListener(EventObject e) {
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"urlsflex"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnupload".equals(control.getKey())) {
            UploadOption opt = new UploadOption();
            opt.setMultiple(true);
            opt.setTitle(ResManager.loadKDString((String)"\u4e0a\u4f20XML\u811a\u672c\u6587\u4ef6", (String)"BigDataImportPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            opt.setSuffix(".xml");
            this.getView().showUpload(opt, "btnupload");
        } else if ("btndel".equals(control.getKey())) {
            IDataModel model = this.getModel();
            int i = model.getEntryCurrentRowIndex("upload_urls");
            String cacheUrls = this.getPageCache().get("_file_list_");
            List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
            String url = (String)model.getValue("url", i);
            filelist.removeIf(f -> f.get("url").equals(url));
            this.getPageCache().put("_file_list_", SerializationUtils.serializeToBase64(filelist));
            model.deleteEntryRow("upload_urls", i);
            if (filelist.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"urlsflex"});
            }
        } else if (BT_TRANS.equals(control.getKey())) {
            String file_list = this.getPageCache().get("_file_list_");
            if (StringUtils.isEmpty((CharSequence)file_list)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0a\u4f20\u6587\u4ef6", (String)"BigDataImportPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            List filelist = (List)SerializationUtils.deSerializeFromBase64((String)file_list);
            if (filelist.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0a\u4f20\u6587\u4ef6", (String)"BigDataImportPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            if (filelist.size() > 3) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0d\u591a\u4e8e3\u4e2a\u6587\u4ef6\u4e0a\u4f20", (String)"BigDataImportPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            FileService service = FileServiceFactory.getAttachmentFileService();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < filelist.size(); ++i) {
                Map fileMap = (Map)filelist.get(i);
                String file_url = (String)fileMap.get("url");
                String fileName = (String)fileMap.get("name");
                stringBuilder.append(String.format("Start import %s", fileName)).append("\r\n");
                if (StringUtils.isBlank((CharSequence)file_url)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6", (String)"BigDataImportPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
                try (InputStream inputStream = service.getInputStream(file_url);){
                    if (this.handleInputStream(inputStream) <= 0) continue;
                    stringBuilder.append(String.format("Import Success %s", fileName)).append("\r\n");
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                    String error = e.getMessage();
                    stringBuilder.append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a", (String)"BigDataImportPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0])).append(error).append("\n\t");
                }
            }
            CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("codeshow_sql");
            codeSQLshow.setText(stringBuilder.toString());
        }
    }

    private int handleInputStream(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        XMLEventReader reader = inputFactory.createXMLEventReader(inputStream);
        ArrayList<XmlCto> xmlctoList = new ArrayList<XmlCto>(4);
        while (reader.hasNext()) {
            StartElement element;
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement() || !(element = event.asStartElement()).getName().getLocalPart().equals("longtextdata")) continue;
            XmlCto xmlcto = this.parseElement("longtextdata", reader, event);
            xmlctoList.add(xmlcto);
        }
        int result = 0;
        for (XmlCto xmlcto : xmlctoList) {
            Map<String, String> attr = xmlcto.getAttr();
            String tablename = attr.get("tablename");
            String colname = attr.get("colname");
            XmlCto pkcols = xmlcto.getSubs().get("pkcols");
            XmlCto dataXMl = xmlcto.getSubs().get("data");
            String data = null;
            if (dataXMl != null) {
                data = dataXMl.getText();
            }
            if (!Objects.equals(tablename, "t_tctb_template") && !Objects.equals(tablename, "t_bdtaxr_template_main") || !StringUtils.isNotEmpty((CharSequence)tablename) || !StringUtils.isNotEmpty((CharSequence)colname) || !StringUtils.isNotEmpty((CharSequence)tablename) || !StringUtils.isNotEmpty((CharSequence)data) || pkcols == null) continue;
            XmlCto pkcol = pkcols.getSubs().get("pkcol");
            Map<String, String> map = pkcol.getAttr();
            String pkName = map.get("name");
            String pkVal = map.get("value");
            if (!StringUtils.isNotEmpty((CharSequence)pkVal) || !StringUtils.isNotEmpty((CharSequence)pkName)) continue;
            String sql = String.format("update %s set %s = ? where %s=?", tablename, colname, pkName);
            Object[] params = new Object[]{data, Long.valueOf(pkVal)};
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>(4);
            arrayList.add(params);
            int[] ints = DBUtils.executeBatch((String)sql, arrayList);
            result = ints[0];
        }
        return result;
    }

    private XmlCto parseElement(String name, XMLEventReader reader, XMLEvent event) throws XMLStreamException {
        XmlCto xmlcto = new XmlCto();
        xmlcto.setName(name);
        boolean exit = false;
        do {
            if (event.isStartElement()) {
                String localPart;
                StartElement selement = event.asStartElement();
                Iterator<Attribute> attributes = selement.getAttributes();
                while (attributes.hasNext()) {
                    XMLEvent next = attributes.next();
                    if (!next.isAttribute()) continue;
                    AttributeEventImpl attributeEvent = (AttributeEventImpl)next;
                    localPart = attributeEvent.getName().getLocalPart();
                    String value = attributeEvent.getValue();
                    xmlcto.getAttr().put(localPart, value);
                }
                String slocalPart = selement.getName().getLocalPart();
                if (Objects.equals(slocalPart, name)) {
                    while (reader.hasNext()) {
                        EndElement element;
                        event = reader.nextEvent();
                        if (event.isStartElement()) {
                            StartElement startElement = event.asStartElement();
                            XmlCto sub = this.parseElement(startElement.getName().toString(), reader, event);
                            xmlcto.getSubs().put(sub.getName(), sub);
                            continue;
                        }
                        if (event.isCharacters()) {
                            xmlcto.setText(event.asCharacters().getData());
                            continue;
                        }
                        if (!event.isEndElement() || !Objects.equals(localPart = (element = event.asEndElement()).getName().getLocalPart(), name)) continue;
                        exit = true;
                        break;
                    }
                }
            }
            if (exit) break;
            event = reader.nextEvent();
        } while (reader.hasNext());
        return xmlcto;
    }

    public void remove(UploadEvent evt) {
        String cacheUrls = this.getPageCache().get("_file_list_");
        List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        for (Object url : evt.getUrls()) {
            filelist.removeIf(f -> f.get("uid").equals(((Map)url).get("uid")));
        }
        this.getPageCache().put("_file_list_", SerializationUtils.serializeToBase64(filelist));
    }

    public void upload(UploadEvent evt) {
        IDataModel model = this.getModel();
        this.getView().setVisible(Boolean.TRUE, new String[]{"urlsflex"});
        String cacheUrls = this.getPageCache().get("_file_list_");
        List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        Object[] urls = evt.getUrls();
        LOGGER.info("\u83b7\u5f97\u4e0a\u4f20\u6587\u4ef6urls\uff1a{}", (Object)Arrays.toString(urls));
        this.getModel().beginInit();
        for (int i = 0; i < urls.length; ++i) {
            if (urls[i] == null) continue;
            String urlStr = (String)((Map)urls[i]).get("url");
            String name = (String)((Map)urls[i]).get("name");
            if (!StringUtils.isNotBlank((CharSequence)urlStr)) continue;
            filelist.add((Map)urls[i]);
            int index = model.createNewEntryRow("upload_urls");
            model.setValue("name", (Object)name, index);
            model.setValue("url", (Object)urlStr, index);
        }
        this.getModel().endInit();
        this.getView().updateView("upload_urls");
        this.getPageCache().put("_file_list_", SerializationUtils.serializeToBase64(filelist));
    }
}

