/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.formula.update;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.JdbcConstants;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.service.taxdeclare.TaxDeclareDataService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxDeclareDataServiceImpl;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.refactor.formula.parse.ParseUtils;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.formula.update.FormulaReplacerProcessor;
import kd.taxc.bdtaxr.formplugin.formula.update.QueryNoSupportVisitor;
import kd.taxc.bdtaxr.formplugin.formula.update.ReplaceSqlUtil;
import kd.taxc.bdtaxr.formplugin.formula.update.TccitNbReplacer;
import kd.taxc.bdtaxr.formplugin.formula.update.TcvatYbnsrDlsbReplacer;
import org.apache.commons.io.input.CharSequenceInputStream;

public class FormulaUpdToNewPlugin
extends AbstractFormPlugin
implements FormulaReplacerProcessor {
    private static final String BTNOK = "btnok";
    private static final String TPO_FORMULA_EDIT = "tpo_formula_edit";
    private static final String TPO_FORMULA_EDIT_OLD = "tpo_formula_temp_edit";
    private static LinkedHashMap<String, FormulaReplacerProcessor> replacerLinkedHashMap = new LinkedHashMap(4);
    private static final String SQL_FORMULA_DEL = "delete from t_bdtaxr_formula  where ftemplatenum = '%s'";
    private static final String SQL_FORMULA_INSERT = "insert into t_bdtaxr_formula(fid,fformulakey,fname,fformula,fformulaname,fdescribe,ftemplateid,ftable,frow,fcolumn,ftaxtype,fformulatype,ftitle,fcontent,fcelltype,ftemplatenum,fupdatetime) \nselect fid,fformulakey,fname,fformula,fformulaname,fdescribe,ftemplateid,ftable,frow,fcolumn,ftaxtype,fformulatype,ftitle,fcontent,fcelltype,ftemplatenum,fupdatetime from t_tctb_formula  where ftemplatenum = '%s'";
    private static TaxDeclareDataService taxDeclareDataService;

    public void registerListener(EventObject e) {
    }

    private void testRunTemplateDeclaretion() {
        long l = System.currentTimeMillis();
        String taxtype = (String)this.getModel().getValue("taxtype");
        Long orgid = (Long)this.getModel().getValue("org_id");
        Date skssqq = (Date)this.getModel().getValue("skssqq");
        Date skssqz = (Date)this.getModel().getValue("skssqz");
        String skssqqStr = DateUtils.format((Date)skssqq);
        String skssqzStr = DateUtils.format((Date)skssqz);
        String format = String.format("{\"id\":1424628610286864385,\"skssqq\":\"%s\",\"skssqz\":\"%s\",\"orgId\":%s,\"templateType\":\"%s\",\"businessMap\":{},\"operation\":\"edit\",\"refresh\":true}", skssqqStr, skssqzStr, orgid, taxtype);
        DeclareRequestModel requestModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)format, DeclareRequestModel.class);
        DeclareResponseModel responseModel = taxDeclareDataService.refreshData(requestModel, null);
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("codeshow_sql");
        codeSQLshow.setText("cost time:" + (System.currentTimeMillis() - l) + "ms--" + SerializationUtils.toJsonString((Object)responseModel));
    }

    private void findNoSupport(String templatenum) {
        block18: {
            QFilter qFilter = new QFilter("templatenum", "=", (Object)templatenum);
            QFilter qFilter1 = new QFilter("formula", "like", (Object)"%{M[%");
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)TPO_FORMULA_EDIT, (String)"id,taxtype,templatenum,formulatype,formulakey,name,table,row,column,celltype,title,content,describe,templateid,updatetime,formulaname,formula", (QFilter[])new QFilter[]{qFilter, qFilter1});
            ArrayList<QueryNoSupportVisitor> msgs = new ArrayList<QueryNoSupportVisitor>();
            for (DynamicObject dynamicObject : dynamicObjects) {
                String formulakey = dynamicObject.getString("formulakey");
                String formula = dynamicObject.getString("formula");
                try {
                    QueryNoSupportVisitor visitor = this.queryNoSupportFormula(formula, formulakey);
                    if (visitor == null) continue;
                    msgs.add(visitor);
                }
                catch (Exception e) {
                    msgs.add(new QueryNoSupportVisitor(formulakey, e.getMessage()));
                }
            }
            if (msgs.size() > 0) {
                StringBuilder sb = new StringBuilder();
                msgs.sort(Comparator.comparing(QueryNoSupportVisitor::getNoSupportMsg));
                msgs.stream().forEach(a -> sb.append(a.toString()).append("\n"));
                sb.append("--------------------------------------------------------------").append("\n");
                msgs.stream().forEach(a -> sb.append("'").append(a.getFormulaKey()).append("'").append(","));
                try (CharSequenceInputStream in = new CharSequenceInputStream((CharSequence)sb.toString(), "UTF-8");){
                    String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(UUID.randomUUID() + "tst.txt", (InputStream)in, 5000);
                    this.getView().openUrl(urls);
                    break block18;
                }
                catch (IOException e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
                }
            }
            CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("codeshow_sql");
            codeSQLshow.setText("no result");
        }
    }

    private void updateFormulaByTempNum(String[] split) {
        StringBuilder msg = new StringBuilder();
        for (String s : split) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    String update = this.update(s);
                    if (!StringUtil.isNotEmpty((CharSequence)update)) continue;
                    msg.append(update).append("\r\n");
                }
                catch (Throwable t) {
                    h.markRollback();
                    msg.append(String.format("Updated '%s' error !", s)).append("\r\n").append(t.getMessage()).append("\r\n");
                }
            }
        }
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("codeshow_sql");
        codeSQLshow.setText(msg.toString());
    }

    private void testOne() {
        String replace;
        String newFormula = (String)this.getModel().getValue("formula_tag");
        try {
            replace = this.replace(newFormula, "1", "");
        }
        catch (Exception e) {
            replace = StringUtil.getStackTraceMessage((Throwable)e);
        }
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("codeshow_sql");
        codeSQLshow.setText(replace);
    }

    private String update(String templatenum) {
        DynamicObject[] dynamicObjects;
        QFilter qFilter = new QFilter("templatenum", "=", (Object)templatenum);
        boolean exists = QueryServiceHelper.exists((String)TPO_FORMULA_EDIT_OLD, (QFilter[])qFilter.toArray());
        if (!exists) {
            return String.format("Template '%s' is not exist!", templatenum);
        }
        String formulaDel = String.format(SQL_FORMULA_DEL, templatenum);
        boolean execute = DBUtils.execute((String)formulaDel);
        String formulaInsert = String.format(SQL_FORMULA_INSERT, templatenum);
        execute = DBUtils.execute((String)formulaInsert);
        if (!execute) {
            return String.format("Updated '%s' error cause insert formula!", templatenum);
        }
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)TPO_FORMULA_EDIT, (String)"id,taxtype,templatenum,formulatype,formulakey,name,table,row,column,celltype,title,content,describe,templateid,updatetime,formulaname,formula", (QFilter[])new QFilter[]{qFilter})) {
            String formula = dynamicObject.getString("formula");
            if (StringUtil.isEmpty((CharSequence)formula)) continue;
            String formulatype = dynamicObject.getString("formulatype");
            String formulakey = dynamicObject.getString("formulakey");
            String taxtype = dynamicObject.getString("taxtype.id");
            String newFormula = this.replace(formula, formulatype, taxtype);
            dynamicObject.set("formula", (Object)newFormula);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        return String.format("Updated '%s' SUCCESS!", templatenum);
    }

    @Override
    public String replace(String formula, String formulatype, String taxtype) {
        String temp;
        String reduced;
        if (StringUtil.isEmpty((CharSequence)formula)) {
            return formula;
        }
        String s = formula;
        FormulaReplacerProcessor formulaReplacer = replacerLinkedHashMap.get(taxtype);
        if (formulaReplacer != null) {
            s = formulaReplacer.beforeReplace(s, formulatype, taxtype);
            s = formulaReplacer.replace(s, formulatype, taxtype);
        }
        if ((reduced = formula.replace(" ", "")).contains("}=")) {
            for (int i = 0; i < 10; ++i) {
                String target = "]}=" + i;
                String target1 = "]} = " + i;
                String target2 = "]} =" + i;
                String target3 = "]}= " + i;
                String replacement = "]}==" + i;
                s = s.replace(target, replacement).replace(target1, replacement).replace(target2, replacement).replace(target3, replacement);
            }
            s = s.replace("}={", "} == {").replace("} = (", "} == (").replace("} = {", "}=={").replace("]}=if({", "]} == if({").replace("]} = if({", "]} == if({");
            s = s.replace("}=true", "} == true").replace("}=false", "} == false");
        }
        if ("2".equals(formulatype) && reduced.contains(")=")) {
            s = s.replace(")=0", ") == 0").replace(") = 0", ") == 0");
        }
        if (formula.contains("#if") && formula.contains("#else") && formula.contains("#end")) {
            s = s.replace("#if", "if").replace("#else", ",").replace(" #end", " )");
        }
        if ((temp = s.replace(" ", "")).contains("if(")) {
            if (temp.contains(",,")) {
                s = s.replace(",,", ", '',").replace(", ,", ", '',").replace(",  ,", ", '',");
            }
            if (temp.contains(",)")) {
                s = s.replace(",)", ",'')").replace(", )", ",'')").replace(",  )", ",'')");
            }
        }
        if (("1".equals(formulatype) || "4".equals(formulatype) || "2".equals(formulatype)) && (formula.contains("{P[") || formula.contains("{C[") || formula.contains("{S["))) {
            try {
                s = this.updateFormula(s);
            }
            catch (Exception e) {
                String stackTraceMessage = StringUtil.getStackTraceMessage((Throwable)e);
                String format = String.format("%s formula: %s \n", e.getMessage(), formula);
                throw new KDBizException(format + stackTraceMessage);
            }
            if (temp.contains("*")) {
                s = s.replace("count(*)", "count(id)");
            }
        }
        if (formulaReplacer != null) {
            s = formulaReplacer.afterReplace(s, formulatype, taxtype);
        }
        return s;
    }

    private String updateFormula(String formula) {
        String newformula = formula;
        List list = ParseUtils.parseformula((String)newformula);
        for (String formulaStr : list) {
            Map map = ParseUtils.parseFormulaZKH((String)formulaStr);
            String type = ParseUtils.getType((Map)map);
            String value = ParseUtils.getValue((Map)map) == null ? "" : ParseUtils.getValue((Map)map).trim();
            switch (type) {
                case "P": {
                    newformula = newformula.replace(formulaStr, String.format("{A[%s]}", value));
                    break;
                }
                case "C": {
                    if (value.startsWith("#")) {
                        value = value.substring(1);
                    }
                    newformula = newformula.replace(formulaStr, String.format("{P[%s]}", value));
                    break;
                }
                case "S": {
                    String replace = ReplaceSqlUtil.replaceSql(value);
                    System.out.println(String.format("S\u516c\u5f0f\u66ff\u6362M\u516c\u5f0f\uff0cS\u516c\u5f0f\uff1a{S[%s]}\uff0cM\u516c\u5f0f\uff1a{M[%s]} \n", value, replace));
                    newformula = newformula.replace(formulaStr, String.format("{M[%s]}", replace));
                }
            }
        }
        return newformula;
    }

    private QueryNoSupportVisitor queryNoSupportFormula(String formula, String formulaKey) {
        List list = ParseUtils.parseformula((String)formula);
        for (String formulaStr : list) {
            Map map = ParseUtils.parseFormulaZKH((String)formulaStr);
            String type = ParseUtils.getType((Map)map);
            String value = ParseUtils.getValue((Map)map) == null ? "" : ParseUtils.getValue((Map)map).trim();
            switch (type) {
                case "M": {
                    SQLStatementParser mysql = SQLParserUtils.createSQLStatementParser((String)value, (DbType)JdbcConstants.MYSQL);
                    SQLStatement sqlStatement = mysql.parseSelect();
                    QueryNoSupportVisitor supportVisitor = new QueryNoSupportVisitor(formulaKey);
                    sqlStatement.accept((SQLASTVisitor)supportVisitor);
                    if (supportVisitor.isSupport()) break;
                    return supportVisitor;
                }
            }
        }
        return null;
    }

    static {
        replacerLinkedHashMap.put("zzsybnsr", new TcvatYbnsrDlsbReplacer());
        replacerLinkedHashMap.put("zzsybnsr_ybhz", new TcvatYbnsrDlsbReplacer());
        replacerLinkedHashMap.put("qysdsnb", new TccitNbReplacer());
        taxDeclareDataService = new TaxDeclareDataServiceImpl();
    }
}

