/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.formula.update.twotothree;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.business.template.update.UpdateToThreeService;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class EkTemplateDataUpdFormPlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";
    private static final String BTNOK_1 = "btnok1";
    private static final String METAIDS = "metaids";
    private static final String TEMPLATENUM = "templatenum";
    private static final String FORMULAKEYS = "formulakeys";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
        this.addClickListeners(new String[]{BTNOK_1});
    }

    public void click(EventObject evt) {
        Button source = (Button)evt.getSource();
        UpdateToThreeService updateToThreeService = new UpdateToThreeService();
        updateToThreeService.setPreset(Boolean.FALSE);
        if (BTNOK_1.equals(source.getKey())) {
            String metaids = (String)this.getModel().getValue(METAIDS);
            if (StringUtil.isEmpty((CharSequence)metaids)) {
                this.getView().showErrorNotification("Please enter the metadata keys");
                return;
            }
            Set<String> metadataSet = Arrays.stream(metaids.split(",")).collect(Collectors.toSet());
            updateToThreeService.updateRowColByMeta(metadataSet);
            CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("codeshow_sql1");
            codeSQLshow.setText(String.join((CharSequence)"\n", updateToThreeService.getRunLogs()));
        }
        if (BTNOK.equals(source.getKey())) {
            String templatenum = (String)this.getModel().getValue(TEMPLATENUM);
            String formulakeys = (String)this.getModel().getValue(FORMULAKEYS);
            if (StringUtil.isEmpty((CharSequence)templatenum) || StringUtil.isEmpty((CharSequence)formulakeys)) {
                this.getView().showErrorNotification("Please enter the template numbers and formula keys");
                return;
            }
            Set<String> formulaKeySet = Arrays.stream(formulakeys.split(",")).collect(Collectors.toSet());
            updateToThreeService.updateFormulaByTempKey(templatenum, formulaKeySet);
            CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("codeshow_sql");
            codeSQLshow.setText(String.join((CharSequence)"\n", updateToThreeService.getRunLogs()));
        }
    }
}

