/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.formula.update.twotothree;

import java.util.EventObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.business.template.update.UpdateToThreeService;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class ToThreeUpdFormPlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";
    private static final String UPDROWCOL = "updrowcol";
    private static final String UPDTEMP = "updtemp";
    private static final String UPDFORMULA = "updformula";
    private static final String GOBACKUP = "gobackup";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
        this.addClickListeners(new String[]{UPDROWCOL});
        this.addClickListeners(new String[]{UPDTEMP});
        this.addClickListeners(new String[]{UPDFORMULA});
        this.addClickListeners(new String[]{GOBACKUP});
    }

    public void click(EventObject evt) {
        Button source = (Button)evt.getSource();
        if (GOBACKUP.equals(source.getKey())) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("tpo_declare_data_export");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(param);
        } else {
            String templatenum = (String)this.getModel().getValue("templatenum");
            if (StringUtil.isEmpty((CharSequence)templatenum)) {
                this.getView().showErrorNotification("Please enter the Template Number");
                return;
            }
            UpdateToThreeService updateToThreeService = new UpdateToThreeService();
            if (BTNOK.equals(source.getKey())) {
                updateToThreeService.clearData(templatenum);
            } else {
                updateToThreeService.update(templatenum, source.getKey());
            }
            CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("codeshow_sql");
            codeSQLshow.setText(String.join((CharSequence)"\n", updateToThreeService.getRunLogs()));
        }
    }
}

