/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.init.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineBusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.orgmapping.TaxcOrgMappingDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcparamapply.TaxcParamApplyDataServiceHelper;

public class BaseInitConfigSubmitHelper {
    private static final Map<String, String> OPERATION_SOURCE = new HashMap<String, String>();
    public static final String SUBMIT = "submit";
    public static final String UNSUBMIT = "unsubmit";
    public static final String AUDIT = "audit";

    public void batchOperateSubBillsByOrgs(List<Long> selectedOrgIds, String operate) {
        this.operateTaxMain(this.queryTaxMainIdsByOrg(selectedOrgIds), operate);
        this.operateOrgMapping(this.queryOrgMappingIdsByOrg(selectedOrgIds), operate);
        this.operateParamApply(this.queryApplyFormIdsByOrg(selectedOrgIds), operate);
    }

    public void batchUnSubmitSubBillsByOrgs(List<Long> selectedOrgIds) {
        this.unSubmitTaxMain(this.queryTaxMainIdsByOrg(selectedOrgIds));
        this.unSubmitOrgMapping(this.queryOrgMappingIdsByOrg(selectedOrgIds));
        this.unSubmitParamApply(this.queryApplyFormIdsByOrg(selectedOrgIds));
    }

    public void batchAuditSubBillsByOrgs(List<Long> selectedOrgIds) {
        this.auditTaxMain(this.queryTaxMainIdsByOrg(selectedOrgIds));
        this.auditOrgMapping(this.queryOrgMappingIdsByOrg(selectedOrgIds));
        this.auditParamApply(this.queryApplyFormIdsByOrg(selectedOrgIds));
    }

    public TaxResult<OperationResult> submitTaxMain(List<Long> ids) {
        return this.operateTaxMain(ids, SUBMIT);
    }

    public TaxResult<OperationResult> unSubmitTaxMain(List<Long> ids) {
        return this.operateTaxMain(ids, UNSUBMIT);
    }

    public TaxResult<OperationResult> auditTaxMain(List<Long> ids) {
        return this.operateTaxMain(ids, AUDIT);
    }

    public TaxResult<OperationResult> submitOrgMapping(List<Long> ids) {
        return this.operateOrgMapping(ids, SUBMIT);
    }

    public TaxResult<OperationResult> unSubmitOrgMapping(List<Long> ids) {
        return this.operateOrgMapping(ids, UNSUBMIT);
    }

    public TaxResult<OperationResult> auditOrgMapping(List<Long> ids) {
        return this.operateOrgMapping(ids, AUDIT);
    }

    public TaxResult<OperationResult> submitParamApply(List<Long> ids) {
        return this.operateParamApply(ids, SUBMIT);
    }

    public TaxResult<OperationResult> unSubmitParamApply(List<Long> ids) {
        return this.operateParamApply(ids, UNSUBMIT);
    }

    public TaxResult<OperationResult> auditParamApply(List<Long> ids) {
        return this.operateParamApply(ids, AUDIT);
    }

    private TaxResult<OperationResult> operateTaxMain(List<Long> ids, String operation) {
        return TaxcCombineBusinessDataServiceHelper.taxMainOperation(ids, (String)operation, OPERATION_SOURCE);
    }

    private TaxResult<OperationResult> operateOrgMapping(List<Long> ids, String operation) {
        return TaxcCombineBusinessDataServiceHelper.taxOrgMappingOperation(ids, (String)operation, OPERATION_SOURCE);
    }

    private TaxResult<OperationResult> operateParamApply(List<Long> ids, String operation) {
        return TaxcCombineBusinessDataServiceHelper.taxcParamApplyOperation(ids, (String)operation, OPERATION_SOURCE);
    }

    public List<Long> queryTaxMainIdsByOrg(List<Long> selectedOrgIds) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsWithNoStatus(selectedOrgIds, null);
        return this.getIdsByTaxResult((TaxResult<List<DynamicObject>>)result);
    }

    public List<Long> queryOrgMappingIdsByOrg(List<Long> selectedOrgIds) {
        TaxResult result = TaxcOrgMappingDataServiceHelper.getOrgMappingByOrgIds(selectedOrgIds);
        return this.getIdsByTaxResult((TaxResult<List<DynamicObject>>)result);
    }

    public List<Long> queryApplyFormIdsByOrg(List<Long> selectedOrgIds) {
        TaxResult result = TaxcParamApplyDataServiceHelper.getTaxcParamApplyByOrgIds(selectedOrgIds);
        return this.getIdsByTaxResult((TaxResult<List<DynamicObject>>)result);
    }

    private List<Long> getIdsByTaxResult(TaxResult<List<DynamicObject>> result) {
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return new ArrayList<Long>();
        }
        return ((List)result.getData()).stream().map(d -> d.getLong("id")).collect(Collectors.toList());
    }

    static {
        OPERATION_SOURCE.put("sourceType", "tam");
    }
}

