/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.monitor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BussinessDataCheckSettingPlugin
extends AbstractListPlugin {
    private static final String FILTER_ENTITY = "bdtaxr_billtax_filter";
    private static final String BILL_CONFIG_ENTITY = "bdtaxr_bill_configs";
    private static final String NUMBER = "billfieldnumber";
    private static final String BILL_ENTITY = "billentity";
    private static final String ID = "id";
    private static final String ACTION_ID = "filter_setting";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"condition"});
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof TextEdit && ((TextEdit)evt.getSource()).getKey().equals("condition")) {
            Object callbill = this.getModel().getValue("checkdata");
            Object conditionjson = this.getModel().getValue("conditionjson");
            if (ObjectUtils.isEmpty((Object)callbill)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8c03\u7528\u5355\u636e", (String)"BussinessDataCheckSettingPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            String entityNumber = ((DynamicObject)callbill).getString(ID);
            this.openCallSettingPage(entityNumber, conditionjson, ACTION_ID);
        }
    }

    private void openCallSettingPage(String entityNumber, Object conditionjson, String actionId) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId(FILTER_ENTITY);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCaption(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u914d\u7f6e", (String)"BussinessDataCheckSettingPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        formshowParameter.setCustomParam("filterColunms", this.getFilterColunms(entityNumber));
        formshowParameter.setCustomParam("billNumber", (Object)entityNumber);
        formshowParameter.setCustomParam("callconditionjson", conditionjson);
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    private List<String> getFilterColunms(String entityNumber) {
        List<String> list = new ArrayList<String>(10);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)BILL_CONFIG_ENTITY, (String)NUMBER, (QFilter[])new QFilter[]{new QFilter(BILL_ENTITY, "=", (Object)entityNumber)});
        if (!ObjectUtils.isEmpty((Object)dynamicObject)) {
            String billfieldnumber = dynamicObject.getString(NUMBER);
            list = Stream.of(billfieldnumber.split(",")).collect(Collectors.toList());
        }
        return list;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map filterData;
        super.closedCallBack(evt);
        String key = evt.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)ACTION_ID) && (filterData = (Map)evt.getReturnData()) != null) {
            this.getModel().setValue("condition", filterData.get("callcondition"));
            this.getModel().setValue("conditionjson", filterData.get("callconditionjson"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        if ("checkdata".equals(eventName)) {
            this.getModel().setValue("condition", null);
            this.getModel().setValue("conditionjson", null);
        }
    }
}

