/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.monitor.timertask;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.tax.utils.FilterUtils;
import kd.taxc.bdtaxr.common.sms.MessageCenterService;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class BussinessDataCheckService {
    private Log logger = LogFactory.getLog(BussinessDataCheckService.class);
    private static final String YYYYMMDD = "yyyyMMdd";
    private static final String FORMAT = "JC-%s-%05d";
    private static final String START = "start";
    private static final String END = "end";
    private static final String COUNT = "count";
    private static final String RANGE = "range";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String NUMBER = "itemnumber";
    private static final String NAME = "itemname";
    private static final String OPERATION = "operation";
    private static final String ITEMCREATEDATE = "itemcreatedate";
    private static final String ITEMMODIFYDATE = "itemmodifydate";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dataCheck(DynamicObject dyo, Date now, List<DynamicObject> result, boolean isTimerTask, Date startDate, Date endDate) {
        String email = dyo.getString("receiver.email");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String operation = null;
        try {
            int period = dyo.getInt("period");
            operation = dyo.getString(OPERATION);
            if (isTimerTask) {
                if (null == operation || operation.length() == 0 || !this.isCheckTime(now, DateUtils.trunc((Date)dyo.getDate("createtime")), period)) return;
                this.buildTimeFilter(operation, now, period, filters);
            } else {
                this.buildTimeFilter(operation, startDate, endDate, filters);
            }
        }
        catch (Exception e) {
            result.add(this.buildTarget(dyo, null, now, isTimerTask, startDate, endDate, operation));
            this.logger.info("build time filter for " + dyo.getString("number") + "faild:" + e);
            return;
        }
        String filterJson = dyo.getString("conditionjson");
        if (null != filterJson && filterJson.length() != 0) {
            filters.add(FilterUtils.buildFilter((String)filterJson, (boolean)false));
        }
        try {
            DynamicObjectCollection colls = QueryServiceHelper.query((String)dyo.getDynamicObject("checkdata").getString("number"), (String)"name,number,createtime,modifytime", (QFilter[])filters.toArray(new QFilter[0]));
            if (null == colls || colls.size() == 0) return;
            result.add(this.buildTarget(dyo, colls, now, isTimerTask, startDate, endDate, operation));
            this.sendMsgToReceiver(result, email);
            return;
        }
        catch (Exception e) {
            result.add(this.buildTarget(dyo, null, now, isTimerTask, startDate, endDate, operation));
            this.logger.info("query data from " + dyo.getString("number") + "faild:" + e);
        }
    }

    private void sendMsgToReceiver(List<DynamicObject> result, String email) {
        ArrayList<String> messageList = new ArrayList<String>(32);
        StringBuilder info = new StringBuilder();
        info.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u8d44\u6599\u53d8\u66f4\u68c0\u67e5\u63d0\u9192\n", (String)"BussinessDataCheckService_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        result.stream().forEach(o -> {
            StringBuilder rowInfo = new StringBuilder();
            rowInfo.append(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u7f16\u53f7\uff1a%1$s \u68c0\u67e5\u8d44\u6599\uff1a%2$s \u68c0\u67e5\u65f6\u95f4\u8303\u56f4\uff1a%3$s ~%4$s \u53d8\u66f4\u6570\u636e\u91cf\uff1a%5$s \u5f71\u54cd\u8303\u56f4\uff1a%6$s \u8bf7\u53ca\u65f6\u5904\u7406\u3002\n", (String)"BussinessDataCheckService_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), o.getString("number"), o.getString("checkdata"), DateUtils.format((Date)o.getDate(START)), DateUtils.format((Date)o.getDate(END)), o.getString(COUNT), o.getString(RANGE)));
            rowInfo.append(ResManager.loadKDString((String)"\u53d8\u66f4\u5185\u5bb9\n", (String)"BussinessDataCheckService_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            DynamicObjectCollection collection = o.getDynamicObjectCollection(ENTRY_ENTITY);
            collection.stream().forEach(subObject -> {
                String operation = StringUtil.equalsIgnoreCase((CharSequence)subObject.getString(OPERATION), (CharSequence)",add,edit,") ? ResManager.loadKDString((String)"\u65b0\u589e \u4fee\u6539", (String)"BussinessDataCheckService_3", (String)"taxc-bdtaxr", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fee\u6539", (String)"BussinessDataCheckService_4", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                rowInfo.append(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\uff1a%1$s \u540d\u79f0\uff1a%2$s \u53d8\u66f4\u7c7b\u578b\uff1a%3$s \u521b\u5efa\u65f6\u95f4\uff1a%4$s \u4fee\u6539\u65f6\u95f4\uff1a%5$s \n", (String)"BussinessDataCheckService_5", (String)"taxc-bdtaxr", (Object[])new Object[0]), subObject.getString(NUMBER), subObject.getString(NAME), operation, subObject.getString(ITEMCREATEDATE), subObject.getString(ITEMMODIFYDATE)));
            });
            info.append((CharSequence)rowInfo);
        });
        messageList.add(info.toString());
        MessageCenterService service = new MessageCenterService(messageList, email);
        ThreadPoolsUtils.execute((RequestContext)RequestContext.getOrCreate(), (Runnable)service);
    }

    private void buildTimeFilter(String operation, Date startDate, Date endDate, List<QFilter> filters) {
        QFilter createTimeFilter = null;
        if (operation.contains("add")) {
            createTimeFilter = new QFilter("createtime", ">=", (Object)startDate);
            createTimeFilter.and(new QFilter("createtime", "<=", (Object)DateUtils.getDayLast((Date)endDate)));
        }
        QFilter modifyTimeFilter = null;
        if (operation.contains("edit")) {
            modifyTimeFilter = new QFilter("modifytime", ">=", (Object)startDate);
            modifyTimeFilter.and(new QFilter("modifytime", "<=", (Object)DateUtils.getDayLast((Date)endDate)));
        }
        if (null != createTimeFilter && null != modifyTimeFilter) {
            createTimeFilter.or(modifyTimeFilter);
            filters.add(createTimeFilter);
        } else if (null != createTimeFilter) {
            filters.add(createTimeFilter);
        } else if (null != modifyTimeFilter) {
            filters.add(modifyTimeFilter);
        }
    }

    private void buildTimeFilter(String operation, Date now, int period, List<QFilter> filters) {
        QFilter createTimeFilter = null;
        if (operation.contains("add")) {
            createTimeFilter = new QFilter("createtime", ">=", (Object)DateUtils.addDay((Date)now, (int)(-period)));
            createTimeFilter.and(new QFilter("createtime", "<", (Object)now));
        }
        QFilter modifyTimeFilter = null;
        if (operation.contains("edit")) {
            modifyTimeFilter = new QFilter("modifytime", ">=", (Object)DateUtils.addDay((Date)now, (int)(-period)));
            modifyTimeFilter.and(new QFilter("modifytime", "<", (Object)now));
        }
        if (null != createTimeFilter && null != modifyTimeFilter) {
            createTimeFilter.or(modifyTimeFilter);
            filters.add(createTimeFilter);
        } else if (null != createTimeFilter) {
            filters.add(createTimeFilter);
        } else if (null != modifyTimeFilter) {
            filters.add(modifyTimeFilter);
        }
    }

    private boolean isCheckTime(Date now, Date createTime, int period) {
        return now.after(createTime) && TimeUnit.DAYS.convert(now.getTime() - createTime.getTime(), TimeUnit.MILLISECONDS) % (long)period == 0L;
    }

    private DynamicObject buildTarget(DynamicObject checkSet, DynamicObjectCollection colls, Date now, boolean isTimerTask, Date startDate, Date endDate, String operation) {
        DynamicObject target = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_datachange_check");
        DynamicObject maxObject = QueryServiceHelper.queryOne((String)"bdtaxr_datachange_check", (String)"max(number) as maxnumber", (QFilter[])new QFilter[]{new QFilter("number", "like", (Object)("%" + DateUtils.format((Date)now, (String)YYYYMMDD) + "%"))});
        if (null != maxObject && null != maxObject.getString("maxnumber")) {
            target.set("number", (Object)String.format(FORMAT, DateUtils.format((Date)now, (String)YYYYMMDD), Integer.parseInt(maxObject.getString("maxnumber").split("-")[2]) + 1));
        } else {
            target.set("number", (Object)String.format(FORMAT, DateUtils.format((Date)now, (String)YYYYMMDD), 1));
        }
        target.set("checkdata", (Object)checkSet.getDynamicObject("checkdata").getString("name"));
        target.set(START, (Object)DateUtils.addDay((Date)now, (int)(-checkSet.getInt("period"))));
        now = DateUtils.addDay((Date)now, (int)-1);
        target.set(END, (Object)now);
        if (!isTimerTask) {
            target.set(START, (Object)startDate);
            target.set(END, (Object)endDate);
        }
        target.set(COUNT, (Object)(null == colls ? 0 : colls.size()));
        target.set(RANGE, (Object)checkSet.getString(RANGE));
        target.set("processstatus", (Object)"todo");
        this.buildEntry(colls, target, operation);
        return target;
    }

    private void buildEntry(DynamicObjectCollection colls, DynamicObject target, String operation) {
        if (null != colls) {
            DynamicObjectCollection dynamicObjectCollection = target.getDynamicObjectCollection(ENTRY_ENTITY);
            for (DynamicObject coll : colls) {
                String name = coll.getString("name");
                String number = coll.getString("number");
                if (StringUtil.isEmpty((CharSequence)name) && StringUtil.isEmpty((CharSequence)number)) continue;
                DynamicObject object = dynamicObjectCollection.addNew();
                object.set(NUMBER, (Object)coll.getString("number"));
                object.set(NAME, (Object)coll.getString("name"));
                Date createTime = coll.getDate("createtime");
                Date modifyTime = coll.getDate("modifytime");
                object.set(ITEMCREATEDATE, (Object)createTime);
                object.set(ITEMMODIFYDATE, (Object)modifyTime);
                if (modifyTime.after(createTime) && org.apache.commons.lang.time.DateUtils.isSameDay((Date)createTime, (Date)modifyTime)) {
                    object.set(OPERATION, (Object)",add,edit,");
                    continue;
                }
                object.set(OPERATION, (Object)",edit,");
            }
        }
    }
}

