/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.questionnaire;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;

public class OptionItemSetFormPlugin
extends AbstractFormPlugin {
    protected static final String SETENTRY = "setentry";
    protected static final String SETENTRY_SEQ = "seq";
    protected static final String SETENTRY_OPTION = "setentry_option";
    protected static final String SETENTRY_STANDARDSCORE = "setentry_standardscore";
    protected static final String APPLYNULLOTHER = "applynullother";
    protected static final String BTNOK = "btnok";
    protected static final String OP_CONFIRM = "confirm";
    public static final String BDTAXR_QUESTIONNAIRE_SET = "bdtaxr_questionnaire_set";

    public void beforeBindData(EventObject e) {
        this.beforeBindData_updateData();
        super.beforeBindData(e);
    }

    public void registerListener(EventObject e) {
        Button btnok = (Button)this.getView().getControl(BTNOK);
        btnok.addClickListener((ClickListener)this);
        super.registerListener(e);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)BTNOK)) {
            this.beforeClick_btnok(evt);
        }
    }

    protected void beforeClick_btnok(BeforeClickEvent evt) {
        DynamicObjectCollection setEntry = this.getModel().getEntryEntity(SETENTRY);
        Integer standardScore = (Integer)this.getView().getFormShowParameter().getCustomParam("standardscore");
        if (setEntry == null || standardScore == null) {
            return;
        }
        String option = null;
        HashSet<String> optionSet = new HashSet<String>(setEntry.size());
        String message = null;
        int rowStandardScore = 0;
        for (DynamicObject setEntryRow : setEntry) {
            option = setEntryRow.getString(SETENTRY_OPTION);
            if (!optionSet.add(option)) {
                message = ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u9009\u9879\u540d\u79f0\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OptionItemSetFormPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                break;
            }
            rowStandardScore = setEntryRow.getInt(SETENTRY_STANDARDSCORE);
            if (rowStandardScore <= standardScore) continue;
            message = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u51fa\u6807\u51c6\u5206\u503c\uff08%s\u5206\uff09\u7684\u9009\u9879\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"OptionItemSetFormPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), standardScore);
            break;
        }
        if (message != null) {
            evt.setCancel(true);
            this.getView().showTipNotification(message);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)OP_CONFIRM, (CharSequence)operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.afterConfirmOperation(afterDoOperationEventArgs);
        }
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    protected void afterConfirmOperation(AfterDoOperationEventArgs evt) {
        if (this.checkParentDataIsQuestionnaire()) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection setEntry = dataEntity.getDynamicObjectCollection(SETENTRY);
            Integer rowindex = (Integer)this.getView().getFormShowParameter().getCustomParam("rowindex");
            IFormView parentView = this.getView().getParentView();
            DynamicObject parentDataEntity = parentView.getModel().getDataEntity(true);
            DynamicObjectCollection parentSetEntry = parentDataEntity.getDynamicObjectCollection(SETENTRY);
            boolean applyNullOther = dataEntity.getBoolean(APPLYNULLOTHER);
            if (applyNullOther) {
                for (int i = 0; i < parentSetEntry.size(); ++i) {
                    DynamicObject parentSetEntryRow = (DynamicObject)parentSetEntry.get(i);
                    if (!StringUtils.equals((CharSequence)"choice", (CharSequence)parentSetEntryRow.getString("setentry_problemtype")) || parentSetEntryRow.getDynamicObjectCollection("subentry").size() != 0 || i == rowindex) continue;
                    this.addSubEntryRow(setEntry, parentSetEntryRow, parentView, i, Boolean.TRUE);
                }
                this.addSubEntryRow(setEntry, (DynamicObject)parentSetEntry.get(rowindex.intValue()), parentView, rowindex, Boolean.FALSE);
            } else {
                DynamicObject parentSetEntryRow = (DynamicObject)parentSetEntry.get(rowindex.intValue());
                this.addSubEntryRow(setEntry, parentSetEntryRow, parentView, rowindex, Boolean.FALSE);
            }
            parentView.updateView(SETENTRY);
            parentView.updateView("subentry");
            this.getView().sendFormAction(parentView);
            this.getView().close();
        }
    }

    protected void addSubEntryRow(DynamicObjectCollection setEntry, DynamicObject parentSetEntryRow, IFormView parentView, Integer rowindex, Boolean flag) {
        DynamicObjectCollection subEntry = parentSetEntryRow.getDynamicObjectCollection("subentry");
        subEntry.clear();
        StringBuilder optionSetStr = new StringBuilder();
        String option = "";
        for (DynamicObject setEntryRow : setEntry) {
            DynamicObject newSubEntryRow = subEntry.addNew();
            newSubEntryRow.set(SETENTRY_SEQ, setEntryRow.get(SETENTRY_SEQ));
            option = setEntryRow.getString(SETENTRY_OPTION);
            newSubEntryRow.set("subentry_option", (Object)option);
            int standardScore = setEntryRow.getInt(SETENTRY_STANDARDSCORE);
            newSubEntryRow.set("subentry_standardscore", (Object)standardScore);
            optionSetStr.append(option).append("(").append(standardScore).append(")\uff1b");
        }
        if (flag.booleanValue()) {
            Integer score = (Integer)this.getView().getFormShowParameter().getCustomParam("standardscore");
            parentSetEntryRow.set(SETENTRY_STANDARDSCORE, (Object)score);
        }
        parentSetEntryRow.set("setentry_optionset", (Object)optionSetStr);
    }

    protected void beforeBindData_updateData() {
        if (this.checkParentDataIsQuestionnaire()) {
            Integer rowindex = (Integer)this.getView().getFormShowParameter().getCustomParam("rowindex");
            DynamicObject parentDataEntity = this.getView().getParentView().getModel().getDataEntity(true);
            DynamicObjectCollection parentSetEntry = parentDataEntity.getDynamicObjectCollection(SETENTRY);
            DynamicObject parentSetEntryRow = (DynamicObject)parentSetEntry.get(rowindex.intValue());
            DynamicObjectCollection subEntry = parentSetEntryRow.getDynamicObjectCollection("subentry");
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection setEntry = dataEntity.getDynamicObjectCollection(SETENTRY);
            for (DynamicObject subEntryRow : subEntry) {
                DynamicObject newSetEntry = setEntry.addNew();
                newSetEntry.set(SETENTRY_SEQ, subEntryRow.get(SETENTRY_SEQ));
                newSetEntry.set(SETENTRY_OPTION, subEntryRow.get("subentry_option"));
                newSetEntry.set(SETENTRY_STANDARDSCORE, subEntryRow.get("subentry_standardscore"));
            }
            dataEntity.set(APPLYNULLOTHER, (Object)true);
        }
    }

    protected boolean checkParentDataIsQuestionnaire() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return false;
        }
        String parentFormId = parentView.getFormShowParameter().getFormId();
        return StringUtils.equals((CharSequence)BDTAXR_QUESTIONNAIRE_SET, (CharSequence)parentFormId);
    }
}

