/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.questionnaire;

import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.taxc.bdtaxr.formplugin.questionnaire.QuestionnaireUtils;

public class QuestionnaireFormPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    protected static final String PREVIEW = "preview";
    protected static final String TBMAIN = "tbmain";
    protected static final String BAR_PREVIEW = "bar_preview";
    public static final String BDTAXR_QUESTIONNAIRE_SET = "bdtaxr_questionnaire_set";
    public static final String BDTAXR_OPTIONITEMSET = "bdtaxr_optionitemset";

    public void initialize() {
        Object appname;
        super.initialize();
        if (null != this.getView().getParentView() && !"bdtaxr".equals(appname = this.getView().getParentView().getFormShowParameter().getCustomParam("appname"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"appname"});
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("heightLimit", false);
        this.getView().updateControlMetadata("setentry", map);
    }

    public void afterCreateNewData(EventObject e) {
        Object appname = this.getView().getParentView().getFormShowParameter().getCustomParam("appname");
        if (!"bdtaxr".equals(appname)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"appname"});
            Object appfid = this.getView().getParentView().getFormShowParameter().getCustomParam("appfid");
            IPageCache parentViewPageCache = this.getView().getParentView().getPageCache();
            this.getModel().setValue("appname", appfid);
            this.getModel().setValue("createorg", (Object)parentViewPageCache.get("currentorg"));
            this.getView().getFormShowParameter().getCustomParams().put("useorgId", parentViewPageCache.get("currentorg"));
        }
        super.afterCreateNewData(e);
    }

    public void registerListener(EventObject e) {
        TextEdit optionset = (TextEdit)this.getView().getControl("setentry_optionset");
        optionset.addButtonClickListener((ClickListener)this);
        Toolbar tbmain = (Toolbar)this.getView().getControl(TBMAIN);
        tbmain.addItemClickListener((ItemClickListener)this);
        super.registerListener(e);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)BAR_PREVIEW, (CharSequence)itemKey)) {
            this.previewItemClick();
        }
        super.itemClick(evt);
    }

    protected void previewItemClick() {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        int rowIndex = cd.getRowIndex();
        switch (fieldKey = e.getProperty().getName()) {
            case "setentry_optionset": {
                this.propertyChanged_setEntry_optionSet(rowIndex, newVal, oldVal);
                break;
            }
            case "setentry_problemtype": {
                this.propertyChanged_setEntry_problemType(rowIndex, newVal, oldVal);
                break;
            }
            case "setentry_standardscore": {
                this.propertyChanged_setEntry_standardscore(rowIndex, newVal, oldVal);
                break;
            }
            case "startdate": {
                this.propertyChanged_date(newVal, "startdate");
                break;
            }
            case "enddate": {
                this.propertyChanged_date(newVal, "enddate");
                break;
            }
            case "name": {
                this.propertyChanged_name();
                break;
            }
        }
    }

    public void propertyChanged_name() {
        this.getModel().setValue("number", this.getModel().getValue("name"));
    }

    public void propertyChanged_setEntry_problemType(int rowIndex, Object newVal, Object oldVal) {
        String problemType;
        String optionSet = null;
        String string = problemType = newVal == null ? "" : newVal.toString();
        if (StringUtils.equals((CharSequence)"oneticketveto", (CharSequence)problemType)) {
            optionSet = ResManager.loadKDString((String)"\u662f\uff08\u95ee\u5377\u5f970\u5206\uff09\uff0c\u5426\uff08\u4e0d\u53c2\u4e0e\u8ba1\u5206\uff09", (String)"QuestionnaireFormPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        } else if (StringUtils.equals((CharSequence)"inputscore", (CharSequence)problemType) || StringUtils.equals((CharSequence)"essayque", (CharSequence)problemType)) {
            optionSet = ResManager.loadKDString((String)"\u65e0\u9009\u9879", (String)"QuestionnaireFormPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        }
        this.getModel().setValue("setentry_optionset", (Object)optionSet, rowIndex);
    }

    public void propertyChanged_setEntry_standardscore(int rowIndex, Object newVal, Object oldVal) {
        DynamicObject[] setentry = this.getView().getModel().getEntryEntity("setentry", rowIndex, rowIndex + 1);
        DynamicObjectCollection subentry = setentry[0].getDynamicObjectCollection("subentry");
        if (subentry.size() > 0) {
            int maxStandardScore = Math.toIntExact(subentry.stream().map(s -> s.getLong("subentry_standardscore")).sorted(Comparator.reverseOrder()).findFirst().get());
            if (null != newVal && (Integer)newVal < maxStandardScore) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u9898\u6700\u5927\u5206\u503c\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u8bbe\u7f6e\u9009\u9879\u4e2d\u7684\u6700\u5927\u5206\u503c\u3002", (String)"QuestionnaireFormPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                this.getModel().setValue("setentry_standardscore", oldVal, rowIndex);
            }
        }
    }

    public void propertyChanged_date(Object date, String type) {
        Date currentdate = (Date)date;
        if (null != currentdate) {
            Date startdate;
            Date enddate;
            if (type.equals("startdate") && null != (enddate = (Date)this.getModel().getValue("enddate")) && currentdate.after(enddate)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"QuestionnaireFormPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            if (type.equals("enddate") && null != (startdate = (Date)this.getModel().getValue("startdate")) && currentdate.before(startdate)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"QuestionnaireFormPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
        }
    }

    protected void propertyChanged_setEntry_optionSet(int rowIndex, Object newVal, Object oldVal) {
        if (newVal == null || newVal.toString().isEmpty()) {
            this.deleteSubEntryByRowIndex(rowIndex);
            this.getView().updateView("subentry");
        }
    }

    protected void deleteSubEntryByRowIndex(int rowIndex) {
        DynamicObject setEntrySelectRow = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("setentry").get(rowIndex);
        setEntrySelectRow.getDynamicObjectCollection("subentry").clear();
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)"setentry_optionset", (CharSequence)key)) {
            this.click_setEntryOptionset();
        }
        super.click(evt);
    }

    public void click_setEntryOptionset() {
        EntryGrid setEntryGrid = (EntryGrid)this.getControl("setentry");
        int[] selectRows = setEntryGrid.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        int rowIndex = selectRows[0];
        DynamicObject setEntrySelectRow = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("setentry").get(rowIndex);
        if (!StringUtils.equals((CharSequence)setEntrySelectRow.getString("setentry_problemtype"), (CharSequence)"choice")) {
            return;
        }
        if (setEntrySelectRow.get("setentry_standardscore") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u9898\u6700\u5927\u5206\u503c\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"QuestionnaireFormPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        int standardScore = setEntrySelectRow.getInt("setentry_standardscore");
        if (standardScore == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u9898\u6700\u5927\u5206\u503c\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"QuestionnaireFormPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(BDTAXR_OPTIONITEMSET);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCustomParam("rowindex", (Object)rowIndex);
        formShowParameter.setCustomParam("standardscore", (Object)standardScore);
        this.getView().showForm(formShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
            this.beforeSubmitOperation(args);
        }
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)PREVIEW, (CharSequence)operateKey)) {
            this.afterPreview(afterDoOperationEventArgs);
        }
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    protected void afterPreview(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long pkValue = dataEntity.getLong("id");
        IFormView view = this.getView();
        if (pkValue == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u9875\u9762\u3002", (String)"QuestionnaireFormPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection setEntry = dataEntity.getDynamicObjectCollection("setentry");
        for (DynamicObject setEntryRow : setEntry) {
            if (setEntryRow.getLong("id") != 0L) continue;
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u9875\u9762\u3002", (String)"QuestionnaireFormPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        String questionName = this.getModel().getValue("name").toString();
        QuestionnaireUtils.showQuesnairePreview(pkValue, view, ShowType.Modal, BDTAXR_QUESTIONNAIRE_SET, questionName);
    }

    protected void beforeSubmitOperation(BeforeDoOperationEventArgs args) {
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }
}

