/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.rule;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.taxc.bdtaxr.common.constant.InvoiceTypeEnum;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class BillFilterOperPlugin
extends AbstractFormPlugin
implements BeforeFilterF7SelectListener {
    public static final String BillFilter_entityNumber = "entityNumber";
    public static final String BillFilter_entityId = "entityId";
    public static final String CustParamKey_FilterJson = "filterJson";
    public static final String KEY_FILTERDESCRIPTION = "filterdescription";
    public static final String KEY_FILTER_VALUE = "filtervalue";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String KEY_BTNOK = "btnok";
    private static final String Key_filtergridap = "filtergridap";
    private static final String BD_INVOICETYPE = "bd_invoicetype";
    private static final String BOS_ORG = "bos_org";
    private static final Set<String> ref_entity_ids = new HashSet<String>(){
        {
            this.add("bd_accountview");
        }
    };
    private static String INVOICE_TYPE = "";
    private static final String REPLACE_MAP_KEY = "replaceMap";
    private static Map<String, List<SimpleFilterRow>> origin_input_condition = new HashMap<String, List<SimpleFilterRow>>();
    private static final Set<String> compareTypes_need_merge = new HashSet<String>(){
        {
            this.add(BillFilterOperPlugin.EQUEAL);
            this.add(BillFilterOperPlugin.NOT_EQUEAL);
            this.add(BillFilterOperPlugin.CONTAIN);
            this.add(BillFilterOperPlugin.NOT_CONTAIN);
            this.add(BillFilterOperPlugin.START_WITH);
            this.add(BillFilterOperPlugin.END_WITH);
        }
    };
    private static final Set<String> compareTypes_stay_same = new HashSet<String>(){
        {
            this.add(BillFilterOperPlugin.IN);
            this.add(BillFilterOperPlugin.NOT_IN);
        }
    };
    private Map<String, String> compareTypes_and_cn_name = new HashMap<String, String>(){
        {
            this.put(BillFilterOperPlugin.IN, ResManager.loadKDString((String)" \u5728\u2026\u2026\u4e2d", (String)"BillFilterOperPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            this.put(BillFilterOperPlugin.NOT_IN, ResManager.loadKDString((String)" \u4e0d\u5728\u2026\u2026\u4e2d", (String)"BillFilterOperPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            this.put(BillFilterOperPlugin.EQUEAL, ResManager.loadKDString((String)" \u7b49\u4e8e", (String)"BillFilterOperPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            this.put(BillFilterOperPlugin.NOT_EQUEAL, ResManager.loadKDString((String)" \u4e0d\u7b49\u4e8e", (String)"BillFilterOperPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            this.put(BillFilterOperPlugin.CONTAIN, ResManager.loadKDString((String)" \u5305\u542b", (String)"BillFilterOperPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            this.put(BillFilterOperPlugin.NOT_CONTAIN, ResManager.loadKDString((String)" \u4e0d\u5305\u542b", (String)"BillFilterOperPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            this.put(BillFilterOperPlugin.START_WITH, ResManager.loadKDString((String)" \u4ee5\u2026\u2026\u5f00\u59cb", (String)"BillFilterOperPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            this.put(BillFilterOperPlugin.END_WITH, ResManager.loadKDString((String)" \u4ee5\u2026\u2026\u7ed3\u675f", (String)"BillFilterOperPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    };
    private static final String EQUEAL = "67";
    private static final String NOT_EQUEAL = "83";
    private static final String IN = "17";
    private static final String NOT_IN = "34";
    private static final String START_WITH = "60";
    private static final String END_WITH = "211";
    private static final String CONTAIN = "59";
    private static final String NOT_CONTAIN = "58";
    private static final String PERCENT = "%";
    private static final String IS_DIGIT = "[0-9]+";
    private static final String GL_VOUCHER = "gl_voucher";
    private static final String GL_BALANCE = "gl_balance";
    private static final String ACCOUNT_TYPE = "bd_accountbookstype";
    private static final String BOOK_TYPE_DEFAULT_VALUE = "1";
    private static final String STATUS_DEFAULT_VALUE = "C";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BTNCANCEL, KEY_BTNOK});
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent evt) {
        Object ruletype = this.getView().getFormShowParameter().getCustomParams().get("ruletype");
        if ("public".equals(ruletype) && "tdm_account".equals(evt.getRefEntityId())) {
            evt.setRefEntityId("tdm_account_summary");
        }
        if (BD_INVOICETYPE.equals(evt.getRefEntityId()) && StringUtil.isNotBlank((CharSequence)INVOICE_TYPE)) {
            QFilter q = new QFilter("number", "in", Arrays.asList(INVOICE_TYPE.split(",")));
            evt.addCustomQFilter(q);
        }
        this.addExtendFilter(evt, ruletype);
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        List filteList = filterCondition.getFilterRow();
        int rowIndex = evt.getRowIndex();
        if (rowIndex > filteList.size()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u4e4b\u524d\u5b58\u5728\u914d\u7f6e\u884c\u672a\u914d\u7f6e\u6570\u636e\u7684\u60c5\u51b5\uff0c\u8bf7\u5148\u914d\u7f6e\u597d\u3002", (String)"BillFilterOperPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]), rowIndex + 1));
            evt.setCancel(true);
        } else {
            SimpleFilterRow simpleFilterRow = null;
            try {
                simpleFilterRow = (SimpleFilterRow)filteList.get(rowIndex);
            }
            catch (Exception e2) {
                return;
            }
            List value = simpleFilterRow.getValue();
            QFilter q1 = new QFilter(evt.getRefPropKey(), "in", value.stream().map(FilterValue::getValue).collect(Collectors.toList()));
            QFilter q2 = null;
            String refEntityId = evt.getRefEntityId();
            EntityInfo entityById = MetadataUtil.getEntityById((String)refEntityId);
            List fieldList = entityById.getFieldList();
            for (EntityField entityField : fieldList) {
                String fieldType = entityField.getFieldType();
                if (!"Basedata".equals(fieldType)) continue;
                if (BOS_ORG.equals(entityField.getBaseEntityId())) {
                    Object orgid = this.getView().getFormShowParameter().getCustomParam("orgid");
                    if (orgid == null) continue;
                    q2 = new QFilter(entityField.getFieldId(), "=", orgid);
                    break;
                }
                if (!BD_INVOICETYPE.equals(entityField.getBaseEntityId())) continue;
                q2 = new QFilter(entityField.getFieldId(), "=", (Object)"orgid");
                break;
            }
            DynamicObjectCollection ids = QueryServiceHelper.query((String)refEntityId, (String)"id", (QFilter[])new QFilter[]{q1, q2});
            evt.setSelectedIds(ids.stream().map(e -> e.get("id")).toArray());
        }
    }

    private void addExtendFilter(BeforeFilterF7SelectEvent evt, Object ruletype) {
        if (ref_entity_ids.contains(evt.getRefEntityId())) {
            QFilter userQfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("orgid")));
            if ("public".equals(ruletype)) {
                DynamicObject dyo = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"accounttable", (QFilter[])new QFilter[]{userQfilter});
                if (null == dyo) {
                    return;
                }
                evt.getCustomQFilters().add(new QFilter("accounttable", "=", (Object)dyo.getLong("accounttable")));
            } else {
                evt.getCustomQFilters().add(userQfilter);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(BillFilter_entityNumber);
        INVOICE_TYPE = InvoiceTypeEnum.getEnumByEntityId((String)entityNumber);
        Long entityid = (Long)this.getView().getFormShowParameter().getCustomParam(BillFilter_entityId);
        if (!StringUtils.isBlank((CharSequence)entityNumber)) {
            this.initFilterCondition(entityid, entityNumber);
            String filterJson = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_FilterJson);
            if (!StringUtils.isBlank((CharSequence)filterJson)) {
                this.setDataFilter(filterJson, entityNumber);
            }
        }
    }

    private void initFilterCondition(Long entityid, String entityNumber) {
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition fc = filterGridState.getFilterCondition();
        fc.getFilterRow().clear();
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (GL_BALANCE.equals(entityNumber)) {
            ((MainOrgProp)entityType.getFields().get("org")).setAlias("forgid");
            ((BasedataProp)entityType.getFields().get("booktype")).setAlias("fbooktypeid");
            ((BasedataProp)entityType.getFields().get("period")).setAlias("FPERIODID");
            ((BasedataProp)entityType.getFields().get("endperiod")).setAlias("FENDPERIODID");
            ((BasedataProp)entityType.getFields().get("accounttable")).setAlias("faccounttableid");
            ((BasedataProp)entityType.getFields().get("account")).setAlias("FACCOUNTID");
            ((FlexProp)entityType.getFields().get("assgrp")).setAlias("fassgrpid");
            ((CurrencyProp)entityType.getFields().get("currency")).setAlias("FCURRENCYID");
            ((UnitProp)entityType.getFields().get("measureunit")).setAlias("FMEASUREUNITID");
        }
        List list = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
        QFilter tableid = new QFilter("tableid", "=", (Object)entityid);
        QFilter wherestate = new QFilter("wherestate", "=", (Object)BOOK_TYPE_DEFAULT_VALUE);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bdtaxr_datasource_entry", (String)"fieldname,bizsubname", (QFilter[])new QFilter[]{tableid, wherestate});
        ArrayList<Map> filterColumns = new ArrayList<Map>();
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        for (Map filterColumn : list) {
            String type = (String)filterColumn.get("type");
            String fieldName = (String)filterColumn.get("fieldName");
            for (DynamicObject dynamicObject : dynamicObjects) {
                String bizsubname = dynamicObject.getString("bizsubname");
                if ("basedata".equals(type)) {
                    if (!fieldName.equals(dynamicObject.getString("fieldname")) && !fieldName.split("\\.")[0].equals(dynamicObject.getString("fieldname"))) continue;
                    String oldCaption = (String)filterColumn.get("fieldCaption");
                    String newCaption = oldCaption.replace(".", "");
                    replaceMap.put(oldCaption, newCaption);
                    if (entityNumber.equals(GL_VOUCHER) && newCaption.startsWith(ResManager.loadKDString((String)"\u5206\u5f55\u4f53", (String)"BillFilterOperPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]))) {
                        newCaption = newCaption.substring(3);
                    }
                    filterColumn.put("fieldCaption", newCaption);
                    filterColumns.add(filterColumn);
                    continue;
                }
                if (!fieldName.equals(dynamicObject.getString("fieldname"))) continue;
                replaceMap.put((String)filterColumn.get("fieldCaption"), bizsubname);
                filterColumn.put("fieldCaption", bizsubname);
                filterColumns.add(filterColumn);
            }
        }
        this.getPageCache().put(REPLACE_MAP_KEY, JSON.toJSONString(replaceMap));
        filterGrid.setFilterColumns(filterColumns);
        filterGrid.setEntityNumber(entityNumber);
        filterGrid.SetValue(fc);
        this.getView().updateView(Key_filtergridap);
    }

    private void setDataFilter(String dataFilter, String entityNumber) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)dataFilter, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        this.updateAssgrpToOrigin(filterCondition, entityNumber);
        filterGrid.SetValue(filterCondition);
    }

    private void updateAssgrpToOrigin(FilterCondition filterCondition, String entityNumber) {
        String bizName = (String)this.getView().getFormShowParameter().getCustomParam("bizname");
        String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
        List<SimpleFilterRow> orginRows = origin_input_condition.get(entity + bizName);
        if (null == orginRows) {
            return;
        }
        Iterator<SimpleFilterRow> iterator = orginRows.iterator();
        for (SimpleFilterRow filterRow : filterCondition.getFilterRow()) {
            if (!"assgrp".equals(filterRow.getFieldName()) || !iterator.hasNext()) continue;
            SimpleFilterRow orgin = iterator.next();
            filterRow.setValue(orgin.getValue());
            filterRow.setCompareType(orgin.getCompareType());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_BTNOK.equalsIgnoreCase(key)) {
            this.returnDataToParent();
        } else if (KEY_BTNCANCEL.equalsIgnoreCase(key)) {
            this.getView().close();
        }
    }

    private void returnDataToParent() {
        Map<String, Object> ret = this.getConfig();
        this.getView().returnDataToParent(ret);
        this.getView().close();
    }

    private Map<String, Object> getConfig() {
        ArrayList<String> errors = new ArrayList<String>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(KEY_FILTER_VALUE, "");
        data.put(KEY_FILTERDESCRIPTION, "");
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        List filteList = filterCondition.getFilterRow();
        this.setDefaultFilter(filterGrid, filteList, errors);
        if (errors.size() != 0) {
            this.getView().getParentView().showTipNotification((String)errors.get(0));
        }
        if (filteList == null || filteList.isEmpty()) {
            return data;
        }
        String modelType = "DynamicFormModel";
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        binder.setWriteInheritFlag(true);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        String filterJson = SerializationUtils.toJsonString((Object)filterConditionMap);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(BillFilter_entityNumber);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        String filter = filterBuilder.getFilterObject().getFilter();
        String replaceMapStr = this.getPageCache().get(REPLACE_MAP_KEY);
        if (StringUtils.isNotBlank((CharSequence)replaceMapStr)) {
            Map<String, String> replaceMap = JSON.parseObject((String)replaceMapStr).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)e.getValue(), (v1, v2) -> v1));
            ArrayList<Map.Entry<String, String>> entryList = new ArrayList<Map.Entry<String, String>>(replaceMap.entrySet());
            entryList.sort((e1, e2) -> ((String)e2.getKey()).length() - ((String)e1.getKey()).length());
            for (Map.Entry entry : entryList) {
                filter = filter.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        this.getPageCache().remove(REPLACE_MAP_KEY);
        data.put(KEY_FILTER_VALUE, filterJson);
        data.put(KEY_FILTERDESCRIPTION, filter);
        return data;
    }

    private void setDefaultFilter(FilterGrid filterGrid, List<SimpleFilterRow> filteList, List<String> errors) {
        if (GL_VOUCHER.equals(filterGrid.getEntityNumber()) || GL_BALANCE.equals(filterGrid.getEntityNumber())) {
            FilterValue filterValue;
            boolean isSetBookType = false;
            boolean isSetBillStatus = false;
            for (SimpleFilterRow filterRow : filteList) {
                if (null == filterRow.getFieldName()) continue;
                if (filterRow.getFieldName().startsWith("booktype")) {
                    isSetBookType = true;
                    continue;
                }
                if (GL_VOUCHER.equals(filterGrid.getEntityNumber()) && filterRow.getFieldName().startsWith("billstatus")) {
                    isSetBillStatus = true;
                    continue;
                }
                if (!GL_BALANCE.equals(filterGrid.getEntityNumber()) && !GL_VOUCHER.equals(filterGrid.getEntityNumber()) || !filterRow.getFieldName().equals("assgrp")) continue;
                String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
                String bizName = (String)this.getView().getFormShowParameter().getCustomParam("bizname");
                origin_input_condition.put(entity + bizName, this.getOrDefault(filterRow, entity + bizName));
                this.packageFilter(filterRow, errors);
            }
            if (!isSetBookType) {
                filterValue = new FilterValue();
                filterValue.setValue((Object)this.getMainBookId());
                filteList.add(new SimpleFilterRow("", EQUEAL, "booktype.number", "", "0", Collections.singletonList(filterValue)));
            }
            if (!isSetBillStatus && GL_VOUCHER.equals(filterGrid.getEntityNumber())) {
                filterValue = new FilterValue();
                filterValue.setValue((Object)STATUS_DEFAULT_VALUE);
                filteList.add(new SimpleFilterRow("", "105", "billstatus", "", "0", Collections.singletonList(filterValue)));
            }
        }
    }

    private String getMainBookId() {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ACCOUNT_TYPE, (String)"number", (QFilter[])new QFilter[]{new QFilter("accounttype", "=", (Object)BOOK_TYPE_DEFAULT_VALUE)});
        return null == dynamicObject ? null : dynamicObject.getString("number");
    }

    private List<SimpleFilterRow> getOrDefault(SimpleFilterRow filterRow, String bizName) {
        List<SimpleFilterRow> temp = origin_input_condition.get(bizName);
        if (null == temp) {
            temp = new ArrayList<SimpleFilterRow>();
        }
        temp.add(this.getOriginFilterRow(filterRow));
        return temp;
    }

    private SimpleFilterRow getOriginFilterRow(SimpleFilterRow filterRow) {
        SimpleFilterRow originFilterRow = new SimpleFilterRow();
        originFilterRow.setCompareType(filterRow.getCompareType());
        originFilterRow.setValue(filterRow.getValue());
        return originFilterRow;
    }

    private void packageFilter(SimpleFilterRow filterRow, List<String> errors) {
        String compareType = filterRow.getCompareType();
        if (!compareTypes_need_merge.contains(compareType) && !compareTypes_stay_same.contains(compareType)) {
            return;
        }
        List content = filterRow.getValue();
        ArrayList<FilterValue> cache = new ArrayList<FilterValue>();
        LinkedHashMap<String, Long> queryJson = new LinkedHashMap<String, Long>();
        ArrayList<String> oldCaptionList = new ArrayList<String>();
        StringBuilder values = new StringBuilder();
        for (FilterValue filter : content) {
            String value = (String)filter.getValue();
            values.append(value).append(';');
            if (value.contains(":")) {
                String[] assgrpAndDetail = value.split(":");
                if (assgrpAndDetail.length == 2) {
                    String assgrpName = assgrpAndDetail[0];
                    String detailName = assgrpAndDetail[1];
                    DynamicObject assgrp = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"flexfield,valuesource,disprops", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)assgrpName)});
                    if (null == assgrp) {
                        filterRow.setValue(cache);
                        errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u5192\u53f7\u5de6\u4fa7\u6761\u4ef6\u65e0\u5339\u914d\u503c\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a.", (String)"BillFilterOperPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObjectCollection detail = null;
                    QFilter qFilter = this.getFilterByDisplayproperty(assgrp.getString("disprops"), detailName);
                    try {
                        detail = QueryServiceHelper.query((String)assgrp.getString("valuesource"), (String)"id", (QFilter[])new QFilter[]{qFilter});
                        if (null == detail || detail.size() == 0) {
                            String[] subs;
                            if (qFilter.getProperty().equals("fullname")) {
                                qFilter = new QFilter("name", "=", (Object)detailName);
                            } else if (qFilter.getProperty().equals("longnumber") && (subs = detailName.split(",")).length == 2) {
                                qFilter = new QFilter("longnumber", "=", (Object)subs[0]);
                                detail = QueryServiceHelper.query((String)assgrp.getString("valuesource"), (String)"id", (QFilter[])new QFilter[]{qFilter});
                            }
                        }
                    }
                    catch (Throwable e2) {
                        if (qFilter.getProperty().equals("fullname")) {
                            qFilter = new QFilter("name", "=", (Object)detailName);
                            detail = QueryServiceHelper.query((String)assgrp.getString("valuesource"), (String)"id", (QFilter[])new QFilter[]{qFilter});
                        }
                        if (qFilter.getProperty().equals("longnumber") && detailName.split(",").length == 2) {
                            qFilter = new QFilter("number", "=", (Object)detailName.split(",")[0]);
                            detail = QueryServiceHelper.query((String)assgrp.getString("valuesource"), (String)"id", (QFilter[])new QFilter[]{qFilter});
                        }
                        filterRow.setValue(cache);
                        errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u5192\u53f7\u5de6\u4fa7\u6761\u4ef6\u65e0\u5339\u914d\u503c\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a.", (String)"BillFilterOperPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                        return;
                    }
                    if (null == detail || detail.size() == 0) {
                        filterRow.setValue(cache);
                        errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u5192\u53f7\u53f3\u4fa7\u6761\u4ef6\u65e0\u5339\u914d\u503c\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a.", (String)"BillFilterOperPlugin_11", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                        return;
                    }
                    String Qcp = this.getQcp(filterRow, compareType);
                    qFilter = null;
                    for (DynamicObject dynamicObject : detail) {
                        queryJson.put(assgrp.getString("flexfield"), dynamicObject.getLong("id"));
                        String tempJson = this.packageQueryJson(queryJson, compareType);
                        if (null == qFilter) {
                            qFilter = new QFilter("assvals", Qcp, (Object)tempJson);
                        } else {
                            qFilter.or(new QFilter("assvals", Qcp, (Object)tempJson));
                        }
                        queryJson.clear();
                    }
                    DynamicObjectCollection assgrpAssists = QueryServiceHelper.query((String)"gl_assist", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (null == assgrpAssists || assgrpAssists.size() == 0) continue;
                    for (DynamicObject assgrpAssist : assgrpAssists) {
                        FilterValue filterValue = new FilterValue();
                        filterValue.setValue((Object)String.valueOf(assgrpAssist.getLong("id")));
                        oldCaptionList.add(String.valueOf(assgrpAssist.getLong("id")));
                        cache.add(filterValue);
                    }
                    continue;
                }
                filterRow.setValue(cache);
                errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u6761\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a\uff0c\u6b63\u786e\u683c\u5f0f\u5982:\u7269\u6599:\u6253\u5370\u673a.", (String)"BillFilterOperPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            if (value.matches(IS_DIGIT)) {
                return;
            }
            filterRow.setValue(cache);
            errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u6761\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a\uff0c\u6b63\u786e\u683c\u5f0f\u5982:\u7269\u6599:\u6253\u5370\u673a.", (String)"BillFilterOperPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        if (cache.size() != 0) {
            filterRow.setValue(cache);
            String oldCaption = ((Object)oldCaptionList).toString();
            String replaceMapStr = this.getPageCache().get(REPLACE_MAP_KEY);
            Map<String, String> replaceMap = StringUtils.isNotBlank((CharSequence)replaceMapStr) ? JSON.parseObject((String)replaceMapStr).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)e.getValue(), (v1, v2) -> v1)) : new HashMap<String, String>();
            replaceMap.put(this.compareTypes_and_cn_name.get(filterRow.getCompareType()) + " " + oldCaption.substring(1, oldCaption.length() - 1).replace(", ", ";"), this.compareTypes_and_cn_name.get(compareType) + " " + values.toString().substring(0, values.length() - 1));
            this.getPageCache().put(REPLACE_MAP_KEY, JSON.toJSONString(replaceMap));
        } else {
            filterRow.setValue(cache);
            errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u6761\u4ef6\u65e0\u5339\u914d\u503c\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a.", (String)"BillFilterOperPlugin_13", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    private QFilter getFilterByDisplayproperty(String displayproperty, String value) {
        String disprop;
        QFilter qFilter = new QFilter("fullname", "=", (Object)value);
        if (StringUtil.isEmpty((CharSequence)displayproperty)) {
            return qFilter;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)displayproperty, Map.class);
        if (null == map || null == map.get("disp") || null == ((Map)map.get("disp")).get("dispprop")) {
            return qFilter;
        }
        switch (disprop = (String)((Map)map.get("disp")).get("dispprop")) {
            case "1": {
                qFilter = new QFilter("longnumber", "=", (Object)value);
                break;
            }
            case "2": {
                qFilter = new QFilter("fullname", "=", (Object)value);
                break;
            }
            case "3": {
                String[] subs = value.split(",");
                if (subs.length != 2) break;
                qFilter = new QFilter("longnumber", "=", (Object)subs[0]);
            }
        }
        return qFilter;
    }

    private String packageQueryJson(Map<String, Long> map, String compareType) {
        String json = JsonUtil.toJson(map);
        if (START_WITH.equals(compareType)) {
            json = json.substring(0, json.length() - 1);
            return json + PERCENT;
        }
        if (END_WITH.equals(compareType)) {
            json = json.substring(1);
            return PERCENT + json;
        }
        if (CONTAIN.equals(compareType) || NOT_CONTAIN.equals(compareType)) {
            json = json.substring(1, json.length() - 1);
            return PERCENT + json + PERCENT;
        }
        return JsonUtil.toJson(map);
    }

    private String getQcp(SimpleFilterRow filterRow, String compareType) {
        switch (compareType) {
            case "17": {
                return "=";
            }
            case "34": {
                return "=";
            }
            case "67": {
                return "=";
            }
            case "83": {
                return "=";
            }
            case "58": {
                filterRow.setCompareType(IN);
                return "not like";
            }
            case "59": {
                filterRow.setCompareType(IN);
                return "like";
            }
            case "60": {
                filterRow.setCompareType(IN);
                return "like";
            }
            case "211": {
                filterRow.setCompareType(IN);
                return "like";
            }
        }
        return null;
    }
}

