/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class RuleTemplatePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String KEY_FILTERCONDITION = "filtercondition";
    private static final String KEY_CONDITIONJSON = "conditionjson";
    private static final String FILTER_DESC = "filterdescription";
    private static final String DISTINCT_FIELD = "distinctfield";
    private static final String GROUP_FIELD = "groupfields";
    private static final String TABLES = "tables";
    private static final String TABLE_ID = "tableid";
    private static final String SETTING = "setting";
    private static final String DO_NOTHING = "donothing";
    private static final String BASEDATA_ID = "fbasedataid";
    private static final String BIZNAME = "bizname";
    private static final String ENTITY = "entity";

    public void initialize() {
        BasedataEdit distinctfield = (BasedataEdit)this.getControl(DISTINCT_FIELD);
        distinctfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit tablefield = (BasedataEdit)this.getControl(TABLES);
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit groupfields = (MulBasedataEdit)this.getControl(GROUP_FIELD);
        if (groupfields != null) {
            groupfields.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && DO_NOTHING.equals(((Donothing)args.getSource()).getOperateKey())) {
            DynamicObjectCollection tabletypes = (DynamicObjectCollection)this.getModel().getValue(TABLES);
            if (tabletypes.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"RuleTemplatePlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            HashMap<Long, String> tableId2Name = new HashMap<Long, String>();
            for (DynamicObject table : tabletypes) {
                DynamicObject dataSource = table.getDynamicObject(BASEDATA_ID);
                tableId2Name.put(dataSource.getLong("id"), dataSource.getString(BIZNAME));
            }
            this.openSettingPage(tableId2Name, ENTRY_ENTITY, KEY_CONDITIONJSON, SETTING);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map filterData;
        super.closedCallBack(evt);
        if (SETTING.equals(evt.getActionId()) && (filterData = (Map)evt.getReturnData()) != null) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            String desc = (String)filterData.get(FILTER_DESC);
            if (((DynamicObjectCollection)this.getModel().getValue(TABLES)).size() == 1 && !StringUtil.isEmpty((CharSequence)desc)) {
                DynamicObject dyo = (DynamicObject)((DynamicObjectCollection)this.getModel().getValue(TABLES)).get(0);
                DynamicObject dataSource = dyo.getDynamicObject(BASEDATA_ID);
                desc = desc.replaceAll(dataSource.getString(BIZNAME) + ".", "");
            }
            this.getModel().setValue(KEY_FILTERCONDITION, (Object)desc, currentRowIndex);
            this.getModel().setValue(KEY_CONDITIONJSON, filterData.get("filtervalue"), currentRowIndex);
        }
    }

    private void openSettingPage(Map<Long, String> tableId2Name, String entityfield, String conditionjson, String actionId) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_filter_setting");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", tableId2Name);
        formshowParameter.setCustomParam("filterJson", this.getModel().getValue(conditionjson));
        formshowParameter.setCustomParam(BIZNAME, this.getModel().getValue("name"));
        formshowParameter.setCustomParam(ENTITY, (Object)entityfield);
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (evt.getProperty().getName().equals(DISTINCT_FIELD)) {
            DynamicObjectCollection tabletypes = (DynamicObjectCollection)this.getModel().getValue(TABLES);
            if (tabletypes == null || tabletypes.size() == 0) {
                evt.setCancel(true);
                return;
            }
            ArrayList<Long> tableIds = new ArrayList<Long>();
            for (DynamicObject tabletype : tabletypes) {
                DynamicObject dataSource = tabletype.getDynamicObject(BASEDATA_ID);
                tableIds.add(dataSource.getLong("id"));
            }
            String func = (String)this.getModel().getValue("func");
            QFilter funcFilter = null;
            if ("sum".equals(func) || "abs".equals(func)) {
                funcFilter = new QFilter("isamount", "=", (Object)"1");
            }
            QFilter id = new QFilter(TABLE_ID, "in", tableIds);
            if (null != funcFilter) {
                id = id.and(funcFilter);
            }
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(id);
        } else if (evt.getProperty().getName().equals(GROUP_FIELD)) {
            DynamicObjectCollection tabletypes = (DynamicObjectCollection)this.getModel().getValue(TABLES);
            if (tabletypes == null || tabletypes.size() == 0) {
                evt.setCancel(true);
                return;
            }
            ArrayList<Long> tableIds = new ArrayList<Long>();
            for (DynamicObject tabletype : tabletypes) {
                DynamicObject dataSource = tabletype.getDynamicObject(BASEDATA_ID);
                tableIds.add(dataSource.getLong("id"));
            }
            QFilter funcFilter = new QFilter(TABLE_ID, "in", tableIds);
            if ("bdtaxr_batch_rule_set".equals(this.getView().getFormShowParameter().getFormId())) {
                List ids;
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fields");
                if (entryEntity.size() == 0) {
                    evt.setCancel(true);
                    return;
                }
                if (entryEntity.size() > 0 && CollectionUtils.isNotEmpty(ids = entryEntity.stream().filter(o -> StringUtil.isEmpty((CharSequence)o.getString("func"))).map(k -> k.getDynamicObject(DISTINCT_FIELD).getLong("id")).collect(Collectors.toList()))) {
                    QFilter idQFilter = new QFilter("id", "in", ids);
                    funcFilter.and(idQFilter);
                }
            } else if ("bdtaxr_rule_set".equals(this.getView().getFormShowParameter().getFormId())) {
                Object func = this.getModel().getValue("func");
                Object obj = this.getModel().getValue(DISTINCT_FIELD);
                if (obj != null && EmptyCheckUtils.isEmpty((Object)func)) {
                    DynamicObject distinctObj = (DynamicObject)obj;
                    QFilter idQFilter = new QFilter("id", "=", (Object)distinctObj.getLong("id"));
                    funcFilter.and(idQFilter);
                }
            }
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(funcFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }
}

