/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.rule.datasource;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class DataSourceEditPlugin
extends AbstractFormPlugin {
    private static final String ENTITY_NAME = "entityname";
    private static final String SUB_ENTITY_NAME = "subname";
    private static final String TOOL_TBMAIN = "tbmain";
    private static final String HAS_SUBENTITY = "has_subentity";
    private static final String HAS_SUBTIPS = "has_subtips";
    private static final String BAR_SAVE = "bar_save";
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final Map<String, Set<String>> dfs = new HashMap<String, Set<String>>(){
        {
            this.put("gl_balance", new HashSet<String>(Arrays.asList("account", "booktype", "period")));
            this.put("gl_voucher", new HashSet<String>(Arrays.asList("account", "booktype", "vouchertype", "period")));
            this.put("entries", new HashSet<String>(Collections.singletonList("account")));
        }
    };
    private static final Map<String, String> field2Entity = new HashMap<String, String>(){
        {
            this.put("booktype", "bd_accountbookstype");
            this.put("account", "bd_accountview");
            this.put("vouchertype", "gl_vouchertype");
            this.put("period", "bd_period");
        }
    };
    private static final Map<String, Set<String>> entity2FilesShow = new HashMap<String, Set<String>>(){
        {
            this.put("bd_accountbookstype", new HashSet<String>(Arrays.asList("number", "name")));
            this.put("bd_accountview", new HashSet<String>(Arrays.asList("number", "name")));
            this.put("gl_vouchertype", new HashSet<String>(Arrays.asList("number", "name")));
            this.put("bd_period", new HashSet<String>(Collections.singletonList("begindate")));
        }
    };
    private static final String MAIN_KEY = "main";

    public void afterBindData(EventObject e) {
        BaseView baseView = (BaseView)e.getSource();
        OperationStatus status = baseView.getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ENTITY_NAME, SUB_ENTITY_NAME});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtil.equals((CharSequence)operate.getOperateKey(), (CharSequence)"save")) {
            String integrityInfo = this.checkFieldIntegrity();
            if (integrityInfo != null) {
                this.getView().showErrorNotification(integrityInfo);
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection ds = this.getModel().getEntryEntity(ENTRY_ENTITY);
            if (ds == null || ds.size() <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u70b9\u51fb\u751f\u6210\u6309\u94ae\uff0c\u751f\u6210\u5b9e\u4f53\u5b57\u6bb5", (String)"DataSourceEditPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            List<String> validityInfo = this.checkFieldValidity();
            if (validityInfo.size() > 0) {
                for (String info : validityInfo) {
                    this.getView().showErrorNotification(info);
                }
                args.setCancel(true);
                return;
            }
            String subEntityNumber = (String)this.getModel().getValue(SUB_ENTITY_NAME);
            String hasSubEntity = this.getPageCache().get(HAS_SUBENTITY);
            if (StringUtil.isBlank((CharSequence)subEntityNumber) && StringUtil.isNotBlank((CharSequence)hasSubEntity) && "1".equals(hasSubEntity)) {
                RefObject afterConfirm = new RefObject();
                if (!operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm)) {
                    this.showConfirmTips();
                    args.setCancel(true);
                }
                operate.getOption().setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            }
        }
    }

    private void showConfirmTips() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BAR_SAVE, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"DataSourceEditPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"DataSourceEditPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String tipInfo = this.getPageCache().get(HAS_SUBTIPS);
        String msg = ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u8868\u5355\u672a\u9009\u62e9\uff0c\u786e\u5b9a\u4e0d\u5173\u8054\u5417\uff1f", (String)"DataSourceEditPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        this.getView().showConfirm(msg, tipInfo, options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private List<String> checkFieldValidity() {
        ArrayList<String> infoList = new ArrayList<String>();
        DynamicObjectCollection ds = this.getModel().getEntryEntity(ENTRY_ENTITY);
        boolean orgStatus = false;
        boolean timeStatus = false;
        boolean yearStatus = false;
        boolean mouthStatus = false;
        for (DynamicObject d : ds) {
            if (d.getBoolean("orgstate")) {
                orgStatus = true;
            }
            if (d.getBoolean("datastate")) {
                timeStatus = true;
            }
            if (d.getBoolean("yearstate")) {
                yearStatus = true;
            }
            if (!d.getBoolean("monthstate")) continue;
            mouthStatus = true;
        }
        return infoList;
    }

    private String checkFieldIntegrity() {
        String entityName;
        StringBuilder tipInfo = new StringBuilder();
        String name = this.getModel().getValue("bizname").toString();
        if (StringUtils.isEmpty((String)name)) {
            tipInfo.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u540d\u79f0", (String)"DataSourceEditPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0])).append('\u3001');
        }
        if (StringUtils.isEmpty((String)(entityName = (String)this.getModel().getValue(ENTITY_NAME)))) {
            tipInfo.append(ResManager.loadKDString((String)"\u8868\u5355", (String)"DataSourceEditPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0])).append('\u3001');
        }
        if (tipInfo.length() > 0) {
            return String.format(ResManager.loadKDString((String)"\u6709\u5185\u5bb9\u672a\u6309\u8981\u6c42\u586b\u5199\uff1a%s", (String)"DataSourceEditPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]), tipInfo.substring(0, tipInfo.length() - 1));
        }
        return null;
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ENTITY_NAME, SUB_ENTITY_NAME});
        this.addItemClickListeners(new String[]{TOOL_TBMAIN, BAR_SAVE});
    }

    public void click(EventObject evt) {
        IDataModel model;
        String mainNumber;
        String key = ((Control)evt.getSource()).getKey();
        if (ENTITY_NAME.equalsIgnoreCase(key)) {
            ListShowParameter listShowParameter = this.createAndSetListShowParameter("bos_formmeta", "bos_devp_formtreelistf7", ResManager.loadKDString((String)"\u901a\u7528\u8868\u5355\u9009\u62e9", (String)"DataSourceEditPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]), false);
            if (listShowParameter != null) {
                listShowParameter.setCustomParam("onlyvisible", (Object)Boolean.FALSE);
                listShowParameter.setCustomParam("onlydeployed", (Object)Boolean.FALSE);
                listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "formCallBack"));
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter("modeltype", "in", Arrays.asList("BillFormModel", "BaseFormModel")));
                listShowParameter.getListFilterParameter().setQFilters(qFilters);
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        } else if (SUB_ENTITY_NAME.equalsIgnoreCase(key) && StringUtils.isNotEmpty((String)(mainNumber = (String)(model = this.getModel()).getValue(ENTITY_NAME)))) {
            this.showSubEntityForm(mainNumber);
        }
    }

    private void showSubEntityForm(String mainNumber) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId("tctb_datasource_subentity");
        showParameter.setCaption(ResManager.loadKDString((String)"\u5173\u8054\u5b50\u5b9e\u4f53", (String)"DataSourceEditPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("mainEntity", (Object)mainNumber);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "subFormCallBack");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (BAR_SAVE.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            this.getView().invokeOperation("save", operateOption);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("generate".equalsIgnoreCase(key)) {
            String number = (String)this.getModel().getValue(ENTITY_NAME);
            String subNumber = (String)this.getModel().getValue(SUB_ENTITY_NAME);
            if (StringUtil.isBlank((CharSequence)number)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53\u540d\u79f0", (String)"DataSourceEditPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            if (this.getView().getPageCache().get(MAIN_KEY) != null && !number.equals(this.getView().getPageCache().get(MAIN_KEY))) {
                this.getModel().deleteEntryData(ENTRY_ENTITY);
            }
            this.getView().getPageCache().put(MAIN_KEY, number);
            this.createEntry(number, subNumber, null);
        }
    }

    public void createEntry(String main, String sub, String parentFieldName) {
        boolean flag;
        if (StringUtils.isNotEmpty((String)main) && !(flag = this.entry(main, sub, parentFieldName))) {
            this.entry(sub, "", parentFieldName);
        }
    }

    public boolean entry(String entryId, String sub, String parentFieldName) {
        if (StringUtils.isEmpty((String)entryId)) {
            return false;
        }
        Map<String, DynamicObject> map = this.getEntryList();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entryId);
        boolean flag = false;
        Map entityMap = mainEntityType.getAllEntities();
        if (entityMap.size() > 1) {
            this.getPageCache().put(HAS_SUBENTITY, "1");
        } else {
            this.getPageCache().put(HAS_SUBENTITY, "0");
        }
        ArrayList<String> subEntityName = new ArrayList<String>();
        for (Map.Entry entry : entityMap.entrySet()) {
            String key = (String)entry.getKey();
            if (!flag && key.equals(sub)) {
                flag = true;
            }
            EntityType entityType = (EntityType)entry.getValue();
            if (key.equals(entryId) || key.equals(sub)) {
                DataEntityPropertyCollection pros = entityType.getProperties();
                for (IDataEntityProperty property : pros) {
                    Set<String> fieldsShow = entity2FilesShow.get(key);
                    if (null != fieldsShow && !fieldsShow.contains(property.getName())) continue;
                    this.setColumnValue(property, map, key, parentFieldName);
                }
                continue;
            }
            subEntityName.add(entityType.getDisplayName().toString());
        }
        if (subEntityName.size() > 0) {
            StringBuilder subBuiler = new StringBuilder();
            subBuiler.append(ResManager.loadKDString((String)"\u672a\u5173\u8054\u8868\u5355\uff1a", (String)"DataSourceEditPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            subBuiler.append(StringUtil.join(subEntityName, (String)","));
            this.getPageCache().put(HAS_SUBTIPS, subBuiler.toString());
        } else {
            this.getPageCache().put(HAS_SUBTIPS, "");
        }
        return flag;
    }

    private void setColumnValue(IDataEntityProperty property, Map<String, DynamicObject> map, String key, String parentFieldName) {
        String bizsubname;
        String descrice;
        if (!"id".equals(property.getName()) && (property instanceof EntryProp || null == property.getDisplayName())) {
            return;
        }
        String fieldname = null == parentFieldName ? property.getName() : parentFieldName + "." + property.getName();
        boolean isamount = false;
        if (this.needExpand(key, fieldname)) {
            this.createEntry(field2Entity.get(fieldname), "", fieldname);
            return;
        }
        Class propertyType = property.getPropertyType();
        if (propertyType.isAssignableFrom(BigDecimal.class)) {
            isamount = true;
        }
        if (null != property.getDisplayName()) {
            descrice = property.getDisplayName().getLocaleValue();
            bizsubname = property.getDisplayName().getLocaleValue();
        } else if ("id".equals(property.getName())) {
            descrice = fieldname;
            bizsubname = property.getAlias();
        } else {
            descrice = fieldname;
            bizsubname = fieldname;
        }
        if (null == map.get(this.getkey(key, fieldname))) {
            this.setValue(key, fieldname, descrice, bizsubname, isamount);
        }
    }

    private boolean needExpand(String key, String fieldname) {
        if ("entries".equals(key)) {
            return "gl_voucher".equals(this.getPageCache().get(MAIN_KEY)) && "account".equals(fieldname);
        }
        Set<String> fields = dfs.get(key);
        return null != fields && fields.contains(fieldname);
    }

    public void setValue(String entityname, String fieldname, String descrice, String subname, Boolean amountfield) {
        int index = this.getModel().createNewEntryRow(ENTRY_ENTITY);
        this.getModel().setValue("fieldsubname", (Object)entityname, index);
        this.getModel().setValue("fieldname", (Object)fieldname, index);
        this.getModel().setValue("descrice", (Object)descrice, index);
        this.getModel().setValue("bizsubname", (Object)subname, index);
        this.getModel().setValue("state", (Object)"0", index);
        this.getModel().setValue("isamount", (Object)amountfield, index);
        this.getModel().setValue("wherestate", (Object)"1", index);
    }

    public Map<String, DynamicObject> getEntryList() {
        DynamicObjectCollection ds = this.getModel().getEntryEntity(ENTRY_ENTITY);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        for (DynamicObject d : ds) {
            map.put(this.getkey(d.getString("fieldsubname"), d.getString("fieldname")), d);
        }
        return map;
    }

    private String getkey(String fieldsubname, String fieldname) {
        return fieldsubname + "_" + fieldname;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (event.getReturnData() != null) {
            JSONObject reObj;
            String callBackID = event.getActionId();
            IDataModel model = this.getModel();
            if ("formCallBack".equalsIgnoreCase(callBackID)) {
                ListSelectedRowCollection rt = (ListSelectedRowCollection)event.getReturnData();
                String itemNumber = rt.get(0).getNumber();
                model.setValue(ENTITY_NAME, (Object)itemNumber);
                model.setValue("name", (Object)itemNumber);
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)itemNumber);
                Map entityMap = mainEntityType.getAllEntities();
                if (entityMap != null && entityMap.size() > 1) {
                    this.showSubEntityForm(itemNumber);
                }
            } else if ("subFormCallBack".equalsIgnoreCase(callBackID) && (reObj = (JSONObject)event.getReturnData()) != null && reObj.size() > 0) {
                model.setValue(SUB_ENTITY_NAME, (Object)reObj.getString("number"));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ArrayList<String> fieldList;
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (ENTITY_NAME.equals(propertyName)) {
            this.getModel().setValue(SUB_ENTITY_NAME, (Object)"");
            if (StringUtil.isEmpty((CharSequence)((String)changeData.getNewValue()))) {
                this.getModel().setValue(ENTITY_NAME, (Object)"");
                this.getModel().setValue("name", (Object)"");
            }
        }
        if (SUB_ENTITY_NAME.equals(propertyName) && StringUtil.isEmpty((CharSequence)((String)changeData.getNewValue()))) {
            this.getModel().setValue(SUB_ENTITY_NAME, (Object)"");
        }
        if ("orgstate".equals(propertyName) && ((Boolean)changeData.getNewValue()).booleanValue()) {
            this.setFieldProperties(propertyName, changeData.getRowIndex(), null);
        }
        if ("datastate".equals(propertyName) && ((Boolean)changeData.getNewValue()).booleanValue()) {
            fieldList = new ArrayList<String>();
            fieldList.add("yearstate");
            fieldList.add("monthstate");
            this.setFieldProperties(propertyName, changeData.getRowIndex(), fieldList);
        }
        if (("yearstate".equals(propertyName) || "monthstate".equals(propertyName)) && ((Boolean)changeData.getNewValue()).booleanValue()) {
            fieldList = new ArrayList();
            fieldList.add("datastate");
            this.setFieldProperties(propertyName, changeData.getRowIndex(), fieldList);
        }
    }

    private void setFieldProperties(String propertyName, int rowIndex, List<String> fieldList) {
        DynamicObjectCollection ds = this.getModel().getEntryEntity(ENTRY_ENTITY);
        DynamicObjectType dynamicObjectType = ds.getDynamicObjectType();
        for (int i = 0; i < ds.size(); ++i) {
            DynamicObject d = (DynamicObject)ds.get(i);
            if (i == rowIndex) {
                dynamicObjectType.getProperty(propertyName).setValueFast((Object)d, (Object)Boolean.TRUE);
            } else {
                dynamicObjectType.getProperty(propertyName).setValueFast((Object)d, (Object)Boolean.FALSE);
            }
            if (fieldList == null) continue;
            for (String itemName : fieldList) {
                dynamicObjectType.getProperty(itemName).setValueFast((Object)d, (Object)Boolean.FALSE);
            }
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    protected ListShowParameter createAndSetListShowParameter(String billFormId, String fromId, String caption, boolean isMultiSelect) {
        ListShowParameter para = ShowFormHelper.createShowListForm((String)billFormId, (boolean)isMultiSelect);
        para.setCaption(caption);
        para.setFormId(fromId);
        return para;
    }
}

