/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.tax.rules;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class TaxRulesEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTYR_ENTITY = "entryentity";
    private static final String TYPE = "type";
    private static final String ITEM_RESULT = "itemresult";
    private static final String ITEM_CLASS = "itemclass";
    private static final String TYPE_CHANGE = "type_change";
    private static final String OLD_TYPEVALUE = "old_typevalue";
    private static final String ENTRY_CLASS = "entryclass";
    private static final String ENTRY_TYPE = "entrytype";
    private static final String VALUE_NAME = "valuename";
    private static final String BASTAX_ADDRESSTYPE = "bastax_addresstype";
    private static final String BASTAX_PARTY_TYPE = "bastax_party_type";
    private static final String BASTAX_TAXPRODUCT = "bastax_taxproduct";
    private static final String BASTAX_PROCESS_TYPE = "bastax_process_type";

    public void initialize() {
        ItemClassEdit itemClassEdit = (ItemClassEdit)this.getControl(ITEM_RESULT);
        itemClassEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getModel().getValue(ITEM_CLASS) == null) {
            this.getModel().setValue(ITEM_CLASS, (Object)"bastax_taxcode");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (ITEM_RESULT.equals(name)) {
            if (this.getModel().getValue(ITEM_CLASS) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u3010\u7a0e\u7801/\u7a0e\u7ec4\u3011", (String)"TaxRulesEditPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject country = (DynamicObject)this.getModel().getValue("country");
            if (country != null) {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                Date now = new Date();
                QFilter dateFilter = new QFilter("startdate", "<=", (Object)now);
                dateFilter.and(new QFilter("enddate", ">=", (Object)now).or(QFilter.isNull((String)"enddate")));
                qFilters.add(dateFilter);
                qFilters.add(new QFilter("country.id", "=", (Object)country.getLong("id")));
                qFilters.add(new QFilter("enable", "=", (Object)"1"));
                formShowParameter.getListFilterParameter().setQFilters(qFilters);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u56fd\u5bb6\u6216\u5730\u533a\u3011\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxRulesEditPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (TYPE.equals(name)) {
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (oldValue != null) {
                this.showConfirmTips(oldValue.getString("id"));
            } else {
                this.showConfirmTips("");
            }
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTYR_ENTITY);
        if (ENTRY_CLASS.equals(name)) {
            this.getModel().setValue(ENTRY_TYPE, null, rowIndex);
            this.getModel().setValue(VALUE_NAME, null, rowIndex);
            this.getModel().setValue("valueid", null, rowIndex);
            this.getModel().setValue("condition", null, rowIndex);
        } else if (ENTRY_TYPE.equals(name)) {
            this.getModel().setValue(VALUE_NAME, null, rowIndex);
            this.getModel().setValue("valueid", null, rowIndex);
            this.getModel().setValue("condition", null, rowIndex);
        } else if ("condition".equals(name)) {
            this.getModel().setValue(VALUE_NAME, null, rowIndex);
            this.getModel().setValue("valueid", null, rowIndex);
        }
    }

    private void showConfirmTips(String oldValue) {
        if (this.hasEntryRows() && !"true".equals(this.getPageCache().get(TYPE_CHANGE))) {
            this.getPageCache().put(OLD_TYPEVALUE, oldValue);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(TYPE_CHANGE, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TaxRulesEditPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TaxRulesEditPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u4e0d\u540c\u56fd\u5bb6\u7684\u7a0e\u5219\u5206\u7c7b\uff0c\u5c06\u4f1a\u6e05\u7a7a\u3010\u7a0e\u7801/\u7a0e\u7ec4\u3011\u548c\u3010\u89c4\u5219\u6761\u4ef6\u3011\uff0c\u786e\u8ba4\u4fee\u6539\u5417?", (String)"TaxRulesEditPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            this.getPageCache().put(TYPE_CHANGE, "false");
        }
    }

    private boolean hasEntryRows() {
        if (this.getModel().getValue(ITEM_CLASS) != null && this.getModel().getValue(ITEM_RESULT) != null) {
            return true;
        }
        int size = this.getModel().getEntryRowCount(ENTYR_ENTITY);
        return size == 1 && this.getModel().getValue(ENTRY_CLASS, 0) != null && this.getModel().getValue(ENTRY_TYPE, 0) != null || size > 1;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (TYPE_CHANGE.equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getPageCache().put(TYPE_CHANGE, "false");
                this.getModel().setValue(ITEM_CLASS, null);
                this.getModel().deleteEntryData(ENTYR_ENTITY);
                this.getModel().createNewEntryRow(ENTYR_ENTITY);
            } else {
                Long oldId = Long.valueOf(this.getPageCache().get(OLD_TYPEVALUE));
                this.getPageCache().put(TYPE_CHANGE, "true");
                this.getModel().setValue(TYPE, (Object)oldId);
            }
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{VALUE_NAME});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (VALUE_NAME.equalsIgnoreCase(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTYR_ENTITY);
            String itemClass = (String)this.getModel().getValue(ENTRY_CLASS, rowIndex);
            DynamicObject itemType = (DynamicObject)this.getModel().getValue(ENTRY_TYPE, rowIndex);
            String condition = (String)this.getModel().getValue("condition", rowIndex);
            if (itemClass != null && condition != null) {
                DynamicObject country = (DynamicObject)this.getModel().getValue("country");
                if (country == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u56fd\u5bb6\u6216\u5730\u533a\u3011\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxRulesEditPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                String type = String.valueOf(itemType == null ? "" : itemType.get("number"));
                if (itemType == null && !BASTAX_TAXPRODUCT.equals(itemClass)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u3010\u7a0e\u8981\u7d20\u5c0f\u7c7b\u3011", (String)"TaxRulesEditPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                Date now = new Date();
                String formId = "";
                boolean isMultiSelect = false;
                switch (itemClass) {
                    case "bastax_addresstype": {
                        formId = "bastax_addressterms";
                        qFilters.add(new QFilter("addtype.number", "=", (Object)type));
                        break;
                    }
                    case "bastax_party_type": {
                        formId = "bastax_party";
                        qFilters.add(new QFilter("group.number", "=", (Object)type));
                        break;
                    }
                    case "bastax_process_type": {
                        formId = "bastax_process";
                        qFilters.add(new QFilter("group.number", "=", (Object)type));
                        break;
                    }
                    case "bastax_taxproduct": {
                        formId = BASTAX_TAXPRODUCT;
                        break;
                    }
                }
                if (!"=".equals(condition) && !"<>".equals(condition)) {
                    isMultiSelect = true;
                }
                qFilters.add(new QFilter("country.id", "=", (Object)country.getLong("id")));
                qFilters.add(new QFilter("enable", "=", (Object)"1"));
                if (!BASTAX_ADDRESSTYPE.equals(itemClass)) {
                    QFilter date = new QFilter("startdate", "<=", (Object)now);
                    date.and(new QFilter("enddate", ">=", (Object)now).or(QFilter.isNull((String)"enddate")));
                    qFilters.add(date);
                }
                this.showBaseDataForm(formId, isMultiSelect, qFilters);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u8981\u7d20\u5206\u7c7b\u53ca\u6761\u4ef6\u5b57\u6bb5", (String)"TaxRulesEditPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        }
    }

    private void showBaseDataForm(String formId, boolean isMultiSelect, List<QFilter> qFilters) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)formId, (boolean)isMultiSelect);
        listShowParameter.getListFilterParameter().setQFilters(qFilters);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showFormCallBack"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String callBackID;
        if (event.getReturnData() != null && "showFormCallBack".equalsIgnoreCase(callBackID = event.getActionId())) {
            ArrayList<String> ids = new ArrayList<String>();
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> numbers = new ArrayList<String>();
            ListSelectedRowCollection rt = (ListSelectedRowCollection)event.getReturnData();
            for (ListSelectedRow row : rt) {
                ids.add(row.getPrimaryKeyValue().toString());
                numbers.add(row.getNumber());
                names.add(row.getName());
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTYR_ENTITY);
            this.getModel().setValue("valueid", (Object)StringUtils.join((Object[])ids.toArray(), (String)","), rowIndex);
            this.getModel().setValue(VALUE_NAME, (Object)StringUtils.join((Object[])names.toArray(), (String)","), rowIndex);
            this.getModel().setValue("valuenumber", (Object)StringUtils.join((Object[])numbers.toArray(), (String)","), rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            int size = this.getModel().getEntryRowCount(ENTYR_ENTITY);
            for (int i = 0; i < size; ++i) {
                DynamicObject entrytype;
                String entryclass = (String)this.getModel().getValue(ENTRY_CLASS, i);
                if (entryclass == null) {
                    args.setCancel(true);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u884c%s\uff1a\u7a0e\u8981\u7d20\u5927\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxRulesEditPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]), i + 1));
                }
                if ((entrytype = (DynamicObject)this.getModel().getValue(ENTRY_TYPE, i)) != null || BASTAX_TAXPRODUCT.equals(entryclass)) continue;
                args.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u884c%s\uff1a\u8bf7\u5148\u9009\u62e9\u7a0e\u8981\u7d20\u5c0f\u7c7b", (String)"TaxRulesEditPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]), i + 1));
            }
        }
    }
}

