/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.tax.rules;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.BatchFillEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.DynamicObjectCollectionUtil;
import kd.taxc.bdtaxr.formplugin.tax.rules.enums.ValueRulesEnum;

public class ValueRulesEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String VALUERULES_ENTRY = "valuerules_entry";
    private static final String BD_MATERIALGROUP = "bd_materialgroup";
    private static final String MATERIALTAXONOMY = "materialtaxonomy";
    private static final String TAXELEMENT = "taxelement";
    private static final String BASICDATA = "basicdata";
    private static final String materialtaxonomy_change = "materialtaxonomy_change";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BASICDATA});
        ItemClassEdit itemClassEdit = (ItemClassEdit)this.getControl(TAXELEMENT);
        itemClassEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)BASICDATA)) {
            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getValue(ValueRulesEnum.BASICDATATYPE.getKey());
            if (ObjectUtils.isEmpty((Object)dynamicObject)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"ValueRulesEdit_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection taxonomy = (DynamicObjectCollection)this.getView().getModel().getValue(MATERIALTAXONOMY);
            if (StringUtils.equalsIgnoreCase((CharSequence)dynamicObject.getString("id"), (CharSequence)BD_MATERIALGROUP) && taxonomy.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"ValueRulesEdit_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            String entity = dynamicObject.getString("number");
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId(entity);
            FormConfig formConfig = FormMetadataCache.getListFormConfig((String)entity);
            if (ObjectUtils.isEmpty((Object)formConfig)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u6253\u5f00\u5f02\u5e38\u3002", (String)"ValueRulesEdit_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
            if (ObjectUtils.isEmpty((Object)entityType.getAlias())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u7684\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ValueRulesEdit_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            showParameter.setFormId(formConfig.getF7ListFormId());
            StyleCss css = new StyleCss();
            css.setWidth("960px");
            css.setHeight("580px");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setShowTitle(false);
            showParameter.setMultiSelect(true);
            showParameter.setLookUp(true);
            showParameter.setCustomParam("selectaction", (Object)"doOpenParent");
            showParameter.setCustomParam("modeltype", (Object)"BaseFormModel");
            showParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(VALUERULES_ENTRY);
            DynamicObject focusRow = this.getModel().getEntryRowEntity(VALUERULES_ENTRY, entryGrid.getEntryState().getFocusRow());
            showParameter.setSelectedRow(focusRow.get("basicdataid"));
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(VALUERULES_ENTRY);
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "not in", (Object)DynamicObjectCollectionUtil.getPkValueSet((DynamicObjectCollection)dynamicObjectCollection, (String)"basicdataid")));
            if (StringUtils.equalsIgnoreCase((CharSequence)dynamicObject.getString("id"), (CharSequence)BD_MATERIALGROUP)) {
                List taxonomyList = taxonomy.stream().map(o -> o.getDynamicObject("fbasedataid").get("id")).collect(Collectors.toList());
                showParameter.getListFilterParameter().setFilter(new QFilter("standard", "in", (Object)taxonomyList.toArray()));
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BASICDATA);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection listDatas;
        if (StringUtils.equalsIgnoreCase((CharSequence)BASICDATA, (CharSequence)closedCallBackEvent.getActionId()) && !ObjectUtils.isEmpty((Object)(listDatas = (ListSelectedRowCollection)closedCallBackEvent.getReturnData())) && listDatas.size() > 0) {
            ArrayList<String> duplicateValue = new ArrayList<String>(8);
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(VALUERULES_ENTRY);
            boolean isFirst = true;
            for (ListSelectedRow row : listDatas) {
                String itemId = String.valueOf(row.getPrimaryKeyValue());
                String basicdataId = this.isDuplicateValue(itemId);
                if (basicdataId != null) {
                    duplicateValue.add(row.getName());
                    continue;
                }
                EntryGrid orgList = (EntryGrid)this.getControl(VALUERULES_ENTRY);
                int[] indexs = orgList.getSelectRows();
                if (isFirst) {
                    this.getModel().setValue("basicdataid", row.getPrimaryKeyValue(), indexs[0]);
                    this.getModel().setValue("basicdatanumber", (Object)row.getNumber(), indexs[0]);
                    this.getModel().setValue(BASICDATA, (Object)row.getName(), indexs[0]);
                    isFirst = false;
                    continue;
                }
                DynamicObject dynamicObject = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
                int index = this.getModel().createNewEntryRow(VALUERULES_ENTRY, dynamicObject);
                this.getModel().setValue("basicdataid", row.getPrimaryKeyValue(), index);
                this.getModel().setValue("basicdatanumber", (Object)row.getNumber(), index);
                this.getModel().setValue(BASICDATA, (Object)row.getName(), index);
            }
            this.showValueNotification(duplicateValue);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (StringUtils.equalsIgnoreCase((CharSequence)TAXELEMENT, (CharSequence)beforeF7SelectEvent.getProperty().getName())) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("country");
            if (dynamicObject == null) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u672c\u4fe1\u606f\u7684\u56fd\u5bb6\u6216\u5730\u533a\u3002", (String)"ValueRulesEdit_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            QFilter qfilter = new QFilter("country", "=", (Object)dynamicObject.getLong("id"));
            QFilter dateQFilter = new QFilter("enddate", "is null", null).and(new QFilter("startdate", "<=", (Object)new Date()));
            QFilter dateQFilter1 = new QFilter("enddate", "is not null", null).and(new QFilter("startdate", "<=", (Object)new Date())).and(new QFilter("enddate", ">=", (Object)new Date()));
            qfilter.and(dateQFilter.or(dateQFilter1));
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(qfilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject oldValue;
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)ValueRulesEnum.BASICDATATYPE.getKey(), (CharSequence)fieldKey)) {
            DynamicObject newObject = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (null == newObject) {
                return;
            }
            String value = newObject.getString("id");
            if (StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)BD_MATERIALGROUP)) {
                this.setMustInput(MATERIALTAXONOMY, true);
            } else {
                this.setMustInput(MATERIALTAXONOMY, false);
            }
        }
        if (ValueRulesEnum.getKeys().contains(fieldKey)) {
            oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            this.showConfirmTips(fieldKey, oldValue);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)MATERIALTAXONOMY, (CharSequence)fieldKey)) {
            oldValue = (DynamicObjectCollection)e.getChangeSet()[0].getOldValue();
            if (!"true".equals(this.getPageCache().get(materialtaxonomy_change))) {
                List materialtaxonomyIds = oldValue.stream().map(o -> o.getDynamicObject("fbasedataid").get("id")).collect(Collectors.toList());
                this.getPageCache().put(fieldKey, SerializationUtils.toJsonString(materialtaxonomyIds));
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(fieldKey, (IFormPlugin)this);
                DynamicObjectCollection rows = this.getModel().getEntryEntity(VALUERULES_ENTRY);
                if (!ObjectUtils.isEmpty((Object)rows) && rows.size() > 0) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u7269\u6599\u5206\u7c7b\u6807\u51c6\uff0c\u5c06\u6e05\u7a7a\u5217\u8868\u884c\u6570\u636e\uff0c\u786e\u8ba4\u8981\u4fee\u6539\u5417\uff1f", (String)"ValueRulesEdit_5", (String)"taxc-bdtaxr", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                }
            } else {
                this.getPageCache().put(materialtaxonomy_change, "false");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if (ValueRulesEnum.getKeys().contains(fieldKey)) {
            ValueRulesEnum valueRulesEnum = ValueRulesEnum.getEnumByKey(fieldKey);
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put(valueRulesEnum.getChange(), "false");
                this.getModel().deleteEntryData(VALUERULES_ENTRY);
                DynamicObject basicdatatype = (DynamicObject)this.getView().getModel().getValue(ValueRulesEnum.BASICDATATYPE.getKey());
                if (StringUtils.equalsIgnoreCase((CharSequence)ValueRulesEnum.BASICDATATYPE.getKey(), (CharSequence)fieldKey) && !StringUtils.equalsIgnoreCase((CharSequence)basicdatatype.getString("id"), (CharSequence)BD_MATERIALGROUP)) {
                    this.getModel().setValue(MATERIALTAXONOMY, null);
                }
            } else {
                this.getPageCache().put(valueRulesEnum.getChange(), "true");
                this.getModel().setValue(fieldKey, (Object)this.getPageCache().get(fieldKey));
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)MATERIALTAXONOMY, (CharSequence)fieldKey)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put(materialtaxonomy_change, "false");
                this.getModel().deleteEntryData(VALUERULES_ENTRY);
            } else {
                this.getPageCache().put(materialtaxonomy_change, "true");
                List ids = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(fieldKey), Object.class);
                this.getModel().setValue(MATERIALTAXONOMY, (Object)ids.toArray());
            }
        }
    }

    private void showConfirmTips(String fieldKey, DynamicObject oldValue) {
        if (ValueRulesEnum.getKeys().contains(fieldKey)) {
            ValueRulesEnum valueRulesEnum = ValueRulesEnum.getEnumByKey(fieldKey);
            if (!"true".equals(this.getPageCache().get(valueRulesEnum.getChange()))) {
                this.getPageCache().put(fieldKey, ObjectUtils.isEmpty((Object)oldValue) ? "" : oldValue.getString("id"));
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(fieldKey, (IFormPlugin)this);
                DynamicObjectCollection rows = this.getModel().getEntryEntity(VALUERULES_ENTRY);
                if (!ObjectUtils.isEmpty((Object)rows) && rows.size() > 0) {
                    this.getView().showConfirm(valueRulesEnum.getShowConfirm(), MessageBoxOptions.OKCancel, confirmCallBackListener);
                }
            } else {
                this.getPageCache().put(valueRulesEnum.getChange(), "false");
            }
        }
    }

    private void showValueNotification(List<String> list) {
        if (list.size() > 0) {
            String msg = StringUtils.join((Object[])list.toArray(), (String)"\u3001");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u57fa\u7840\u8d44\u6599\u503c\uff1a%s", (String)"ValueRulesEdit_6", (String)"taxc-bdtaxr", (Object[])new Object[0]), msg));
        }
    }

    private String isDuplicateValue(String id) {
        int size = this.getModel().getEntryRowCount(VALUERULES_ENTRY);
        int count = 0;
        for (int i = 0; i < size; ++i) {
            String basicdataId = String.valueOf(this.getModel().getValue("basicdataid", i));
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(VALUERULES_ENTRY);
            if (ObjectUtils.isEmpty((Object)basicdataId) || !StringUtils.equalsIgnoreCase((CharSequence)basicdataId, (CharSequence)id) || entryGrid.getEntryState().getFocusRow() == i || ++count <= 0) continue;
            return basicdataId;
        }
        return null;
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        if (!ObjectUtils.isEmpty((Object)e.getSourceData()) && e.getSourceData() instanceof JSONObject) {
            String basicDataTypeNumber;
            QFilter basicNumber;
            JSONObject jsonObject = (JSONObject)e.getSourceData();
            String countryNumber = jsonObject.getJSONObject("country").getString("number");
            String taxelementType = jsonObject.getString("taxelementtype");
            String basicDataType = jsonObject.getJSONObject(ValueRulesEnum.BASICDATATYPE.getKey()).getString("name");
            QFilter basicName = new QFilter("name", "=", (Object)basicDataType);
            DynamicObjectCollection entityObjects = QueryServiceHelper.query((String)"bos_entityobject", (String)"id,number", (QFilter[])new QFilter[]{basicName, basicNumber = new QFilter("number", "=", (Object)(basicDataTypeNumber = jsonObject.getJSONObject(ValueRulesEnum.BASICDATATYPE.getKey()).getString("number")))});
            if (!ObjectUtils.isEmpty((Object)entityObjects) && entityObjects.size() > 0) {
                JSONArray basicValues = jsonObject.getJSONArray(VALUERULES_ENTRY);
                String entity = ((DynamicObject)entityObjects.get(0)).getString("number");
                for (Object object : basicValues) {
                    DynamicObjectCollection basicDataTpyes;
                    JSONObject row = (JSONObject)object;
                    String basicdata = row.getString(BASICDATA);
                    String basicdataNumber = row.getString("basicdatanumber");
                    QFilter nameFilter = new QFilter("name", "=", (Object)basicdata);
                    QFilter numberFilter = new QFilter("number", "=", (Object)basicdataNumber);
                    String taxelementNumber = row.getJSONObject(TAXELEMENT).getString("number");
                    String taxelementName = row.getJSONObject(TAXELEMENT).getString("name");
                    if (!QueryServiceHelper.exists((String)taxelementType, (QFilter[])new QFilter[]{new QFilter("country.number", "=", (Object)countryNumber).and(new QFilter("number", "=", (Object)taxelementNumber))})) {
                        e.setCancel(true);
                        e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5728\u6240\u5c5e\u7684\u56fd\u5bb6\u6216\u5730\u533a\u67e5\u4e0d\u5230\u7a0e\u52a1\u8981\u7d20\u503c:%s", (String)"ValueRulesEdit_7", (String)"taxc-bdtaxr", (Object[])new Object[0]), taxelementName));
                    }
                    if (!ObjectUtils.isEmpty((Object)(basicDataTpyes = QueryServiceHelper.query((String)entity, (String)"id,number", (QFilter[])new QFilter[]{nameFilter, numberFilter}))) && basicDataTpyes.size() > 0) {
                        DynamicObject dynamicObject = (DynamicObject)basicDataTpyes.get(0);
                        row.put("basicdataid", (Object)dynamicObject.getLong("id"));
                        row.put("basicdatanumber", (Object)dynamicObject.getString("number"));
                        continue;
                    }
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u67e5\u4e0d\u5230\u57fa\u7840\u8d44\u6599\u503c\uff1a%s", (String)"ValueRulesEdit_8", (String)"taxc-bdtaxr", (Object[])new Object[0]), basicdata));
                }
            } else {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\uff1a%s", (String)"ValueRulesEdit_9", (String)"taxc-bdtaxr", (Object[])new Object[0]), basicDataType));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject focusRow;
        String taxelement;
        EntryGrid entryGrid;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof BatchFillEntry && StringUtils.equalsIgnoreCase((CharSequence)TAXELEMENT, (CharSequence)(entryGrid = (EntryGrid)this.getView().getControl(VALUERULES_ENTRY)).getEntryState().getFocusField()) && ObjectUtils.isEmpty((Object)(taxelement = (focusRow = this.getModel().getEntryRowEntity(VALUERULES_ENTRY, entryGrid.getEntryState().getFocusRow())).getString(TAXELEMENT)))) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u503c\u7684\u5355\u5143\u683c\u7528\u4e8e\u586b\u5145\u3002", (String)"ValueRulesEdit_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    private void setMustInput(String key, boolean mustInput) {
        FieldEdit control = (FieldEdit)this.getControl(key);
        control.setMustInput(mustInput);
    }
}

