/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxcalculate;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class FormulaRangePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String FORMULA = "formula";
    private static final String BILL = "bill";
    private static final String TAX_TYPE = "taxtype";
    private static final String NUMBER = "number";
    private static final String ID = "id";

    public void registerListener(EventObject e) {
        BasedataEdit formula = (BasedataEdit)this.getControl(FORMULA);
        formula.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxType = (BasedataEdit)this.getControl(TAX_TYPE);
        taxType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if (FORMULA.equals(evt.getProperty().getName())) {
            DynamicObject bill = (DynamicObject)this.getModel().getValue(BILL);
            if (null == bill) {
                evt.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u8c03\u7528\u5355\u636e\u3002", (String)"FormulaRangePlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            formShowParameter.getListFilterParameter().setFilter(new QFilter(BILL, "=", (Object)bill.getString(NUMBER)));
        } else if (TAX_TYPE.equals(evt.getProperty().getName())) {
            DynamicObject bill = (DynamicObject)this.getModel().getValue(BILL);
            if (null == bill) {
                evt.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8c03\u7528\u5355\u636e\u3002", (String)"FormulaRangePlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] collection = BusinessDataServiceHelper.load((String)"bdtaxr_formula_range", (String)"id,bill,taxtype", (QFilter[])new QFilter[]{new QFilter(BILL, "=", (Object)bill.getString(NUMBER))});
            if (null == collection || collection.length == 0) {
                return;
            }
            HashSet<String> existTaxTypes = new HashSet<String>(16);
            for (DynamicObject dyo : collection) {
                DynamicObject sameBillDyos = dyo.getDynamicObject(TAX_TYPE);
                existTaxTypes.add(sameBillDyos.getString(NUMBER));
            }
            formShowParameter.getListFilterParameter().setFilter(new QFilter(NUMBER, "not in", existTaxTypes));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        if (eventName.startsWith(BILL)) {
            this.getModel().setValue(FORMULA, null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            QFilter idQ;
            QFilter taxTypeQ;
            Object id = this.getModel().getValue(ID);
            DynamicObject bill = (DynamicObject)this.getModel().getValue(BILL);
            DynamicObject taxtype = (DynamicObject)this.getModel().getValue(TAX_TYPE);
            QFilter billQ = new QFilter(BILL, "=", (Object)bill.getString(NUMBER));
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"bdtaxr_formula_range", (String)"id,bill,taxtype", (QFilter[])new QFilter[]{billQ, taxTypeQ = new QFilter(TAX_TYPE, "=", taxtype.get(ID)), idQ = new QFilter(ID, "!=", id)});
            if (null != collection && collection.size() != 0) {
                args.setCancel(true);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u8c03\u7528\u5355\u636e\u5df2\u5b58\u5728\u7a0e\u79cd\u8ba1\u7b97\u516c\u5f0f\uff1a%s", (String)"FormulaRangePlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]), taxtype.getString("name")));
            }
        }
    }
}

