/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.taxc.bdtaxr.business.constant.CheckFailTypeEnum;
import kd.taxc.bdtaxr.business.constant.TaxDeclareConstant;
import kd.taxc.bdtaxr.business.domain.CheckResultDto;
import kd.taxc.bdtaxr.business.multidideclare.DeclareReportHelpService;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceImpl;
import kd.taxc.bdtaxr.business.service.taxdeclare.BaseDataService;
import kd.taxc.bdtaxr.business.service.taxdeclare.ChangeDataService;
import kd.taxc.bdtaxr.business.service.taxdeclare.SavetaxDeclareService;
import kd.taxc.bdtaxr.business.service.taxdeclare.TaxDeclareDataService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.BaseDataServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.ChangeDataServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.SavetaxDeclareServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxDeclareDataServiceImpl;
import kd.taxc.bdtaxr.business.subplugin.declare.DeclareBizExtendHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.DeclareReportLock.DeclareReportLockFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.DeclareReportLock.service.DeclareReportLockService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.buttoncalculate.ButtonCalculateFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.buttoncalculate.service.ButtonCalculateService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declaredynamicrowcalculate.DeclareDynamicRowCalculateFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declaredynamicrowcalculate.service.DeclareDynamicRowCalculateService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.DeclareReportCalculateFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.service.DeclareReportCalculateService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.DeclareReportHideFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.service.DeclareReportHideService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.DeclareReportSaveFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.DeclareReportSaveService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttree.DeclareReportTreeFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttree.service.DeclareReportTreeService;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.declare.initparam.InitParamsService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.declare.model.result.DeclareDynamicRowCalculateServiceResult;
import kd.taxc.bdtaxr.common.dto.DeclareTable;
import kd.taxc.bdtaxr.common.dto.TaxDeclareSaveDataDto;
import kd.taxc.bdtaxr.common.enums.DeclareServiceEnum;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.refactor.declare.savecheck.TaxDeclareCheckFactory;
import kd.taxc.bdtaxr.common.refactor.declare.savecheck.TaxDeclareCheckHandler;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaCollectionVo;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.verify.CheckResult;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.taxdeclare.AbstractTaxDeclarePluginNew;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.DeclareDataCheckVo;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import kd.taxc.bdtaxr.formplugin.taxdeclare.TaxDeclarePlugin;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.BorderCardVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.GetTemplateVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.LoadDeclareDataVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.MultiTctrcwarningVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.TctrcwarningVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class MultiDeclarePlugin
extends AbstractTaxDeclarePluginNew {
    private static Log LOGGER = LogFactory.getLog(TaxDeclarePlugin.class);
    private String CACHE_BASE_KEY;
    private String cacheDeclareRequestKey;
    private String cacheDeclareResponseKey;
    private String cacheEntityFieldsKey;
    private String cacheHtmlTemplateKey;
    private String cacheShowDataKey;
    private IPageCache pageCache;
    private IPageCache parentPageCache;
    private CustomControl control;
    private TaxDeclareCheckHandler check_handler;
    private DeclareReportTreeService declareReportTreeService;
    private DeclareReportSaveService declareReportSaveService;
    private DeclareReportHideService declareReportHideService;
    private DeclareReportLockService declareReportLockService;
    private DeclareReportCalculateService declareReportCalculateService;
    private TaxDeclareDataService taxDeclareDataService = new TaxDeclareDataServiceImpl();
    private static SavetaxDeclareService savetaxDeclareService = new SavetaxDeclareServiceImpl();
    private BaseDataService baseDataService = new BaseDataServiceImpl();
    private ChangeDataService changeDataService = new ChangeDataServiceImpl();

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public String getAttachmentFieldName() {
        return "attachmentpanelap";
    }

    public String getAttachmentPanelName() {
        return "attachmentflex";
    }

    public void initialize() {
        this.pageCache = this.getPageCache();
        this.control = (CustomControl)this.getControl(TaxDeclareConstant.CUSTOM_CONTROL);
    }

    public void afterCreateNewData(EventObject e) {
        this.parentPageCache = this.getView().getParentView().getPageCache();
        try {
            List<BorderCardVo> dataBoardResult;
            long t1 = System.currentTimeMillis();
            DeclareRequestModel requestModel = this.getRequestModel();
            long t2 = System.currentTimeMillis();
            if (requestModel == null) {
                return;
            }
            this.pageCache.put("entity_field_map", this.parentPageCache.get(this.cacheEntityFieldsKey));
            this.pageCache.put("htmlTemplate", this.parentPageCache.get(this.cacheHtmlTemplateKey));
            this.pageCache.put("showData", this.parentPageCache.get(this.cacheShowDataKey));
            this.pageCache.put("declareData", this.parentPageCache.get(this.cacheDeclareResponseKey));
            this.pageCache.put("remark_data", this.parentPageCache.get("remark_data"));
            Map parentUpdataCellMap = (Map)TreeUtils.getCache((IPageCache)this.parentPageCache, (String)"updata_cellid_parent", Map.class);
            if (parentUpdataCellMap != null && !parentUpdataCellMap.isEmpty()) {
                Map updataCellMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"updata_cellid", Map.class);
                if (updataCellMap != null) {
                    updataCellMap.putAll(parentUpdataCellMap);
                    TreeUtils.putCache((IPageCache)this.pageCache, (String)"updata_cellid", (Object)updataCellMap);
                } else {
                    TreeUtils.putCache((IPageCache)this.pageCache, (String)"updata_cellid", (Object)parentUpdataCellMap);
                }
                TreeUtils.removeCache((IPageCache)this.parentPageCache, (String)"updata_cellid_parent");
            }
            Map showData = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"showData", Map.class);
            TemplateVo template = (TemplateVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)"htmlTemplate", TemplateVo.class);
            DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class);
            long t3 = System.currentTimeMillis();
            Map<String, EntityField> typeMap = null;
            long t4 = System.currentTimeMillis();
            LOGGER.info("\u521d\u59cb\u5316\u53c2\u6570\u8017\u65f6\uff1a{}", (Object)(t2 - t1));
            LOGGER.info("\u52a0\u8f7d\u6811\u8017\u65f6\uff1a{}", (Object)(t3 - t2));
            LOGGER.info("\u67e5\u6570\u636e\u7c7b\u578b\u8017\u65f6\uff1a{}", (Object)(t4 - t3));
            if (requestModel.getRefresh().booleanValue() || showData == null || showData.size() == 0 || "cancel".equals(requestModel.getCustomEvent())) {
                responseModel = this.queryData(requestModel, typeMap);
                TaxDeclarePluginService.checkResponse(requestModel, responseModel);
                this.getCache().put("resultData", SerializationUtils.toJsonString((Object)responseModel.getData()));
                showData = responseModel.getData() == null ? new HashMap(0) : responseModel.getData();
                this.baseDataService.queryBaseDataMulti(showData, responseModel.getData(), responseModel.getDynRowList(), requestModel, responseModel.getAllFormulas().getCelltypeFormulas());
                if (typeMap == null) {
                    typeMap = DeclareReportHelpService.getEntityFields(requestModel, responseModel.getDynRowList());
                }
                if ((showData = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_DECLARE_SHOW_DATA, (Object[])new Object[]{showData, responseModel.getAllFormulas().getCelltypeFormulas(), typeMap})) == null) {
                    this.getView().showErrorNotification("data error\uff01");
                    return;
                }
                template = this.handleTemplate(requestModel, showData, template, responseModel, typeMap);
            }
            this.declareReportCalculateService = DeclareReportCalculateFactory.createHandler(requestModel.getTemplateType());
            if (this.declareReportCalculateService != null && !CollectionUtils.isEmpty(dataBoardResult = this.declareReportCalculateService.getDeclareTaxDataBoard(requestModel, responseModel, showData))) {
                TreeUtils.putCache((IPageCache)this.pageCache, (String)"dataBoardResult", dataBoardResult);
            }
            this.baseDataService.queryBaseDataMulti(showData, responseModel.getData(), responseModel.getDynRowList(), requestModel, responseModel.getAllFormulas().getCelltypeFormulas());
            Map<String, Object> treeData = null;
            this.declareReportTreeService = DeclareReportTreeFactory.createHandler(requestModel.getTemplateType());
            if (this.declareReportTreeService != null) {
                treeData = this.declareReportTreeService.loadTreeByCurrentData(requestModel, responseModel, (String)this.getView().getFormShowParameter().getCustomParam("sheetname"), (String)this.getParentViewCustomParam("datatype"), showData);
                TreeUtils.putCache((IPageCache)this.pageCache, (String)"treeData", treeData);
            }
            if (typeMap == null) {
                typeMap = DeclareReportHelpService.getEntityFields(requestModel, responseModel.getDynRowList());
            }
            List<Map<String, String>> checkFormulaList = DeclareReportHelpService.doCheckFormula(requestModel, responseModel, template.getShowItems(), showData, typeMap);
            TctrcwarningVo riskResultMap = TaxDeclarePluginService.getRiskResult(requestModel);
            List<MultiTctrcwarningVo> multiRiskResult = null;
            try {
                multiRiskResult = TaxDeclarePluginService.getMultiRiskResult(requestModel);
            }
            catch (Exception e1) {
                LOGGER.error("\u83b7\u53d6\u7a0e\u52a1\u98ce\u63a7\u7ed3\u679c\u5f02\u5e38\uff1a" + e1.getMessage(), (Throwable)e1);
            }
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"riskResultMap", (Object)riskResultMap);
            if ("read".equals(requestModel.getOperation())) {
                savetaxDeclareService.saveRiskItem(String.valueOf(requestModel.getId()), checkFormulaList, riskResultMap.getTctrcwarning(), 2);
            }
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"entity_field_map", typeMap);
            TreeUtils.putCache((IPageCache)this.parentPageCache, (String)this.cacheEntityFieldsKey, typeMap);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"showData", (Object)showData);
            TreeUtils.putCache((IPageCache)this.parentPageCache, (String)this.cacheShowDataKey, (Object)showData);
            TreeUtils.putCache((IPageCache)this.parentPageCache, (String)"dynRowList", (Object)responseModel.getDynRowList());
            LoadDeclareDataVo loadDeclareDataVo = new LoadDeclareDataVo(showData, checkFormulaList, riskResultMap, requestModel, responseModel, template, this.control, treeData, typeMap, multiRiskResult);
            this.loadPageMulti(loadDeclareDataVo);
            DeclareTable declareTable = MultiTableEnum.getDeclareTable((Long)requestModel.getModelId());
            this.showAttachment(declareTable.getMainTable(), responseModel.getId().toString(), requestModel.getOperation(), requestModel.getTemplateType());
            if (null != this.getView().getParentView()) {
                this.getView().getParentView().getPageCache().put("showData", SerializationUtils.toJsonString((Object)showData));
                this.getView().getParentView().addClientCallBack(null == this.getPageCache().get("sheetid") ? "0" : this.getPageCache().get("sheetid"), Integer.valueOf(0));
                this.getView().sendFormAction(this.getView().getParentView());
            }
        }
        catch (KDBizException ex) {
            LOGGER.error(ex.getMessage());
            this.getView().getParentView().showErrorNotification(ex.getMessage());
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private void loadPageMulti(LoadDeclareDataVo loadDeclareDataVo) {
        if (loadDeclareDataVo == null) {
            return;
        }
        String currentSheetId = this.pageCache.get("sheetid");
        loadDeclareDataVo.setCurrentSheetId(currentSheetId);
        List borderCardVoList = (List)TreeUtils.getCache((IPageCache)this.pageCache, (String)"dataBoardResult", List.class);
        if (!CollectionUtils.isEmpty((Collection)borderCardVoList)) {
            loadDeclareDataVo.setBorderCardVoList(borderCardVoList);
        }
        TaxDeclarePluginService.loadPageMulti(loadDeclareDataVo);
    }

    private TemplateVo handleTemplate(DeclareRequestModel requestModel, Map<String, String> showData, TemplateVo template, DeclareResponseModel responseModel, Map<String, EntityField> typeMap) {
        List<String> hideRows = null;
        Map<String, List<Integer>> hideRowByRowNum = null;
        List<String> hideCols = null;
        List<String> hideModificationNotes = null;
        List<String> hideSheets = null;
        this.declareReportHideService = DeclareReportHideFactory.createHandler(requestModel.getTemplateType());
        if (this.declareReportHideService != null) {
            hideRows = this.declareReportHideService.hideRow(responseModel.getDynRowList());
            hideRowByRowNum = this.declareReportHideService.hideRowByRowNum(requestModel);
            hideCols = this.declareReportHideService.hideCol(requestModel);
            List<String> hideRowsByRequestModel = this.declareReportHideService.hideRowByRequestModel(requestModel);
            if (CollectionUtils.isNotEmpty(hideRowsByRequestModel)) {
                if (hideRows == null) {
                    hideRows = new ArrayList<String>(hideRowsByRequestModel.size());
                }
                hideRows.addAll(hideRowsByRequestModel);
            }
            hideModificationNotes = this.declareReportHideService.hideModificationNotes();
            hideSheets = this.declareReportHideService.hideSheets(requestModel);
        }
        List<String> lockCellKeys = null;
        this.declareReportLockService = DeclareReportLockFactory.createHandler(requestModel.getTemplateType());
        if (this.declareReportLockService != null) {
            lockCellKeys = this.declareReportLockService.lockCells(requestModel, responseModel, showData);
        }
        GetTemplateVo getTemplateVo = new GetTemplateVo(requestModel, responseModel, hideRows, hideRowByRowNum, hideCols, hideModificationNotes, hideSheets, lockCellKeys);
        TemplateVo newTemplate = this.getTemplate(getTemplateVo);
        newTemplate = DeclareReportHelpService.parseTemplateByCurrentData(newTemplate, requestModel, responseModel, typeMap, showData);
        if (template == null) {
            template = new TemplateVo();
        }
        template.setTemplate(newTemplate.getTemplate());
        template.setDynamicRow(newTemplate.getDynamicRow());
        template.setShowItems(newTemplate.getShowItems());
        template.setSheetIdNames(newTemplate.getSheetIdNames());
        this.parentPageCache = this.getView().getParentView().getPageCache();
        Map keyMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"keyMap", Map.class);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"htmlTemplate", (Object)template);
        TreeUtils.putCache((IPageCache)this.parentPageCache, (String)((String)keyMap.get("cacheHtmlTemplateKey")), (Object)template);
        return template;
    }

    private Object getParentViewCustomParam(String key) {
        if (this.getView().getParentView() != null) {
            return this.getView().getParentView().getFormShowParameter().getCustomParam(key);
        }
        return null;
    }

    public void customEvent(CustomEventArgs e) {
        String args = e.getEventArgs();
        String eventName = e.getEventName();
        Map argsMap = (Map)SerializationUtils.fromJsonString((String)args, HashMap.class);
        DeclareRequestModel requestModel = this.getRequestModel();
        DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class);
        Map showAllMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"showData", Map.class);
        if (responseModel == null || showAllMap == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f13\u5b58\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u7f6e\uff01", (String)"MultiDeclarePlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFields(requestModel, responseModel.getDynRowList());
        Map<String, String> currentMap = this.getCurrentMap();
        if ("changeData".equals(eventName)) {
            HashMap<String, String> argsMap1;
            IFormView parentView;
            String msg;
            String cellKey = argsMap.getOrDefault("cellKey", "");
            if (cellKey.endsWith("%")) {
                argsMap.put("cellKey", cellKey.replace("%", ""));
                String value = (String)argsMap.get("value");
                argsMap.put("value", value.replace("%", ""));
            }
            Map celltypeFormulas = null;
            if (responseModel != null && responseModel.getAllFormulas() != null) {
                celltypeFormulas = responseModel.getAllFormulas().getCelltypeFormulas();
            }
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)(msg = (String)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.CHECK_DECLARE_DATA, (Object[])new Object[]{argsMap, celltypeFormulas, typeMap})))) {
                this.getView().showErrorNotification(msg);
            }
            if ((parentView = this.getView().getParentView()) != null) {
                parentView.setEnable(Boolean.valueOf(false), new String[]{"save"});
                this.getView().sendFormAction(parentView);
            }
            if ((argsMap1 = (HashMap<String, String>)TreeUtils.getCache((IPageCache)this.pageCache, (String)"changeDataParams", Map.class)) == null) {
                argsMap1 = new HashMap<String, String>(1);
            }
            argsMap1.put(argsMap.get("cellKey").toString(), argsMap.get("value").toString());
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"changeDataParams", argsMap1);
            this.getView().addClientCallBack("changeDataFunc");
        } else if ("showAddRemark".equals(eventName)) {
            this.showAddRemark(argsMap.get("cellKey").toString());
        } else if ("detail".equals(eventName)) {
            this.showDetail(argsMap, requestModel);
        } else if ("selectSheet".equals(eventName)) {
            this.pageCache.put("sheetid", argsMap.get("data").toString());
            TemplateVo templateMap = (TemplateVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)"htmlTemplate", TemplateVo.class);
            LoadDeclareDataVo loadDeclareDataVo = new LoadDeclareDataVo(showAllMap, null, null, requestModel, responseModel, templateMap, this.control, null, typeMap);
            this.loadPageMulti(loadDeclareDataVo);
            if (null != this.getView().getParentView()) {
                String cacheKey = requestModel.getOrgId() + requestModel.getSkssqq() + requestModel.getSkssqz() + (String)requestModel.getBusinessMap().get("taxsystem") + (String)requestModel.getBusinessMap().get("accountsettype") + "_declareRequest";
                DeclareRequestModel cache = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.getView().getParentView().getPageCache(), (String)cacheKey, DeclareRequestModel.class);
                if (cache != null) {
                    cache.setCustomEvent(eventName);
                }
                TreeUtils.putCache((IPageCache)this.getView().getParentView().getPageCache(), (String)cacheKey, (Object)cache);
                this.getView().getParentView().addClientCallBack(argsMap.get("data").toString());
                this.getView().sendFormAction(this.getView().getParentView());
            }
        } else if ("showBaseData".equals(eventName)) {
            Map map = (Map)argsMap.get("formulaVo");
            String cellId = (String)map.get("formulaKey");
            String value = null == argsMap.get("value") ? "" : argsMap.get("value").toString();
            String formulaName = (String)map.get("formulaName");
            FormulaVo formulaVo = new FormulaVo();
            formulaVo.setFormulaKey(cellId);
            formulaVo.setFormulaName(formulaName);
            formulaName = DeclareReportHelpService.getFormulaNameByCurrentData(showAllMap, requestModel.getBusinessMap(), typeMap, responseModel.getDynRowList(), formulaVo);
            JSONArray jsonArray = JSONArray.parseArray((String)formulaName);
            JSONObject o = (JSONObject)jsonArray.get(0);
            HashMap<String, String> baseDataCache = new HashMap<String, String>(1);
            baseDataCache.put(cellId, value);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"baseDataCache", baseDataCache);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"baseDataFormula", (Object)formulaName);
            String entityId = o.getString("val");
            String minCompany = currentMap.get("tccit_qysds_zb#1#xxwlqy");
            if (cellId.startsWith("tccit_qysds_ext_dyn")) {
                String beforeValue = currentMap.get(cellId);
                String amountCellId = cellId + "amount";
                String beforeAmountValue = currentMap.get(amountCellId);
                if (TaxDeclarePluginService.StringValueExist(beforeValue) || TaxDeclarePluginService.StringValueExist(beforeAmountValue)) {
                    HashMap<String, String> baseParamMap = new HashMap<String, String>();
                    baseParamMap.put("cellId", cellId);
                    baseParamMap.put("entityId", entityId);
                    baseParamMap.put("minCompany", minCompany);
                    this.remindChange(baseParamMap);
                } else {
                    this.showBaseData(cellId, entityId, minCompany, formulaName);
                }
            } else {
                this.showBaseData(cellId, entityId, minCompany, formulaName);
            }
        } else if ("datahref".equals(eventName)) {
            String hrefpara = argsMap.get("hrefData").toString();
            String cellid = argsMap.get("cellKey").toString();
            FormulaVo formulaVo = new FormulaVo();
            formulaVo.setFormulaKey(cellid);
            formulaVo.setFormulaName(hrefpara);
            hrefpara = DeclareReportHelpService.getFormulaNameByCurrentData(showAllMap, requestModel.getBusinessMap(), typeMap, responseModel.getDynRowList(), formulaVo);
            argsMap.put("hrefData", hrefpara);
            this.hyperLinkClick(argsMap, requestModel);
        } else if ("addRow".equals(eventName)) {
            String dynamicRowNo = (String)argsMap.get("data");
            Map<String, String> golVariableKeyMap = this.handleAddDynamicRow(dynamicRowNo, null);
            LoadDeclareDataVo loadDeclareDataVo = this.afterChangeData(golVariableKeyMap);
            this.loadPageMulti(loadDeclareDataVo);
        } else if ("delRow".equals(eventName) && argsMap.get("data") != null) {
            DeclareDynamicRowCalculateServiceResult declareDynamicRowCalculateServiceResult;
            ArrayList cellsData = (ArrayList)argsMap.get("data");
            HashMap<String, String> golVariableKeyMap = new HashMap<String, String>();
            DeclareDynamicRowCalculateService declareDynamicRowCalculateService = DeclareDynamicRowCalculateFactory.createHandler(requestModel.getTemplateType());
            if (declareDynamicRowCalculateService != null && (declareDynamicRowCalculateServiceResult = declareDynamicRowCalculateService.dynamicRowCalculateAfterDelRow(cellsData, requestModel, responseModel, this)) != null) {
                Map dynRowForAdd = declareDynamicRowCalculateServiceResult.getDynRowForAdd();
                Map dynRowCellListForDel = declareDynamicRowCalculateServiceResult.getDynRowCellListForDel();
                Map changeCells = declareDynamicRowCalculateServiceResult.getChangeCells();
                this.doDeclareReportDynAreaAssociationService(dynRowForAdd, dynRowCellListForDel, changeCells, golVariableKeyMap);
            }
            requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareRequest", DeclareRequestModel.class);
            responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class);
            typeMap = DeclareReportHelpService.getEntityFields(requestModel, responseModel.getDynRowList());
            this.deleteRowBusiness(requestModel, responseModel, cellsData, this.getCurrentMap(), typeMap, golVariableKeyMap);
            LoadDeclareDataVo loadDeclareDataVo = this.afterChangeData(golVariableKeyMap);
            this.loadPageMulti(loadDeclareDataVo);
        } else if ("jumptotctrcrisk".equals(eventName)) {
            String tctrcResultId = (String)argsMap.get("data");
            this.jumpToTctrcRisk(tctrcResultId);
        } else if ("dynButtonClick".equals(eventName)) {
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"CUSTOMARGS", (Object)argsMap);
            ButtonCalculateService buttonCalculateService = ButtonCalculateFactory.createHandler(requestModel.getTemplateType());
            CheckResultDto checkResult = buttonCalculateService.checkButtonCalculate(requestModel, responseModel, this);
            if (checkResult.isCheckSuccess()) {
                Map<String, String> resultMap = buttonCalculateService.buttonCalculate(requestModel, responseModel, this);
                TreeUtils.putCache((IPageCache)this.pageCache, (String)"changeDataParams", resultMap);
                this.getView().addClientCallBack("changeDataFunc");
            } else if (CheckFailTypeEnum.SHOW_CONFIRM == checkResult.getFailType()) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("buttonCalculateCheck", (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"MultiDeclarePlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"MultiDeclarePlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                this.getView().showConfirm(checkResult.getFailMessage(), "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            } else if (CheckFailTypeEnum.SHOW_ALERT == checkResult.getFailType()) {
                if (checkResult.isFailIsFinish()) {
                    this.getView().showErrorNotification(checkResult.getFailMessage());
                } else {
                    this.getView().showTipNotification(checkResult.getFailMessage());
                    Map<String, String> resultMap = buttonCalculateService.buttonCalculate(requestModel, responseModel, this);
                    TreeUtils.putCache((IPageCache)this.pageCache, (String)"changeDataParams", resultMap);
                    this.getView().addClientCallBack("changeDataFunc");
                }
            }
        } else if ("showBaseDataDetail".equals(eventName)) {
            JSONObject o;
            boolean isshowdetail;
            Map map = (Map)argsMap.get("formulaVo");
            String cellId = (String)map.get("formulaKey");
            String formulaName = (String)map.get("formulaName");
            FormulaVo formulaVo = new FormulaVo();
            formulaVo.setFormulaKey(cellId);
            formulaVo.setFormulaName(formulaName);
            formulaName = DeclareReportHelpService.getFormulaNameByCurrentData(showAllMap, requestModel.getBusinessMap(), typeMap, responseModel.getDynRowList(), formulaVo);
            JSONArray jsonArray = JSONArray.parseArray((String)formulaName);
            if (jsonArray != null && jsonArray.size() > 0 && (isshowdetail = "true".equals((o = (JSONObject)jsonArray.get(0)).getString("isshowdetail")))) {
                String entityId = o.getString("val");
                this.showBaseDataDetail(cellId, entityId, formulaName);
            }
        }
    }

    private void showBaseDataDetail(String cellId, String entityId, String formulaName) {
        List selectedIds;
        String value;
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "showBaseDataDetail");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        BillShowParameter showParameter = TaxDeclarePluginService.setBaseDataDetail(cellId, entityId, customParams, closeCallBack, formulaName);
        showParameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
        Map showAllMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"showData", Map.class);
        if (showAllMap != null && StringUtil.isNotEmpty((CharSequence)(value = (String)showAllMap.get(cellId))) && CollectionUtils.isNotEmpty((Collection)(selectedIds = TemplateShowUtils.getBaseDataIdList((String)value)))) {
            showParameter.setPkId(selectedIds.get(0));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        Map argsMap1;
        if ("changeDataFunc".equals(e.getName()) && (argsMap1 = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"changeDataParams", Map.class)) != null) {
            this.changeDataBusiness(argsMap1);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnObj = event.getReturnData();
        if (returnObj != null && "bdtaxr_declare_remark".equals(event.getActionId())) {
            Map returnData = (Map)returnObj;
            String cellId = (String)returnData.get("cellid");
            String remark = (String)returnData.get("remark");
            this.changeRemark(cellId, remark);
        } else if (event.getActionId().startsWith("showBaseData") && returnObj != null) {
            ListSelectedRowCollection returnList = (ListSelectedRowCollection)returnObj;
            if (!returnList.isEmpty()) {
                String value;
                String number;
                if (returnList.size() > 100) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u591a\u9009\u57fa\u7840\u8d44\u6599\u6700\u5927\u9009\u62e9\u884c\u6570100\u884c\u3002", (String)"MultiDeclarePlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                Map dataMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"baseDataCache", Map.class);
                DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareRequest", DeclareRequestModel.class);
                DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class);
                Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFields(requestModel, responseModel.getDynRowList());
                Map showAllMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"showData", Map.class);
                Map vriableKeysCollectionMap = responseModel.getVariableKeys();
                HashMap<String, String> varibleKeyList = new HashMap<String, String>(1);
                String cellId = "";
                String beforeValue = "";
                for (Map.Entry entry : dataMap.entrySet()) {
                    cellId = entry.getKey().toString();
                    beforeValue = entry.getValue().toString();
                    if (vriableKeysCollectionMap.get(cellId) == null) continue;
                    varibleKeyList.putAll((Map)vriableKeysCollectionMap.get(cellId));
                }
                String baseDataFormula = (String)TreeUtils.getCache((IPageCache)this.pageCache, (String)"baseDataFormula", String.class);
                JSONArray jsonArray = JSONArray.parseArray((String)baseDataFormula);
                JSONObject o = (JSONObject)(jsonArray != null ? jsonArray.get(0) : null);
                boolean multiSelect = "true".equals(o != null ? o.getString("multiselect") : null);
                boolean quickAddNew = "true".equals(o != null ? o.getString("quickaddnew") : null);
                if (this.checkIsDynCell(cellId) && !multiSelect && quickAddNew && returnList.size() > 1) {
                    ListSelectedRow firstListSelectedRow = returnList.get(0);
                    number = firstListSelectedRow.getNumber();
                    value = firstListSelectedRow.getPrimaryKeyValue().toString();
                    returnList.remove(0);
                    HashMap<String, String> golVariableKeyMap = new HashMap<String, String>();
                    String[] splits = cellId.split("#");
                    this.check_handler = TaxDeclareCheckFactory.createHandler((String)requestModel.getTemplateType());
                    for (ListSelectedRow listSelectedRow : returnList) {
                        String newCellId = splits[0] + "#" + splits[2];
                        String dynamicRowNo = splits[0] + "#1";
                        String dynBaseDataValue = listSelectedRow.getPrimaryKeyValue().toString();
                        String dynBaseDataNumber = listSelectedRow.getNumber();
                        TemplateVo templateMap = (TemplateVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)"htmlTemplate", TemplateVo.class);
                        String newDynBaseDataCellId = MultiDeclarePlugin.getDynBaseDataCellId(templateMap, dynamicRowNo, splits);
                        if (!this.duplicatCheck(newDynBaseDataCellId, dynBaseDataValue, dynBaseDataNumber)) continue;
                        HashMap<String, String> addRowData = new HashMap<String, String>();
                        addRowData.put(newCellId, dynBaseDataValue);
                        golVariableKeyMap.putAll(this.handleAddDynamicRow(dynamicRowNo, addRowData));
                    }
                    varibleKeyList.putAll(golVariableKeyMap);
                } else {
                    value = returnList.stream().map(row -> row.getPrimaryKeyValue().toString()).collect(Collectors.joining("\u3001"));
                    number = returnList.stream().map(row -> row.getNumber()).collect(Collectors.joining("\u3001"));
                }
                if (!value.equals(beforeValue)) {
                    DeclareDynamicRowCalculateServiceResult declareDynamicRowCalculateServiceResult;
                    Map<String, String> currentMap = this.getCurrentMap();
                    this.check_handler = TaxDeclareCheckFactory.createHandler((String)requestModel.getTemplateType());
                    dataMap.put(cellId, value);
                    Map<String, String> changCellMap = this.changCellMap(dataMap, responseModel.getAllFormulas().getCelltypeFormulas(), typeMap);
                    currentMap.putAll(changCellMap);
                    if (!this.duplicatCheck(cellId, value, number)) {
                        return;
                    }
                    this.changeData(currentMap, responseModel, requestModel, varibleKeyList, typeMap);
                    DeclareDynamicRowCalculateService declareDynamicRowCalculateService = DeclareDynamicRowCalculateFactory.createHandler(requestModel.getTemplateType());
                    if (declareDynamicRowCalculateService != null && (declareDynamicRowCalculateServiceResult = declareDynamicRowCalculateService.dynamicRowCalculate(changCellMap, requestModel, responseModel, this)) != null) {
                        Map dynRowForAdd = declareDynamicRowCalculateServiceResult.getDynRowForAdd();
                        Map dynRowCellListForDel = declareDynamicRowCalculateServiceResult.getDynRowCellListForDel();
                        Map dynChangeCellMap = declareDynamicRowCalculateServiceResult.getChangeCells();
                        this.doDeclareReportDynAreaAssociationService(dynRowForAdd, dynRowCellListForDel, dynChangeCellMap, varibleKeyList);
                    }
                    LoadDeclareDataVo loadDeclareDataVo = this.afterChangeData(varibleKeyList);
                    this.loadPageMulti(loadDeclareDataVo);
                }
            }
        } else if (returnObj != null && "cell_click_popup".equals(event.getActionId())) {
            Map returnData = (Map)returnObj;
            String cellId = (String)returnData.get("cellid");
            String value = (String)returnData.get("adjustsumamout");
            Map<String, String> currentMap = this.getCurrentMap();
            if (currentMap == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f13\u5b58\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u7f6e\uff01", (String)"MultiDeclarePlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            String oldValue = currentMap.get(cellId);
            if (!value.equals(oldValue)) {
                HashMap<String, String> changeCellMap = new HashMap<String, String>(1);
                changeCellMap.put(cellId, value);
                this.changeDataBusiness(changeCellMap);
            }
        }
    }

    private static String getDynBaseDataCellId(TemplateVo templateMap, String dynamicRowNo, String[] splits) {
        if (splits.length < 3) {
            return null;
        }
        String newDynBaseDataCellId = null;
        if (templateMap != null) {
            Map dynRow = templateMap.getDynamicRow();
            List lists = (List)dynRow.get(dynamicRowNo);
            int newIndex = lists.size() + 1;
            newDynBaseDataCellId = splits[0] + "#" + newIndex + "#" + splits[2];
        }
        return newDynBaseDataCellId;
    }

    private void changeRemark(String cellId, String remark) {
        HashMap<String, String> remarkMap = (HashMap<String, String>)TreeUtils.getCache((IPageCache)this.pageCache, (String)"remark_data", Map.class);
        if (remarkMap == null) {
            remarkMap = new HashMap<String, String>(16);
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)cellId) && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)remark)) {
            remarkMap.put(cellId, remark);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"remark_data", remarkMap);
        }
    }

    private void changeRemark(Map<String, String> remark) {
        HashMap<String, String> remarkMap = (HashMap<String, String>)TreeUtils.getCache((IPageCache)this.pageCache, (String)"remark_data", Map.class);
        if (remarkMap == null) {
            remarkMap = new HashMap<String, String>(16);
        }
        if (!ObjectUtils.isEmpty(remark)) {
            remarkMap.putAll(remark);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"remark_data", remarkMap);
        }
    }

    private void changeDataBusiness(Map<String, String> changeCellMap) {
        DeclareDynamicRowCalculateServiceResult declareDynamicRowCalculateServiceResult;
        DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareRequest", DeclareRequestModel.class);
        DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class);
        Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFields(requestModel, responseModel.getDynRowList());
        Map keyMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"keyMap", Map.class);
        Map<String, String> currentMap = this.getCurrentMap();
        Map vriableKeysCollectionMap = responseModel.getVariableKeys();
        HashMap<String, String> varibleKeyList = new HashMap<String, String>(1);
        HashMap<String, String> changeData = new HashMap<String, String>(changeCellMap.size());
        for (Map.Entry<String, String> argsMap : changeCellMap.entrySet()) {
            String cellId = argsMap.getKey().toString();
            String value = argsMap.getValue().toString();
            changeData.put(cellId, value);
            if (vriableKeysCollectionMap.get(cellId) == null) continue;
            varibleKeyList.putAll((Map)vriableKeysCollectionMap.get(cellId));
        }
        Map<String, String> changCellMap = this.changCellMap(changeData, responseModel.getAllFormulas().getCelltypeFormulas(), typeMap);
        currentMap.putAll(changCellMap);
        Map<String, String> showData = this.changeData(currentMap, responseModel, requestModel, varibleKeyList, typeMap);
        DeclareDynamicRowCalculateService declareDynamicRowCalculateService = DeclareDynamicRowCalculateFactory.createHandler(requestModel.getTemplateType());
        if (declareDynamicRowCalculateService != null && (declareDynamicRowCalculateServiceResult = declareDynamicRowCalculateService.dynamicRowCalculate(changeCellMap, requestModel, responseModel, this)) != null) {
            Map dynRowForAdd = declareDynamicRowCalculateServiceResult.getDynRowForAdd();
            Map dynRowCellListForDel = declareDynamicRowCalculateServiceResult.getDynRowCellListForDel();
            Map dynChangeCellMap = declareDynamicRowCalculateServiceResult.getChangeCells();
            this.doDeclareReportDynAreaAssociationService(dynRowForAdd, dynRowCellListForDel, dynChangeCellMap, varibleKeyList);
        }
        LoadDeclareDataVo loadDeclareDataVo = this.afterChangeData(varibleKeyList);
        this.loadPageMulti(loadDeclareDataVo);
        if (this.getView().getParentView() != null) {
            this.parentPageCache = this.getView().getParentView().getPageCache();
            this.parentPageCache.put("showData", SerializationUtils.toJsonString(showData));
            this.parentPageCache.put("dynRowList", SerializationUtils.toJsonString((Object)responseModel.getDynRowList()));
            TreeUtils.putCache((IPageCache)this.parentPageCache, (String)((String)keyMap.get("cacheShowDataKey")), showData);
            this.getView().getParentView().addClientCallBack("0", Integer.valueOf(0));
            this.getView().sendFormAction(this.getView().getParentView());
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            parentView.setEnable(Boolean.valueOf(true), new String[]{"save"});
            this.getView().sendFormAction(parentView);
        }
    }

    private LoadDeclareDataVo afterChangeData(Map<String, String> varibleKeyList) {
        DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareRequest", DeclareRequestModel.class);
        DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class);
        Map showAllMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"showData", Map.class);
        TemplateVo template = (TemplateVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)"htmlTemplate", TemplateVo.class);
        Map showData = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"updata_cellid_save", Map.class);
        Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFields(requestModel, responseModel.getDynRowList());
        Map<String, Object> treeData = null;
        this.declareReportTreeService = DeclareReportTreeFactory.createHandler(requestModel.getTemplateType());
        if (this.declareReportTreeService != null) {
            treeData = this.declareReportTreeService.loadTreeByCurrentData(requestModel, responseModel, (String)this.getView().getFormShowParameter().getCustomParam("sheetname"), (String)this.getParentViewCustomParam("datatype"), showData);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"treeData", treeData);
        }
        this.handleTemplate(requestModel, showData, template, responseModel, typeMap);
        List<Map<String, String>> checkFormulaList = DeclareReportHelpService.doCheckFormula(requestModel, responseModel, template != null ? template.getShowItems() : null, showData, typeMap);
        this.baseDataService.queryBaseDataMulti(showData, responseModel.getData(), responseModel.getDynRowList(), requestModel, responseModel.getAllFormulas().getCelltypeFormulas());
        Map changeShowData = new HashMap(1);
        for (String key : varibleKeyList.keySet()) {
            changeShowData.put(key, showData.get(key));
        }
        changeShowData = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_DECLARE_SHOW_DATA, (Object[])new Object[]{showData, responseModel.getAllFormulas().getCelltypeFormulas(), typeMap});
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"updata_cellid_save", (Object)showData);
        showData.putAll(changeShowData);
        showAllMap.putAll(showData);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"showData", (Object)showAllMap);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"declareData", (Object)responseModel);
        TreeUtils.removeCache((IPageCache)this.pageCache, (String)"changeDataParams");
        TctrcwarningVo riskResultMap = (TctrcwarningVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)"riskResultMap", TctrcwarningVo.class);
        LoadDeclareDataVo loadDeclareDataVo = new LoadDeclareDataVo(showAllMap, checkFormulaList, riskResultMap, requestModel, responseModel, template, this.control, treeData, typeMap);
        return loadDeclareDataVo;
    }

    private void addRowBusiness(DeclareRequestModel requestModel, DeclareResponseModel responseModel, Map<String, String> currentMap, Map<String, String> showAllMap, Map<String, EntityField> typeMap, Map<String, String> newDynData, String dynamicRowNo, Map<String, String> gloVariableKeyMap) {
        Map dynRow;
        TemplateVo templateMap = (TemplateVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)"htmlTemplate", TemplateVo.class);
        boolean addTemplate = false;
        DynamicRowModel dynamicRow = null;
        for (DynamicRowModel m : responseModel.getDynRowList()) {
            if (!dynamicRowNo.equals(m.getDynRowNo()) || m.getRowList() == null || m.getRowList().size() <= 0) continue;
            dynamicRow = m;
            addTemplate = true;
        }
        if (addTemplate) {
            templateMap = this.changeDataService.addTemplateRow(templateMap, dynamicRow);
        }
        List listRow = (dynRow = templateMap.getDynamicRow()) != null ? (List)dynRow.get(dynamicRowNo) : new ArrayList(0);
        ArrayList list = listRow.size() > 0 ? (List)listRow.get(listRow.size() - 1) : new ArrayList(0);
        ArrayList<Map<String, Object>> listKeyValue = new ArrayList<Map<String, Object>>(list.size());
        ArrayList<String> cellList = new ArrayList<String>(list.size());
        for (Object el : list) {
            if (el == null || !el.isDynRowCell()) continue;
            String string = el.getCellKey();
            String[] split = string.split("#");
            String originCellKey = split[0] + "#" + split[2];
            cellList.add(string);
            String value = "";
            if (newDynData != null) {
                if (newDynData.get(string) != null) {
                    value = newDynData.get(string);
                } else if (newDynData.get(originCellKey) != null) {
                    value = newDynData.get(originCellKey);
                }
            }
            HashMap<String, String> keyValue = new HashMap<String, String>(1);
            keyValue.put("cellKey", string);
            keyValue.put("value", value);
            listKeyValue.add(keyValue);
        }
        String matchKey = ((Cell)list.get(0)).getCellKey();
        this.changeDataService.addDataRow(responseModel, currentMap, listKeyValue, matchKey);
        typeMap = DeclareReportHelpService.getEntityFields(requestModel, responseModel.getDynRowList());
        for (Map map : listKeyValue) {
            String cellKey = map.get("cellKey").toString();
            Object value = map.get("value");
            String newValue = DataFormatUtils.dataFormatByFieldType(value, (EntityField)typeMap.get(cellKey));
            currentMap.put(cellKey, newValue);
        }
        FormulaCollectionVo allFormulas = (FormulaCollectionVo)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CAL_FORMULAS, (Object[])new Object[]{requestModel, responseModel.getDynRowList()});
        Map map = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CELLTYPE_FORMULAS, (Object[])new Object[]{requestModel.getTemplateId(), responseModel.getDynRowList()});
        allFormulas.setCelltypeFormulas(map);
        responseModel.setAllFormulas(allFormulas);
        Map formulaVoMap = allFormulas.getFormulas();
        Map qformulasMap = allFormulas.getQformulas();
        HashMap<String, HashMap<String, String>> variableKeys = new HashMap<String, HashMap<String, String>>(1);
        for (String key : formulaVoMap.keySet()) {
            HashMap<String, String> v = new HashMap<String, String>();
            TaxDeclarePluginService.calValues(qformulasMap, formulaVoMap, key, v);
            variableKeys.put(key, v);
        }
        HashMap<String, String> variableKeyMap = new HashMap<String, String>();
        cellList.forEach(c -> {
            boolean noneOrPformula;
            boolean bl = noneOrPformula = formulaVoMap.get(c) == null;
            if (variableKeys.get(c) != null && !noneOrPformula) {
                variableKeyMap.putAll((Map)variableKeys.get(c));
            }
        });
        cellList.forEach(c -> {
            boolean noneOrPformula;
            boolean bl = noneOrPformula = formulaVoMap.get(c) == null;
            if (variableKeyMap.get(c) == null && !noneOrPformula) {
                variableKeyMap.put((String)c, (String)c);
            }
        });
        gloVariableKeyMap.putAll(variableKeyMap);
        currentMap = this.changeData(currentMap, responseModel, requestModel, variableKeyMap, typeMap);
        responseModel.setVariableKeys(variableKeys);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"htmlTemplate", (Object)templateMap);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"declareData", (Object)responseModel);
        showAllMap.putAll(currentMap);
        showAllMap = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_DECLARE_SHOW_DATA, (Object[])new Object[]{showAllMap, responseModel.getAllFormulas().getCelltypeFormulas(), typeMap});
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"updata_cellid_save", (Object)showAllMap);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"showData", (Object)showAllMap);
    }

    private void deleteRowBusiness(DeclareRequestModel requestModel, DeclareResponseModel responseModel, ArrayList<Map<String, String>> list, Map<String, String> currentMap, Map<String, EntityField> typeMap, Map<String, String> golVariableKeyMap) {
        Map<String, String> map = list.get(0);
        String dynamicRowNo = map.get("dynRowNo");
        String rowMember = dynamicRowNo.split("#")[0];
        String cellKey = map.get("cellKey");
        String[] cellKeys = cellKey.split("#");
        TemplateVo templateMap = (TemplateVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)"htmlTemplate", TemplateVo.class);
        Map<String, List<List<Cell>>> dynamicRowMap = templateMap.getDynamicRow();
        HashMap changCellMap = new HashMap();
        boolean deleteTemplate = false;
        int dyrowListSize = 0;
        for (DynamicRowModel m : responseModel.getDynRowList()) {
            if (!cellKeys[0].equals(m.getDynRowNo().split("#")[0])) continue;
            dyrowListSize = m.getRowList().size();
            if (m.getRowList() == null || m.getRowList().size() == 0) {
                return;
            }
            if (m.getRowList().size() <= 1) continue;
            deleteTemplate = true;
        }
        int deleteRowNo = Integer.parseInt(cellKeys[1]);
        int startRow = Integer.parseInt(dynamicRowNo.split("#")[1]);
        list.forEach((Consumer<Map<String, String>>)((Consumer<Map>)el -> {
            Object dynRowCellValue = el.get("dynRowCell");
            boolean dynRowCell = dynRowCellValue == null ? Boolean.FALSE : Boolean.valueOf(dynRowCellValue + "");
            if (!dynRowCell) {
                return;
            }
            if (deleteRowNo > startRow) {
                String[] str = ((String)el.get("cellKey")).split("#");
                String newCellKey = str[0] + "#" + (Integer.parseInt(str[1]) - 1) + "#" + str[2];
                changCellMap.put(newCellKey, "");
                return;
            }
            changCellMap.put(el.get("cellKey"), "");
        }));
        if (deleteTemplate) {
            dynamicRowMap = this.changeDataService.deleteTemplateRow(dynamicRowMap, dynamicRowNo, cellKey);
            templateMap.setDynamicRow(dynamicRowMap);
        }
        this.changeDataService.deleteDataRow(responseModel, currentMap, startRow, cellKey, list);
        FormulaCollectionVo allFormulas = (FormulaCollectionVo)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CAL_FORMULAS, (Object[])new Object[]{requestModel, responseModel.getDynRowList()});
        Map cellTypeFormulas = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CELLTYPE_FORMULAS, (Object[])new Object[]{requestModel.getTemplateId(), responseModel.getDynRowList()});
        allFormulas.setCelltypeFormulas(cellTypeFormulas);
        responseModel.setAllFormulas(allFormulas);
        Map formulaVoMap = allFormulas.getFormulas();
        Map qformulasMap = allFormulas.getQformulas();
        HashMap<Object, HashMap<String, String>> variableKeys = new HashMap<Object, HashMap<String, String>>(1);
        for (Object key : formulaVoMap.keySet()) {
            HashMap<String, String> v = new HashMap<String, String>();
            TaxDeclarePluginService.calValues(qformulasMap, formulaVoMap, (String)key, v);
            variableKeys.put(key, v);
        }
        HashMap<String, String> varibleKeyList = new HashMap<String, String>();
        for (Object key : changCellMap.keySet()) {
            boolean noneOrPformula;
            boolean bl = noneOrPformula = formulaVoMap.get(key) == null;
            if (variableKeys.get(key) == null || noneOrPformula) continue;
            varibleKeyList.putAll((Map)variableKeys.get(key));
        }
        Map cFormulas = responseModel.getAllFormulas().getCformulas();
        for (String key : cFormulas.keySet()) {
            boolean noneOrPformula;
            boolean bl = noneOrPformula = formulaVoMap.get(key) == null;
            if (!key.startsWith(rowMember + "#") || noneOrPformula) continue;
            varibleKeyList.put(key, key);
        }
        golVariableKeyMap.putAll(varibleKeyList);
        currentMap = this.changeData(currentMap, responseModel, requestModel, varibleKeyList, typeMap);
        if (dyrowListSize == 1) {
            for (int j = 0; j < list.size(); ++j) {
                if (!currentMap.containsKey(list.get(j).get("cellKey"))) continue;
                currentMap.remove(list.get(j).get("cellKey"));
                currentMap.remove(list.get(j).get("cellKey") + "_text");
            }
        }
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"htmlTemplate", (Object)templateMap);
        currentMap = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_DECLARE_SHOW_DATA, (Object[])new Object[]{currentMap, responseModel.getAllFormulas().getCelltypeFormulas(), typeMap});
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"updata_cellid_save", (Object)currentMap);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"declareData", (Object)responseModel);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"showData", (Object)currentMap);
    }

    private void deleteRowBusinessWithCells(DeclareRequestModel requestModel, DeclareResponseModel responseModel, List<Cell> cells, Map<String, String> currentMap, Map<String, EntityField> typeMap, Map<String, String> golVariableKeyMap) {
        Cell firstCell = cells.get(0);
        String dynamicRowNo = firstCell.getDynRowNo();
        String rowMember = dynamicRowNo.split("#")[0];
        String cellKey = firstCell.getCellKey();
        String[] cellKeys = cellKey.split("#");
        TemplateVo templateMap = (TemplateVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)"htmlTemplate", TemplateVo.class);
        Map<String, List<List<Cell>>> dynamicRowMap = null;
        if (templateMap != null) {
            dynamicRowMap = templateMap.getDynamicRow();
        }
        HashMap changCellMap = new HashMap();
        boolean deleteTemplate = false;
        int dyrowListSize = 0;
        for (DynamicRowModel m : responseModel.getDynRowList()) {
            if (!cellKeys[0].equals(m.getDynRowNo().split("#")[0])) continue;
            dyrowListSize = m.getRowList().size();
            if (m.getRowList() == null || m.getRowList().isEmpty()) {
                return;
            }
            if (m.getRowList().size() <= 1) continue;
            deleteTemplate = true;
        }
        int deleteRowNo = Integer.parseInt(cellKeys[1]);
        int startRow = Integer.parseInt(dynamicRowNo.split("#")[1]);
        cells.forEach(el -> {
            if (!el.isDynRowCell()) {
                return;
            }
            if (deleteRowNo > startRow) {
                String[] str = el.getCellKey().split("#");
                String newCellKey = str[0] + "#" + (Integer.parseInt(str[1]) - 1) + "#" + str[2];
                changCellMap.put(newCellKey, "");
                return;
            }
            changCellMap.put(el.getCellKey(), "");
        });
        if (deleteTemplate) {
            dynamicRowMap = this.changeDataService.deleteTemplateRow(dynamicRowMap, dynamicRowNo, cellKey);
            templateMap.setDynamicRow(dynamicRowMap);
        }
        this.changeDataService.deleteDataRowWithCells(responseModel, currentMap, startRow, cellKey, cells);
        FormulaCollectionVo allFormulas = (FormulaCollectionVo)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CAL_FORMULAS, (Object[])new Object[]{requestModel, responseModel.getDynRowList()});
        Map cellTypeFormulas = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CELLTYPE_FORMULAS, (Object[])new Object[]{requestModel.getTemplateId(), responseModel.getDynRowList()});
        allFormulas.setCelltypeFormulas(cellTypeFormulas);
        responseModel.setAllFormulas(allFormulas);
        Map formulaVoMap = allFormulas.getFormulas();
        Map qformulasMap = allFormulas.getQformulas();
        HashMap<Object, HashMap<String, String>> variableKeys = new HashMap<Object, HashMap<String, String>>(1);
        for (Object key : formulaVoMap.keySet()) {
            HashMap<String, String> v = new HashMap<String, String>();
            TaxDeclarePluginService.calValues(qformulasMap, formulaVoMap, (String)key, v);
            variableKeys.put(key, v);
        }
        HashMap<String, String> varibleKeyList = new HashMap<String, String>();
        for (Object key : changCellMap.keySet()) {
            boolean noneOrPformula;
            boolean bl = noneOrPformula = formulaVoMap.get(key) == null;
            if (variableKeys.get(key) == null || noneOrPformula) continue;
            varibleKeyList.putAll((Map)variableKeys.get(key));
        }
        Map cFormulas = responseModel.getAllFormulas().getCformulas();
        for (String key : cFormulas.keySet()) {
            boolean noneOrPformula;
            boolean bl = noneOrPformula = formulaVoMap.get(key) == null;
            if (!key.startsWith(rowMember + "#") || noneOrPformula) continue;
            varibleKeyList.put(key, key);
        }
        golVariableKeyMap.putAll(varibleKeyList);
        currentMap = this.changeData(currentMap, responseModel, requestModel, varibleKeyList, typeMap);
        if (dyrowListSize == 1) {
            for (int j = 0; j < cells.size(); ++j) {
                if (!currentMap.containsKey(cells.get(j).getCellKey())) continue;
                currentMap.remove(cells.get(j).getCellKey());
                currentMap.remove(cells.get(j).getCellKey() + "_text");
            }
        }
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"htmlTemplate", (Object)templateMap);
        currentMap = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_DECLARE_SHOW_DATA, (Object[])new Object[]{currentMap, responseModel.getAllFormulas().getCelltypeFormulas(), typeMap});
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"updata_cellid_save", (Object)currentMap);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"declareData", (Object)responseModel);
        currentMap = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_DECLARE_SHOW_DATA, (Object[])new Object[]{currentMap, responseModel.getAllFormulas().getCelltypeFormulas(), typeMap});
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"showData", (Object)currentMap);
    }

    public void rangeCalc(IPageCache pageCache, DeclareRequestModel requestModel) {
        this.parentPageCache = this.getView().getParentView().getPageCache();
        Map keyMap = (Map)TreeUtils.getCache((IPageCache)pageCache, (String)"keyMap", Map.class);
        this.initRequestModel(requestModel);
        DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)pageCache, (String)"declareData", DeclareResponseModel.class);
        Map currentMap = (Map)TreeUtils.getCache((IPageCache)pageCache, (String)"updata_cellid_save", Map.class);
        TemplateVo templateVo = (TemplateVo)TreeUtils.getCache((IPageCache)pageCache, (String)"htmlTemplate", TemplateVo.class);
        if (currentMap == null || currentMap.isEmpty()) {
            currentMap = responseModel.getData();
        }
        if (requestModel.getCalcRangeVo() != null) {
            TaxDeclarePluginService.prepareDataByCalc(requestModel, responseModel, currentMap, templateVo, requestModel.getCalcRangeVo(), pageCache);
        } else {
            List<DynamicRowModel> dynList = this.taxDeclareDataService.getDynRowList(requestModel);
            responseModel.setDynRowList(dynList);
            TreeUtils.removeCache((IPageCache)pageCache, (String)"updateCellEntityMap");
        }
        FormulaCollectionVo allFormulas = (FormulaCollectionVo)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CAL_FORMULAS, (Object[])new Object[]{requestModel, responseModel.getDynRowList()});
        Map cellTypeFormulas = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CELLTYPE_FORMULAS, (Object[])new Object[]{requestModel.getTemplateId(), responseModel.getDynRowList()});
        allFormulas.setCelltypeFormulas(cellTypeFormulas);
        responseModel.setAllFormulas(allFormulas);
        HashMap<String, HashMap<String, String>> variableKeys = new HashMap<String, HashMap<String, String>>(100);
        Map formulaVoMap = allFormulas.getFormulas();
        Map qformulasMap = allFormulas.getQformulas();
        for (String key : formulaVoMap.keySet()) {
            HashMap<String, String> v = new HashMap<String, String>(10);
            TaxDeclarePluginService.calValues(qformulasMap, formulaVoMap, key, v);
            variableKeys.put(key, v);
        }
        responseModel.setVariableKeys(variableKeys);
        Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFields(requestModel, responseModel.getDynRowList());
        DeclareResponseModel responseModelNew = DeclareReportHelpService.refreshData(requestModel, responseModel.getAllFormulas(), responseModel.getDynRowList(), typeMap);
        responseModel.setData(responseModelNew.getData());
        TreeUtils.putCache((IPageCache)pageCache, (String)"updata_cellid_save", (Object)responseModel.getData());
        TreeUtils.putCache((IPageCache)pageCache, (String)"declareData", (Object)responseModel);
        TreeUtils.putCache((IPageCache)this.parentPageCache, (String)((String)keyMap.get("cacheDeclareResponseKey")), (Object)responseModel);
        TaxDeclarePluginService.checkResponse(requestModel, responseModel);
        this.getCache().put("resultData", SerializationUtils.toJsonString((Object)responseModel.getData()));
        HashMap<String, String> showData = responseModel.getData() == null ? new HashMap(0) : responseModel.getData();
        showData = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_DECLARE_SHOW_DATA, (Object[])new Object[]{showData, responseModel.getAllFormulas().getCelltypeFormulas(), typeMap});
        templateVo = this.handleTemplate(requestModel, showData, templateVo, responseModel, typeMap);
        this.baseDataService.queryBaseDataMulti(showData, responseModel.getData(), responseModel.getDynRowList(), requestModel, responseModel.getAllFormulas().getCelltypeFormulas());
        Map<String, Object> treeData = null;
        this.declareReportTreeService = DeclareReportTreeFactory.createHandler(requestModel.getTemplateType());
        if (this.declareReportTreeService != null) {
            treeData = this.declareReportTreeService.loadTreeByCurrentData(requestModel, responseModel, (String)this.getView().getFormShowParameter().getCustomParam("sheetname"), (String)this.getParentViewCustomParam("datatype"), showData);
            TreeUtils.putCache((IPageCache)pageCache, (String)"treeData", treeData);
        }
        List<Map<String, String>> checkFormulaList = DeclareReportHelpService.doCheckFormula(requestModel, responseModel, templateVo.getShowItems(), showData, typeMap);
        TctrcwarningVo riskResultMap = TaxDeclarePluginService.getRiskResult(requestModel);
        List<MultiTctrcwarningVo> multiRiskResult = null;
        try {
            multiRiskResult = TaxDeclarePluginService.getMultiRiskResult(requestModel);
        }
        catch (Exception e1) {
            LOGGER.error("\u83b7\u53d6\u7a0e\u52a1\u98ce\u63a7\u7ed3\u679c\u5f02\u5e38\uff1a" + e1.getMessage(), (Throwable)e1);
        }
        TreeUtils.putCache((IPageCache)pageCache, (String)"riskResultMap", (Object)riskResultMap);
        TreeUtils.putCache((IPageCache)pageCache, (String)"entity_field_map", typeMap);
        TreeUtils.putCache((IPageCache)this.parentPageCache, (String)((String)keyMap.get("cacheEntityFieldsKey")), typeMap);
        TreeUtils.putCache((IPageCache)pageCache, (String)"showData", showData);
        TreeUtils.putCache((IPageCache)this.parentPageCache, (String)((String)keyMap.get("cacheShowDataKey")), showData);
        TreeUtils.putCache((IPageCache)this.parentPageCache, (String)"dynRowList", (Object)responseModel.getDynRowList());
        LoadDeclareDataVo loadDeclareDataVo = new LoadDeclareDataVo(showData, checkFormulaList, riskResultMap, requestModel, responseModel, templateVo, this.control, treeData, typeMap, multiRiskResult);
        this.loadPageMulti(loadDeclareDataVo);
        this.getView().getParentView().sendFormAction(this.getView());
    }

    public BaseResult saveClick(IPageCache pageCache, DeclareRequestModel declareRequestModel) {
        DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)pageCache, (String)"declareRequest", DeclareRequestModel.class);
        Map updateMap = (Map)TreeUtils.getCache((IPageCache)pageCache, (String)"updata_cellid", Map.class);
        Map remarkMap = (Map)TreeUtils.getCache((IPageCache)pageCache, (String)"remark_data", Map.class);
        DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)pageCache, (String)"declareData", DeclareResponseModel.class);
        Map currMap = responseModel.getData();
        Map newData = (Map)TreeUtils.getCache((IPageCache)pageCache, (String)"updata_cellid_save", Map.class);
        newData = newData == null ? currMap : newData;
        Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFields(requestModel, responseModel.getDynRowList());
        Map treeData = (Map)TreeUtils.getCache((IPageCache)pageCache, (String)"treeData", Map.class);
        Map keyMap = (Map)TreeUtils.getCache((IPageCache)pageCache, (String)"keyMap", Map.class);
        DeclareDataCheckVo declareDataCheckVo = new DeclareDataCheckVo(newData != null ? newData : currMap, requestModel, responseModel.getDynRowList(), typeMap, null);
        CheckResult checkResult = DeclareReportHelpService.checkBeforeSave(declareDataCheckVo);
        if (!checkResult.isSuccess()) {
            return BaseResult.fail((String)checkResult.getReason());
        }
        BaseResult baseResult = TaxDeclareCheckFactory.createHandler((String)requestModel.getTemplateType()).beforeSaveCheck(updateMap, newData, responseModel);
        if (500 == baseResult.getCode()) {
            return baseResult;
        }
        newData = DataFormatUtils.batchDataToDbTypeFormat((Map)newData, typeMap);
        if (updateMap != null) {
            updateMap = DataFormatUtils.batchDataToDbTypeFormat((Map)updateMap, typeMap);
        }
        Map resultMap = null;
        TaxDeclareSaveDataDto saveDataDto = new TaxDeclareSaveDataDto();
        saveDataDto.setModelId(requestModel.getModelId());
        saveDataDto.setOrgId(requestModel.getOrgId().longValue());
        saveDataDto.setSbbId(requestModel.getId());
        saveDataDto.setSkssqq(requestModel.getSkssqq());
        saveDataDto.setSkssqz(requestModel.getSkssqz());
        saveDataDto.setTemplateType(requestModel.getTemplateType());
        saveDataDto.setRefresh(requestModel.getRefresh());
        saveDataDto.setCustomEvent(requestModel.getCustomEvent());
        saveDataDto.setUniKey(requestModel.getUniKey());
        saveDataDto.setCurrMap(currMap);
        saveDataDto.setUpdateMap(updateMap);
        saveDataDto.setRemarkMap(remarkMap);
        saveDataDto.setTypeMap(typeMap);
        saveDataDto.setNewMaps(newData);
        saveDataDto.setExtendParams(requestModel.getExtendParams());
        saveDataDto.setUpdateNsrxxMap(declareRequestModel.getUpdateNsrxxMap());
        BaseResult saveResultMap = (BaseResult)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.SAVE_DECLARE_DATA, (Object[])new Object[]{saveDataDto});
        if (saveResultMap == null || saveResultMap.getData() == null || !BaseResult.OK.equals(saveResultMap.getCode())) {
            if (saveResultMap != null && !BaseResult.OK.equals(saveResultMap.getCode())) {
                baseResult.setCode(saveResultMap.getCode());
                baseResult.setMessage(saveResultMap.getMessage());
            }
            return baseResult;
        }
        resultMap = (Map)saveResultMap.getData();
        try {
            Map ruleFetchData = (Map)TreeUtils.getCache((IPageCache)pageCache, (String)"updateCellEntityMap", Map.class);
            RuleFetchServiceImpl ruleFetchService = new RuleFetchServiceImpl();
            ruleFetchService.saveRuleFetchAdjustData(ruleFetchData, requestModel);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0b\u94bb\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff01", (String)"MultiDeclarePlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        HashMap<String, Object> requestMap = new HashMap<String, Object>(1);
        if (requestModel.getExtendParams() != null) {
            requestMap.putAll(requestModel.getExtendParams());
        }
        requestMap.put("orgId", requestModel.getOrgId());
        requestMap.put("skssqq", requestModel.getSkssqq());
        requestMap.put("skssqz", requestModel.getSkssqz());
        requestMap.put("Id", requestModel.getId());
        requestMap.putAll(requestModel.getBusinessMap());
        requestMap.put("remarks", declareRequestModel.getBusinessValue("remarks"));
        HashMap<String, Object> resultMap1 = new HashMap<String, Object>(resultMap);
        this.declareReportSaveService = DeclareReportSaveFactory.createHandler(requestModel.getTemplateType());
        if (this.declareReportSaveService != null) {
            BaseResult saveResult = this.declareReportSaveService.saveTeeData(requestModel, treeData);
            BaseResult baseResult2 = this.declareReportSaveService.saveBusinessData(requestMap, resultMap1);
        }
        if (this.getView().getParentView() != null) {
            requestMap.put("pageId", this.getView().getParentView().getPageId());
        }
        DeclareBizExtendHelper.saveBusinessData(requestMap, resultMap1);
        try {
            this.saveAttachment(MultiTableEnum.getDeclareTable((Long)saveDataDto.getModelId()).getMainTable(), saveDataDto.getSbbId().toString(), requestModel.getTemplateType(), TaxAppEnum.TPO.getAppid());
        }
        catch (Exception e) {
            LOGGER.error("save attachments error", (Throwable)e);
        }
        this.sendRiskCalRealTimeTask(requestModel, updateMap, resultMap);
        requestModel.setRefresh(Boolean.valueOf(false));
        DeclareResponseModel responseModelNew = (DeclareResponseModel)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_DECLARE_DATA, (Object[])new Object[]{requestModel});
        responseModel.setData(responseModelNew.getData());
        responseModel.setDynRowList(responseModelNew.getDynRowList());
        TreeUtils.putCache((IPageCache)pageCache, (String)"declareData", (Object)responseModel);
        this.parentPageCache = this.getView().getParentView().getPageCache();
        this.parentPageCache.remove((String)keyMap.get("cacheShowDataKey"));
        TreeUtils.putCache((IPageCache)this.parentPageCache, (String)((String)keyMap.get("cacheDeclareResponseKey")), (Object)responseModel);
        return BaseResult.ok((Object)resultMap);
    }

    private DeclareRequestModel getRequestModel() {
        DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareRequest", DeclareRequestModel.class);
        if (requestModel == null) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            LOGGER.info("TaxDeclarePlugin customParams=" + JsonUtil.toJson((Object)customParams));
            requestModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)((String)customParams.get("declareRequestData")), DeclareRequestModel.class);
            this.initRequestModel(requestModel);
        }
        return requestModel;
    }

    private void initRequestModel(DeclareRequestModel requestModel) {
        Long templateId;
        if (requestModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a", (String)"MultiDeclarePlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        TaxDeclarePluginService.checkParams(requestModel);
        String taxSystem = "";
        String accountSetType = "";
        if (requestModel.getBusinessMap() != null) {
            taxSystem = requestModel.getBusinessMap().getOrDefault("taxsystem", "");
            accountSetType = requestModel.getBusinessMap().getOrDefault("accountsettype", "");
        }
        this.CACHE_BASE_KEY = requestModel.getTemplateType().equals("sdsjt_bd") || requestModel.getTemplateType().equals("sdsjt_jt") ? requestModel.getOrgId() + requestModel.getSkssqq() + requestModel.getSkssqz() + taxSystem + accountSetType + "_%s" : requestModel.getUniKey() + "_%s";
        this.cacheDeclareRequestKey = String.format(this.CACHE_BASE_KEY, "declareRequest");
        this.cacheDeclareResponseKey = String.format(this.CACHE_BASE_KEY, "declareData");
        this.cacheEntityFieldsKey = String.format(this.CACHE_BASE_KEY, "entity_field_map");
        this.cacheHtmlTemplateKey = String.format(this.CACHE_BASE_KEY, "htmlTemplate");
        this.cacheShowDataKey = String.format(this.CACHE_BASE_KEY, "showData");
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("cacheDeclareRequestKey", this.cacheDeclareRequestKey);
        keyMap.put("cacheDeclareResponseKey", this.cacheDeclareResponseKey);
        keyMap.put("cacheEntityFieldsKey", this.cacheEntityFieldsKey);
        keyMap.put("cacheHtmlTemplateKey", this.cacheHtmlTemplateKey);
        keyMap.put("cacheShowDataKey", this.cacheShowDataKey);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"keyMap", keyMap);
        DeclareRequestModel parentCacheRequestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.parentPageCache, (String)this.cacheDeclareRequestKey, DeclareRequestModel.class);
        Long sbbid = requestModel.getId();
        if (sbbid == null) {
            sbbid = TaxDeclarePluginService.generateSBBId(null);
            if (sbbid == null) {
                throw new KDBizException("No Sbb Data !");
            }
            requestModel.setId(sbbid);
        }
        if ((templateId = requestModel.getTemplateId()) == null) {
            TemplateVo templateVo = (TemplateVo)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_BASE_TEMPLATE, (Object[])new Object[]{requestModel.getModelId(), requestModel.getTemplateType(), String.valueOf(requestModel.getOrgId()), DateUtils.stringToDate((String)requestModel.getSkssqq(), (String)"yyyy-MM-dd"), DateUtils.stringToDate((String)requestModel.getSkssqz(), (String)"yyyy-MM-dd")});
            if (templateVo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7533\u62a5\u8868\u6a21\u677f\u5c1a\u672a\u7ef4\u62a4\uff0c\u6682\u4e0d\u652f\u6301\u7533\u62a5", (String)"MultiDeclarePlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            requestModel.setTemplateId(templateVo.getTemplateId());
            requestModel.setTemplateNumber(templateVo.getTemplateNumber());
            requestModel.setBaseTemplate(templateVo.getTemplate());
        }
        Map businessMap = null;
        businessMap = parentCacheRequestModel != null && requestModel.getRefresh() == false ? (parentCacheRequestModel.getBusinessMap() != null ? parentCacheRequestModel.getBusinessMap() : InitParamsService.getInitParams((String)requestModel.getTemplateType()).buildBizParam(requestModel)) : InitParamsService.getInitParams((String)requestModel.getTemplateType()).buildBizParam(requestModel);
        requestModel.getBusinessMap().putAll(businessMap);
        HashMap<String, Object> ruleParamMap = new HashMap<String, Object>();
        ruleParamMap.put("orgId", requestModel.getOrgId());
        if (requestModel.getExtendParams() != null && requestModel.getExtendParams().size() > 0) {
            ruleParamMap.putAll(requestModel.getExtendParams());
        }
        if (businessMap != null) {
            ruleParamMap.putAll(businessMap);
        }
        if (requestModel.getBusinessValue("maindataid") != null) {
            ruleParamMap.put("maindataid", Long.valueOf(requestModel.getBusinessValue("maindataid")));
        }
        ruleParamMap.put("reportId", requestModel.getId());
        ruleParamMap.put("skssqq", requestModel.getSkssqq());
        ruleParamMap.put("skssqz", requestModel.getSkssqz());
        ruleParamMap.put("operation", requestModel.getOperation());
        ruleParamMap.put("modelId", requestModel.getModelId());
        ruleParamMap.put("templateId", requestModel.getTemplateId());
        ruleParamMap.put("cacheId", UUID.randomUUID());
        requestModel.setRuleParamMap(ruleParamMap);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"declareRequest", (Object)requestModel);
        TreeUtils.putCache((IPageCache)this.parentPageCache, (String)"declareRequest", (Object)requestModel);
        TreeUtils.putCache((IPageCache)this.parentPageCache, (String)this.cacheDeclareRequestKey, (Object)requestModel);
    }

    private DeclareResponseModel queryData(DeclareRequestModel requestModel, Map<String, EntityField> typeMap) {
        if (requestModel.getRefresh() == null) {
            requestModel.setRefresh(Boolean.FALSE);
        }
        DeclareResponseModel responseModel = new DeclareResponseModel();
        HashMap<String, HashMap<String, String>> variableKeys = new HashMap<String, HashMap<String, String>>();
        if (requestModel.getRefresh().booleanValue()) {
            List<DynamicRowModel> dynList = this.taxDeclareDataService.getDynRowList(requestModel);
            typeMap = DeclareReportHelpService.getEntityFields(requestModel, dynList);
            FormulaCollectionVo allFormulas = (FormulaCollectionVo)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CAL_FORMULAS, (Object[])new Object[]{requestModel, dynList});
            Map cellTypeFormulas = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CELLTYPE_FORMULAS, (Object[])new Object[]{requestModel.getTemplateId(), dynList});
            allFormulas.setCelltypeFormulas(cellTypeFormulas);
            Map formulaVoMap = allFormulas.getFormulas();
            Map qformulasMap = allFormulas.getQformulas();
            for (String key : formulaVoMap.keySet()) {
                HashMap<String, String> v = new HashMap<String, String>();
                TaxDeclarePluginService.calValues(qformulasMap, formulaVoMap, key, v);
                variableKeys.put(key, v);
            }
            responseModel = DeclareReportHelpService.refreshData(requestModel, allFormulas, dynList, typeMap);
            responseModel.setDynRowList(dynList);
            responseModel.setAllFormulas(allFormulas);
            responseModel.setVariableKeys(variableKeys);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"updata_cellid_save", (Object)responseModel.getData());
        }
        if (!requestModel.getRefresh().booleanValue()) {
            long t1 = System.currentTimeMillis();
            responseModel = this.queryDBData(requestModel, "cancel".equals(requestModel.getCustomEvent()));
            long t2 = System.currentTimeMillis();
            LOGGER.info("\u67e5\u8be2\u6570\u636e\u8017\u65f6\uff1a{}", (Object)(t2 - t1));
            if (responseModel.getAllFormulas() == null || responseModel.getVariableKeys() == null) {
                long t3 = System.currentTimeMillis();
                FormulaCollectionVo allFormulas = (FormulaCollectionVo)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CAL_FORMULAS, (Object[])new Object[]{requestModel, responseModel.getDynRowList()});
                long t4 = System.currentTimeMillis();
                LOGGER.info("\u83b7\u53d6\u516c\u5f0f\u8017\u65f6\uff1a{}", (Object)(t4 - t3));
                Map cellTypeFormulas = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CELLTYPE_FORMULAS, (Object[])new Object[]{requestModel.getTemplateId(), responseModel.getDynRowList()});
                allFormulas.setCelltypeFormulas(cellTypeFormulas);
                responseModel.setAllFormulas(allFormulas);
                Map formulaVoMap = allFormulas.getFormulas();
                Map qformulasMap = allFormulas.getQformulas();
                for (String key : formulaVoMap.keySet()) {
                    HashMap<String, String> v = new HashMap<String, String>();
                    TaxDeclarePluginService.calValues(qformulasMap, formulaVoMap, key, v);
                    variableKeys.put(key, v);
                }
                responseModel.setVariableKeys(variableKeys);
            }
        }
        try {
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"declareData", (Object)responseModel);
            TreeUtils.putCache((IPageCache)this.parentPageCache, (String)this.cacheDeclareResponseKey, (Object)responseModel);
        }
        catch (Exception e) {
            LOGGER.error("\u7f13\u5b58\u5199\u5165\u5931\u8d25");
            LOGGER.error(JSON.toJSONString((Object)responseModel));
        }
        return responseModel;
    }

    private DeclareResponseModel queryDBData(DeclareRequestModel requestModel, Boolean queryDb) {
        DeclareResponseModel responseModel = null;
        responseModel = "history".equals(requestModel.getDataSource()) ? (DeclareResponseModel)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.QUERY_HISTORY_DATA, (Object[])new Object[]{requestModel, this.getView().getFormShowParameter().getCustomParams()}) : (null != (responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class)) && queryDb == false ? responseModel : (DeclareResponseModel)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_DECLARE_DATA, (Object[])new Object[]{requestModel}));
        return responseModel;
    }

    private Map<String, String> changCellMap(Map<String, String> changeData, Map<String, FormulaVo> celltypeFormulas, Map<String, EntityField> typeMap) {
        HashMap dataMap = (HashMap)TreeUtils.getCache((IPageCache)this.pageCache, (String)"updata_cellid", Map.class);
        changeData = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_DECLARE_SHOW_DATA, (Object[])new Object[]{changeData, celltypeFormulas, typeMap});
        if (dataMap == null) {
            dataMap = new HashMap(1);
        }
        dataMap.putAll(changeData);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"updata_cellid", dataMap);
        return changeData;
    }

    private Map<String, String> changeData(Map<String, String> currentMap, DeclareResponseModel responseModel, DeclareRequestModel requestModel, Map<String, String> variableKeys, Map<String, EntityField> typeMap) {
        List<BorderCardVo> dataBoardResult;
        currentMap = (Map<String, String>)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.CHANGE_DECLARE_DATA, (Object[])new Object[]{responseModel, requestModel, variableKeys, currentMap, typeMap});
        this.declareReportCalculateService = DeclareReportCalculateFactory.createHandler(requestModel.getTemplateType());
        if (this.declareReportCalculateService != null && !CollectionUtils.isEmpty(dataBoardResult = this.declareReportCalculateService.getDeclareTaxDataBoard(requestModel, responseModel, currentMap = this.declareReportCalculateService.customAdjustAndCascade(requestModel, responseModel, currentMap)))) {
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"dataBoardResult", dataBoardResult);
        }
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"updata_cellid_save", (Object)currentMap);
        return currentMap;
    }

    private Map<String, String> getCurrentMap() {
        Map currentMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"updata_cellid_save", Map.class);
        if (null == currentMap) {
            DeclareRequestModel requestModel = this.getRequestModel();
            DeclareResponseModel responseModel = this.queryDBData(requestModel, false);
            currentMap = responseModel.getData();
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"updata_cellid_save", (Object)currentMap);
        }
        return currentMap;
    }

    private void hyperLinkClick(Map<String, Object> argsMap, DeclareRequestModel requestModel) {
        String isShow;
        JSONObject hrefJSON;
        String operation = requestModel.getOperation();
        String hrefpara = argsMap.get("hrefData").toString();
        String cellid = argsMap.get("cellKey").toString();
        String locked = argsMap.get("locked") != null ? argsMap.get("locked").toString() : "false";
        IFormView parentView = this.getView().getParentView();
        if (hrefpara.startsWith("[")) {
            hrefpara = hrefpara.substring(1, hrefpara.length() - 1);
        }
        if (hrefpara.endsWith("]")) {
            hrefpara = hrefpara.substring(0, hrefpara.length() - 2);
        }
        if ((hrefJSON = JSONObject.parseObject((String)hrefpara)).containsKey((Object)"isshow") && (isShow = hrefJSON.getString("isshow")).equals("false")) {
            return;
        }
        JSONObject jsonObject = (JSONObject)hrefJSON.get((Object)"text");
        String pluginName = jsonObject.getString("plugin");
        String method = jsonObject.getString("method");
        JSONObject param = jsonObject.getJSONObject("param");
        param.put("operation", (Object)operation);
        param.put("templateId", (Object)requestModel.getTemplateId());
        param.put("locked", (Object)locked);
        param.put("businessParams", (Object)requestModel.getBusinessMap());
        param.put("isCal", (Object)requestModel.getRefresh());
        param = this.replaceCellValue(param, cellid);
        try {
            Class<?> aClass = Class.forName(pluginName);
            if (aClass == null) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u63d2\u4ef6%s", (String)"MultiDeclarePlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), pluginName));
            }
            Method hyperLinkClick = aClass.getMethod(method, String.class, JSONObject.class, IFormView.class, IFormPlugin.class);
            hyperLinkClick.invoke(aClass.newInstance(), new Object[]{cellid, param, this.getView(), this});
            this.getView().sendFormAction(parentView);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public JSONObject replaceCellValue(JSONObject param, String cellid) {
        Map<String, String> resultCache = this.getCurrentMap();
        param.put("cellvalue", (Object)resultCache.get(cellid));
        for (Map.Entry entry : param.entrySet()) {
            if (resultCache.get(entry.getValue()) == null) continue;
            entry.setValue(resultCache.get(entry.getValue()));
        }
        return param;
    }

    private void showAddRemark(String cellId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bdtaxr_declare_remark");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("cellid", (Object)cellId);
        Map remarkMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"remark_data", Map.class);
        showParameter.setCustomParam("remarkValue", remarkMap == null ? null : remarkMap.get(cellId));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bdtaxr_declare_remark");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showDetail(Map<String, Object> argsMap, DeclareRequestModel requestModel) {
        Map map = (Map)argsMap.get("formulaVo");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bdtaxr_declare_detail");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("cellid", (Object)argsMap.get("cellKey").toString());
        showParameter.setCustomParam("sbbid", (Object)String.valueOf(requestModel.getId()));
        showParameter.setCustomParam("formulaVo", (Object)map);
        showParameter.setCustomParam("businessMap", (Object)requestModel.getBusinessMap());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bdtaxr_declare_detail");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showBaseData(String cellId, String entityId, String minCompany, String formulaName) {
        List selectedIds;
        String value;
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "showBaseData");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        ListShowParameter showParameter = TaxDeclarePluginService.setBaseData(cellId, entityId, minCompany, customParams, closeCallBack, formulaName);
        Map showAllMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"showData", Map.class);
        if (showAllMap != null && StringUtil.isNotEmpty((CharSequence)(value = (String)showAllMap.get(cellId))) && CollectionUtils.isNotEmpty((Collection)(selectedIds = TemplateShowUtils.getBaseDataIdList((String)value)))) {
            showParameter.setSelectedRows(selectedIds.toArray());
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private TemplateVo getTemplate(GetTemplateVo getTemplateVo) {
        this.parentPageCache = this.getView().getParentView().getPageCache();
        Map keyMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"keyMap", Map.class);
        TemplateVo templateMap = null;
        if (templateMap == null) {
            templateMap = (TemplateVo)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.PARSE_TEMPLATE, (Object[])new Object[]{getTemplateVo});
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"htmlTemplate", (Object)templateMap);
            TreeUtils.putCache((IPageCache)this.parentPageCache, (String)((String)keyMap.get("cacheHtmlTemplateKey")), (Object)templateMap);
        }
        return templateMap;
    }

    private void remindChange(Map<String, String> argsMap) {
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"orgModifyParams", argsMap);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("orgModifyConform", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"MultiDeclarePlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"MultiDeclarePlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u884c\u6b21\u5df2\u5b58\u5728\u6570\u636e\uff0c\u91cd\u65b0\u9009\u62e9\u4f18\u60e0\u9879\u76ee\u5c06\u4f1a\u8986\u76d6\u5f53\u524d\u5df2\u6709\u4f18\u60e0\u9879\u76ee\u53ca\u91d1\u989d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u7f16\u8f91\uff1f", (String)"MultiDeclarePlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)"orgModifyConform", (String)callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                Map baseParamMap = (Map)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"orgModifyParams", Map.class);
                this.showBaseData((String)baseParamMap.get("cellId"), (String)baseParamMap.get("entityId"), (String)baseParamMap.get("minCompany"), null);
            } else if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
                return;
            }
        } else if (StringUtils.equals((String)"buttonCalculateCheck", (String)callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            DeclareRequestModel requestModel = this.getRequestModel();
            DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class);
            ButtonCalculateService buttonCalculateService = ButtonCalculateFactory.createHandler(requestModel.getTemplateType());
            Map<String, String> resultMap = null;
            if (buttonCalculateService != null) {
                resultMap = buttonCalculateService.buttonCalculate(requestModel, responseModel, this);
            }
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"changeDataParams", resultMap);
            this.getView().addClientCallBack("changeDataFunc");
        }
    }

    private IPageCache getCache() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ParentCache = (String)customParams.get("ParentCache");
        if (Boolean.TRUE.toString().equals(ParentCache)) {
            String parentpageId = (String)customParams.get("rootPageId");
            IFormView parentView = this.getView().getParentView();
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)parentpageId)) {
                parentView = this.getView().getView(parentpageId);
            }
            return parentView == null ? new PageCache(parentpageId) : (IPageCache)parentView.getService(IPageCache.class);
        }
        return this.pageCache;
    }

    private boolean duplicatCheck(String cellId, String value, String number) {
        Map data = (Map)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"updata_cellid_save", Map.class);
        if (null != data && !this.duplicatCheckMap(data, value)) {
            return false;
        }
        return this.check_handler.dynCheck(data, cellId, number);
    }

    private boolean duplicatCheckMap(Map<String, String> map, String value) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().startsWith("tccit_qysds_ext_dyn") && !entry.getKey().startsWith("tccit_nontax_summary_m") && !entry.getKey().startsWith("tccit_qysds_a201020_dyn1") && !entry.getKey().startsWith("tccit_qysds_a201020_dyn2") || !entry.getKey().endsWith("item")) continue;
            if (entry.getValue().equals(value)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"MultiDeclarePlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return false;
            }
            if (!this.isConflict(entry.getValue(), value)) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u52a0\u8ba1\u6263\u9664\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"MultiDeclarePlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isConflict(String ... items) {
        ArrayList conflicts = Lists.newArrayList((Object[])new String[]{"1315279067611882499", "1315279067611882500", "1315279067611882497", "1315279067611882498"});
        return items.length > 1 && conflicts.containsAll(Stream.of(items).collect(Collectors.toList()));
    }

    private void jumpToTctrcRisk(String tctrcResultId) {
        FormShowParameter param = TaxDeclarePluginService.jumpToTctrcRiskParam(tctrcResultId);
        if (param == null) {
            return;
        }
        this.getView().showForm(param);
    }

    public void doDeclareReportDynAreaAssociationService(Map<String, List<Map<String, String>>> dynRowForAdd, Map<String, List<Integer>> dynRowCellListForDel, Map<String, String> changeCells, Map<String, String> golVariableKeyMap) {
        Map<String, EntityField> typeMap;
        DeclareResponseModel responseModel;
        DeclareRequestModel requestModel;
        if (changeCells != null && !changeCells.isEmpty()) {
            this.changeDataWithOutLoadPage(changeCells, golVariableKeyMap);
        }
        if (dynRowForAdd != null && !dynRowForAdd.isEmpty()) {
            requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareRequest", DeclareRequestModel.class);
            responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class);
            typeMap = DeclareReportHelpService.getEntityFields(requestModel, responseModel.getDynRowList());
            for (Map.Entry<String, List<Map<String, String>>> entry : dynRowForAdd.entrySet()) {
                String k = entry.getKey();
                List<Map<String, String>> v = entry.getValue();
                for (Map<String, String> addRowData : v) {
                    Map showAllMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"showData", Map.class);
                    this.addRowBusiness(requestModel, responseModel, this.getCurrentMap(), showAllMap, typeMap, addRowData, k, golVariableKeyMap);
                }
            }
        }
        if (dynRowCellListForDel != null && !dynRowCellListForDel.isEmpty()) {
            requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareRequest", DeclareRequestModel.class);
            responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class);
            typeMap = DeclareReportHelpService.getEntityFields(requestModel, responseModel.getDynRowList());
            TemplateVo templateMap = (TemplateVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)"htmlTemplate", TemplateVo.class);
            for (Map.Entry<String, List<Integer>> entry : dynRowCellListForDel.entrySet()) {
                String k = entry.getKey();
                List<Integer> v = entry.getValue();
                v.sort(Collections.reverseOrder());
                List cellRows = null;
                if (templateMap != null) {
                    cellRows = (List)templateMap.getDynamicRow().get(k);
                }
                for (Integer v1 : v) {
                    if (cellRows != null && v1 > cellRows.size()) {
                        LOGGER.error("dynRowCellListForDel \u53c2\u6570\u4e0b\u6807\u8d8a\u754c\uff0c\u52a8\u6001\u533a\u57df\uff1a{}\u3001\u884c\u53f7\uff1a{}", (Object)k, (Object)v1);
                    }
                    List cells = null;
                    if (cellRows != null) {
                        cells = (List)cellRows.get(v1 - 1);
                    }
                    if (cells == null) continue;
                    this.deleteRowBusinessWithCells(requestModel, responseModel, cells, this.getCurrentMap(), typeMap, golVariableKeyMap);
                }
            }
        }
    }

    public void changeDataWithOutLoadPage(Map<String, String> changeCellMap, Map<String, String> golVariableKeyMap) {
        DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareRequest", DeclareRequestModel.class);
        DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class);
        Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFields(requestModel, responseModel.getDynRowList());
        Map keyMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"keyMap", Map.class);
        Map showAllMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"showData", Map.class);
        TemplateVo template = (TemplateVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)"htmlTemplate", TemplateVo.class);
        Map<String, String> currentMap = this.getCurrentMap();
        Map vriableKeysCollectionMap = responseModel.getVariableKeys();
        HashMap<String, String> varibleKeyList = new HashMap<String, String>(1);
        HashMap<String, String> changeData = new HashMap<String, String>(changeCellMap.size());
        for (Map.Entry<String, String> argsMap : changeCellMap.entrySet()) {
            String cellId = argsMap.getKey().toString();
            String value = argsMap.getValue() == null ? "" : argsMap.getValue().toString();
            changeData.put(cellId, value);
            if (vriableKeysCollectionMap.get(cellId) == null) continue;
            varibleKeyList.putAll((Map)vriableKeysCollectionMap.get(cellId));
        }
        Map<String, String> changCellMap = this.changCellMap(changeData, responseModel.getAllFormulas().getCelltypeFormulas(), typeMap);
        currentMap.putAll(changCellMap);
        golVariableKeyMap.putAll(varibleKeyList);
        Map<String, String> showData = this.changeData(currentMap, responseModel, requestModel, varibleKeyList, typeMap);
        Map<String, String> changeShowData = new HashMap<String, String>(1);
        for (String key : varibleKeyList.keySet()) {
            changeShowData.put(key, showData.get(key));
        }
        changeShowData = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_DECLARE_SHOW_DATA, (Object[])new Object[]{showData, responseModel.getAllFormulas().getCelltypeFormulas(), typeMap});
        showData.putAll(changeShowData);
        if (showAllMap != null) {
            showAllMap.putAll(showData);
        }
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"showData", (Object)showAllMap);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"declareData", (Object)responseModel);
    }

    public Map<String, String> handleAddDynamicRow(String dynamicRowNo, Map<String, String> addRowData) {
        HashMap<String, String> golVariableKeyMap = new HashMap<String, String>();
        DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareRequest", DeclareRequestModel.class);
        DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class);
        Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFields(requestModel, responseModel.getDynRowList());
        Map<String, String> currentMap = this.getCurrentMap();
        Map showAllMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"showData", Map.class);
        this.addRowBusiness(requestModel, responseModel, currentMap, showAllMap, typeMap, null, dynamicRowNo, golVariableKeyMap);
        DeclareDynamicRowCalculateService declareDynamicRowCalculateService = DeclareDynamicRowCalculateFactory.createHandler(requestModel.getTemplateType());
        if (declareDynamicRowCalculateService != null) {
            Map<String, String> addRowDataNewKey;
            DeclareDynamicRowCalculateServiceResult declareDynamicRowCalculateServiceResult = declareDynamicRowCalculateService.dynamicRowCalculateAfterAddRow(dynamicRowNo, requestModel, responseModel, this);
            if (declareDynamicRowCalculateServiceResult != null) {
                Map dynRowForAdd = declareDynamicRowCalculateServiceResult.getDynRowForAdd();
                Map dynRowCellListForDel = declareDynamicRowCalculateServiceResult.getDynRowCellListForDel();
                Map changeCells = declareDynamicRowCalculateServiceResult.getChangeCells();
                this.doDeclareReportDynAreaAssociationService(dynRowForAdd, dynRowCellListForDel, changeCells, golVariableKeyMap);
            }
            if (addRowData != null && !addRowData.isEmpty() && (addRowDataNewKey = this.parseAddRowDataCellKey(addRowData, dynamicRowNo)) != null && !addRowDataNewKey.isEmpty()) {
                declareDynamicRowCalculateServiceResult = declareDynamicRowCalculateService.dynamicRowCalculate(addRowDataNewKey, requestModel, responseModel, this);
                if (declareDynamicRowCalculateServiceResult != null) {
                    Map dynRowForAdd = declareDynamicRowCalculateServiceResult.getDynRowForAdd();
                    Map dynRowCellListForDel = declareDynamicRowCalculateServiceResult.getDynRowCellListForDel();
                    Map changeCells = declareDynamicRowCalculateServiceResult.getChangeCells();
                    this.doDeclareReportDynAreaAssociationService(dynRowForAdd, dynRowCellListForDel, changeCells, golVariableKeyMap);
                }
                this.changeDataWithOutLoadPage(addRowDataNewKey, golVariableKeyMap);
            }
        }
        return golVariableKeyMap;
    }

    private Map<String, String> parseAddRowDataCellKey(Map<String, String> addRowData, String dynamicRowNo) {
        HashMap<String, String> result = new HashMap<String, String>(1);
        TemplateVo templateMap = (TemplateVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)"htmlTemplate", TemplateVo.class);
        Map dynRow = null;
        if (templateMap != null) {
            dynRow = templateMap.getDynamicRow();
        }
        if (dynRow == null) {
            return null;
        }
        List listRow = (List)dynRow.get(dynamicRowNo);
        if (listRow == null || listRow.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, String> entry : addRowData.entrySet()) {
            String k = entry.getKey();
            String v = entry.getValue();
            String[] splits = k.split("#");
            result.put(splits[0] + "#" + listRow.size() + "#" + splits[1], v);
        }
        return result;
    }

    public boolean checkIsDynCell(String cellKey) {
        String[] splits = cellKey.split("#");
        if (splits.length == 3) {
            try {
                Integer.parseInt(splits[1]);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

