/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class RiskItemViewFormPlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        String sbbid1 = (String)this.getView().getFormShowParameter().getCustomParam("sbbid");
        if (StringUtil.isNotEmpty((CharSequence)sbbid1)) {
            Long sbbid = Long.valueOf(sbbid1);
            DynamicObjectCollection items = QueryServiceHelper.query((String)"bdtaxr_declare_risk", (String)"id,sbbid,itemtype,riskdesc,riskresolveid,itemname", (QFilter[])new QFilter("sbbid", "=", (Object)sbbid).toArray());
            Map<String, List<DynamicObject>> groupByMap = items.stream().collect(Collectors.groupingBy(a -> a.getString("itemtype")));
            List<DynamicObject> declareItem = groupByMap.get("1");
            this.updateEntity(declareItem, "");
            List<DynamicObject> riskItem = groupByMap.get("2");
            this.updateEntity(riskItem, "1");
            Tab tab = (Tab)this.getView().getControl("tabap");
            if (riskItem != null && riskItem.size() > 0 && (declareItem == null || declareItem.size() == 0)) {
                tab.activeTab("tabpageap1");
            } else {
                tab.activeTab("tabpageap");
            }
        }
    }

    private void updateEntity(List<DynamicObject> dynamicObjects, String suffix) {
        int row = 0;
        if (EmptyCheckUtils.isNotEmpty(dynamicObjects)) {
            this.getModel().beginInit();
            String entityKey = ENTRYENTITY + suffix;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entityKey);
            for (DynamicObject object : dynamicObjects) {
                DynamicObject dynamicObject = entryEntity.addNew();
                dynamicObject.set("name" + suffix, object.get("itemname"));
                dynamicObject.set("riskdesc" + suffix, object.get("riskdesc"));
            }
            this.getModel().endInit();
            this.getView().updateView(entityKey);
            row = dynamicObjects.size();
        }
        TabPage tabpageap = (TabPage)this.getControl("tabpageap" + suffix);
        String format = "1".equals(suffix) ? ResManager.loadKDString((String)"\u98ce\u63a7\u4e8b\u9879\u98ce\u9669\u63d0\u793a(%d)", (String)"RiskItemViewFormPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7533\u62a5\u4e8b\u9879\u98ce\u9669\u63d0\u793a(%d)", (String)"RiskItemViewFormPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        tabpageap.setText(new LocaleString(String.format(format, row)));
        this.getView().setEnable(Boolean.valueOf(row > 0), new String[]{"tabpageap" + suffix});
    }
}

