/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.taxc.bdtaxr.business.formula.FormulaService;
import kd.taxc.bdtaxr.business.formula.impl.FormulaServiceImpl;
import kd.taxc.bdtaxr.business.multidideclare.DeclareReportHelpService;
import kd.taxc.bdtaxr.business.service.taxdeclare.BaseDataService;
import kd.taxc.bdtaxr.business.service.taxdeclare.ChangeDataService;
import kd.taxc.bdtaxr.business.service.taxdeclare.DeclareRequestService;
import kd.taxc.bdtaxr.business.service.taxdeclare.DeclareTemplateService;
import kd.taxc.bdtaxr.business.service.taxdeclare.SavetaxDeclareService;
import kd.taxc.bdtaxr.business.service.taxdeclare.TaxDeclareDataService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.BaseDataServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.ChangeDataServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.DeclareRequestServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.DeclareTemplateServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.SavetaxDeclareServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxDeclareDataServiceImpl;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.DeclareReportCalculateFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.service.DeclareReportCalculateService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttree.DeclareReportTreeFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttree.service.DeclareReportTreeService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.GetTemplateVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.TctrcwarningVo;
import org.apache.commons.lang3.StringUtils;

public class TaxDeclareCalTask
extends AbstractTask {
    private static final String ARSEDATAFORSHOW = "parseDataForShow";
    private TaxDeclareDataService taxDeclareDataService = new TaxDeclareDataServiceImpl();
    private DeclareTemplateService declareTemplateService = new DeclareTemplateServiceImpl();
    private DeclareReportCalculateService declareReportCalculateService;
    private DeclareRequestService declareRequestService = new DeclareRequestServiceImpl();
    private DeclareReportTreeService declareReportTreeService;
    private BaseDataService baseDataService = new BaseDataServiceImpl();
    private FormulaService formulaService = new FormulaServiceImpl();
    private SavetaxDeclareService savetaxDeclareService = new SavetaxDeclareServiceImpl();
    private ChangeDataService changeDataService = new ChangeDataServiceImpl();
    private String message;

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        try {
            String feedbackMsg = ResManager.loadKDString((String)"\u6570\u636e\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"TaxDeclareCalTask_0", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            this.feedbackProgress(0, feedbackMsg, null);
            String requestStr = (String)params.getOrDefault("declareRequest", "");
            if (StringUtil.isBlank((CharSequence)requestStr)) {
                requestStr = (String)params.getOrDefault("declareRequestData", "");
            }
            if (StringUtil.isBlank((CharSequence)requestStr)) {
                return;
            }
            DeclareRequestModel requestModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)requestStr, DeclareRequestModel.class);
            requestModel = this.declareRequestService.build(requestStr);
            String selectNode = (String)params.getOrDefault("selectNode", "");
            String sourceFrom = (String)params.getOrDefault("sourceFrom", "");
            Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFieldsByMetadata(requestModel, null);
            this.feedbackProgress(10, feedbackMsg, null);
            DeclareResponseModel responseModel = this.queryData(requestModel, typeMap, params);
            this.feedbackProgress(30, feedbackMsg, null);
            TaxDeclarePluginService.checkResponse(requestModel, responseModel);
            Map<String, String> showData = new HashMap<String, String>(responseModel.getData());
            this.baseDataService.queryBaseData(showData, responseModel.getDynRowList(), requestModel);
            this.feedbackProgress(50, feedbackMsg, null);
            GetTemplateVo getTemplateVo = DeclareReportHelpService.getTemplateVo(requestModel, responseModel);
            getTemplateVo.setTypeMap(typeMap);
            TemplateVo template = this.declareTemplateService.getTemplate(getTemplateVo);
            template = DeclareReportHelpService.parseTemplateByCalResponse(template, requestModel, responseModel, typeMap);
            Map<String, Object> treeData = null;
            this.declareReportTreeService = DeclareReportTreeFactory.createHandler(requestModel.getTemplateType());
            if (this.declareReportTreeService != null) {
                treeData = this.declareReportTreeService.loadTreeByCurrentData(requestModel, responseModel, selectNode, sourceFrom, showData);
            }
            this.feedbackProgress(80, feedbackMsg, null);
            List<Map<String, String>> checkFormulaList = this.formulaService.checkFormulasNew(requestModel, showData, responseModel.getParamMap(), responseModel.getDynRowList());
            showData = this.changeDataService.changeToShow(showData, responseModel, typeMap, requestModel.getOperation());
            TctrcwarningVo riskResultMap = TaxDeclarePluginService.getRiskResult(requestModel);
            if ("read".equals(requestModel.getOperation())) {
                this.savetaxDeclareService.saveRiskItem(requestModel.getId().toString(), checkFormulaList, riskResultMap.getTctrcwarning(), 2);
            }
            HashMap<String, String> newTypeMap = new HashMap<String, String>(typeMap.size());
            HashMap<String, String> baseTypeMap = new HashMap<String, String>(50);
            TaxDeclarePluginService.parseTypeMap(typeMap, newTypeMap, baseTypeMap);
            Map<String, Map<String, String>> parseDataForShow = TaxDeclarePluginService.parseShowData(showData, newTypeMap);
            List<String> hisCellList = null;
            if ("read".equals(requestModel.getOperation())) {
                hisCellList = TaxDeclarePluginService.queryHasHisCell(requestModel.getId().toString());
                params.put("hisCellList", SerializationUtils.toJsonString(hisCellList));
            }
            Map sheetCellMap = template.getSheetCellMap();
            params.put("sheetCellMap", SerializationUtils.toJsonString((Object)sheetCellMap));
            params.put("declareRequest", SerializationUtils.toJsonString((Object)requestModel));
            params.put("declareData", SerializationUtils.toJsonString((Object)responseModel));
            params.put("resultData", SerializationUtils.toJsonString((Object)responseModel.getData()));
            params.put("showData", SerializationUtils.toJsonString(showData));
            params.put("htmlTemplate", SerializationUtils.toJsonString((Object)template));
            params.put("riskResultMap", SerializationUtils.toJsonString((Object)riskResultMap));
            params.put("treeData", SerializationUtils.toJsonString(treeData));
            params.put(ARSEDATAFORSHOW, SerializationUtils.toJsonString(parseDataForShow));
            params.put("baseTypeMap", SerializationUtils.toJsonString(baseTypeMap));
            params.put("newTypeMap", SerializationUtils.toJsonString(newTypeMap));
            params.put("checkResultList", SerializationUtils.toJsonString(checkFormulaList));
            this.feedbackCustomdata(params);
        }
        catch (Exception e) {
            params.put("resultStatus", "false");
            params.put("failureReason", e.getMessage());
            this.feedbackCustomdata(params);
        }
    }

    private DeclareResponseModel queryData(DeclareRequestModel requestModel, Map<String, EntityField> metaTypeMap, Map<String, Object> params) {
        if (requestModel.getRefresh() == null) {
            requestModel.setRefresh(Boolean.FALSE);
        }
        DeclareResponseModel responseModel = new DeclareResponseModel();
        if (requestModel.getRefresh().booleanValue()) {
            responseModel = this.refreshData(requestModel, metaTypeMap);
        }
        if (!requestModel.getRefresh().booleanValue()) {
            responseModel = this.queryDBData(requestModel, params);
            metaTypeMap = TaxDeclarePluginService.expanFieldsTypeByDynRow(metaTypeMap, responseModel.getDynRowList());
        }
        return responseModel;
    }

    private DeclareResponseModel refreshData(DeclareRequestModel requestModel, Map<String, EntityField> metaTypeMap) {
        DeclareResponseModel responseModel = this.taxDeclareDataService.refreshData(requestModel, metaTypeMap);
        this.declareReportCalculateService = DeclareReportCalculateFactory.createHandler(requestModel.getTemplateType());
        if (this.declareReportCalculateService != null) {
            responseModel = this.declareReportCalculateService.afterCalculate(requestModel, responseModel, responseModel.getDynRowList(), metaTypeMap);
        }
        return responseModel;
    }

    private DeclareResponseModel queryDBData(DeclareRequestModel requestModel, Map<String, Object> customParams) {
        DeclareResponseModel responseModel = new DeclareResponseModel();
        responseModel = "history".equals(requestModel.getDataSource()) ? this.taxDeclareDataService.queryHistoryData(requestModel, customParams) : ("taxBureau".equals(requestModel.getDataSource()) ? this.taxDeclareDataService.queryTaxBureauData(requestModel, customParams) : this.taxDeclareDataService.queryData(requestModel));
        return responseModel;
    }

    private void allRequiredFieldValidator(String orgId) {
        DynamicObject taxMain;
        if (StringUtils.isNotBlank((CharSequence)orgId) && (taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData()) != null) {
            DynamicObject taxorg = taxMain.getDynamicObject("taxorg");
            String orgname = taxorg.getString("org.name");
            String taxoffice = taxMain.getString("taxoffice.id");
            String registertype = taxMain.getString("registertype.id");
            String registertime = taxMain.getString("registertime");
            String registeraddress = taxMain.getString("registeraddress");
            String codeandname = taxMain.getString("codeandname.id");
            String actualaddress = taxMain.getString("actualaddress");
            String admindivisionObject = taxMain.getString("accountingstandards.id");
            if (StringUtils.isEmpty((CharSequence)registeraddress) || "0".equalsIgnoreCase(admindivisionObject) || "0".equalsIgnoreCase(taxoffice) || "0".equalsIgnoreCase(registertype) || StringUtils.isEmpty((CharSequence)registertime) || "0".equalsIgnoreCase(codeandname) || StringUtils.isEmpty((CharSequence)actualaddress)) {
                ErrorCode errorCode = new ErrorCode("allRequiredField", String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5148\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"TaxDeclarePlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgname));
                throw new KDBizException(errorCode, new Object[0]);
            }
        }
    }
}

