/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.bdtaxr.business.multidideclare.DeclareReportHelpService;
import kd.taxc.bdtaxr.business.multidideclare.UnifiedDeclareBizBusiness;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.unifieddeclarereportlist.UnifiedDeclareReportQueryListFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.unifieddeclarereportlist.service.UnifiedDeclareReportQueryListService;
import kd.taxc.bdtaxr.business.taxdeclare.update.DeclareMainTableSyncBusiness;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.enums.tpo.ModelVersionEnum;
import kd.taxc.bdtaxr.common.helper.tpo.MultiDeclareDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.enums.TaxDeclareMetaRouteEnum;
import kd.taxc.bdtaxr.common.taxorg.TaxNameUtil;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.exception.ThrowableHelper;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.ObjectUtils;
import kd.taxc.bdtaxr.formplugin.taxdeclare.helper.MultiDeclarePageOpenHelper;
import kd.taxc.bdtaxr.formplugin.taxdeclare.helper.UnifiedDeclareReportQueryListHelper;

public class UnifiedDeclareReportQueryListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(UnifiedDeclareReportQueryListPlugin.class);
    private static final String SEPARATOR = System.getProperty("line.separator");
    public static final String REFRESH = "refresh";
    private static final String BILL_LIST = "billlistap";
    private static final String NEW = "new";
    private static final String VIEWHISTORYSBB = "viewhistorysbb";
    private static final String EXPORT = "export";
    private static final String IMPORT = "import";
    private static final String PAY = "pay";
    private static final String VIEWFLOWCHART = "viewflowchart";
    private static final String INVALID = "invalid";
    private static final String RECTIFY = "rectify";
    private static final String ORG_ID = "org.id";

    public UnifiedDeclareReportQueryListService getUnifiedDeclareReportQueryListService() {
        return UnifiedDeclareReportQueryListFactory.getInstance(((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId());
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void setFilter(SetFilterEvent e) {
        String customFilter;
        ArrayList<QFilter> resultFilter = new ArrayList<QFilter>();
        List<String> list = this.getTemplateTypeList();
        if (!CollectionUtils.isEmpty(list)) {
            resultFilter.add(new QFilter("templatetype", "in", list));
        }
        if (StringUtils.isNotEmpty((CharSequence)(customFilter = (String)this.getView().getFormShowParameter().getCustomParam("customFilter")))) {
            QFilter customQFilter = QFilter.fromSerializedString((String)customFilter);
            resultFilter.add(customQFilter);
        }
        e.setCustomQFilters(resultFilter);
    }

    private List<String> getTemplateTypeList() {
        return this.getUnifiedDeclareReportQueryListService().getTemplateTypeList();
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if (ORG_ID.equalsIgnoreCase(args.getFieldName())) {
            List<Long> idList = this.getPermissionOrgIds();
            QFilter orgFilter = new QFilter("id", "in", idList);
            args.getQfilters().add(orgFilter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        FilterContainerInitEvent contInitEvent = args.getFilterContainerInitEvent();
        List filterColumnList = contInitEvent.getCommonFilterColumns();
        for (FilterColumn column : filterColumnList) {
            Object org;
            if ("org.name".equals(column.getFieldName())) {
                List<Long> idList = this.getPermissionOrgIds();
                long orgId = RequestContext.get().getOrgId();
                List<DynamicObject> orgCol = DeclareReportHelpService.queryTaxcOrgByOrgIds(idList);
                List comboItems = orgCol.stream().map(dyo -> {
                    ComboItem item = new ComboItem();
                    item.setValue(dyo.getString("id"));
                    item.setCaption(new LocaleString(dyo.getString("org.name")));
                    return item;
                }).collect(Collectors.toList());
                CommonFilterColumn typeColumn = (CommonFilterColumn)column;
                typeColumn.setComboItems(comboItems);
                if (idList.contains(orgId)) {
                    typeColumn.setDefaultValue(String.valueOf(orgId));
                } else if (!CollectionUtils.isEmpty(idList)) {
                    typeColumn.setDefaultValue(String.valueOf(idList.get(0)));
                }
            }
            if ((org = customParams.get("orgid")) != null && column.getFieldName().equals("org.name") && column instanceof CommonFilterColumn) {
                column.setDefaultValue(org.toString());
                continue;
            }
            Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
            Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
            if (null == skssqq || null == skssqz || !column.getFieldName().equals("skssqq")) continue;
            column.setDefaultValues(new Object[]{DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz)});
        }
    }

    protected List<Long> getPermissionOrgIds() {
        String appid = this.getView().getFormShowParameter().getAppId();
        String entityid = this.getView().getEntityId();
        if (this.getView() instanceof ListView) {
            entityid = ((ListView)this.getView()).getBillFormId();
        }
        List<Long> idList = this.getUnifiedDeclareReportQueryListService().getPermissionOrgIds(appid, entityid, "47150e89000000ac");
        return idList;
    }

    protected boolean isMutexOperate(String operateKey) {
        ArrayList operates = Lists.newArrayList((Object[])new String[]{"delete", "submit", "unsubmit", "audit", "unaudit"});
        return operates.contains(operateKey);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        List<String> ids;
        List<String> errList;
        BillList billlist = (BillList)this.getControl(BILL_LIST);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (this.isMutexOperate(operateKey) && (errList = UnifiedDeclareBizBusiness.checkMutex(ids = list.stream().map(a -> String.valueOf(a.getPrimaryKeyValue())).collect(Collectors.toList()))).size() > 0) {
            args.setCancel(true);
            String errorMsg = errList.stream().collect(Collectors.joining());
            if (errList.size() == 1) {
                this.getView().showTipNotification(errorMsg);
            } else {
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"UnifiedDeclareReportQueryListPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.OK;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002", (String)"UnifiedDeclareReportQueryListPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), errorMsg, options, ConfirmTypes.Save, null, btnNameMaps);
            }
            return;
        }
        if (INVALID.equals(operateKey) || RECTIFY.equals(operateKey)) {
            String keyStr;
            Object source = args.getSource();
            String opreateType = "";
            FormOperate operate = (FormOperate)source;
            if (operate.getOption().containsVariable("type")) {
                opreateType = operate.getOption().getVariableValue("type");
            }
            if ("msgInput".equals(opreateType)) {
                return;
            }
            Set collect = list.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            String string = keyStr = INVALID.equals(operateKey) ? ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"UnifiedDeclareReportQueryListPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u66f4\u6b63", (String)"UnifiedDeclareReportQueryListPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            if (collect.size() != 1) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e%s\u7533\u62a5\u3002", (String)"UnifiedDeclareReportQueryListPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), keyStr));
                args.setCancel(true);
                return;
            }
            String msg = null;
            Object pkValue = list.get(0).getPrimaryKeyValue();
            msg = INVALID.equals(operateKey) ? UnifiedDeclareBizBusiness.checkBeforeInvalid(ObjectUtils.toLong((Object)pkValue)) : UnifiedDeclareBizBusiness.checkBeforeRectify(ObjectUtils.toLong((Object)pkValue));
            if (msg != null) {
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u4e0d\u53ef\u64a4\u9500\uff0c\u5982\u786e\u8ba4\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5f55\u5165\u539f\u56e0\u8bf4\u660e\u3002", (String)"UnifiedDeclareReportQueryListPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        if (this.isCommonOperate(operateKey)) {
            this.doCommonOperate(operateKey);
        } else if (NEW.equals(operateKey)) {
            String querytype = this.getQuerytype(evt.getOperateKey());
            HashMap<String, Object> custom = new HashMap<String, Object>(16);
            custom.put("type", querytype);
            this.showDeclarePage(querytype, null, custom);
        } else if (EXPORT.equals(operateKey)) {
            this.export();
        } else if (IMPORT.equals(operateKey)) {
            this.importExcel();
        } else if (VIEWFLOWCHART.equals(operateKey)) {
            this.viewFlowChart();
        } else if (VIEWHISTORYSBB.equals(operateKey)) {
            this.viewHistorySbb();
        } else if (REFRESH.equals(operateKey)) {
            this.refresh();
        }
    }

    public void refresh() {
        try {
            DeclareMainTableSyncBusiness.refreshModel3Data(Collections.emptyMap());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean isCommonOperate(String operateKey) {
        ArrayList operates = Lists.newArrayList((Object[])new String[]{"delete", "submit", "unsubmit", "audit", "unaudit", PAY, "cancelpay", "apply", "cancelapply", INVALID, RECTIFY});
        return operates.contains(operateKey);
    }

    protected void doCommonOperate(String operateKey) {
        BillList billlist = (BillList)this.getControl(BILL_LIST);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        List<Long> ids = Arrays.stream(list.getPrimaryKeyValues()).map(v -> Long.valueOf(v.toString())).collect(Collectors.toList());
        OperationResult result = UnifiedDeclareBizBusiness.executeOperate(operateKey, ids, OperateOption.create());
        if (result.isSuccess()) {
            if (PAY.equals(operateKey)) {
                FormShowParameter param = new FormShowParameter();
                param.setFormId("bdtaxr_paydate_confirm");
                param.getOpenStyle().setShowType(ShowType.NonModal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payDateConfirm");
                param.setCloseCallBack(closeCallBack);
                this.getView().showForm(param);
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"UnifiedDeclareReportQueryListPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        } else {
            String msg = result.getMessage();
            if (StringUtil.isNotBlank((CharSequence)msg)) {
                String[] messages = msg.split(SEPARATOR);
                if (messages.length == 1) {
                    this.getView().showErrorNotification(msg);
                } else {
                    this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                    OperationResult operationResult = new OperationResult();
                    operationResult.setSuccess(false);
                    operationResult.setMessage(msg);
                    this.getView().showOperationResult(operationResult);
                }
            }
        }
        billlist.refresh();
    }

    protected void importExcel() {
        String appId = this.getView().getFormShowParameter().getAppId();
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bdtaxr_import_dialog_unif");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORT));
        parameter.setCustomParam("source", (Object)"declare");
        List<String> templateTypeList = this.getTemplateTypeList();
        parameter.setCustomParam("templatetypelist", templateTypeList);
        String operateName = ResManager.loadKDString((String)"\u5bfc\u5165", (String)"UnifiedDeclareReportQueryListPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        String operateDescription = String.format(ResManager.loadKDString((String)"\u6253\u5f00\u5bfc\u5165\u7533\u62a5\u8868\u6570\u636e\u5f39\u7a97\u6210\u529f\u3002", (String)"UnifiedDeclareReportQueryListPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]), new Object[0]);
        String taxName = TaxNameUtil.getTaxName((String)appId);
        if ("other".equals(taxName) && templateTypeList.size() > 0) {
            taxName = templateTypeList.get(0);
        }
        OperatorDialogUtils.operateDialog((String)taxName, (String)((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId(), (String)operateName, (String)operateDescription);
        this.getView().showForm(parameter);
    }

    private void export() {
        BillList billlist = (BillList)this.getView().getControl(BILL_LIST);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u8bb0\u5f55\u3002", (String)"UnifiedDeclareReportQueryListPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
        if (collect.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5bfc\u51fa\u591a\u4efd\u7533\u62a5\u8868\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u7533\u62a5\u8bb0\u5f55\u518d\u64cd\u4f5c\u5bfc\u51fa\u3002", (String)"UnifiedDeclareReportQueryListPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        Long pk = ObjectUtils.toLong((Object)list.get(0).getPrimaryKeyValue());
        Map modelVersionEnumMap = (Map)MultiDeclareDataServiceHelper.queryModelVersionByIds((List)Lists.newArrayList((Object[])new Long[]{pk})).getData();
        if (!CollectionUtils.isEmpty((Map)modelVersionEnumMap)) {
            ModelVersionEnum version = (ModelVersionEnum)modelVersionEnumMap.get(pk);
            if (version != null && ModelVersionEnum.MODEL3.getVersion().equals(version.getVersion())) {
                UnifiedDeclareReportQueryListHelper.exportModel3(this.getView());
            } else {
                UnifiedDeclareReportQueryListHelper.exportModel2(this.getView());
            }
        }
    }

    protected void viewFlowChart() {
        BillList billlist = (BillList)this.getControl(BILL_LIST);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u67e5\u770b\u7684\u8bb0\u5f55\u3002", (String)"UnifiedDeclareReportQueryListPlugin_11", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
        if (collect.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u591a\u4e2a\u6d41\u7a0b\u8bb0\u5f55\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u7533\u62a5\u8bb0\u5f55\u518d\u64cd\u4f5c\u3002", (String)"UnifiedDeclareReportQueryListPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        try {
            Long id = Long.valueOf(list.get(0).getPrimaryKeyValue().toString());
            List declares = (List)MultiDeclareDataServiceHelper.queryDeclareMainByIds((List)Lists.newArrayList((Object[])new Long[]{id})).getData();
            if (!CollectionUtils.isEmpty((Collection)declares)) {
                DynamicObject declare = (DynamicObject)declares.get(0);
                String billno = declare.getString("billno");
                String type = declare.getString("templatetype.id");
                String operateName = ResManager.loadKDString((String)"\u67e5\u770b\u6d41\u7a0b\u56fe", (String)"UnifiedDeclareReportQueryListPlugin_13", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u67e5\u770b\u6d41\u7a0b\u56fe\u6210\u529f", (String)"UnifiedDeclareReportQueryListPlugin_14", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno);
                OperatorDialogUtils.operateDialog((String)type, (String)((String)this.getView().getFormShowParameter().getCustomParams().get("billFormId")), (String)operateName, (String)operateDescription);
            }
            WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)list.get(0).getPrimaryKeyValue(), (OpenStyle)openStyle);
        }
        catch (Exception e) {
            logger.error(ThrowableHelper.toString((Exception)e));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"UnifiedDeclareReportQueryListPlugin_15", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    protected void viewHistorySbb() {
        BillList billlist = (BillList)this.getControl(BILL_LIST);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        Set collect = list.stream().map(a -> a.getPrimaryKeyValue()).collect(Collectors.toSet());
        if (collect.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u591a\u4efd\u5386\u53f2\u7248\u672c\uff0c\u8bf7\u4ec5\u52fe\u9009\u4e00\u6761\u7533\u62a5\u8868\u6570\u636e\u518d\u8fdb\u884c\u67e5\u770b\u3002", (String)"UnifiedDeclareReportQueryListPlugin_16", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        Long sbbid = Long.valueOf(list.get(0).getPrimaryKeyValue().toString());
        if (!UnifiedDeclareBizBusiness.existsHistorySbb(sbbid)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u7533\u62a5\u8868\u65e0\u5386\u53f2\u7248\u672c\u3002", (String)"UnifiedDeclareReportQueryListPlugin_17", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Long> customParams = new HashMap<String, Long>(4);
        customParams.put("sbbid", sbbid);
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)UnifiedDeclareBizBusiness.getHistorySbbView(sbbid), (IFormView)this.getView(), customParams, (IFormPlugin)this);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        if (currentSelectedRowInfo == null) {
            return;
        }
        if ("riskcontent".equals(args.getFieldName())) {
            DeclareUtils.showRiskDialog((String)currentSelectedRowInfo.getPrimaryKeyValue().toString(), (IFormView)this.getView());
        } else if ("skssqq".equals(args.getFieldName())) {
            Long id = Long.valueOf(currentSelectedRowInfo.getPrimaryKeyValue().toString());
            List declares = (List)MultiDeclareDataServiceHelper.queryDeclareMainByIds((List)Lists.newArrayList((Object[])new Long[]{id})).getData();
            if (!CollectionUtils.isEmpty((Collection)declares)) {
                DynamicObject declare = (DynamicObject)declares.get(0);
                String type = declare.getString("templatetype.number");
                this.showDeclarePage(type, id, null);
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("skssqq".equals(columnDesc.getKey())) {
            String dataFormat = InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId());
            String skssqq = DateUtils.format((Date)data.getDate("skssqq"), (String)dataFormat);
            String skssqz = DateUtils.format((Date)data.getDate("skssqz"), (String)dataFormat);
            e.setFormatValue((Object)(skssqq + "~" + skssqz));
        } else if ("riskcontent".equals(columnDesc.getKey()) && "normal".equals(e.getFormatValue())) {
            e.getNoLinkKey().add("riskcontent");
        }
    }

    protected void showDeclarePage(String type, Long pkid, Map<String, Object> customParams) {
        if (ObjectUtils.isNotEmpty((Object)pkid)) {
            MultiDeclarePageOpenHelper.openDeclareSbb(this.getView(), type, pkid, null, customParams);
        } else {
            FormShowParameter param = new FormShowParameter();
            TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
            String declarePage = templateEnum.getDeclarePage();
            TaxDeclareMetaRouteEnum metaRouteEnum = TaxDeclareMetaRouteEnum.getEnumByDeclarePage((String)declarePage);
            if (metaRouteEnum == null) {
                param.setFormId(declarePage);
            } else {
                param.setFormId(metaRouteEnum.getThreeMetaEntity());
            }
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(param);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (PAY.equals(event.getCallBackId())) {
            if (event.getResult() == MessageBoxResult.Yes) {
                FormShowParameter param = new FormShowParameter();
                param.setFormId("bdtaxr_paydate_confirm");
                param.getOpenStyle().setShowType(ShowType.NonModal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payDateConfirm");
                param.setCloseCallBack(closeCallBack);
                this.getView().showForm(param);
            }
        } else if ((INVALID.equals(event.getCallBackId()) || RECTIFY.equals(event.getCallBackId())) && event.getResult() == MessageBoxResult.Yes) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            String keyStr = INVALID.equals(event.getCallBackId()) ? ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"UnifiedDeclareReportQueryListPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u66f4\u6b63", (String)"UnifiedDeclareReportQueryListPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            customParams.put("customCaption", String.format(ResManager.loadKDString((String)"%s\u7533\u62a5", (String)"UnifiedDeclareReportQueryListPlugin_18", (String)"taxc-bdtaxr", (Object[])new Object[0]), keyStr));
            customParams.put("inputType", event.getCallBackId());
            BillList billlist = (BillList)this.getControl(BILL_LIST);
            ListSelectedRowCollection list = billlist.getSelectedRows();
            Object[] pkIds = list.getPrimaryKeyValues();
            customParams.put("pkid", pkIds[0]);
            Long pkid = ObjectUtils.toLong((Object)pkIds[0]);
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)UnifiedDeclareBizBusiness.getDeclareMsgInputView(pkid), (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals(IMPORT)) {
            BillList billList = (BillList)this.getView().getControl(BILL_LIST);
            billList.refresh();
        } else if (actionId.equals("payDateConfirm")) {
            Date payDate = (Date)closedCallBackEvent.getReturnData();
            if (payDate == null) {
                return;
            }
            BillList billList = (BillList)this.getView().getControl(BILL_LIST);
            ListSelectedRowCollection list = billList.getSelectedRows();
            Object[] pkIds = list.getPrimaryKeyValues();
            List<Long> ids = Arrays.stream(pkIds).map(v -> ObjectUtils.toLong((Object)v)).collect(Collectors.toList());
            UnifiedDeclareBizBusiness.pay(ids, payDate);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"UnifiedDeclareReportQueryListPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            billList.refresh();
        }
    }

    public String getQuerytype(String operateKey) {
        return (String)this.getView().getFormShowParameter().getCustomParam("querytype");
    }
}

