/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare.helper;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.multidideclare.DeclareReportHelpService;
import kd.taxc.bdtaxr.business.multidideclare.ExportService;
import kd.taxc.bdtaxr.business.service.taxdeclare.BaseDataService;
import kd.taxc.bdtaxr.business.service.taxdeclare.ChangeDataService;
import kd.taxc.bdtaxr.business.service.taxdeclare.TaxDeclareDataService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.BaseDataServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.ChangeDataServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxDeclareDataServiceImpl;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.DeclareReportHideFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.service.DeclareReportHideService;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.declare.helper.TemplateFormulaServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.enums.DeclareServiceEnum;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.refactor.formula.service.CacheFormulaService;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.taxorg.TaxNameUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.file.FileUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.GetTemplateVo;
import org.apache.commons.io.FilenameUtils;

public class UnifiedDeclareReportQueryListHelper {
    private static Log logger = LogFactory.getLog(UnifiedDeclareReportQueryListHelper.class);
    public static final String BILLLISTID = "billlistap";
    public static final String BASE_PATH = System.getProperty("user.home") + File.separator + "template" + File.separator;
    private static TaxDeclareDataService taxDeclareDataService = new TaxDeclareDataServiceImpl();
    private static ChangeDataService changeDataService = new ChangeDataServiceImpl();
    private static BaseDataService baseDataService = new BaseDataServiceImpl();

    public static void exportModel3(IFormView view) {
        BillList billlist = (BillList)view.getControl(BILLLISTID);
        String appId = view.getFormShowParameter().getAppId();
        Long modelId = MultiTableEnum.getModelIdByNumber((String)MultiTableEnum.TSCOO1.getModel());
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u8bb0\u5f55\u3002", (String)"UnifiedDeclareReportQueryListHelper_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
        if (collect.size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5bfc\u51fa\u591a\u4efd\u7533\u62a5\u8868\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u7533\u62a5\u8bb0\u5f55\u518d\u64cd\u4f5c\u5bfc\u51fa\u3002", (String)"UnifiedDeclareReportQueryListHelper_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        String pk = list.get(0).getPrimaryKeyValue().toString();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)MultiTableEnum.TSCOO1.getDeclareMainTable());
        DynamicObject org = obj.getDynamicObject("org");
        DynamicObject templateObject = obj.getDynamicObject("templateid");
        long templateId = templateObject.getLong("id");
        String templatetype = obj.getDynamicObject("templatetype").getString("number");
        String billno = obj.getString("billno");
        String draftpurpose = "";
        if (obj.containsProperty("draftpurpose")) {
            draftpurpose = obj.getString("draftpurpose");
        }
        String taxsystem = "";
        if (obj.containsProperty("taxsystem")) {
            taxsystem = obj.getString("taxsystem.id");
        }
        String fileName = TemplateTypeConstant.getNsrtypemap().getOrDefault(templatetype, templatetype) + "_";
        if (org != null) {
            fileName = fileName + org.getString("name");
        }
        Date startDate = (Date)obj.get("skssqq");
        Date endDate = (Date)obj.get("skssqz");
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"tpo_template");
        if (template == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728\u3002", (String)"UnifiedDeclareReportQueryListHelper_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        fileName = fileName + DateUtils.format((Date)startDate, (String)"yyyy-MM");
        String operateName = ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"UnifiedDeclareReportQueryListHelper_3", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u7533\u62a5\u8868\uff0c\u5bfc\u51fa\u6210\u529f\u3002", (String)"UnifiedDeclareReportQueryListHelper_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno);
        String taxName = TaxNameUtil.getTaxName((String)appId);
        if ("other".equals(taxName)) {
            taxName = templatetype;
        }
        OperatorDialogUtils.operateDialog((String)taxName, (String)((ListShowParameter)view.getFormShowParameter()).getBillFormId(), (String)operateName, (String)operateDescription);
        DeclareRequestModel declareModel = new DeclareRequestModel();
        declareModel.setModelId(modelId);
        declareModel.setId(Long.valueOf(Long.parseLong(pk)));
        declareModel.setTemplateId(Long.valueOf(templateId));
        declareModel.setTemplateType(templatetype);
        declareModel.setTemplateNumber(template.getString("number"));
        if (org != null) {
            declareModel.setOrgId(Long.valueOf(org.getLong("id")));
        }
        declareModel.setSkssqq(obj.getString("skssqq"));
        declareModel.setSkssqz(obj.getString("skssqz"));
        declareModel.getBusinessMap().put("taxationsys", taxsystem);
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("draftpurpose", draftpurpose);
        declareModel.setExtendParams(map);
        DeclareResponseModel responseModel = (DeclareResponseModel)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_DECLARE_DATA, (Object[])new Object[]{declareModel});
        Map valMap = responseModel.getData();
        Map cellTypeFormulas = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CELLTYPE_FORMULAS, (Object[])new Object[]{templateId, responseModel.getDynRowList()});
        Map fieldMap = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_ALL_FIELDS_TYPE_SHOW, (Object[])new Object[]{modelId});
        GetTemplateVo getTemplateVo = DeclareReportHelpService.getTemplateVo(declareModel, responseModel);
        logger.info(ResManager.loadKDString((String)"\u5f15\u51fafieldTypes: {}", (String)"AbstractDeclareReportMultiQueryListPlugin_41", (String)"taxc-bdtaxr", (Object[])new Object[0]), fieldMap == null ? "" : JSONObject.toJSON((Object)fieldMap));
        String tempFileName = UUID.randomUUID().toString() + ".xlsx";
        File file = new File(FilenameUtils.normalize((String)(BASE_PATH + FilenameUtils.getName((String)tempFileName))));
        file.getParentFile().mkdirs();
        String jsonString = template.getString("content_tag");
        List dynRowList = DynamicRowService.getDynRowNoList((Long)templateId);
        ExportService.buildExcel("RESULT", templateId, jsonString, getTemplateVo, fieldMap, file, cellTypeFormulas, valMap, dynRowList, declareModel.getBusinessMap());
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)in, 5000);
            String serviceAppId = view.getFormShowParameter().getServiceAppId();
            String entityNum = ((IListView)view).getBillFormId();
            PermissionUtils.putTempFilePermissionCache((String)urls, (String)serviceAppId, (String)entityNum, (String)"4730fc9f000004ae");
            view.openUrl(urls);
        }
        catch (Exception e) {
            try {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
            }
            catch (Throwable throwable) {
                FileUtils.safeClose(in);
                throw throwable;
            }
        }
        FileUtils.safeClose((InputStream)in);
    }

    public static void exportModel2(IFormView view) {
        boolean zerodeclare;
        String orgName;
        BillList billlist = (BillList)view.getControl(BILLLISTID);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u8bb0\u5f55\u3002", (String)"UnifiedDeclareReportQueryListHelper_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
        if (collect.size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5bfc\u51fa\u591a\u4efd\u7533\u62a5\u8868\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u7533\u62a5\u8bb0\u5f55\u518d\u64cd\u4f5c\u5bfc\u51fa\u3002", (String)"UnifiedDeclareReportQueryListHelper_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        String appId = view.getFormShowParameter().getAppId();
        String pk = list.get(0).getPrimaryKeyValue().toString();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"tcvat_nsrxx");
        DynamicObject org = obj.getDynamicObject("org");
        Long orgId = org.getLong("id");
        String type = obj.getString("type");
        String billno = obj.getString("billno");
        String string = orgName = org != null ? org.getString("name") : "";
        if (!"qtsf_tysbb".equals(type) && !"qtsf_fsstysbb".equals(type) && (zerodeclare = obj.getBoolean("zerodeclare"))) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u7533\u62a5\u8868\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u8868\uff0c\u4e0d\u652f\u6301\u5bfc\u51fa\u3002", (String)"UnifiedDeclareReportQueryListHelper_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("type", "=", (Object)type);
        boolean isNewTemplate = QueryServiceHelper.exists((String)"bdtaxr_template_main", (QFilter[])new QFilter[]{qFilter});
        String fileName = TemplateTypeConstant.getNsrtypemap().getOrDefault(type, type) + "_" + orgName;
        Date date = (Date)obj.get("skssqq");
        Date endDate = (Date)obj.get("skssqz");
        DynamicObject template = null;
        String templateid = obj.getString("templateid");
        if (StringUtils.isNotEmpty((CharSequence)templateid)) {
            DynamicObject dynamicObject = template = isNewTemplate ? TemplateUtils.getTemplateObjectById((String)type, (String)templateid) : TemplateUtilsOld.getTemplateObjectById((String)type, (String)templateid);
        }
        if (template == null && org != null) {
            DynamicObject dynamicObject = template = isNewTemplate ? TemplateUtils.getTemplateObjectByConfig((String)type, (String)org.getString("id"), (Date)date, (Date)date) : TemplateUtilsOld.getTemplateObjectByConfig((String)type, (String)org.getString("id"), (Date)date, (Date)date);
        }
        if (template == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728\u3002", (String)"UnifiedDeclareReportQueryListHelper_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)templateid)) {
            templateid = template.getString("id");
        }
        fileName = fileName + DateUtils.format((Date)date, (String)"yyyy-MM");
        String operateName = ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"UnifiedDeclareReportQueryListHelper_3", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u7533\u62a5\u8868\uff0c\u5bfc\u51fa\u6210\u529f\u3002", (String)"UnifiedDeclareReportQueryListHelper_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno);
        String taxName = TaxNameUtil.getTaxName((String)appId);
        if ("other".equals(taxName)) {
            taxName = type;
        }
        OperatorDialogUtils.operateDialog((String)taxName, (String)((ListShowParameter)view.getFormShowParameter()).getBillFormId(), (String)operateName, (String)operateDescription);
        Long reportId = obj.getLong("id");
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setId(reportId);
        requestModel.setOrgId(orgId);
        requestModel.setTemplateId(Long.valueOf(templateid));
        requestModel.setTemplateType(type);
        requestModel.setTemplateNumber(template.getString("number"));
        requestModel.setSkssqq(DateUtils.format((Date)date));
        requestModel.setSkssqz(DateUtils.format((Date)endDate));
        Map metaMap = TemplateFormulaServiceHelper.getMetaDataListByTmpId((Long)Long.valueOf(templateid));
        requestModel.setMetaDataMap(metaMap);
        Map<String, String> valMap = null;
        Map<String, EntityField> typeMap = null;
        Map cellTypeFormulas = null;
        if (isNewTemplate) {
            DeclareResponseModel responseModel = taxDeclareDataService.queryData(requestModel);
            valMap = responseModel.getData();
            typeMap = DeclareReportHelpService.getEntityFieldsByMetadata(requestModel, responseModel.getDynRowList());
            valMap = changeDataService.changeToShow(valMap, responseModel, typeMap, "");
            cellTypeFormulas = CacheFormulaService.getCellTypeFormulas((Long)Long.valueOf(templateid), (List)responseModel.getDynRowList());
            baseDataService.queryBaseData(valMap, responseModel.getDynRowList(), requestModel);
        } else {
            valMap = TemplateShowUtils.queryData((String)type, (String)pk, (String)"_");
        }
        List<String> hideSheets = null;
        DeclareReportHideService declareReportHideService = DeclareReportHideFactory.createHandler(type);
        if (declareReportHideService != null) {
            hideSheets = declareReportHideService.hideSheets(requestModel);
        }
        try (InputStream in = isNewTemplate ? kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils.getDownResultExcelFileNew((DynamicObject)template, hideSheets, valMap, typeMap, cellTypeFormulas) : TemplateShowUtils.getDownResultExcelFile((DynamicObject)template, hideSheets, valMap);){
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", in, 5000);
            String serviceAppId = view.getFormShowParameter().getServiceAppId();
            String entityNum = ((IListView)view).getBillFormId();
            PermissionUtils.putTempFilePermissionCache((String)urls, (String)serviceAppId, (String)entityNum, (String)"4730fc9f000004ae");
            view.openUrl(urls);
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
    }
}

