/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare.importdeclare;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.upload.UploadOption;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.DeclareReportHideFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.service.DeclareReportHideService;
import kd.taxc.bdtaxr.common.db.DataSaveService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TableTypeMapTemplateTypeEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.formula.db.formula.QueryFormulaService;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.service.ImportReportCalService;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.constant.ImportDataConstant;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TemplateTypeMappingEnum;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.taxorg.TaxOrgUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.service.DeductionCodeCheckService;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.ExcelUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ImportDeclareReportPlugin
extends AbstractFormPlugin
implements UploadListener,
HyperLinkClickListener {
    private static final String GANG = "-";
    private static final String DISENABLE = "0";
    private static Log logger = LogFactory.getLog(ImportDeclareReportPlugin.class);
    private static final String BTN_OK = "btnok";
    private static final String ENTRYENT_FINANCIAL_STATEMENTS = "entryent";
    private static final String COL_FINANCIAL_STATEMENTS = "textfield";
    public static final String COL_FINANCIAL_DOWNLOAD = "download";
    private static final String COL_FINANCIAL_SRARTDATE_STATEMENTS = "startdate";
    private static final String COL_FINANCIAL_ENDDATE_STATEMENTS = "enddate";
    private static final String FINANCIAL_TYPE_STATEMENTS = "selecttype";
    private static final String FINANCIAL_ENTITY_ID = "tdm_finance_main";
    private static final String ORG_FIELD_ID = "org";
    private static final String PEIROD_FIELD_ID = "peirod";
    private static final String START_FIELD_ID = "skssqq";
    private static final String END_FIELD_ID = "skssqz";
    private static final String TEMP_FIELD_ID = "templateid";
    private static final String TYPE_FIELD_ID = "type";
    private static final String PARAM_TYPE = "source";
    private static final String DECLARE_ENTITY_ID = "tcvat_nsrxx";
    private static final String NSRSBH_FIELD_ID = "nsrsbh";
    private static final String NSRMC_FIELD_ID = "nsrmc";
    private static final String STATUS_FIELD_ID = "declarestatus";
    private static final String TAX_TYPE_PARAM = "taxtype";
    private static final Pattern PATTERN = Pattern.compile("^-?[0-9]+");
    private List<Map<String, String>> RECACHELIST = new ArrayList<Map<String, String>>();
    private String MARKWORDS;
    private String RECACHE = "recache";
    private List<Map<String, String>> BILLCACHELIST = new ArrayList<Map<String, String>>();
    private String BILLMARKWORDS;
    private String BILLCACHE = "billcache";
    private static Map<String, String[]> UNIQ_CACHE_FIELDS = new LinkedHashMap<String, String[]>(){
        {
            this.put("tvpt", new String[]{"tcret_clgzs_zb#1#carserialno"});
        }
    };
    private DeclareReportHideService declareReportHideService;
    private List<String> NO_BLANK_SHEETS = new ArrayList<String>();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, "btnupload", "btndownload", "btndel", "buttondownload", FINANCIAL_TYPE_STATEMENTS});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
        EntryGrid tempGrid = (EntryGrid)this.getView().getControl(ENTRYENT_FINANCIAL_STATEMENTS);
        tempGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (FINANCIAL_TYPE_STATEMENTS.equals(name)) {
            ChangeData[] changeSet = e.getChangeSet();
            QFilter q = new QFilter("type.number", "in", changeSet[0].getNewValue());
            this.getModel().deleteEntryData(ENTRYENT_FINANCIAL_STATEMENTS);
            this.queryEntityData(q);
        }
    }

    public void afterCreateNewData(EventObject evt) {
        List templatetypelist;
        String paramtype = this.getParam(PARAM_TYPE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"urlsflex"});
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(FINANCIAL_TYPE_STATEMENTS);
        if (paramtype != null && "declare".equals(paramtype.trim()) && EmptyCheckUtils.isNotEmpty((Object)(templatetypelist = (List)this.getView().getFormShowParameter().getCustomParam("templatetypelist")))) {
            ArrayList data = new ArrayList();
            templatetypelist.stream().filter(s -> !Lists.newArrayList((Object[])new String[]{"qysdsjb", "qysds_hdzs_jb"}).contains(s)).forEach(type -> {
                if (StringUtils.isNotEmpty((CharSequence)TemplateTypeMappingEnum.getDescByCode((String)type))) {
                    data.add(new ComboItem(new LocaleString(TemplateTypeMappingEnum.getDescByCode((String)type)), type));
                }
            });
            comboEdit.setComboItems(data);
            this.getModel().setValue(FINANCIAL_TYPE_STATEMENTS, (Object)((ComboItem)data.get(0)).getValue());
            QFilter q = new QFilter("type.number", "in", (Object)((ComboItem)data.get(0)).getValue());
            this.queryEntityData(q);
        }
    }

    private void queryEntityData(QFilter q) {
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"tpo_template_old", (String)"id,name as textfield,type.id as typeid,startdate,enddate", (QFilter[])new QFilter[]{q}, (String)"startdate desc,number");
        if (dcs == null || dcs.isEmpty()) {
            return;
        }
        List ids = dcs.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        logger.info(JsonUtil.toJson(ids));
        this.getModel().beginInit();
        for (DynamicObject d : dcs) {
            int index = this.getModel().createNewEntryRow(ENTRYENT_FINANCIAL_STATEMENTS);
            this.getModel().setValue("id", (Object)d.getLong("id"), index);
            this.getModel().setValue("typeid", (Object)d.getString("typeid"), index);
            String name = d.getString(COL_FINANCIAL_STATEMENTS);
            this.getModel().setValue(COL_FINANCIAL_STATEMENTS, (Object)name, index);
            Date startDate = d.getDate(COL_FINANCIAL_SRARTDATE_STATEMENTS) != null ? d.getDate(COL_FINANCIAL_SRARTDATE_STATEMENTS) : null;
            Date endDate = d.getDate(COL_FINANCIAL_ENDDATE_STATEMENTS) != null ? d.getDate(COL_FINANCIAL_ENDDATE_STATEMENTS) : null;
            this.getModel().setValue(COL_FINANCIAL_SRARTDATE_STATEMENTS, (Object)startDate, index);
            this.getModel().setValue(COL_FINANCIAL_ENDDATE_STATEMENTS, (Object)endDate, index);
            this.getModel().setValue(COL_FINANCIAL_DOWNLOAD, (Object)ResManager.loadKDString((String)"\u4e0b\u8f7d", (String)"ImportDeclareReportPlugin_40", (String)"taxc-bdtaxr", (Object[])new Object[0]), index);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENT_FINANCIAL_STATEMENTS);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int index = hyperLinkClickEvent.getRowIndex();
        long id = (Long)this.getModel().getValue("id", index);
        try (InputStream in = TemplateShowUtils.getbuildExcel((String)"IMPORT", (Long)id);){
            String name = (String)this.getModel().getValue(COL_FINANCIAL_STATEMENTS, index);
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(name + ".xlsx", in, 5000);
            this.getView().openUrl(urls);
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnupload".equals(control.getKey())) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENT_FINANCIAL_STATEMENTS);
            int[] rows = entry.getSelectRows();
            if (rows.length != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u6a21\u677f\u7c7b\u578b", (String)"ImportDeclareReportPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            UploadOption opt = new UploadOption();
            opt.setMultiple(true);
            opt.setTitle(ResManager.loadKDString((String)"\u4e0a\u4f20\u6570\u636e\u6587\u4ef6", (String)"ImportDeclareReportPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            opt.setSuffix(".xlsx");
            opt.setLimitSize(0x1400000L);
            this.getView().showUpload(opt, "btnupload");
        } else if ("buttondownload".equals(control.getKey())) {
            Object field = this.getModel().getValue("templatetype");
            if (field == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5148\u9009\u62e9\u9700\u8981\u4e0b\u8f7d\u7684\u6a21\u677f\u7c7b\u578b", (String)"ImportDeclareReportPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        } else if ("btndel".equals(control.getKey())) {
            IDataModel model = this.getModel();
            int i = model.getEntryCurrentRowIndex("upload_urls");
            String cacheUrls = this.getPageCache().get("_file_list_");
            List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
            String url = (String)model.getValue("url", i);
            filelist.removeIf(f -> f.get("url").equals(url));
            this.getPageCache().put("_file_list_", SerializationUtils.serializeToBase64(filelist));
            model.deleteEntryRow("upload_urls", i);
            if (filelist.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"urlsflex"});
            }
        } else if (BTN_OK.equals(control.getKey())) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENT_FINANCIAL_STATEMENTS);
            int[] rows = entry.getSelectRows();
            if (rows.length != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u6a21\u677f\u7c7b\u578b", (String)"ImportDeclareReportPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            String file_list = this.getPageCache().get("_file_list_");
            if (StringUtils.isEmpty((CharSequence)file_list)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0a\u4f20\u6587\u4ef6", (String)"ImportDeclareReportPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            List filelist = (List)SerializationUtils.deSerializeFromBase64((String)file_list);
            if (filelist.size() > 3 || filelist.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0d\u591a\u4e8e3\u4e2a\u6587\u4ef6\u4e0a\u4f20", (String)"ImportDeclareReportPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            this.RECACHELIST.clear();
            this.BILLCACHELIST.clear();
            this.MARKWORDS = "";
            this.BILLMARKWORDS = "";
            StringBuilder message = new StringBuilder();
            FileService service = FileServiceFactory.getAttachmentFileService();
            for (int i = 0; i < filelist.size(); ++i) {
                Map fileMap = (Map)filelist.get(i);
                String file_url = (String)fileMap.get("url");
                String fileName = (String)fileMap.get("name");
                if (StringUtils.isBlank((CharSequence)file_url)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e", (String)"ImportDeclareReportPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
                InputStream inputStream = service.getInputStream(file_url);
                long templateId = (Long)this.getModel().getValue("id", rows[0]);
                String typeId = (String)this.getModel().getValue("typeid", rows[0]);
                logger.info("id:" + templateId + "typeId:" + typeId);
                try {
                    this.handleInputStream(inputStream, templateId, typeId);
                    continue;
                }
                catch (RuntimeException e) {
                    logger.error((Throwable)e);
                    String error = e.getMessage();
                    message.append(fileName).append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u9519\u8bef\u4fe1\u606f\uff1a", (String)"ImportDeclareReportPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0])).append(error).append("\r\n");
                }
            }
            if (message.length() > 0 && !"null".equals(message.toString()) && !"".equals(message.toString())) {
                this.getView().showErrorNotification(message.toString());
            }
            if (this.RECACHELIST.size() > 0 && this.MARKWORDS.length() > 0) {
                String reCache = JSONArray.toJSONString(this.RECACHELIST);
                this.getPageCache().put(this.RECACHE, reCache);
                ConfirmCallBackListener callBack = new ConfirmCallBackListener("sbboverridereport", (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\r\n%s\u8bf7\u786e\u8ba4\u662f\u5426\u8986\u76d6\uff1f", (String)"ImportDeclareReportPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.MARKWORDS), MessageBoxOptions.OKCancel, callBack);
                return;
            }
            if (this.BILLCACHELIST.size() > 0 && this.BILLMARKWORDS.length() > 0) {
                String billCache = JSONArray.toJSONString(this.BILLCACHELIST);
                this.getPageCache().put(this.BILLCACHE, billCache);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u653e\u5f03\u5f15\u5165", (String)"ImportDeclareReportPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u5f15\u5165", (String)"ImportDeclareReportPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("draftoverride", (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u5c5e\u671f\u5e95\u7a3f\u4e2d\u5b58\u5728\u7f16\u8f91\u7684\u5e95\u7a3f\u6570\u636e\uff0c\u7ee7\u7eed\u64cd\u4f5c\u5c06\u5220\u9664\u5e95\u7a3f\u6570\u636e\uff0c\u53ef\u9009\u62e9\u4ee5\u4e0b\u64cd\u4f5c", (String)"ImportDeclareReportPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.BILLMARKWORDS), "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
            }
        }
    }

    private void handleInputStream(InputStream inputStream, long templateId, String typeId) {
        DynamicObject reportExistsId;
        Workbook hssfWorkbook = null;
        try {
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            hssfWorkbook = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u683c\u5f0f\u6587\u4ef6", (String)"ImportDeclareReportPlugin_11", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        Iterator it = hssfWorkbook.sheetIterator();
        LinkedHashMap<String, String> excelDataMap = new LinkedHashMap<String, String>();
        while (it.hasNext()) {
            Sheet sheet = (Sheet)it.next();
            String sheetName = sheet.getSheetName();
            for (Row row : sheet) {
                int rowNum = row.getRowNum();
                for (Cell cell : row) {
                    int columnIndex = cell.getColumnIndex();
                    String key = sheetName + "#" + rowNum + "#" + columnIndex;
                    String sheetName5 = ResManager.loadKDString((String)"\u9644\u8868\u4e94", (String)"ImportDeclareReportPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                    if (sheetName5.equals(sheetName) && rowNum > 6) {
                        logger.info("\u9644\u8868\u4e94\u7684\u503c\uff1a{}", (Object)cell.toString());
                    }
                    if (sheetName5.equals(sheetName) && rowNum == 10 && columnIndex == 12) {
                        logger.info("\u516c\u5f0f\u7684\u503c\uff1a{}\uff0c\u7c7b\u578b\uff1a{}", (Object)cell.toString(), (Object)cell.getCellType());
                        if (cell.getCellType().equals((Object)CellType.FORMULA)) {
                            logger.info("\u516c\u5f0f\uff1a{}", (Object)cell.getCellFormula());
                        }
                        if (cell.getCellType().equals((Object)CellType.STRING)) {
                            logger.info("\u975e\u516c\u5f0f\u53d6\u503c\uff1a{}", (Object)cell.getStringCellValue());
                        }
                    }
                    String text = "";
                    text = Sets.newHashSet((Object[])new String[]{"A107041#11#8", "A107041#14#8", "A107041#32#8"}).contains(key) ? ExcelUtils.getStringValueFromCell((Cell)cell, (DecimalFormat)new DecimalFormat("#####0.0000")) : ExcelUtils.getStringValueFromCell((Cell)cell);
                    if (text == null || "".equals(text)) continue;
                    excelDataMap.put(key, text);
                    if (this.NO_BLANK_SHEETS.contains(sheetName)) continue;
                    this.NO_BLANK_SHEETS.add(sheetName);
                }
            }
        }
        Map templateEntityMap = TemplateShowUtils.queryTemplateField((Long)templateId);
        if (templateEntityMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u6a21\u677f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u5408\u6cd5\u6027", (String)"ImportDeclareReportPlugin_13", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        Map formulaVoMap = QueryFormulaService.queryDBFormulaByTypeId((String)String.valueOf(templateId), (String)"3");
        DynamicObject template = TemplateUtilsOld.getTemplateObjectById((String)String.valueOf(templateId));
        Set entrySet = templateEntityMap.entrySet();
        Iterator tempIterator = entrySet.iterator();
        String orgid = "";
        String orgName = "";
        Date startDate = null;
        Date endDate = null;
        Date fregisterTime = null;
        HashMap<String, String> resultMap = new HashMap<String, String>(templateEntityMap.size());
        while (tempIterator.hasNext()) {
            String typenumber;
            Map.Entry entry = tempIterator.next();
            String key = (String)entry.getKey();
            EntityField value = (EntityField)entry.getValue();
            String inputValue = StringUtil.trim((String)((String)excelDataMap.get(key)));
            String entryId = value.getEntityId();
            String ewblxh = value.getEwblxh();
            String fieldId = value.getFieldId();
            String rKey = entryId + "#" + ewblxh + "#" + fieldId;
            if (StringUtils.isNotBlank((CharSequence)inputValue)) {
                DynamicObject dobj;
                TaxResult result;
                if (Arrays.asList(ImportDataConstant.getFinancialTypes()).contains(typeId)) {
                    if (FINANCIAL_ENTITY_ID.equals(entryId) && ORG_FIELD_ID.equals(fieldId)) {
                        DynamicObject org = this.queryOrg(inputValue);
                        if (org != null) {
                            orgid = org.getString("id");
                        }
                        resultMap.put("tdm_finance_main#1#org", orgid);
                        continue;
                    }
                    if (FINANCIAL_ENTITY_ID.equals(entryId) && PEIROD_FIELD_ID.equals(fieldId)) {
                        String format;
                        String dateStr = inputValue.trim();
                        if (dateStr.contains(ResManager.loadKDString((String)"\u65e5", (String)"ImportDeclareReportPlugin_14", (String)"taxc-bdtaxr", (Object[])new Object[0]))) {
                            format = DateUtils.YYYYMMDD_CHINESE;
                            this.checkLeapYear(dateStr);
                        } else {
                            format = DateUtils.YYYYMM_CHINESE;
                        }
                        SimpleDateFormat df = new SimpleDateFormat(format);
                        try {
                            Date d = df.parse(dateStr);
                            startDate = DateUtils.getFirstDateOfMonth((Date)d);
                            endDate = DateUtils.getLastDateOfMonth((Date)d);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                            throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01\u8bf7\u4e25\u683c\u6309\u7167\u6a21\u677f\u683c\u5f0f\u5f15\u5165\uff0c\u5408\u6cd5\u65e5\u671f\u683c\u5f0f xxxx\u5e74xx\u6708xx\u65e5\u6216xxxx\u5e74xx\u6708", (String)"ImportDeclareReportPlugin_15", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                        }
                        resultMap.put("tdm_finance_main#1#peirod", inputValue);
                        resultMap.put("tdm_finance_main#1#skssqq", DateUtils.format((Date)startDate));
                        resultMap.put("tdm_finance_main#1#skssqz", DateUtils.format((Date)endDate));
                        continue;
                    }
                    this.setValue(formulaVoMap, resultMap, value, inputValue, rKey);
                    continue;
                }
                if (DECLARE_ENTITY_ID.equals(entryId) && NSRSBH_FIELD_ID.equals(fieldId)) {
                    result = TaxcMainDataServiceHelper.queryTaxcMainByUnifiedsocialCode((String)inputValue);
                    if (!result.isSuccess()) {
                        throw new KDBizException(result.getMessage());
                    }
                    if (EmptyCheckUtils.isEmpty((Object)result.getData())) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u5f02\u5e38\uff0c\u6ca1\u6709\u67e5\u5230\u76f8\u5173\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u7684\u6b63\u786e\u6027\uff01", (String)"ImportDeclareReportPlugin_16", (String)"taxc-bdtaxr", (Object[])new Object[0]), inputValue));
                    }
                    dobj = (DynamicObject)result.getData();
                    orgid = dobj.getString("taxorg.id");
                    orgName = dobj.getString("taxorg.org.name");
                    resultMap.put("tcvat_nsrxx#1#nsrsbh", inputValue);
                    resultMap.put("tcvat_nsrxx#1#nsrmc", dobj.getString("taxorg.taxpayer"));
                    resultMap.put("tcvat_nsrxx#1#org", orgid);
                    resultMap.put("tcvat_nsrxx#1#taxauthority", dobj.getDynamicObject("taxoffice").getString("id"));
                    continue;
                }
                if (DECLARE_ENTITY_ID.equals(entryId) && NSRMC_FIELD_ID.equals(fieldId)) {
                    result = TaxcMainDataServiceHelper.queryTaxcMainByTaxpayer((String)inputValue);
                    if (!result.isSuccess()) {
                        throw new KDBizException(result.getMessage());
                    }
                    if (EmptyCheckUtils.isEmpty((Object)result.getData())) {
                        if ("tvpt".equals(typeId)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u540d\u79f0\u5f02\u5e38\uff0c\u6ca1\u6709\u67e5\u5230\u76f8\u5173\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u7eb3\u7a0e\u4eba\u540d\u79f0\u7684\u6b63\u786e\u6027\uff01", (String)"ImportDeclareReportPlugin_17", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                        }
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u8be5\u7ec4\u7ec7\u3010%s\u3011\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5148\u5728\u57fa\u7840\u8bbe\u7f6e-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u4e2d\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"ImportDeclareReportPlugin_18", (String)"taxc-bdtaxr", (Object[])new Object[0]), inputValue));
                    }
                    dobj = (DynamicObject)result.getData();
                    orgName = dobj.getString("taxorg.org.name");
                    DynamicObjectCollection obj = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"name", (Object)orgName));
                    String status = ((DynamicObject)obj.get(0)).getString("status");
                    if ("3".equalsIgnoreCase(status)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u8be5\u7ec4\u7ec7\u3010%s\u3011\u5c1a\u672a\u542f\u7528\uff0c\u8bf7\u5148\u8fdb\u884c\u7a0e\u52a1\u7ec4\u7ec7\u72b6\u6001\u542f\u7528\u3002", (String)"ImportDeclareReportPlugin_19", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgName));
                    }
                    if ("tvpt".equals(typeId)) {
                        orgid = dobj.getString("taxorg.id");
                        resultMap.put("tcvat_nsrxx#1#nsrsbh", TaxOrgUtil.getUnifiedsocialcode((DynamicObject)dobj.getDynamicObject("taxorg")));
                        resultMap.put("tcvat_nsrxx#1#org", orgid);
                        resultMap.put("tcvat_nsrxx#1#taxauthority", dobj.getDynamicObject("taxoffice").getString("id"));
                    }
                    resultMap.put("tcvat_nsrxx#1#nsrmc", TaxOrgUtil.getTaxpayer((DynamicObject)dobj.getDynamicObject("taxorg")));
                    fregisterTime = dobj.getDate("registertime");
                    continue;
                }
                if (DECLARE_ENTITY_ID.equals(entryId) && START_FIELD_ID.equals(fieldId)) {
                    startDate = this.formatDateStr(inputValue);
                    resultMap.put("tcvat_nsrxx#1#skssqq", inputValue);
                    if (!"tvpt".equals(typeId)) continue;
                    endDate = startDate;
                    resultMap.put("tcvat_nsrxx#1#skssqz", inputValue);
                    continue;
                }
                if (DECLARE_ENTITY_ID.equals(entryId) && END_FIELD_ID.equals(fieldId)) {
                    endDate = this.formatDateStr(inputValue);
                    resultMap.put("tcvat_nsrxx#1#skssqz", inputValue);
                    continue;
                }
                if ("jbrysfzjhm".equals(fieldId) && ("tcvat_xgm_zb".equals(entryId) || "tcvat_ybnsr_zb".equals(entryId))) {
                    if (StringUtils.isNotBlank((CharSequence)(inputValue = inputValue.replaceAll("(^[ \\u3000]*|[ \\u3000]*$)", ""))) && inputValue.length() <= 6) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u7ecf\u529e\u4eba\u5458\u8eab\u4efd\u8bc1\u4ef6\u53f7\u7801\u5c0f\u4e8e6\u4f4d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ImportDeclareReportPlugin_20", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    }
                    this.setValue(formulaVoMap, resultMap, value, inputValue, rKey);
                    continue;
                }
                this.setValue(formulaVoMap, resultMap, value, inputValue, rKey);
                continue;
            }
            if ("Decimal".equals(value.getFieldType())) {
                resultMap.put(rKey, DISENABLE);
            }
            if (DECLARE_ENTITY_ID.equals(entryId) && NSRMC_FIELD_ID.equals(fieldId) && (typenumber = template.getString("typenumber")) != null && !typenumber.contains("qysds")) continue;
        }
        if (template.getString("number").startsWith("VAT")) {
            BigDecimal totalmsxm;
            int i;
            for (i = 2; i < 11; ++i) {
                totalmsxm = this.calcTotalAmount(resultMap, "tcvat_ybnsr_jsxm#" + i + "#qcye", "tcvat_ybnsr_jsxm#" + i + "#bqfse", "tcvat_ybnsr_jsxm#" + i + "#bqydjse", "tcvat_ybnsr_jsxm#" + i + "#bqsjdjse", "tcvat_ybnsr_jsxm#" + i + "#qmye");
                if (totalmsxm.compareTo(BigDecimal.ZERO) == 0 || null != resultMap.get("tcvat_ybnsr_jsxm#" + i + "#swsxdm")) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u51cf\u514d\u7a0e\u7533\u62a5\u660e\u7ec6\u8868\u7b2c%s\u884c\u5b58\u5728\u660e\u7ec6\u884c\u6570\u636e\u672a\u586b\u5199\u51cf\u514d\u6027\u8d28\u4ee3\u7801\u3002", (String)"ImportDeclareReportPlugin_21", (String)"taxc-bdtaxr", (Object[])new Object[0]), i));
            }
            for (i = 4; i < 16; ++i) {
                totalmsxm = this.calcTotalAmount(resultMap, "tcvat_ybnsr_msxm#" + i + "#mzzzsxmxse", "tcvat_ybnsr_msxm#" + i + "#bqsjkcje", "tcvat_ybnsr_msxm#" + i + "#kchmsxse", "tcvat_ybnsr_msxm#" + i + "#mse");
                if (totalmsxm.compareTo(BigDecimal.ZERO) == 0 || null != resultMap.get("tcvat_ybnsr_msxm#" + i + "#swsxdm")) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u51cf\u514d\u7a0e\u7533\u62a5\u660e\u7ec6\u8868\u7b2c%s\u884c\u5b58\u5728\u660e\u7ec6\u884c\u6570\u636e\u672a\u586b\u5199\u514d\u7a0e\u6027\u8d28\u4ee3\u7801\u3002", (String)"ImportDeclareReportPlugin_22", (String)"taxc-bdtaxr", (Object[])new Object[0]), i));
            }
        }
        this.validateDates(orgid, typeId, templateId, startDate, endDate, fregisterTime);
        List<String> hideSheets = null;
        this.declareReportHideService = DeclareReportHideFactory.createHandler(typeId);
        if (this.declareReportHideService != null) {
            DeclareRequestModel requestModel = new DeclareRequestModel();
            requestModel.setOrgId(Long.valueOf(orgid));
            requestModel.setTemplateId(Long.valueOf(templateId));
            requestModel.setTemplateType(typeId);
            requestModel.setSkssqq(DateUtils.format(startDate));
            requestModel.setSkssqz(DateUtils.format(endDate));
            hideSheets = this.declareReportHideService.hideSheets(requestModel);
            if (!CollectionUtils.isEmpty(this.NO_BLANK_SHEETS) && !CollectionUtils.isEmpty(hideSheets)) {
                this.NO_BLANK_SHEETS.retainAll(hideSheets);
                if (!CollectionUtils.isEmpty(this.NO_BLANK_SHEETS)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u9690\u85cf\u9875\u7b7e\u5355\u5143\u683c\u4e0d\u80fd\u586b\u503c\u3002", (String)"ImportDeclareReportPlugin_23", (String)"taxc-bdtaxr", (Object[])new Object[0]), StringUtil.join((Object[])new List[]{this.NO_BLANK_SHEETS})));
                }
            }
        }
        String reportId = (reportExistsId = TemplateUtils.queryReportExistsId((String)orgid, (String)typeId, startDate, endDate, (String)DateUtils.getTaxLimit(startDate, endDate))) != null && StringUtil.isNotEmpty((CharSequence)reportExistsId.getString("id")) ? reportExistsId.getString("id") : String.valueOf(DB.genLongId((String)DECLARE_ENTITY_ID));
        String taxLimit = null;
        String oldBillno = ImportDeclareReportPlugin.getOldBillno(reportId);
        if (Arrays.asList(ImportDataConstant.getFinancialTypes()).contains(typeId)) {
            resultMap.put("tdm_finance_main#1#templateid", String.valueOf(templateId));
            resultMap.put("tdm_finance_main#1#type", typeId);
            resultMap.put("tdm_finance_main#1#id", String.valueOf(DB.genLongId((String)FINANCIAL_ENTITY_ID)));
            resultMap.put("tdm_finance_main#1#datasource", "mbyr");
            resultMap.put("tdm_finance_main#1#sourcesystem", "ierp");
        } else {
            resultMap.put("tcvat_nsrxx#1#templateid", String.valueOf(templateId));
            resultMap.put("tcvat_nsrxx#1#type", typeId);
            resultMap.put("tcvat_nsrxx#1#declarestatus", "editing");
            resultMap.put("tcvat_nsrxx#1#paystatus", "unpaid");
            resultMap.put("tcvat_nsrxx#1#billstatus", "C");
            resultMap.put("tcvat_nsrxx#1#datatype", "2");
            resultMap.put("tcvat_nsrxx#1#id", reportId);
            if (null == oldBillno) {
                resultMap.put("tcvat_nsrxx#1#billno", ImportDeclareReportPlugin.getBillNo(orgid, typeId));
            } else {
                resultMap.put("tcvat_nsrxx#1#billno", oldBillno);
            }
            resultMap.put("tcvat_nsrxx#1#modifytime", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            resultMap.put("tcvat_nsrxx#1#createtime", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            resultMap.put("tcvat_nsrxx#1#modifier", RequestContext.get().getUserId());
            resultMap.put("tcvat_nsrxx#1#creator", RequestContext.get().getUserId());
            taxLimit = DateUtils.getTaxLimit((Date)startDate, (Date)endDate);
            resultMap.put("tcvat_nsrxx#1#taxlimit", taxLimit);
            resultMap.put("tcvat_nsrxx#1#apanage", "\u2014");
            resultMap.put("tcvat_nsrxx#1#tcrettype", "fcscztdsys");
            resultMap.put("tcvat_nsrxx#1#sblx", "1");
            resultMap.put("tcvat_nsrxx#1#serialno", DISENABLE);
        }
        if (Arrays.asList(ImportDataConstant.getDeclaredTypes()).contains(typeId)) {
            resultMap.put("tcvat_nsrxx#1#declarestatus", "editing");
            resultMap.put("tcvat_nsrxx#1#declaretype", DISENABLE);
            resultMap.put("tcvat_nsrxx#1#declaredate", DateUtils.format((Date)startDate));
            resultMap.put("tcvat_nsrxx#1#sbrq", DateUtils.format((Date)startDate));
            resultMap.put("tcvat_nsrxx#1#declarer", RequestContext.get().getUserId());
            resultMap.put("tcvat_nsrxx#1#sblx", "2");
        }
        this.validateBusinessData(resultMap, typeId);
        Object[] uniqExistsResult = ImportDeclareReportPlugin.queryReportUniqExists(orgName, orgid, typeId, startDate, endDate, taxLimit, resultMap);
        Boolean exists = (Boolean)uniqExistsResult[0];
        String uniqMarkWords = (String)uniqExistsResult[1];
        Long[] sbbids = (Long[])uniqExistsResult[2];
        String startdateStr = DateUtils.format((Date)startDate);
        String enddateStr = DateUtils.format((Date)endDate);
        if (exists.booleanValue()) {
            HashMap<String, String> cacheMap = new HashMap<String, String>();
            cacheMap.put("orgid", orgid);
            cacheMap.put(COL_FINANCIAL_SRARTDATE_STATEMENTS, startdateStr);
            cacheMap.put(COL_FINANCIAL_ENDDATE_STATEMENTS, enddateStr);
            cacheMap.put("typeid", typeId);
            cacheMap.put("taxlimit", taxLimit);
            cacheMap.put("templateId", String.valueOf(templateId));
            cacheMap.put("reportId", reportId);
            cacheMap.put("resultMap", SerializationUtils.toJsonString(resultMap));
            if (sbbids != null) {
                cacheMap.put("existSbbids", SerializationUtils.toJsonString((Object)sbbids));
            }
            this.RECACHELIST.add(cacheMap);
            String sDate = DateUtils.format((Date)startDate, (String)ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"ImportDeclareReportPlugin_24", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            String eDate = DateUtils.format((Date)endDate, (String)ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"ImportDeclareReportPlugin_24", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            this.MARKWORDS = StringUtil.isNotEmpty((CharSequence)uniqMarkWords) ? uniqMarkWords : String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011\u3010%3$s\u3011\u3010%4$s\u3011\u7684\u7533\u62a5\u8868\uff0c\r\n", (String)"ImportDeclareReportPlugin_25", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.MARKWORDS, orgName, sDate, eDate);
        } else {
            TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)typeId);
            if (templateEnum != null) {
                DynamicObject object = StatusUtils.queryOne((String)templateEnum.getDraftType(), (String)orgid, (String)startdateStr, (String)enddateStr, (String)"nssb");
                if (object != null) {
                    HashMap<String, String> cacheMap = new HashMap<String, String>();
                    cacheMap.put("orgid", orgid);
                    cacheMap.put(COL_FINANCIAL_SRARTDATE_STATEMENTS, startdateStr);
                    cacheMap.put(COL_FINANCIAL_ENDDATE_STATEMENTS, enddateStr);
                    cacheMap.put("typeid", typeId);
                    cacheMap.put("taxlimit", taxLimit);
                    cacheMap.put("templateId", String.valueOf(templateId));
                    cacheMap.put("reportId", reportId);
                    cacheMap.put("resultMap", SerializationUtils.toJsonString(resultMap));
                    this.BILLCACHELIST.add(cacheMap);
                    DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(orgid), (String)"bos_org");
                    this.BILLMARKWORDS = this.BILLMARKWORDS + "\u3010" + orgObj.getString("name") + "\u3011\u3010" + startdateStr + "\u3011\u3010" + enddateStr + "\u3011\r\n";
                } else {
                    this.saveDataAndRefresh(templateId, typeId, resultMap, reportId, orgid, startdateStr, enddateStr);
                }
            } else {
                this.saveDataAndRefresh(templateId, typeId, resultMap, reportId, orgid, startdateStr, enddateStr);
            }
        }
    }

    private static String getBillNo(String orgid, String type) {
        switch (type) {
            case "fcscztdsys": {
                String billno = ImportDeclareReportPlugin.generateDraftNo("tcret_declare_query", orgid);
                return billno;
            }
            case "yhs": {
                String billno = ImportDeclareReportPlugin.generateDraftNo("tcsd_yhs_declare_list", orgid);
                return billno;
            }
            case "tcept": {
                String billno = ImportDeclareReportPlugin.generateDraftNo("totf_nssb_query", orgid);
                return billno;
            }
            case "tcrt": {
                String billno = ImportDeclareReportPlugin.generateDraftNo("totf_nssb_query", orgid);
                return billno.replace("ENP", "RES");
            }
            case "yys": {
                String billno = ImportDeclareReportPlugin.generateDraftNo("totf_nssb_query", orgid);
                return billno.replace("ENP", "TBL");
            }
            case "tcvvt": {
                String billno = ImportDeclareReportPlugin.generateDraftNo("totf_nssb_query", orgid);
                return billno.replace("ENP", "VAV");
            }
            case "tvpt": {
                String billno = ImportDeclareReportPlugin.generateDraftNo("totf_nssb_query", orgid);
                return billno.replace("ENP", "VPC");
            }
        }
        return null;
    }

    protected static String generateDraftNo(String entityName, String orgid) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        return CodeRuleServiceHelper.getNumber((String)entityName, (DynamicObject)dynamicObject, (String)orgid);
    }

    public static Object[] queryReportUniqExists(String orgName, String orgid, String templateTypeId, Date startDate, Date endDate, String taxLimit, Map<String, String> resultMap) {
        Object[] result = new Object[]{Boolean.FALSE, "", null};
        DynamicObject typeObject = BusinessDataServiceHelper.loadSingle((Object)templateTypeId, (String)"tpo_template_type");
        String mainTable = typeObject.getString("maintable");
        switch (templateTypeId) {
            case "tvpt": {
                String carserialno = resultMap.get("tcret_clgzs_zb#1#carserialno");
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcret_clgzs_zb", (String)"sbbid", (QFilter[])new QFilter("carserialno", "=", (Object)carserialno).toArray());
                List<Long> sbbid = dynamicObjects.stream().map(a -> a.getString("sbbid")).filter(b -> StringUtil.isNotEmpty((CharSequence)b)).map(Long::valueOf).collect(Collectors.toList());
                if (sbbid.size() <= 0) break;
                QFilter[] qFilters = new QFilter(ORG_FIELD_ID, "=", (Object)Long.valueOf(orgid)).and("id", "in", sbbid).toArray();
                DynamicObjectCollection sbbs = QueryServiceHelper.query((String)mainTable, (String)"id", (QFilter[])qFilters);
                sbbid = sbbs.stream().map(a -> a.getLong("id")).collect(Collectors.toList());
                Boolean exists = EmptyCheckUtils.isNotEmpty((Object)sbbs);
                result[0] = exists;
                result[1] = exists != false ? String.format(ResManager.loadKDString((String)"%s\u6b64\u8f66\u67b6\u53f7\u7684\u7533\u62a5\u8868", (String)"ImportDeclareReportPlugin_26", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgName) : "";
                result[2] = sbbid.toArray(new Long[sbbid.size()]);
                break;
            }
            default: {
                result[0] = TemplateUtilsOld.queryReportExists((String)orgid, (String)templateTypeId, (Date)startDate, (Date)endDate, (String)taxLimit);
            }
        }
        return result;
    }

    private void validateBusinessData(Map<String, String> resultMap, String typeId) {
        if (UNIQ_CACHE_FIELDS.containsKey(typeId)) {
            String[] fields;
            for (String field : fields = UNIQ_CACHE_FIELDS.get(typeId)) {
                String value = resultMap.get(field);
                if (!StringUtil.isEmpty((CharSequence)value)) continue;
                String[] split = field.split("#");
                String filedLocalStr = MetadataUtil.getFiledLocalStr((String)split[0], (String)split[2]);
                String errorMsg = String.format(ResManager.loadKDString((String)"%s\u586b\u5199\u6709\u8bef\uff01", (String)"ImportDeclareReportPlugin_27", (String)"taxc-bdtaxr", (Object[])new Object[0]), filedLocalStr);
                throw new KDBizException(errorMsg);
            }
        }
    }

    private BigDecimal calcTotalAmount(Map<String, String> dataResult, String ... keys) {
        BigDecimal result = BigDecimal.ZERO;
        for (String key : keys) {
            BigDecimal decimal = BigDecimalUtil.toBigDecimal((Object)dataResult.get(key));
            result = BigDecimalUtil.addObject((Object)result, (Object)decimal);
        }
        return result;
    }

    private DynamicObject queryOrg(String orgNumber) {
        if (StringUtils.isBlank((CharSequence)orgNumber)) {
            return null;
        }
        QFilter idFilter = new QFilter("number", "=", (Object)orgNumber);
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{idFilter});
        return org;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if (("sbboverridereport".equals(callBackId) || "draftoverride".equals(callBackId)) && MessageBoxResult.Yes == e.getResult()) {
            IPageCache pageCache = this.getPageCache();
            String jsonCache = "";
            if ("sbboverridereport".equals(callBackId)) {
                jsonCache = pageCache.get(this.RECACHE);
            }
            if ("draftoverride".equals(callBackId)) {
                jsonCache = pageCache.get(this.BILLCACHE);
            }
            List cacheList = JSON.parseArray((String)jsonCache, Map.class);
            for (Map cacheMap : cacheList) {
                String orgid = (String)cacheMap.get("orgid");
                String startdate = (String)cacheMap.get(COL_FINANCIAL_SRARTDATE_STATEMENTS);
                Date skssqq = DateUtils.stringToDate((String)startdate);
                String enddate = (String)cacheMap.get(COL_FINANCIAL_ENDDATE_STATEMENTS);
                Date skssqz = DateUtils.stringToDate((String)enddate);
                String typeid = (String)cacheMap.get("typeid");
                String taxlimit = (String)cacheMap.get("taxlimit");
                Map resultMap = (Map)SerializationUtils.fromJsonString((String)((String)cacheMap.get("resultMap")), Map.class);
                if ("tvpt".equals(typeid)) {
                    Object existSbbids = cacheMap.get("existSbbids");
                    if (existSbbids != null) {
                        Long[] sbbids = (Long[])SerializationUtils.fromJsonString((String)((String)existSbbids), Long[].class);
                        TemplateUtilsOld.deleteReport((Boolean)true, (Long[])sbbids, (String)typeid);
                    }
                } else {
                    QFilter q1 = new QFilter(ORG_FIELD_ID, "=", (Object)Long.parseLong(orgid));
                    QFilter q2 = new QFilter(START_FIELD_ID, "=", (Object)skssqq);
                    QFilter q3 = new QFilter(END_FIELD_ID, "=", (Object)skssqz);
                    QFilter q4 = new QFilter(TYPE_FIELD_ID, "=", (Object)typeid);
                    DynamicObject sbbid = QueryServiceHelper.queryOne((String)DECLARE_ENTITY_ID, (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4});
                    TemplateUtilsOld.deleteReport((Long)Long.parseLong(orgid), (String)typeid, (Date)skssqq, (Date)skssqz, (String)taxlimit);
                    if (null != sbbid && ("zzsybnsr".equals(typeid) || "zzsybnsr_ybhz".equals(typeid))) {
                        QFilter q5 = new QFilter("sssbbid", "=", (Object)sbbid.getString("id"));
                        QFilter q6 = new QFilter("deductionperiod", "=", (Object)DISENABLE);
                        DynamicObject[] prepaySbb = BusinessDataServiceHelper.load((String)"tcvat_prepay_declare_bill", (String)"deductionperiod,sssbbid", (QFilter[])new QFilter[]{q5, q6});
                        Arrays.stream(prepaySbb).forEach(prepay -> prepay.set("sssbbid", (Object)DISENABLE));
                        SaveServiceHelper.update((DynamicObject[])prepaySbb);
                    }
                }
                TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)typeid);
                if (templateEnum != null) {
                    StatusUtils.delete((String)templateEnum.getDraftType(), (String)orgid, (String)startdate, (String)enddate, (String)"nssb");
                    StatusUtils.deleteDraftByTemplateType((TemplateEnum)templateEnum, (String)orgid, (String)startdate, (String)enddate, (String)"nssb");
                }
                String templateId = (String)cacheMap.get("templateId");
                String reportId = (String)cacheMap.get("reportId");
                this.saveDataAndRefresh(Long.parseLong(templateId), typeid, resultMap, reportId, orgid, startdate, enddate);
            }
        }
    }

    private void saveDataAndRefresh(long templateId, String templatetype, Map<String, String> resultMap, String reportId, String orgid, String startDate, String endDate) {
        ImportReportCalService.cal((IPageCache)this.getPageCache(), (Long)templateId, (String)templatetype, (String)orgid, (String)startDate, (String)endDate, resultMap);
        Map returnMap = DataSaveService.mapToTableOld((long)templateId, resultMap);
        TableTypeMapTemplateTypeEnum typeEnum = TableTypeMapTemplateTypeEnum.getEnumByTemplateType((String)templatetype);
        if (null != typeEnum || Arrays.asList(ImportDataConstant.getFinancialTypes()).contains(templatetype)) {
            this.autoRefreshElement((DynamicObjectCollection)returnMap.get(DECLARE_ENTITY_ID), typeEnum);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ImportDeclareReportPlugin_28", (String)"taxc-bdtaxr", (Object[])new Object[0]));
    }

    private void setValue(Map<String, FormulaVo> formulaVoMap, Map<String, String> resultMap, EntityField value, String inputValue, String rKey) {
        FormulaVo formulaVo;
        String ewblName = value.getEwblName();
        String fieldName = value.getFieldName();
        if (("Decimal".equals(value.getFieldType()) || "Integer".equals(value.getFieldType())) && this.filterSpecialCharacter(inputValue)) {
            if (!(inputValue = inputValue.replaceAll(",", "")).matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
                logger.info("Excel\u5355\u5143\u683c\u6570\u636e\u6821\u9a8c\uff1a{}", (Object)inputValue);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s\uff1a\u6570\u636e\u683c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u6570\u503c\u7c7b\u578b\u5355\u5143\u683c\u53ea\u80fd\u662f\u963f\u62c9\u4f2f\u6570\u5b57\uff0c\u4e14\u6570\u5b57\u4e2d\u4e0d\u80fd\u5e26\u6709\u4efb\u4f55\u7b26\u53f7\uff08\u975e\u4e2d\u6587\u8f93\u5165\u6cd5\u5f55\u5165\u7684\u5c0f\u6570\u70b9\uff0c\u8d1f\u53f7\u9664\u5916\uff09\u3002\u8bf7\u4e25\u683c\u6309\u7167\u4e0a\u8ff0\u6a21\u677f\u683c\u5f0f\u5f15\u5165\u3002", (String)"ImportDeclareReportPlugin_29", (String)"taxc-bdtaxr", (Object[])new Object[0]), ewblName, GANG, fieldName));
            }
        } else if ("Text".equals(value.getFieldType())) {
            if (inputValue.length() > value.getMaxLength()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s\uff1a\u5f55\u5165\u6587\u672c\u5b57\u7b26\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ImportDeclareReportPlugin_30", (String)"taxc-bdtaxr", (Object[])new Object[0]), ewblName, GANG, fieldName));
            }
        } else if ("Date".equals(value.getFieldType())) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                df.parse(inputValue);
            }
            catch (ParseException e) {
                String entityId = value.getEntityName();
                String fieldId = value.getFieldName();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u300a%1$s\u300b\u7684\u201c%2$s\u201d\u5217\u8bf7\u6539\u4e3aYYYY-MM-DD\u7684\u683c\u5f0f\u3002", (String)"ImportDeclareReportPlugin_31", (String)"taxc-bdtaxr", (Object[])new Object[0]), entityId, fieldId, inputValue));
            }
        }
        if ((formulaVo = formulaVoMap.get(rKey)) != null && "3".equals(formulaVo.getFormulaType())) {
            String celltype = formulaVo.getCellType();
            if ("5".equals(celltype)) {
                Map itemMap = TemplateShowUtils.parseCellType((String)formulaVo.getFormulaName());
                if (null == itemMap) {
                    return;
                }
                DeductionCodeCheckService.queryDeductionData((Map)itemMap, resultMap, (String)inputValue, (String)rKey);
            } else if ("2".equals(celltype) || "3".equals(celltype) || "4".equals(celltype)) {
                Map comboMap = TemplateShowUtils.parseCellType((String)formulaVo.getFormulaName());
                if ("jbrysfzjlx".equals(value.getFieldId()) && ("tcvat_ybnsr_zb".equals(value.getEntityId()) || "tcvat_xgm_zb".equals(value.getEntityId())) && !comboMap.containsValue(inputValue)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7ecf\u529e\u4eba\u5458\u8eab\u4efd\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u4ece\u4e0b\u62c9\u6846\u9009\u62e9\u3002", (String)"ImportDeclareReportPlugin_32", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
                for (Map.Entry entry : comboMap.entrySet()) {
                    if (!StringUtils.deleteWhitespace((String)((String)entry.getValue())).equals(StringUtils.deleteWhitespace((String)inputValue))) continue;
                    resultMap.put(rKey, (String)entry.getKey());
                    break;
                }
            }
        } else {
            resultMap.put(rKey, inputValue);
        }
    }

    private boolean filterSpecialCharacter(String inputValue) {
        return StringUtils.isNotBlank((CharSequence)inputValue) && !inputValue.equals("--") && !inputValue.equals("*");
    }

    private void validateDates(String orgid, String typeId, long templateId, Date skssqq, Date skssqz, Date fregistertime) {
        logger.info("typeId:" + typeId);
        logger.info("templateId:" + templateId);
        logger.info("skssqq:" + skssqq);
        logger.info("skssqz:" + skssqz);
        logger.info("orgid:" + orgid);
        if (StringUtils.isBlank((CharSequence)orgid) || DISENABLE.equals(orgid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u6216\u7ec4\u7ec7\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7ec4\u7ec7\u7f16\u7801\uff01", (String)"ImportDeclareReportPlugin_33", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if (skssqq == null || skssqz == null || skssqq.compareTo(skssqz) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\uff01", (String)"ImportDeclareReportPlugin_34", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)skssqq);
        if (!"tvpt".equals(typeId) && skssqq.compareTo(firstDateOfMonth) != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\uff01", (String)"ImportDeclareReportPlugin_34", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        String[] types = (String[])ImportDataConstant.getPeriodTypeMap().get(typeId);
        if (types != null) {
            boolean validDate = false;
            String[] stringArray = types;
            int n = stringArray.length;
            block10: for (int i = 0; i < n; ++i) {
                String type;
                switch (type = stringArray[i]) {
                    case "year": {
                        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)skssqq);
                        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)skssqz);
                        if (firstDateOfYear.compareTo(skssqq) != 0 || !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfYear))) continue block10;
                        validDate = true;
                        continue block10;
                    }
                    case "halfyear": {
                        Date firstDateOfHalfYear = DateUtils.getFirstDateOfHalfYear((Date)skssqq);
                        Date lastDateOfHalfYear = DateUtils.getLastDateOfHalfYear((Date)skssqq);
                        if (firstDateOfHalfYear.compareTo(skssqq) != 0 || !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfHalfYear))) continue block10;
                        validDate = true;
                        continue block10;
                    }
                    case "season": {
                        Date firstDateOfSeason = DateUtils.getFirstDateOfSeason((Date)skssqq);
                        Date lastDateOfSeason = DateUtils.getLastDateOfSeason((Date)skssqq);
                        Date lastDateOfMonth1 = DateUtils.getLastDateOfMonth((Date)skssqq);
                        if ((!DateUtils.format((Date)skssqq).equals(DateUtils.format((Date)firstDateOfSeason)) || !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfSeason))) && !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfMonth1))) continue block10;
                        validDate = true;
                        continue block10;
                    }
                    default: {
                        Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)skssqq);
                        if (!DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfMonth))) continue block10;
                        validDate = true;
                    }
                }
            }
            if (!validDate) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\uff01", (String)"ImportDeclareReportPlugin_34", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        } else {
            Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)skssqq);
            if (!"tvpt".equals(typeId) && !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfMonth))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\uff01", (String)"ImportDeclareReportPlugin_34", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        }
        DynamicObject template = QueryServiceHelper.queryOne((String)"tpo_template_old", (String)"startdate,enddate,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        Date tempStartDate = template.getDate(COL_FINANCIAL_SRARTDATE_STATEMENTS);
        Date tempEndDate = template.getDate(COL_FINANCIAL_ENDDATE_STATEMENTS);
        ArrayList endNumbers = Lists.newArrayList((Object[])new String[]{"RT2020", "YYS001", "CCS001", "EPT2018", "stamp-tax", "tcret2019"});
        if (endNumbers.contains(template.getString("number")) ? tempEndDate != null && skssqz.compareTo(tempEndDate) > 0 : tempStartDate.compareTo(skssqz) > 0 || tempEndDate != null && tempEndDate.compareTo(skssqq) < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5c5e\u671f\u4e0d\u5728\u6a21\u677f\u6709\u6548\u671f\u8303\u56f4\u5185\u3002", (String)"ImportDeclareReportPlugin_35", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if (Objects.nonNull(fregistertime) && fregistertime.after(skssqz)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u7a0e\u6b3e\u6240\u5c5e\u671f\u4e0d\u5f97\u65e9\u4e8e\u4f01\u4e1a\u767b\u8bb0\u65f6\u95f4\u3002", (String)"ImportDeclareReportPlugin_36", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    private Date formatDateStr(String dateStr) {
        Date date;
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\uff01", (String)"ImportDeclareReportPlugin_34", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        this.checkLeapYear(dateStr);
        try {
            date = DateUtils.stringToDate((String)dateStr);
        }
        catch (Exception e) {
            try {
                date = DateUtils.stringToDate((String)dateStr, (String)DateUtils.YYYYMMDD_CHINESE);
            }
            catch (Exception e1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01\u8bf7\u4e25\u683c\u6309\u7167\u6a21\u677f\u683c\u5f0f\u5f15\u5165\uff0c\u5408\u6cd5\u65e5\u671f\u683c\u5f0f xxxx\u5e74xx\u6708xx\u65e5\u6216yyyy-MM-dd", (String)"ImportDeclareReportPlugin_37", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        }
        return date;
    }

    private void checkLeapYear(String dateStr) {
        try {
            String[] split;
            String replace = dateStr.replace(ResManager.loadKDString((String)"\u5e74", (String)"ImportDeclareReportPlugin_38", (String)"taxc-bdtaxr", (Object[])new Object[0]), GANG).replace(ResManager.loadKDString((String)"\u6708", (String)"ImportDeclareReportPlugin_39", (String)"taxc-bdtaxr", (Object[])new Object[0]), GANG).replace(ResManager.loadKDString((String)"\u65e5", (String)"ImportDeclareReportPlugin_14", (String)"taxc-bdtaxr", (Object[])new Object[0]), "");
            if (replace.contains(GANG) && (split = replace.split(GANG)).length == 3) {
                Date lastDateOfMonth;
                int lastDayOfDate;
                int year = Integer.parseInt(split[0]);
                int month = Integer.parseInt(split[1]);
                int dayOfMonth = Integer.parseInt(split[2]);
                if (dayOfMonth > (lastDayOfDate = DateUtils.getDayOfDate((Date)(lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)(year + GANG + month), (String)"yyyy-MM")))))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01\u8bf7\u4e25\u683c\u6309\u7167\u6a21\u677f\u683c\u5f0f\u5f15\u5165\uff0c\u5408\u6cd5\u65e5\u671f\u683c\u5f0f xxxx\u5e74xx\u6708xx\u65e5\u6216xxxx\u5e74xx\u6708", (String)"ImportDeclareReportPlugin_15", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01\u8bf7\u4e25\u683c\u6309\u7167\u6a21\u677f\u683c\u5f0f\u5f15\u5165\uff0c\u5408\u6cd5\u65e5\u671f\u683c\u5f0f xxxx\u5e74xx\u6708xx\u65e5\u6216xxxx\u5e74xx\u6708", (String)"ImportDeclareReportPlugin_15", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    private void autoRefreshElement(DynamicObjectCollection nsrxxCollection, TableTypeMapTemplateTypeEnum typeEnum) {
        if (CollectionUtils.isEmpty((Collection)nsrxxCollection)) {
            return;
        }
        String tableType = typeEnum != null ? typeEnum.getTableType() : "2";
        DeclareMQSender.sendMQ((DynamicObjectCollection)nsrxxCollection, (String)tableType, (String)DeclareMQType.DECLARE.name(), (String)DeclareMQEvent.IMPORT.name());
    }

    public void remove(UploadEvent evt) {
        String cacheUrls = this.getPageCache().get("_file_list_");
        List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        for (Object url : evt.getUrls()) {
            filelist.removeIf(f -> f.get("uid").equals(((Map)url).get("uid")));
        }
        this.getPageCache().put("_file_list_", SerializationUtils.serializeToBase64(filelist));
    }

    public void upload(UploadEvent evt) {
        IDataModel model = this.getModel();
        this.getView().setVisible(Boolean.TRUE, new String[]{"urlsflex"});
        String cacheUrls = this.getPageCache().get("_file_list_");
        List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        Object[] urls = evt.getUrls();
        logger.info("\u83b7\u5f97\u4e0a\u4f20\u6587\u4ef6urls\uff1a{}", (Object)Arrays.toString(urls));
        this.getModel().beginInit();
        for (int i = 0; i < urls.length; ++i) {
            if (urls[i] == null) continue;
            String urlStr = (String)((Map)urls[i]).get("url");
            String name = (String)((Map)urls[i]).get("name");
            if (!StringUtils.isNotBlank((CharSequence)urlStr)) continue;
            filelist.add((Map)urls[i]);
            int index = model.createNewEntryRow("upload_urls");
            model.setValue("name", (Object)name, index);
            model.setValue("url", (Object)urlStr, index);
        }
        this.getModel().endInit();
        this.getView().updateView("upload_urls");
        this.getPageCache().put("_file_list_", SerializationUtils.serializeToBase64(filelist));
    }

    private String getParam(String param) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return (String)customParams.get(param);
    }

    protected static String getOldBillno(String reportId) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)DECLARE_ENTITY_ID, (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(reportId))});
        return null == dynamicObject ? null : dynamicObject.getString("billno");
    }
}

