/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare.importdeclare;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AttachmentMarkListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.upload.UploadOption;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.DeclareReportHideFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.service.DeclareReportHideService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.DeclareReportImportFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service.DeclareReportImportService;
import kd.taxc.bdtaxr.business.template.impl.TemplateServiceImpl;
import kd.taxc.bdtaxr.common.cal.eval.ImportReportCalService;
import kd.taxc.bdtaxr.common.db.DataSaveService;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.TemplateImportServiceHelper;
import kd.taxc.bdtaxr.common.declare.initparam.InitParamsService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.service.DeclareService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TableTypeMapTemplateTypeEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.mq.datasynchronize.DataSynchronizeMQSender;
import kd.taxc.bdtaxr.common.mq.datasynchronize.SynchronizeParam;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaMQSender;
import kd.taxc.bdtaxr.common.refactor.declare.ImportExcelHandler;
import kd.taxc.bdtaxr.common.refactor.declare.ImportHandlerFactory;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.service.CacheFormulaService;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.NsrxxValidatorUtils;
import kd.taxc.bdtaxr.common.taxdeclare.constant.ImportDataConstant;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TemplateTypeMappingEnum;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxorg.TaxOrgUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.ExcelUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.file.FileUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import kd.taxc.bdtaxr.formplugin.taxdeclare.importdeclare.ImportDeclareReportPlugin;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.ss.usermodel.Workbook;

public class ImportDeclareReportPluginNew
extends AbstractFormPlugin
implements UploadListener,
HyperLinkClickListener,
AttachmentMarkListener {
    private static Log logger = LogFactory.getLog(ImportDeclareReportPlugin.class);
    private static final String BTN_OK = "btnok";
    private static final String ENTRYENT_FINANCIAL_STATEMENTS = "entryent";
    private static final String COL_FINANCIAL_STATEMENTS = "textfield";
    private static final String COL_FINANCIAL_SRARTDATE_STATEMENTS = "startdate";
    private static final String COL_FINANCIAL_ENDDATE_STATEMENTS = "enddate";
    private static final String COL_FINANCIAL_ENDDATE_FILTERCONDITION = "filtercondition";
    private static final String FINANCIAL_TYPE_STATEMENTS = "selecttype";
    private static final String START_FIELD_ID = "skssqq";
    private static final String END_FIELD_ID = "skssqz";
    private static final String TEMP_FIELD_ID = "templateid";
    private static final String TYPE_FIELD_ID = "type";
    private static final String TCWAT_SZYSBH = "szybh";
    private static final String KJQYSDS_CONTRACTNUMBER = "contractnumber";
    private static final List<String> BUSNIESSNOLIST = Arrays.asList("szybh", "contractnumber");
    private static final String PARAM_TYPE = "source";
    private static final String DECLARE_ENTITY_ID = "tcvat_nsrxx";
    private static final String NSRSBH_FIELD_ID = "nsrsbh";
    private static final String NSRMC_FIELD_ID = "nsrmc";
    private static final String STATUS_FIELD_ID = "declarestatus";
    private static final String TAX_TYPE_PARAM = "taxtype";
    private static final Pattern PATTERN = Pattern.compile("^-?[0-9]+");
    private List<Map<String, String>> RECACHELIST = new ArrayList<Map<String, String>>();
    private String MARKWORDS = "";
    private String INTERRUPT_WORDS = "";
    private String RECACHE = "recache";
    private List<Map<String, String>> BILLCACHELIST = new ArrayList<Map<String, String>>();
    private String BILLMARKWORDS;
    private String BILLCACHE = "billcache";
    private String TEMPLATEID = "templateid";
    private String FILELIST = "_file_list_";
    public static final String REGEX_ID_CARD18 = "^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])$";
    private static ImportExcelHandler handler;
    private Map<String, String> excelDataMap = new HashMap<String, String>(16);
    private Map<String, String> templateExcelDataMap = new HashMap<String, String>(16);
    private Map<String, EntityField> templateEntityMap = new HashMap<String, EntityField>(16);
    private Map<String, List<Map.Entry<String, EntityField>>> sheetsMaps = new HashMap<String, List<Map.Entry<String, EntityField>>>(16);
    private long templateId;
    private String typeId;
    private static DeclareService declareService;
    private DeclareReportHideService declareReportHideService;
    private static DeclareReportImportService declareReportImportService;
    private List<String> NO_BLANK_SHEETS = new ArrayList<String>();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, "btnupload", "btndownload", "btndel", "buttondownload", FINANCIAL_TYPE_STATEMENTS, "next", "back", "step1", "step2"});
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        panel.addMarkListener((AttachmentMarkListener)this);
        panel.addUploadListener((UploadListener)this);
        EntryGrid tempGrid = (EntryGrid)this.getView().getControl(ENTRYENT_FINANCIAL_STATEMENTS);
        tempGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (FINANCIAL_TYPE_STATEMENTS.equals(name)) {
            ChangeData[] changeSet = e.getChangeSet();
            String templateType = (String)changeSet[0].getNewValue();
            this.getModel().deleteEntryData(ENTRYENT_FINANCIAL_STATEMENTS);
            this.queryEntityData(templateType);
        }
    }

    public void afterCreateNewData(EventObject evt) {
        List templatetypelist;
        String paramtype = this.getParam(PARAM_TYPE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"urlsflex"});
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(FINANCIAL_TYPE_STATEMENTS);
        this.initPage();
        if (paramtype != null && "declare".equals(paramtype.trim()) && EmptyCheckUtils.isNotEmpty((Object)(templatetypelist = (List)this.getView().getFormShowParameter().getCustomParam("templatetypelist")))) {
            ArrayList data = new ArrayList();
            templatetypelist.forEach(type -> {
                if (StringUtils.isNotEmpty((CharSequence)TemplateTypeMappingEnum.getDescByCode((String)type))) {
                    data.add(new ComboItem(new LocaleString(TemplateTypeMappingEnum.getDescByCode((String)type)), type));
                }
            });
            comboEdit.setComboItems(data);
            String templateType = ((ComboItem)data.get(0)).getValue();
            this.getModel().setValue(FINANCIAL_TYPE_STATEMENTS, (Object)templateType);
            this.queryEntityData(templateType);
        }
    }

    private void initPage() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"twostepflex", "back", BTN_OK});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"onestepflex", "btncancel", "next"});
        this.setStyle("step2", "step1", "label2", "label1");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENT_FINANCIAL_STATEMENTS);
        if (entity.size() == 1) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENT_FINANCIAL_STATEMENTS);
            entryGrid.selectRows(new int[]{0}, 0);
        }
    }

    private void queryEntityData(String templateType) {
        QFilter q = new QFilter("type.number", "=", (Object)templateType);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bdtaxr_template_main", (String)"id,name as textfield,type.id as typeid,startdate,enddate,filtercondition,conditionjson", (QFilter[])new QFilter[]{q}, (String)"startdate desc,number");
        if (dcs == null || dcs.isEmpty()) {
            return;
        }
        logger.info(dcs.toString());
        this.getModel().beginInit();
        List collect = dcs.stream().filter(e -> e.getString("conditionjson") == null || !e.getString("conditionjson").contains("zerodeclare")).collect(Collectors.toList());
        for (DynamicObject d : collect) {
            int index = this.getModel().createNewEntryRow(ENTRYENT_FINANCIAL_STATEMENTS);
            this.getModel().setValue("id", (Object)d.getLong("id"), index);
            this.getModel().setValue("typeid", (Object)d.getString("typeid"), index);
            String name = d.getString(COL_FINANCIAL_STATEMENTS);
            this.getModel().setValue(COL_FINANCIAL_STATEMENTS, (Object)name, index);
            Date startDate = d.getDate(COL_FINANCIAL_SRARTDATE_STATEMENTS) != null ? d.getDate(COL_FINANCIAL_SRARTDATE_STATEMENTS) : null;
            Date endDate = d.getDate(COL_FINANCIAL_ENDDATE_STATEMENTS) != null ? d.getDate(COL_FINANCIAL_ENDDATE_STATEMENTS) : null;
            this.getModel().setValue(COL_FINANCIAL_SRARTDATE_STATEMENTS, (Object)startDate, index);
            this.getModel().setValue(COL_FINANCIAL_ENDDATE_STATEMENTS, (Object)endDate, index);
            this.getModel().setValue(COL_FINANCIAL_ENDDATE_FILTERCONDITION, (Object)d.getString(COL_FINANCIAL_ENDDATE_FILTERCONDITION), index);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENT_FINANCIAL_STATEMENTS);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int index = hyperLinkClickEvent.getRowIndex();
        long id = (Long)this.getModel().getValue("id", index);
        try (InputStream in = TemplateShowUtils.getbuildExcel((String)"IMPORT", (Long)id);){
            String name = (String)this.getModel().getValue(COL_FINANCIAL_STATEMENTS, index);
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(name + ".xlsx", in, 5000);
            this.getView().openUrl(urls);
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnupload".equals(control.getKey())) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENT_FINANCIAL_STATEMENTS);
            int[] rows = entry.getSelectRows();
            if (rows.length != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u6a21\u677f\u7c7b\u578b", (String)"ImportDeclareReportPluginNew_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            UploadOption opt = new UploadOption();
            opt.setMultiple(true);
            opt.setTitle(ResManager.loadKDString((String)"\u4e0a\u4f20\u6570\u636e\u6587\u4ef6", (String)"ImportDeclareReportPluginNew_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            opt.setSuffix(".xlsx");
            this.getView().showUpload(opt, "btnupload");
        } else if ("buttondownload".equals(control.getKey())) {
            Object field = this.getModel().getValue("templatetype");
            if (field == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5148\u9009\u62e9\u9700\u8981\u4e0b\u8f7d\u7684\u6a21\u677f\u7c7b\u578b", (String)"ImportDeclareReportPluginNew_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        } else if ("btndel".equals(control.getKey())) {
            IDataModel model = this.getModel();
            int i = model.getEntryCurrentRowIndex("upload_urls");
            String cacheUrls = this.getPageCache().get(this.FILELIST);
            List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
            String url = (String)model.getValue("url", i);
            filelist.removeIf(f -> f.get("url").equals(url));
            this.getPageCache().put(this.FILELIST, SerializationUtils.serializeToBase64(filelist));
            model.deleteEntryRow("upload_urls", i);
            if (filelist.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"urlsflex"});
            }
        } else if (BTN_OK.equals(control.getKey())) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENT_FINANCIAL_STATEMENTS);
            int[] rows = entry.getSelectRows();
            if (rows.length != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u6a21\u677f\u7c7b\u578b", (String)"ImportDeclareReportPluginNew_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            String file_list = this.getPageCache().get(this.FILELIST);
            if (StringUtils.isEmpty((CharSequence)file_list)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"ImportDeclareReportPluginNew_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            List filelist = (List)SerializationUtils.deSerializeFromBase64((String)file_list);
            if (filelist.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"ImportDeclareReportPluginNew_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            this.RECACHELIST.clear();
            this.BILLCACHELIST.clear();
            this.MARKWORDS = "";
            this.BILLMARKWORDS = "";
            StringBuilder message = new StringBuilder();
            this.templateId = (Long)this.getModel().getValue("id", rows[0]);
            this.typeId = (String)this.getModel().getValue("typeid", rows[0]);
            DynamicObject templateContent = TemplateUtils.getTemplateDynamicObjectById((Long)this.templateId);
            this.templateExcelDataMap = TemplateShowUtils.getTemplateExcelDataMap((Long)this.templateId);
            this.templateEntityMap = TemplateShowUtils.queryTemplateFieldByTmpId((Long)this.templateId, (String)"bdtaxr_template_main");
            this.sheetsMaps = this.templateEntityMap.entrySet().stream().collect(Collectors.groupingBy(s -> ((String)s.getKey()).split("#")[0]));
            if (this.templateEntityMap.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u6a21\u677f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u5408\u6cd5\u6027", (String)"ImportDeclareReportPluginNew_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            for (int i = 0; i < filelist.size(); ++i) {
                Map fileMap = (Map)filelist.get(i);
                String file_url = (String)fileMap.get("url");
                String fileName = (String)fileMap.get("name");
                if (StringUtils.isBlank((CharSequence)file_url)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e", (String)"ImportDeclareReportPluginNew_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
                TempFileCacheDownloadable.Content content = FileUtils.getFileContent((String)file_url);
                if (content == null) {
                    throw new KDBizException("File Error!");
                }
                InputStream inputStream = content.getInputStream();
                Workbook hssfWorkbook = ExcelUtils.getWorkbook((InputStream)inputStream);
                this.excelDataMap = ExcelUtils.readDataToMap((Workbook)hssfWorkbook, (Boolean)Boolean.FALSE, (IFormView)this.getView());
                handler = ImportHandlerFactory.createHandler((String)this.typeId);
                try {
                    ValidDataResultVo validExcelType = handler.validExcelType(this.excelDataMap, templateContent);
                    if (!validExcelType.getSuccess()) {
                        throw new KDBizException(validExcelType.getMessage());
                    }
                    Map map = ExcelUtils.readDataToMap((Workbook)hssfWorkbook, (Boolean)Boolean.TRUE, (IFormView)this.getView());
                    ValidDataResultVo validDataResultVo = handler.validExcelData(map, templateContent);
                    if (!validDataResultVo.getSuccess()) {
                        ImportDeclareReportPluginNew.confirmTips("justContinue", validDataResultVo.getMessage(), file_url, this.getView(), (IFormPlugin)this);
                        continue;
                    }
                    this.handleInputStream(handler, this.excelDataMap, this.templateEntityMap, this.sheetsMaps, this.templateId, this.typeId);
                    continue;
                }
                catch (KDBizException e) {
                    logger.error((Throwable)e);
                    message.append(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5bfc\u5165\u5931\u8d25\u3002\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"ImportDeclareReportPluginNew_7", (String)"taxc-bdtaxr", (Object[])new Object[0]), fileName, e.getMessage())).append("\r\n");
                    continue;
                }
                catch (KDException e) {
                    logger.error("\u5f15\u5165\u5931\u8d25", (Throwable)e);
                    if (!e.getCause().toString().contains("10^13")) continue;
                    String msg = ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u91d1\u989d\u6574\u6570\u4f4d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc713\u4f4d\u3002", (String)"ImportDeclareReportPluginNew_39", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                    message.append(msg);
                    continue;
                }
                catch (RuntimeException e) {
                    logger.error((Throwable)e);
                    message.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"ImportDeclareReportPluginNew_38", (String)"taxc-bdtaxr", (Object[])new Object[0])).append("\r\n");
                    continue;
                }
                finally {
                    if (inputStream != null) {
                        FileUtils.safeClose((InputStream)inputStream);
                    }
                }
            }
            this.afterImportHandle(message);
        } else if ("next".equals(control.getKey()) || "step2".equals(control.getKey())) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENT_FINANCIAL_STATEMENTS);
            int[] rows = entry.getSelectRows();
            if (rows.length != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u6a21\u677f\u7c7b\u578b", (String)"ImportDeclareReportPluginNew_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            this.isClearTemplate(rows);
            Label templatename = (Label)this.getControl("templatename");
            templatename.setText(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u6a21\u677f\uff1a%s", (String)"ImportDeclareReportPluginNew_8", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.getModel().getValue(COL_FINANCIAL_STATEMENTS, rows[0])));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"twostepflex", "back", BTN_OK});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"onestepflex", "btncancel", "next"});
            this.setStyle("step1", "step2", "label1", "label2");
        } else if ("back".equals(control.getKey()) || "step1".equals(control.getKey())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"twostepflex", "back", BTN_OK});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"onestepflex", "btncancel", "next"});
            this.setStyle("step2", "step1", "label2", "label1");
        }
    }

    private void isClearTemplate(int[] rows) {
        Long id = (Long)this.getModel().getValue("id", rows[0]);
        String oldId = this.getPageCache().get(this.TEMPLATEID);
        this.getPageCache().put(this.TEMPLATEID, String.valueOf(id));
        if (oldId == null || Long.parseLong(oldId) == id) {
            return;
        }
        String cacheUrls = this.getPageCache().get(this.FILELIST);
        List filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        AttachmentPanel attachmentpanelap = (AttachmentPanel)this.getControl("attachmentpanelap");
        for (Map data : filelist) {
            attachmentpanelap.remove(data);
        }
    }

    private void setStyle(String step1, String step2, String lable1, String lable2) {
        HashMap<String, Object> colorMap1 = new HashMap<String, Object>();
        HashMap<String, Object> colorMap2 = new HashMap<String, Object>();
        String stepColor1 = "#CCCCCC";
        String linestyle1 = "1px_solid_#CCCCCC";
        colorMap1.put("followTheme", Boolean.FALSE);
        colorMap1.put("fc", stepColor1);
        HashMap style1 = new HashMap();
        HashMap<String, String> border1 = new HashMap<String, String>();
        border1.put("t", linestyle1);
        border1.put("l", linestyle1);
        border1.put("r", linestyle1);
        border1.put("b", linestyle1);
        style1.put("b", border1);
        colorMap1.put("s", style1);
        String stepColor2 = "themeColor";
        String linestyle2 = "1px_solid_themeColor";
        colorMap2.put("followTheme", Boolean.TRUE);
        colorMap2.put("fc", stepColor2);
        HashMap style2 = new HashMap();
        HashMap<String, String> border2 = new HashMap<String, String>();
        border2.put("t", linestyle2);
        border2.put("l", linestyle2);
        border2.put("r", linestyle2);
        border2.put("b", linestyle2);
        style2.put("b", border2);
        colorMap2.put("s", style2);
        this.getView().updateControlMetadata(step1, colorMap1);
        this.getView().updateControlMetadata(step2, colorMap2);
        String statusColor1 = "#CCCCCC";
        String statusColor2 = "themeColor";
        HashMap<String, String> labColorMap1 = new HashMap<String, String>();
        HashMap<String, String> labColorMap2 = new HashMap<String, String>();
        labColorMap1.put("fc", statusColor1);
        labColorMap2.put("fc", statusColor2);
        this.getView().updateControlMetadata(lable1, labColorMap1);
        this.getView().updateControlMetadata(lable2, labColorMap2);
    }

    private void afterImportHandle(StringBuilder message) {
        if (message.length() > 0 && !"null".equals(message.toString()) && !"".equals(message.toString())) {
            this.getView().showErrorNotification(message.toString());
        }
        if (this.RECACHELIST.size() > 0 && (this.MARKWORDS.length() > 0 || this.INTERRUPT_WORDS.length() > 0)) {
            if (this.INTERRUPT_WORDS.length() > 0) {
                this.getView().showErrorNotification(this.INTERRUPT_WORDS);
                return;
            }
            String reCache = JSONArray.toJSONString(this.RECACHELIST);
            this.getPageCache().put(this.RECACHE, reCache);
            ConfirmCallBackListener callBack = new ConfirmCallBackListener("sbboverridereport", (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\r\n%s\u8bf7\u786e\u8ba4\u662f\u5426\u8986\u76d6\uff1f", (String)"ImportDeclareReportPluginNew_9", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.MARKWORDS), MessageBoxOptions.OKCancel, callBack);
            return;
        }
        if (this.BILLCACHELIST.size() > 0 && this.BILLMARKWORDS.length() > 0) {
            String billCache = JSONArray.toJSONString(this.BILLCACHELIST);
            this.getPageCache().put(this.BILLCACHE, billCache);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u653e\u5f03\u5f15\u5165", (String)"ImportDeclareReportPluginNew_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u5f15\u5165", (String)"ImportDeclareReportPluginNew_11", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("draftoverride", (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u5c5e\u671f\u5e95\u7a3f\u4e2d\u5b58\u5728\u7f16\u8f91\u7684\u5e95\u7a3f\u6570\u636e\uff0c\u7ee7\u7eed\u64cd\u4f5c\u5c06\u5220\u9664\u5e95\u7a3f\u6570\u636e\uff0c\u53ef\u9009\u62e9\u4ee5\u4e0b\u64cd\u4f5c", (String)"ImportDeclareReportPluginNew_12", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.BILLMARKWORDS), "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleInputStream(ImportExcelHandler handler, Map<String, String> importExcelDataMap, Map<String, EntityField> templateEntityMap, Map<String, List<Map.Entry<String, EntityField>>> sheetsMaps, long templateId, String typeId) {
        void var26_31;
        DynamicObject reportExistsId;
        Map formulaVoMap = CacheFormulaService.getCellFormulas((Long)templateId);
        DynamicObject template = TemplateUtils.getTemplateObjectById((String)String.valueOf(templateId));
        Map declareMainInfos = handler.parseDeclareMainInfos(importExcelDataMap, sheetsMaps);
        HashMap<String, String> resultMap = new HashMap<String, String>(templateEntityMap.size());
        Map excelLastLineMap = TemplateImportServiceHelper.getLastLine(importExcelDataMap);
        Map excelIndex2DynamicRowNoMap = TemplateImportServiceHelper.getExcelIndex2DynamicRowNoMap((Long)templateId, templateEntityMap);
        Map dynRowIndexMap = TemplateImportServiceHelper.getDynRowIndexMap(resultMap, (Map)formulaVoMap, (Map)excelIndex2DynamicRowNoMap, importExcelDataMap, this.templateExcelDataMap, templateEntityMap, (Map)excelLastLineMap, (Map)declareMainInfos);
        Map offsets = TemplateImportServiceHelper.getOffsets((Map)dynRowIndexMap, templateEntityMap, (Map)excelIndex2DynamicRowNoMap);
        ImportDataVo importDataVo = new ImportDataVo();
        String number = null;
        if (template != null) {
            number = template.getString("number");
        }
        for (Map.Entry<String, List<Map.Entry<String, EntityField>>> sheet : sheetsMaps.entrySet()) {
            String sheetName = sheet.getKey();
            if ("TEMPLATE_ID".equals(sheetName)) continue;
            List<Map.Entry<String, Object>> sheetMapList = sheet.getValue();
            Comparator<Map.Entry> comparing1 = Comparator.comparing(s -> Integer.parseInt(((String)s.getKey()).split("#")[1]));
            Comparator<Map.Entry> comparing2 = Comparator.comparing(s -> Integer.parseInt(((String)s.getKey()).split("#")[2]));
            sheetMapList = sheetMapList.stream().sorted(comparing1.thenComparing(comparing2)).collect(Collectors.toList());
            String key = "";
            for (Map.Entry<String, Object> entry : sheetMapList) {
                key = entry.getKey();
                EntityField value = (EntityField)entry.getValue();
                String row = key.substring(0, key.lastIndexOf("#"));
                if (excelIndex2DynamicRowNoMap.containsKey(row)) continue;
                key = this.getNewKey(offsets, entry.getKey());
                String inputValue = StringUtil.trim((String)importExcelDataMap.get(key));
                String entryId = value.getEntityId();
                String ewblxh = value.getEwblxh();
                String fieldId = value.getFieldId();
                String rKey = entryId + "#" + ewblxh + "#" + fieldId;
                if (StringUtils.isNotBlank((CharSequence)inputValue)) {
                    if (DECLARE_ENTITY_ID.equals(entryId)) {
                        this.setTcvatNsrxx(formulaVoMap, resultMap, importDataVo, value, inputValue, fieldId, rKey, declareMainInfos);
                    } else if ("tcetr_declare_main".equals(entryId)) {
                        this.setTcetrDeclareMain(formulaVoMap, resultMap, importDataVo, value, inputValue, fieldId, rKey, declareMainInfos);
                    } else {
                        TemplateImportServiceHelper.setValue((Map)formulaVoMap, resultMap, (EntityField)value, (String)inputValue, (String)rKey, (Map)declareMainInfos);
                    }
                    if (this.NO_BLANK_SHEETS.contains(sheetName)) continue;
                    this.NO_BLANK_SHEETS.add(sheetName);
                    continue;
                }
                if (!"Decimal".equals(value.getFieldType())) continue;
                resultMap.put(rKey, "0");
            }
        }
        handler.initImportData(importDataVo, resultMap);
        if (null != number && number.startsWith("VAT")) {
            BigDecimal totalmsxm;
            int i;
            for (i = 2; i < 11; ++i) {
                totalmsxm = this.calcTotalAmount(resultMap, "tcvat_ybnsr_jsxm#" + i + "#qcye", "tcvat_ybnsr_jsxm#" + i + "#bqfse", "tcvat_ybnsr_jsxm#" + i + "#bqydjse", "tcvat_ybnsr_jsxm#" + i + "#bqsjdjse", "tcvat_ybnsr_jsxm#" + i + "#qmye");
                if (totalmsxm.compareTo(BigDecimal.ZERO) == 0 || null != resultMap.get("tcvat_ybnsr_jsxm#" + i + "#swsxdm")) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u51cf\u514d\u7a0e\u7533\u62a5\u660e\u7ec6\u8868\u7b2c%s\u884c\u5b58\u5728\u660e\u7ec6\u884c\u6570\u636e\u672a\u586b\u5199\u51cf\u514d\u6027\u8d28\u4ee3\u7801\u3002", (String)"ImportDeclareReportPluginNew_13", (String)"taxc-bdtaxr", (Object[])new Object[0]), i));
            }
            for (i = 4; i < 16; ++i) {
                totalmsxm = this.calcTotalAmount(resultMap, "tcvat_ybnsr_msxm#" + i + "#mzzzsxmxse", "tcvat_ybnsr_msxm#" + i + "#bqsjkcje", "tcvat_ybnsr_msxm#" + i + "#kchmsxse", "tcvat_ybnsr_msxm#" + i + "#mse");
                if (totalmsxm.compareTo(BigDecimal.ZERO) == 0 || null != resultMap.get("tcvat_ybnsr_msxm#" + i + "#swsxdm")) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u51cf\u514d\u7a0e\u7533\u62a5\u660e\u7ec6\u8868\u7b2c%s\u884c\u5b58\u5728\u660e\u7ec6\u884c\u6570\u636e\u672a\u586b\u5199\u514d\u7a0e\u6027\u8d28\u4ee3\u7801\u3002", (String)"ImportDeclareReportPluginNew_14", (String)"taxc-bdtaxr", (Object[])new Object[0]), i));
            }
        }
        this.validOperatorno(typeId, template, resultMap);
        String orgid = importDataVo.getOrgId();
        Date startDate = importDataVo.getStartDate();
        Date endDate = importDataVo.getEndDate();
        this.validateDates(orgid, typeId, templateId, startDate, endDate, importDataVo.getRegisterTime());
        this.validatePayRecord(importDataVo, typeId);
        List<String> hideSheets = null;
        this.declareReportHideService = DeclareReportHideFactory.createHandler(typeId);
        if (this.declareReportHideService != null) {
            DeclareRequestModel requestModel = new DeclareRequestModel();
            requestModel.setOrgId(Long.valueOf(orgid));
            requestModel.setTemplateId(Long.valueOf(templateId));
            requestModel.setTemplateType(typeId);
            requestModel.setSkssqq(DateUtils.format((Date)startDate));
            requestModel.setSkssqz(DateUtils.format((Date)endDate));
            hideSheets = this.declareReportHideService.hideSheets(requestModel);
            if (!CollectionUtils.isEmpty(this.NO_BLANK_SHEETS) && !CollectionUtils.isEmpty(hideSheets)) {
                logger.info("notBlankSheet:{}, hideSheets:{}", (Object)JSONObject.toJSONString(this.NO_BLANK_SHEETS), (Object)JSONObject.toJSONString(hideSheets));
                this.NO_BLANK_SHEETS.retainAll(hideSheets);
                logger.info("\u53d6\u4ea4\u96c6\u540enotBlankSheet:{}", (Object)JSONObject.toJSONString(this.NO_BLANK_SHEETS));
                if (!CollectionUtils.isEmpty(this.NO_BLANK_SHEETS)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u9690\u85cf\u9875\u7b7e\u5355\u5143\u683c\u4e0d\u80fd\u586b\u503c\u3002", (String)"ImportDeclareReportPluginNew_15", (String)"taxc-bdtaxr", (Object[])new Object[0]), StringUtil.join((Object[])new List[]{this.NO_BLANK_SHEETS})));
                }
            }
            if (!CollectionUtils.isEmpty(hideSheets)) {
                HashSet removedKeys = new HashSet();
                HashSet saveKeys = new HashSet();
                for (Map.Entry<String, Object> entry : sheetsMaps.entrySet()) {
                    List fields = (List)entry.getValue();
                    if (hideSheets.contains(entry.getKey())) {
                        fields.forEach(el -> removedKeys.add(((EntityField)el.getValue()).getReportId()));
                        continue;
                    }
                    fields.forEach(el -> saveKeys.add(((EntityField)el.getValue()).getReportId()));
                }
                Sets.SetView differenKeys = Sets.difference(removedKeys, saveKeys);
                if (!CollectionUtils.isEmpty((Collection)differenKeys)) {
                    differenKeys.forEach(k -> resultMap.remove(k));
                }
            }
        }
        String reportId = (reportExistsId = handler.queryReportExistsId(new ImportDataVo(orgid, typeId, startDate, endDate, resultMap))) != null && StringUtil.isNotEmpty((CharSequence)reportExistsId.getString("id")) ? reportExistsId.getString("id") : String.valueOf(DB.genLongId((String)DECLARE_ENTITY_ID));
        String taxLimit = null;
        String mainTable = TemplateUtils.getMainTableByTemplateId((Long)templateId);
        Object var26_29 = null;
        String oldVersionType = null;
        if (mainTable != null) {
            String string = ImportDeclareReportPluginNew.getOldBillno(reportId, mainTable);
            oldVersionType = DeclareUtils.getVersionType((String)reportId, (String)mainTable);
        }
        if ("drawback".equals(typeId) || "etrsc".equals(typeId) || "etrscsum".equals(typeId)) {
            resultMap.put("tcetr_declare_main#1#templateid", String.valueOf(templateId));
            resultMap.put("tcetr_declare_main#1#type", typeId);
            resultMap.put("tcetr_declare_main#1#declarestatus", "editing");
            resultMap.put("tcetr_declare_main#1#id", reportId);
            resultMap.put("tcetr_declare_main#1#sourcetype", "2");
            resultMap.put("tcetr_declare_main#1#billstatus", "C");
            if (null == var26_31) {
                resultMap.put("tcetr_declare_main#1#billno", ImportDeclareReportPluginNew.getBillNo(handler, typeId, orgid, reportId, (String)resultMap.get("tcetr_declare_main#1#month")));
            } else {
                resultMap.put("tcetr_declare_main#1#billno", (String)var26_31);
            }
            resultMap.put("tcetr_declare_main#1#modifytime", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            resultMap.put("tcetr_declare_main#1#createtime", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            resultMap.put("tcetr_declare_main#1#modifier", RequestContext.get().getUserId());
            resultMap.put("tcetr_declare_main#1#creator", RequestContext.get().getUserId());
        } else {
            if ("dkdj".equals(typeId)) {
                resultMap.put("tcvat_nsrxx#1#declaredate", DateUtils.format((Date)new Date()));
            } else if ("whsyjsf".equals(typeId)) {
                resultMap.put("tctb_declare_entry#1#bqdybtse", resultMap.getOrDefault("totf_whsyjsf_zb#1#bqybtse", "0"));
                resultMap.put("tctb_declare_entry#1#sjje", resultMap.getOrDefault("totf_whsyjsf_zb#1#bqyjfe", "0"));
                resultMap.put("tctb_declare_entry#1#qjje", resultMap.getOrDefault("totf_whsyjsf_zb#1#qzqjfe", "0"));
            }
            resultMap.put("tcvat_nsrxx#1#templateid", String.valueOf(templateId));
            resultMap.put("tcvat_nsrxx#1#type", typeId);
            if (!"FR0011".contains(typeId)) {
                resultMap.put("tcvat_nsrxx#1#declarestatus", "editing");
            }
            resultMap.put("tcvat_nsrxx#1#paystatus", "unpaid");
            resultMap.put("tcvat_nsrxx#1#billstatus", this.isTcvatAudit(Long.parseLong(orgid)) ? "A" : "C");
            resultMap.put("tcvat_nsrxx#1#datatype", "2");
            resultMap.put("tcvat_nsrxx#1#id", reportId);
            resultMap.put("tcvat_nsrxx#1#archivestatus", "unfiled");
            if (null == var26_31) {
                resultMap.put("tcvat_nsrxx#1#billno", ImportDeclareReportPluginNew.getBillNo(handler, typeId, orgid, reportId, (String)resultMap.get("tcvat_nsrxx#1#skssqz")));
                resultMap.put("tcvat_nsrxx#1#versiontype", "zcsb");
            } else {
                resultMap.put("tcvat_nsrxx#1#billno", (String)var26_31);
                resultMap.put("tcvat_nsrxx#1#versiontype", oldVersionType);
            }
            resultMap.put("tcvat_nsrxx#1#modifytime", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            resultMap.put("tcvat_nsrxx#1#createtime", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            resultMap.put("tcvat_nsrxx#1#modifier", RequestContext.get().getUserId());
            resultMap.put("tcvat_nsrxx#1#creator", RequestContext.get().getUserId());
            taxLimit = DateUtils.getTaxLimit((Date)startDate, (Date)endDate);
            resultMap.put("tcvat_nsrxx#1#taxlimit", taxLimit);
            resultMap.put("tcvat_nsrxx#1#apanage", "\u2014");
            resultMap.put("tcvat_nsrxx#1#tcrettype", "fcscztdsys");
            resultMap.put("tcvat_nsrxx#1#sblx", "1");
            resultMap.put("tcvat_nsrxx#1#serialno", "0");
        }
        ValidDataResultVo validDataResultVo = handler.validResultMap(importDataVo, resultMap, template);
        if (!validDataResultVo.getSuccess()) {
            throw new KDBizException(validDataResultVo.getMessage());
        }
        String startdateStr = DateUtils.format((Date)startDate);
        String enddateStr = DateUtils.format((Date)endDate);
        if (reportExistsId != null) {
            HashMap<String, String> cacheMap = new HashMap<String, String>();
            cacheMap.put("orgid", orgid);
            cacheMap.put(COL_FINANCIAL_SRARTDATE_STATEMENTS, startdateStr);
            cacheMap.put(COL_FINANCIAL_ENDDATE_STATEMENTS, enddateStr);
            cacheMap.put("typeid", typeId);
            cacheMap.put("taxlimit", taxLimit);
            cacheMap.put("templateId", String.valueOf(templateId));
            cacheMap.put("taxauthority", (String)resultMap.get("tcvat_nsrxx#1#taxauthority"));
            cacheMap.put("businessno", (String)resultMap.get("tcvat_nsrxx#1#businessno"));
            cacheMap.put("reportId", reportId);
            cacheMap.put("resultMap", SerializationUtils.toJsonString(resultMap));
            cacheMap.put("sheetNames", String.join((CharSequence)",", excelLastLineMap.keySet()));
            this.RECACHELIST.add(cacheMap);
            String sDate = DateUtils.format((Date)startDate, (String)ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"ImportDeclareReportPluginNew_16", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            String eDate = DateUtils.format((Date)endDate, (String)ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"ImportDeclareReportPluginNew_16", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            if ("etrscsum".equals(typeId)) {
                this.INTERRUPT_WORDS = this.INTERRUPT_WORDS + String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u3010%3$s\u3011\u7684\u7533\u62a5\u8868\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u8986\u76d6\uff01", (String)"ImportDeclareReportPluginNew_17", (String)"taxc-bdtaxr", (Object[])new Object[0]), importDataVo.getOrgName(), sDate, eDate);
            }
            if ("drawback".equals(typeId)) {
                String batchNo = (String)resultMap.get("tcetr_declare_main#1#batchno");
                this.MARKWORDS = String.format(ResManager.loadKDString((String)"%1$s\u5728%2$s-%3$s\u671f\u95f4%4$s\u6279\u6b21\u7684\u7533\u62a5\u8868\uff0c\r\n", (String)"ImportDeclareReportPluginNew_18", (String)"taxc-bdtaxr", (Object[])new Object[0]), importDataVo.getOrgName(), sDate, eDate, batchNo);
            } else if ("qtsf_tysbb".equals(typeId) || "qtsf_fsstysbb".equals(typeId)) {
                this.INTERRUPT_WORDS = this.INTERRUPT_WORDS + String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u3010%3$s\u3011\u7684\u7533\u62a5\u8868\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u8986\u76d6\uff01", (String)"ImportDeclareReportPluginNew_17", (String)"taxc-bdtaxr", (Object[])new Object[0]), importDataVo.getOrgName(), sDate, eDate);
            } else if ("3".equals(reportExistsId.getString("datatype"))) {
                this.INTERRUPT_WORDS = this.INTERRUPT_WORDS + String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u3010%3$s\u3011\u5b58\u5728\u7a0e\u5c40\u4e0b\u8f7d\u7684\u7533\u62a5\u8868\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u5f15\u5165\u3002", (String)"ImportDeclareReportPluginNew_19", (String)"taxc-bdtaxr", (Object[])new Object[0]), importDataVo.getOrgName(), sDate, eDate);
            } else {
                this.MARKWORDS = "latyj".equals(typeId) || "latwp".equals(typeId) ? String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011\u3010%3$s\u3011\u3010%4$s\u3011\u3010%5$s\u3011\u7684\u7533\u62a5\u8868\uff0c\r\n", (String)"ImportDeclareReportPluginNew_20", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.MARKWORDS, importDataVo.getOrgName(), resultMap.get("tcret_tdzzs_base_tax#1#proname"), sDate, eDate) : String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011\u3010%3$s\u3011\u3010%4$s\u3011\u7684\u7533\u62a5\u8868\uff0c\r\n", (String)"ImportDeclareReportPluginNew_21", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.MARKWORDS, importDataVo.getOrgName(), sDate, eDate);
            }
        } else {
            TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)typeId);
            if (templateEnum != null) {
                DynamicObject object = StatusUtils.queryOne((String)templateEnum.getDraftType(), (String)orgid, (String)startdateStr, (String)enddateStr, (String)"nssb");
                if (object != null) {
                    HashMap<String, String> cacheMap = new HashMap<String, String>();
                    cacheMap.put("orgid", orgid);
                    cacheMap.put(COL_FINANCIAL_SRARTDATE_STATEMENTS, startdateStr);
                    cacheMap.put(COL_FINANCIAL_ENDDATE_STATEMENTS, enddateStr);
                    cacheMap.put("typeid", typeId);
                    cacheMap.put("taxlimit", taxLimit);
                    cacheMap.put("templateId", String.valueOf(templateId));
                    cacheMap.put("reportId", reportId);
                    cacheMap.put("resultMap", SerializationUtils.toJsonString(resultMap));
                    cacheMap.put("sheetNames", String.join((CharSequence)",", excelLastLineMap.keySet()));
                    this.BILLCACHELIST.add(cacheMap);
                    TaxResult dynamicObjectTaxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)Long.parseLong(orgid));
                    this.BILLMARKWORDS = this.BILLMARKWORDS + "\u3010" + ((DynamicObject)dynamicObjectTaxResult.getData()).getString("taxpayer") + "\u3011\u3010" + startdateStr + "\u3011\u3010" + enddateStr + "\u3011\r\n";
                } else {
                    this.saveDataAndRefresh(templateId, typeId, new ArrayList<String>(excelLastLineMap.keySet()), resultMap, reportId, orgid, startdateStr, enddateStr);
                }
            } else {
                this.saveDataAndRefresh(templateId, typeId, new ArrayList<String>(excelLastLineMap.keySet()), resultMap, reportId, orgid, startdateStr, enddateStr);
            }
        }
    }

    private void validatePayRecord(ImportDataVo importDataVo, String typeId) {
        handler.checkPayRecord(importDataVo.getOrgId(), importDataVo.getStartDate(), importDataVo.getEndDate(), typeId);
    }

    private boolean isTcvatAudit(Long orgid) {
        String appId = this.getView().getFormShowParameter().getAppId();
        return "tcvat".equals(appId) && !SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"importisaudit", (long)orgid);
    }

    private void validOperatorno(String typeId, DynamicObject template, Map<String, String> resultMap) {
        String operatorno;
        String number = template.getString("number");
        if ((typeId.equals("qtsf_tysbb") || typeId.equals("qtsf_fsstysbb") || typeId.equals("qysdsjb") && ("CITQR2021".equals(number) || "CITQR2023".equals(number))) && StringUtil.isNotEmpty((CharSequence)(operatorno = resultMap.get("tcvat_nsrxx#1#operatorno"))) && !ImportDeclareReportPluginNew.isIDCard18(operatorno)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ecf\u529e\u4eba\u8eab\u4efd\u8bc1\u4e0d\u5408\u6cd5\uff01", (String)"ImportDeclareReportPluginNew_22", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    private void setTcetrDeclareMain(Map<String, FormulaVo> formulaVoMap, Map<String, String> resultMap, ImportDataVo importDataVo, EntityField value, String inputValue, String fieldId, String rKey, Map<String, Object> declareMainInfos) {
        if (NSRSBH_FIELD_ID.equals(fieldId)) {
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByUnifiedsocialCode((String)inputValue);
            if (!result.isSuccess()) {
                throw new KDBizException(result.getMessage());
            }
            if (EmptyCheckUtils.isEmpty((Object)result.getData())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u5f02\u5e38\uff0c\u6ca1\u6709\u67e5\u5230\u76f8\u5173\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u7684\u6b63\u786e\u6027\u3002", (String)"ImportDeclareReportPluginNew_23", (String)"taxc-bdtaxr", (Object[])new Object[0]), inputValue));
            }
            DynamicObject dobj = (DynamicObject)result.getData();
            String orgid = dobj.getString("taxorg.id");
            importDataVo.setOrgId(orgid);
            String orgName = dobj.getString("taxorg.org.name");
            importDataVo.setOrgName(orgName);
            resultMap.put("tcetr_declare_main#1#nsrsbh", inputValue);
            resultMap.put("tcetr_declare_main#1#nsrmc", dobj.getString("taxorg.taxpayer"));
            resultMap.put("tcetr_declare_main#1#org", orgid);
        } else if (NSRMC_FIELD_ID.equals(fieldId)) {
            DynamicObjectCollection obj = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"name", (Object)inputValue));
            if (CollectionUtils.isEmpty((Collection)obj)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u540d\u79f0\u5f02\u5e38\uff0c\u6ca1\u6709\u67e5\u5230\u76f8\u5173\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u7eb3\u7a0e\u4eba\u540d\u79f0\u7684\u6b63\u786e\u6027\u3002", (String)"ImportDeclareReportPluginNew_24", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByTaxpayer((String)inputValue);
            if (!result.isSuccess()) {
                throw new KDBizException(result.getMessage());
            }
            if (EmptyCheckUtils.isEmpty((Object)result.getData())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u8be5\u7ec4\u7ec7\u3010%s\u3011\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5148\u5728\u57fa\u7840\u8bbe\u7f6e-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u4e2d\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"ImportDeclareReportPluginNew_25", (String)"taxc-bdtaxr", (Object[])new Object[0]), inputValue));
            }
            DynamicObject dynamicObject = (DynamicObject)result.getData();
            Date registerTime = dynamicObject.getDate("registertime");
            importDataVo.setRegisterTime(registerTime);
        } else if ("month".equals(fieldId)) {
            String regex = "^\\d{6}$";
            if (!inputValue.matches(regex)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u5e74\u6708\u586b\u5199\u9519\u8bef\uff01", (String)"ImportDeclareReportPluginNew_26", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            Date startDate = DateUtils.stringToDate((String)inputValue, (String)"yyyyMM");
            Date endDate = DateUtils.getLastDateOfMonth((Date)startDate);
            importDataVo.setStartDate(startDate);
            importDataVo.setEndDate(endDate);
            resultMap.put("tcetr_declare_main#1#month", DateUtils.format((Date)startDate));
            resultMap.put("tcetr_declare_main#1#skssqq", DateUtils.format((Date)startDate));
            resultMap.put("tcetr_declare_main#1#skssqz", DateUtils.format((Date)endDate));
        } else {
            TemplateImportServiceHelper.setValue(formulaVoMap, resultMap, (EntityField)value, (String)inputValue, (String)rKey, declareMainInfos);
        }
    }

    private void setTcvatNsrxx(Map<String, FormulaVo> formulaVoMap, Map<String, String> resultMap, ImportDataVo importDataVo, EntityField value, String inputValue, String fieldId, String rKey, Map<String, Object> declareMainInfos) {
        if (NSRSBH_FIELD_ID.equals(fieldId)) {
            boolean zerodeclare;
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByUnifiedsocialCode((String)inputValue);
            if (!result.isSuccess()) {
                throw new KDBizException(result.getMessage());
            }
            if (EmptyCheckUtils.isEmpty((Object)result.getData())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u5f02\u5e38\uff0c\u6ca1\u6709\u67e5\u5230\u76f8\u5173\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u7684\u6b63\u786e\u6027\u3002", (String)"ImportDeclareReportPluginNew_23", (String)"taxc-bdtaxr", (Object[])new Object[0]), inputValue));
            }
            DynamicObject dobj = (DynamicObject)result.getData();
            String orgid = dobj.getString("taxorg.id");
            String orgName = dobj.getString("taxorg.org.name");
            String appId = this.getView().getFormShowParameter().getAppId();
            List<String> list = Collections.singletonList("totf");
            if (!list.contains(appId) && (zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)appId, (String)"zerodeclare", (long)Long.parseLong(orgid)))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u5f15\u5165\u3002", (String)"ImportDeclareReportPluginNew_27", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgName));
            }
            importDataVo.setOrgId(orgid);
            importDataVo.setOrgName(orgName);
            resultMap.put("tcvat_nsrxx#1#nsrsbh", inputValue);
            resultMap.put("tcvat_nsrxx#1#nsrmc", TaxOrgUtil.getTaxpayer((DynamicObject)dobj.getDynamicObject("taxorg")));
            resultMap.put("tcvat_nsrxx#1#taxauthority", dobj.getString("taxoffice.id"));
            resultMap.put("tcvat_nsrxx#1#org", orgid);
        } else if (NSRMC_FIELD_ID.equals(fieldId)) {
            DynamicObjectCollection obj = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"name", (Object)inputValue));
            if (CollectionUtils.isEmpty((Collection)obj)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u540d\u79f0\u5f02\u5e38\uff0c\u6ca1\u6709\u67e5\u5230\u76f8\u5173\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u7eb3\u7a0e\u4eba\u540d\u79f0\u7684\u6b63\u786e\u6027\u3002", (String)"ImportDeclareReportPluginNew_24", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByTaxpayer((String)inputValue);
            if (!result.isSuccess()) {
                throw new KDBizException(result.getMessage());
            }
            if (EmptyCheckUtils.isEmpty((Object)result.getData())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u8be5\u7ec4\u7ec7\u3010%s\u3011\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5148\u5728\u57fa\u7840\u8bbe\u7f6e-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u4e2d\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"ImportDeclareReportPluginNew_25", (String)"taxc-bdtaxr", (Object[])new Object[0]), inputValue));
            }
            DynamicObject dynamicObject = (DynamicObject)result.getData();
            if (ObjectUtils.isEmpty((Object)resultMap.get("tcvat_nsrxx#1#nsrmc"))) {
                resultMap.put("tcvat_nsrxx#1#nsrmc", inputValue);
            }
            if (ObjectUtils.isEmpty((Object)resultMap.get("tcvat_nsrxx#1#nsrsbh"))) {
                resultMap.put("tcvat_nsrxx#1#nsrsbh", TaxOrgUtil.getUnifiedsocialcode((DynamicObject)dynamicObject.getDynamicObject("taxorg")));
            }
            if (ObjectUtils.isEmpty((Object)resultMap.get("tcvat_nsrxx#1#org"))) {
                resultMap.put("tcvat_nsrxx#1#org", dynamicObject.getString("taxorg.id"));
            }
            Date registertime = dynamicObject.getDate("registertime");
            importDataVo.setRegisterTime(registertime);
        } else if (START_FIELD_ID.equals(fieldId)) {
            Date startDate = this.formatDateStr(inputValue);
            resultMap.put("tcvat_nsrxx#1#skssqq", inputValue);
            importDataVo.setStartDate(startDate);
        } else if (END_FIELD_ID.equals(fieldId)) {
            Date endDate = this.formatDateStr(inputValue);
            resultMap.put("tcvat_nsrxx#1#skssqz", inputValue);
            importDataVo.setEndDate(endDate);
        } else if (BUSNIESSNOLIST.contains(fieldId)) {
            resultMap.put("tcvat_nsrxx#1#businessno", inputValue);
            importDataVo.setBusinessno(inputValue);
        } else {
            TemplateImportServiceHelper.setValue(formulaVoMap, resultMap, (EntityField)value, (String)inputValue, (String)rKey, declareMainInfos);
        }
    }

    private String getNewKey(Map<String, Integer> offsets, String key) {
        CharSequence[] split = key.split("#");
        Integer oldNum = Integer.valueOf(split[1]);
        Integer offSet = 0;
        if (!offsets.isEmpty()) {
            offSet = offsets.get(key);
        }
        if (offSet == 0) {
            return key;
        }
        Integer newNum = oldNum + offSet;
        split[1] = String.valueOf(newNum);
        key = String.join((CharSequence)"#", split);
        return key;
    }

    private BigDecimal calcTotalAmount(Map<String, String> dataResult, String ... keys) {
        BigDecimal result = BigDecimal.ZERO;
        for (String key : keys) {
            BigDecimal decimal = BigDecimalUtil.toBigDecimal((Object)dataResult.get(key));
            result = BigDecimalUtil.addObject((Object)result, (Object)decimal);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if ("sbboverridereport".equals(callBackId) || "draftoverride".equals(callBackId)) {
            if (MessageBoxResult.Yes == e.getResult()) {
                IPageCache pageCache = this.getPageCache();
                String jsonCache = "";
                if ("sbboverridereport".equals(callBackId)) {
                    jsonCache = pageCache.get(this.RECACHE);
                }
                if ("draftoverride".equals(callBackId)) {
                    jsonCache = pageCache.get(this.BILLCACHE);
                }
                List cacheList = JSON.parseArray((String)jsonCache, Map.class);
                for (Map cacheMap : cacheList) {
                    String orgid = (String)cacheMap.get("orgid");
                    String startdate = (String)cacheMap.get(COL_FINANCIAL_SRARTDATE_STATEMENTS);
                    Date skssqq = DateUtils.stringToDate((String)startdate);
                    String enddate = (String)cacheMap.get(COL_FINANCIAL_ENDDATE_STATEMENTS);
                    Date skssqz = DateUtils.stringToDate((String)enddate);
                    String typeid = (String)cacheMap.get("typeid");
                    String taxlimit = (String)cacheMap.get("taxlimit");
                    String businessno = (String)cacheMap.get("businessno");
                    String taxauthority = (String)cacheMap.get("taxauthority");
                    List<String> sheetNames = Arrays.asList(String.valueOf(cacheMap.get("sheetNames")).split(","));
                    Map resultMap = (Map)SerializationUtils.fromJsonString((String)((String)cacheMap.get("resultMap")), Map.class);
                    ImportDataVo vo = new ImportDataVo(orgid, typeid, skssqq, skssqz, taxlimit, taxauthority, businessno);
                    vo.setResultMap(resultMap);
                    TemplateUtils.deleteReport((ImportDataVo)vo);
                    TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)typeid);
                    if (templateEnum != null) {
                        StatusUtils.delete((String)templateEnum.getDraftType(), (String)orgid, (String)startdate, (String)enddate, (String)"nssb");
                        StatusUtils.deleteDraftByTemplateType((TemplateEnum)templateEnum, (String)orgid, (String)startdate, (String)enddate, (String)"nssb");
                    }
                    String templateId = (String)cacheMap.get("templateId");
                    String reportId = (String)cacheMap.get("reportId");
                    this.saveDataAndRefresh(Long.parseLong(templateId), typeid, sheetNames, resultMap, reportId, orgid, startdate, enddate);
                }
            }
        } else if ("justContinue".equals(callBackId)) {
            StringBuilder message = new StringBuilder();
            if (MessageBoxResult.Yes == e.getResult()) {
                String file_url = e.getCustomVaule();
                if (StringUtils.isBlank((CharSequence)file_url)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e", (String)"ImportDeclareReportPluginNew_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
                InputStream inputStream = FileUtils.getFileInputStream((String)file_url);
                try {
                    EntryGrid entry = (EntryGrid)this.getControl(ENTRYENT_FINANCIAL_STATEMENTS);
                    int[] rows = entry.getSelectRows();
                    Workbook hssfWorkbook = ExcelUtils.getWorkbook((InputStream)inputStream);
                    this.templateId = (Long)this.getModel().getValue("id", rows[0]);
                    this.typeId = (String)this.getModel().getValue("typeid", rows[0]);
                    this.templateEntityMap = TemplateShowUtils.queryTemplateFieldByTmpId((Long)this.templateId, (String)"bdtaxr_template_main");
                    this.templateExcelDataMap = TemplateShowUtils.getTemplateExcelDataMap((Long)this.templateId);
                    this.sheetsMaps = this.templateEntityMap.entrySet().stream().collect(Collectors.groupingBy(s -> ((String)s.getKey()).split("#")[0]));
                    this.excelDataMap = ExcelUtils.readDataToMap((Workbook)hssfWorkbook, (Boolean)Boolean.FALSE, (IFormView)this.getView());
                    this.handleInputStream(handler, this.excelDataMap, this.templateEntityMap, this.sheetsMaps, this.templateId, this.typeId);
                }
                catch (KDBizException ex) {
                    logger.error((Throwable)ex);
                    String error = ex.getMessage();
                    message.append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u9519\u8bef\u4fe1\u606f\uff1a", (String)"ImportDeclareReportPluginNew_28", (String)"taxc-bdtaxr", (Object[])new Object[0])).append(error).append("\r\n");
                }
                catch (RuntimeException e1) {
                    logger.error((Throwable)e1);
                    message.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"ImportDeclareReportPluginNew_38", (String)"taxc-bdtaxr", (Object[])new Object[0])).append("\r\n");
                }
                finally {
                    if (inputStream != null) {
                        FileUtils.safeClose((InputStream)inputStream);
                    }
                }
                this.afterImportHandle(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDataAndRefresh(long templateId, String templatetype, List<String> sheetNames, Map<String, String> resultMap, String reportId, String orgid, String startDate, String endDate) {
        String key = String.format("%s_%s_%s_%s", orgid, startDate, endDate, templatetype);
        DeclareRequestModel requestModel = declareService.getRequestModel(orgid, templatetype, startDate, endDate, templateId);
        requestModel.setId(Long.valueOf(Long.parseLong(reportId)));
        declareReportImportService = DeclareReportImportFactory.createHandler(templatetype);
        if (declareReportImportService != null) {
            declareReportImportService.sendImportSheets(requestModel, sheetNames);
        }
        DLock lock = DLock.create((String)key);
        try {
            if (lock.tryLock(30000L)) {
                Map<String, String> metadata = new TemplateServiceImpl().getMetadata(templateId);
                Map<String, EntityField> typeMap = TaxDeclarePluginService.getAllFieldTypeToShow(metadata);
                ImportReportCalService.cal((Long)templateId, (String)templatetype, (String)orgid, (String)startDate, (String)endDate, resultMap, typeMap);
                DeleteServiceHelper.delete((String)"tctb_declare_his", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)reportId)});
                Map returnMap = DataSaveService.mapToTableFormat((long)templateId, resultMap, metadata);
                this.synchronizeEntryData(Long.parseLong(reportId), templatetype, Long.parseLong(orgid));
                this.syncQysdsData(reportId, templatetype);
                TableTypeMapTemplateTypeEnum typeEnum = TableTypeMapTemplateTypeEnum.getEnumByTemplateType((String)templatetype);
                if (null != typeEnum || Arrays.asList(ImportDataConstant.getFinancialTypes()).contains(templatetype)) {
                    this.autoRefreshElement((DynamicObjectCollection)returnMap.get(DECLARE_ENTITY_ID), typeEnum);
                }
                if (!CollectionUtils.isEmpty((Collection)((Collection)returnMap.get(DECLARE_ENTITY_ID)))) {
                    DeclareUtils.createTaxRefund((DynamicObject[])((DynamicObject[])((DynamicObjectCollection)returnMap.get(DECLARE_ENTITY_ID)).toArray((Object[])new DynamicObject[((DynamicObjectCollection)returnMap.get(DECLARE_ENTITY_ID)).size()])), (String)"audit");
                }
                Map businessMap = InitParamsService.getInitParams((String)requestModel.getTemplateType()).buildBizParam(requestModel);
                String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DynamicRowMSService", (String)"getInitedDynData", (Object[])new Object[]{returnMap, templateId});
                List dynRowList = JsonUtil.fromJsonList((String)result, DynamicRowModel.class);
                List checkFormulaList = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"FormulaService", (String)"checkFormulasNew", (Object[])new Object[]{requestModel, resultMap, businessMap, dynRowList});
                declareService.saveRiskItem(reportId, checkFormulaList, null, 2);
                if ("qhjtydbs".equalsIgnoreCase(templatetype) || "zdsybs_yd".equalsIgnoreCase(templatetype) || "zdsybs_jd".equalsIgnoreCase(templatetype)) {
                    QFilter orgFilter = new QFilter("org", "=", (Object)Long.valueOf(orgid)).and(new QFilter(START_FIELD_ID, "=", (Object)DateUtils.stringToDate((String)startDate))).and(new QFilter(END_FIELD_ID, "=", (Object)DateUtils.stringToDate((String)endDate))).and(new QFilter("templatetype", "=", (Object)templatetype));
                    int tcvvt_fetch_adjust = DeleteServiceHelper.delete((String)"tcvvt_fetch_adjust", (QFilter[])orgFilter.toArray());
                    int n = DeleteServiceHelper.delete((String)"tcvvt_fetch_detail", (QFilter[])orgFilter.toArray());
                }
            }
        }
        finally {
            lock.unlock();
        }
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ImportDeclareReportPluginNew_29", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        this.getView().close();
    }

    private void syncQysdsData(String reportId, String templatetype) {
        if ("qysdsnb".equals(templatetype)) {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tccit", (String)"MbksTaxbookSyncService", (String)"syncData", (Object[])new Object[]{Collections.singletonList(reportId)});
        }
    }

    private void synchronizeEntryData(long id, String templatetype, long orgid) {
        SynchronizeParam param = new SynchronizeParam(Long.valueOf(id), templatetype, Long.valueOf(orgid));
        DataSynchronizeMQSender.sendMessage((SynchronizeParam)param);
    }

    private void validateDates(String orgid, String typeId, long templateId, Date skssqq, Date skssqz, Date fregistertime) {
        logger.info("typeId:" + typeId);
        logger.info("templateId:" + templateId);
        logger.info("skssqq:" + skssqq);
        logger.info("skssqz:" + skssqz);
        logger.info("orgid:" + orgid);
        if (StringUtils.isBlank((CharSequence)orgid) || "0".equals(orgid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u6216\u7ec4\u7ec7\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7ec4\u7ec7\u7f16\u7801\uff01", (String)"ImportDeclareReportPluginNew_30", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        NsrxxValidatorUtils.nsrxxReviewed((Long)Long.parseLong(orgid));
        if (!("qtsf_tysbb".equals(typeId) || "qtsf_fsstysbb".equals(typeId) || "latqs".equals(typeId))) {
            String[] types;
            DynamicObject qysdsCard;
            if (skssqq == null || skssqz == null || skssqq.compareTo(skssqz) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\uff01", (String)"ImportDeclareReportPluginNew_31", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            boolean checkSkqq = true;
            declareReportImportService = DeclareReportImportFactory.createHandler(typeId);
            if (declareReportImportService != null) {
                checkSkqq = declareReportImportService.checkSksqq(skssqq);
            } else {
                Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)skssqq);
                if (skssqq.compareTo(firstDateOfMonth) != 0) {
                    checkSkqq = false;
                }
            }
            if (!checkSkqq) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\uff01", (String)"ImportDeclareReportPluginNew_31", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            if (("qysds_hdzs_jb".equals(typeId) || "qysdsjb".endsWith(typeId)) && (qysdsCard = ImportDeclareReportPluginNew.getTaxCard(orgid, "qysds")) != null) {
                String deadline = qysdsCard.getString("deadline");
                if ("aysb".equals(deadline)) {
                    boolean isBetweenMonth;
                    boolean bl = isBetweenMonth = DateUtils.getMonthOfDate((Date)skssqq) == DateUtils.getMonthOfDate((Date)skssqz);
                    if (!isBetweenMonth) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\uff01", (String)"ImportDeclareReportPluginNew_31", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    }
                } else if ("ajsb".equals(deadline)) {
                    boolean isBetweenSeasonal;
                    boolean bl = isBetweenSeasonal = DateUtils.getMonthOfDate((Date)skssqz) - DateUtils.getMonthOfDate((Date)skssqq) == 2;
                    if (!isBetweenSeasonal) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\uff01", (String)"ImportDeclareReportPluginNew_31", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    }
                }
            }
            if ((types = (String[])ImportDataConstant.getPeriodTypeMap().get(typeId)) != null) {
                boolean validDate = false;
                String[] isBetweenSeasonal = types;
                int n = isBetweenSeasonal.length;
                block10: for (int i = 0; i < n; ++i) {
                    String type;
                    switch (type = isBetweenSeasonal[i]) {
                        case "year": {
                            Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)skssqz);
                            Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)skssqq);
                            if (firstDateOfYear.compareTo(skssqq) != 0 || !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfYear))) continue block10;
                            validDate = true;
                            continue block10;
                        }
                        case "halfyear": {
                            Date firstDateOfHalfYear = DateUtils.getFirstDateOfHalfYear((Date)skssqq);
                            Date lastDateOfHalfYear = DateUtils.getLastDateOfHalfYear((Date)skssqq);
                            if (firstDateOfHalfYear.compareTo(skssqq) != 0 || !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfHalfYear))) continue block10;
                            validDate = true;
                            continue block10;
                        }
                        case "season": {
                            Date firstDateOfSeason = DateUtils.getFirstDateOfSeason((Date)skssqq);
                            Date lastDateOfSeason = DateUtils.getLastDateOfSeason((Date)skssqq);
                            Date lastDateOfMonth1 = DateUtils.getLastDateOfMonth((Date)skssqq);
                            if ((!DateUtils.format((Date)skssqq).equals(DateUtils.format((Date)firstDateOfSeason)) || !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfSeason))) && !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfMonth1))) continue block10;
                            validDate = true;
                            continue block10;
                        }
                        default: {
                            Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)skssqq);
                            if (!DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfMonth))) continue block10;
                            validDate = true;
                        }
                    }
                }
                if (!validDate) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\uff01", (String)"ImportDeclareReportPluginNew_31", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
            } else {
                Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)skssqq);
                if (!DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfMonth)) && !"ccxws".equals(typeId)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\uff01", (String)"ImportDeclareReportPluginNew_31", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
            }
        }
        DynamicObject template = QueryServiceHelper.queryOne((String)"bdtaxr_template_main", (String)"startdate,enddate,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        Date tempStartDate = template.getDate(COL_FINANCIAL_SRARTDATE_STATEMENTS);
        Date tempEndDate = template.getDate(COL_FINANCIAL_ENDDATE_STATEMENTS);
        ArrayList endNumbers = Lists.newArrayList((Object[])new String[]{"RT2020", "YYS001", "CCS001", "EPT2018", "stamp-tax", "tcret2019"});
        if (endNumbers.contains(template.getString("number")) ? tempEndDate != null && skssqz.compareTo(tempEndDate) > 0 : tempStartDate.compareTo(skssqz) > 0 || tempEndDate != null && tempEndDate.compareTo(skssqq) < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5c5e\u671f\u4e0d\u5728\u6a21\u677f\u6709\u6548\u671f\u8303\u56f4\u5185\u3002", (String)"ImportDeclareReportPluginNew_32", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if (Objects.nonNull(fregistertime) && fregistertime.after(skssqz)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u7a0e\u6b3e\u6240\u5c5e\u671f\u4e0d\u5f97\u65e9\u4e8e\u4f01\u4e1a\u767b\u8bb0\u65f6\u95f4\u3002", (String)"ImportDeclareReportPluginNew_33", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    private Date formatDateStr(String dateStr) {
        Date date;
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\uff01", (String)"ImportDeclareReportPluginNew_31", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        String format = "yyyy-MM-dd";
        if (dateStr.contains(ResManager.loadKDString((String)"\u65e5", (String)"ImportDeclareReportPluginNew_34", (String)"taxc-bdtaxr", (Object[])new Object[0]))) {
            format = DateUtils.YYYYMMDD_CHINESE;
        }
        this.checkLeapYear(dateStr, format);
        try {
            date = DateUtils.stringToDate((String)dateStr);
        }
        catch (Exception e) {
            try {
                date = DateUtils.stringToDate((String)dateStr, (String)DateUtils.YYYYMMDD_CHINESE);
            }
            catch (Exception e1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01\u8bf7\u4e25\u683c\u6309\u7167\u6a21\u677f\u683c\u5f0f\u5f15\u5165\uff0c\u5408\u6cd5\u65e5\u671f\u683c\u5f0f xxxx\u5e74xx\u6708xx\u65e5\u6216yyyy-MM-dd", (String)"ImportDeclareReportPluginNew_35", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        }
        return date;
    }

    private void checkLeapYear(String dateStr, String format) {
        try {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
            LocalDate localDate = LocalDate.parse(dateStr, dateTimeFormatter);
            if (!localDate.isLeapYear() && (dateStr.endsWith("-02-29") || dateStr.endsWith(ResManager.loadKDString((String)"\u5e7402\u670829\u65e5", (String)"ImportDeclareReportPluginNew_36", (String)"taxc-bdtaxr", (Object[])new Object[0])))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01\u8bf7\u4e25\u683c\u6309\u7167\u6a21\u677f\u683c\u5f0f\u5f15\u5165\uff0c\u5408\u6cd5\u65e5\u671f\u683c\u5f0f xxxx\u5e74xx\u6708xx\u65e5\u6216yyyy-MM-dd", (String)"ImportDeclareReportPluginNew_35", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01\u8bf7\u4e25\u683c\u6309\u7167\u6a21\u677f\u683c\u5f0f\u5f15\u5165\uff0c\u5408\u6cd5\u65e5\u671f\u683c\u5f0f xxxx\u5e74xx\u6708xx\u65e5\u6216yyyy-MM-dd", (String)"ImportDeclareReportPluginNew_35", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    private void autoRefreshElement(DynamicObjectCollection nsrxxCollection, TableTypeMapTemplateTypeEnum typeEnum) {
        if (CollectionUtils.isEmpty((Collection)nsrxxCollection)) {
            return;
        }
        String tableType = typeEnum != null ? typeEnum.getTableType() : "2";
        String entityName = OverSeaMQSender.getEntityName((IFormView)this.getView().getParentView());
        DeclareMQSender.sendMQ((DynamicObjectCollection)nsrxxCollection, (String)tableType, (String)DeclareMQType.DECLARE.name(), (String)DeclareMQEvent.IMPORT.name(), (String)entityName);
    }

    public void remove(UploadEvent evt) {
        String cacheUrls = this.getPageCache().get(this.FILELIST);
        List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        for (Object url : evt.getUrls()) {
            filelist.removeIf(f -> f.get("uid").equals(((Map)url).get("uid")));
        }
        this.getPageCache().put(this.FILELIST, SerializationUtils.serializeToBase64(filelist));
    }

    public void upload(UploadEvent evt) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"urlsflex"});
        String cacheUrls = this.getPageCache().get(this.FILELIST);
        List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        Object[] urls = evt.getUrls();
        logger.info("\u83b7\u5f97\u4e0a\u4f20\u6587\u4ef6urls\uff1a{}", (Object)Arrays.toString(urls));
        for (int i = 0; i < urls.length; ++i) {
            String urlStr;
            if (urls[i] == null || !StringUtils.isNotBlank((CharSequence)(urlStr = (String)((Map)urls[i]).get("url")))) continue;
            filelist.add((Map)urls[i]);
        }
        this.getPageCache().put(this.FILELIST, SerializationUtils.serializeToBase64(filelist));
    }

    public void afterUpload(UploadEvent evt) {
    }

    private String getParam(String param) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return (String)customParams.get(param);
    }

    private static void confirmTips(String itemKey, String msg, String customValue, IFormView getView, IFormPlugin plugin) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(itemKey, plugin);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String ikonw = ResManager.loadKDString((String)"\u7ee7\u7eed\u5bfc\u5165", (String)"ImportDeclareReportPluginNew_37", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ikonw);
        getView.showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, customValue);
    }

    public static boolean isIDCard18(CharSequence input) {
        Matcher matcher = Pattern.compile(REGEX_ID_CARD18).matcher(input);
        return matcher.matches();
    }

    private static String getBillNo(ImportExcelHandler handler, String type, String orgid, String reportId, String skssqz) {
        switch (type) {
            case "qysdsjb": {
                return ImportDeclareReportPluginNew.generateDraftNo("tccit_query_report", orgid);
            }
            case "qysds_hdzs_jb": {
                return ImportDeclareReportPluginNew.generateDraftNo("tccit_query_report", orgid);
            }
            case "qysdsnb": {
                return ImportDeclareReportPluginNew.generateDraftNo("tccit_quarterly_report", orgid);
            }
            case "qysdsnb_fzjg": {
                return ImportDeclareReportPluginNew.generateDraftNo("tccit_quarterly_report", orgid);
            }
            case "qysds_hdzs_nb": {
                return ImportDeclareReportPluginNew.generateDraftNo("tccit_quarterly_report", orgid);
            }
            case "zzsybnsr": {
                return ImportDeclareReportPluginNew.generateDraftNo("tcvat_zzs_declare_list", orgid);
            }
            case "zzsxgmnsr": {
                String billno = ImportDeclareReportPluginNew.generateDraftNo("tcvat_zzs_declare_list", orgid);
                return billno.replace("VAT", "VATSS");
            }
            case "zzsybnsr_ybhz": {
                String billno = ImportDeclareReportPluginNew.generateDraftNo("tcvat_zzs_declare_list", orgid);
                return billno.replace("VAT", "VATSUM");
            }
            case "zzsybnsr_hz_zjg": {
                String billno = ImportDeclareReportPluginNew.generateDraftNo("tcvat_zzs_declare_list", orgid);
                return billno.replace("VAT", "VAT-HZ");
            }
            case "zzsybnsr_yz_zjg": {
                String billno = ImportDeclareReportPluginNew.generateDraftNo("tcvat_zzs_declare_list", orgid);
                return billno.replace("VAT", "VAYSUM-HOYZ");
            }
            case "zzsybnsr_yz_fzjg": {
                String billno = ImportDeclareReportPluginNew.generateDraftNo("tcvat_zzs_declare_list", orgid);
                return billno.replace("VAT", "VAYSUM-BOYZ");
            }
            case "FR0001": {
                return ImportDeclareReportPluginNew.generateDraftNo("tcvvt_main_declare_list", orgid);
            }
            case "FR0002": {
                return ImportDeclareReportPluginNew.generateDraftNo("tcvvt_main_declare_list", orgid);
            }
            case "FR0003": {
                return ImportDeclareReportPluginNew.generateDraftNo("tcvvt_main_declare_list", orgid);
            }
            case "FR0004": {
                return ImportDeclareReportPluginNew.generateDraftNo("tcvvt_main_declare_list", orgid);
            }
            case "FR0011": {
                return ImportDeclareReportPluginNew.generateDraftNo("tcvvt_main_declare_list", orgid);
            }
            case "zdsybs_yd": 
            case "zdsybs_jd": {
                String zdsyentity = "tcvvt_tras_declare_list";
                DynamicObject zdsydyo = BusinessDataServiceHelper.newDynamicObject((String)zdsyentity);
                zdsydyo.set(END_FIELD_ID, (Object)DateUtils.stringToDate2((String)skssqz));
                return DeclareServiceHelper.generateSBBNo((String)zdsyentity, (DynamicObject)zdsydyo, (String)orgid);
            }
            case "qhjtydbs": {
                String qhjtentity = "tcvvt_month_declare_list";
                DynamicObject qhjtdyo = BusinessDataServiceHelper.newDynamicObject((String)qhjtentity);
                qhjtdyo.set(END_FIELD_ID, (Object)DateUtils.stringToDate2((String)skssqz));
                return DeclareServiceHelper.generateSBBNo((String)qhjtentity, (DynamicObject)qhjtdyo, (String)orgid);
            }
        }
        return handler.getBillNo(reportId, skssqz);
    }

    protected static String generateDraftNo(String entityName, String orgid) {
        return DeclareServiceHelper.generateSBBNo((String)entityName, null, (String)orgid);
    }

    protected static String getOldBillno(String reportId, String mainTable) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)mainTable, (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(reportId))});
        return null == dynamicObject ? null : dynamicObject.getString("billno");
    }

    public static DynamicObject getTaxCard(String orgId, String taxtype) {
        TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainQysdsByOrgIds(Collections.singletonList(Long.parseLong(orgId)));
        if (listTaxResult.isSuccess() && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData()))) {
            DynamicObject cardObject = (DynamicObject)((List)listTaxResult.getData()).get(0);
            return cardObject.getDynamicObjectCollection("categoryentryentity").stream().filter(e -> taxtype.equals(e.getString(TAX_TYPE_PARAM))).findFirst().orElseGet(() -> null);
        }
        return null;
    }

    static {
        declareService = new DeclareService();
    }
}

