/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare.importdeclare;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AttachmentMarkListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.upload.UploadOption;
import kd.taxc.bdtaxr.business.domain.MultiEntityField;
import kd.taxc.bdtaxr.business.multidideclare.DeclareReportHelpService;
import kd.taxc.bdtaxr.business.multidideclare.ExportService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.DeclareReportImportFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service.DeclareReportImportService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.vo.DynRowVo;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.DeclareReportSaveFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.DeclareReportSaveService;
import kd.taxc.bdtaxr.common.declare.helper.TemplateImportServiceHelper;
import kd.taxc.bdtaxr.common.declare.initparam.InitParamsService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.declare.service.DeclareService;
import kd.taxc.bdtaxr.common.dto.DeclareTable;
import kd.taxc.bdtaxr.common.dto.TaxDeclareSaveDataDto;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.DeclareServiceEnum;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.TableTypeMapTemplateTypeEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.helper.YbnsrServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcyear.TaxcYearDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaMQSender;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaCollectionVo;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.verify.CheckResult;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.taxdeclare.constant.ImportDataConstant;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TemplateTypeMappingEnum;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.DeclareReportFactory;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.ExcelUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.file.FileUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.DeclareDataCheckVo;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class MultiImportDeclareReportPlugin
extends AbstractFormPlugin
implements UploadListener,
HyperLinkClickListener,
AttachmentMarkListener {
    private static Log logger = LogFactory.getLog(MultiImportDeclareReportPlugin.class);
    private static final String GANG = "-";
    private static final String BTN_OK = "btnok";
    private static final String ENTRYENT_FINANCIAL_STATEMENTS = "entryent";
    private static final String COL_FINANCIAL_STATEMENTS = "textfield";
    private static final String COL_FINANCIAL_SRARTDATE_STATEMENTS = "startdate";
    private static final String COL_FINANCIAL_ENDDATE_STATEMENTS = "enddate";
    private static final String COL_FINANCIAL_ENDDATE_FILTERCONDITION = "filtercondition";
    private static final String COL_DOWNLOAD = "download";
    private static final String FINANCIAL_TYPE_STATEMENTS = "selecttype";
    private static final String PARAM_TYPE = "source";
    private static final String NSRSBH_FIELD_ID = "nsrsbh";
    private List<Map<String, String>> RECACHELIST = new ArrayList<Map<String, String>>();
    private String MARKWORDS = "";
    private String INTERRUPT_WORDS = "";
    private String RECACHE = "recache";
    private List<Map<String, String>> BILLCACHELIST = new ArrayList<Map<String, String>>();
    private String BILLMARKWORDS;
    private String BILLCACHE = "billcache";
    private String TEMPLATEID = "templateid";
    private String FILELIST = "_file_list_";
    public static final String REGEX_ID_CARD18 = "^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])$";
    private static DeclareReportImportService declareReportImportService;
    private Map<String, String> excelDataMap = new HashMap<String, String>(16);
    private Map<String, EntityField> templateEntityMap = new HashMap<String, EntityField>(16);
    private Map<String, List<Map.Entry<String, EntityField>>> sheetsMaps = new HashMap<String, List<Map.Entry<String, EntityField>>>(16);
    private long moduleId;
    private long templateId;
    private String typeId;
    private Map<String, Integer> offsets;
    private static DeclareService declareService;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, "btnupload", "btndownload", "btndel", "buttondownload", FINANCIAL_TYPE_STATEMENTS, "next", "back", "step1", "step2"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
        EntryGrid tempGrid = (EntryGrid)this.getView().getControl(ENTRYENT_FINANCIAL_STATEMENTS);
        tempGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (FINANCIAL_TYPE_STATEMENTS.equals(name)) {
            ChangeData[] changeSet = e.getChangeSet();
            String templateType = (String)changeSet[0].getNewValue();
            this.getModel().deleteEntryData(ENTRYENT_FINANCIAL_STATEMENTS);
            this.queryEntityData(templateType);
        }
    }

    public void afterCreateNewData(EventObject evt) {
        List templatetypelist;
        String paramtype = this.getParam(PARAM_TYPE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"urlsflex"});
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(FINANCIAL_TYPE_STATEMENTS);
        this.initPage();
        if (paramtype != null && "declare".equals(paramtype.trim()) && EmptyCheckUtils.isNotEmpty((Object)(templatetypelist = (List)this.getView().getFormShowParameter().getCustomParam("templatetypelist")))) {
            ArrayList data = new ArrayList();
            templatetypelist.forEach(type -> {
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)TemplateTypeMappingEnum.getDescByCode((String)type))) {
                    data.add(new ComboItem(new LocaleString(TemplateTypeMappingEnum.getDescByCode((String)type)), type));
                }
            });
            comboEdit.setComboItems(data);
            String templateType = ((ComboItem)data.get(0)).getValue();
            this.getModel().setValue(FINANCIAL_TYPE_STATEMENTS, (Object)templateType);
            this.queryEntityData(templateType);
        }
    }

    private void initPage() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"twostepflex", "back", BTN_OK});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"onestepflex", "btncancel", "next"});
        this.setStyle("step2", "step1", "label2", "label1");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENT_FINANCIAL_STATEMENTS);
        if (entity.size() == 1) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENT_FINANCIAL_STATEMENTS);
            entryGrid.selectRows(new int[]{0}, 0);
        }
    }

    private void queryEntityData(String templateType) {
        QFilter q = new QFilter("type.number", "=", (Object)templateType);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"tpo_template", (String)"id,name as textfield,type.id as typeid,startdate,enddate,filtercondition,conditionjson", (QFilter[])new QFilter[]{q}, (String)"startdate desc,number");
        if (dcs == null || dcs.isEmpty()) {
            return;
        }
        logger.info(dcs.toString());
        this.getModel().beginInit();
        List collect = dcs.stream().filter(e -> e.getString("conditionjson") == null || !e.getString("conditionjson").contains("zerodeclare")).collect(Collectors.toList());
        for (DynamicObject d : collect) {
            int index = this.getModel().createNewEntryRow(ENTRYENT_FINANCIAL_STATEMENTS);
            this.getModel().setValue("id", (Object)d.getLong("id"), index);
            this.getModel().setValue("typeid", (Object)d.getString("typeid"), index);
            String name = d.getString(COL_FINANCIAL_STATEMENTS);
            this.getModel().setValue(COL_FINANCIAL_STATEMENTS, (Object)name, index);
            Date startDate = d.getDate(COL_FINANCIAL_SRARTDATE_STATEMENTS) != null ? d.getDate(COL_FINANCIAL_SRARTDATE_STATEMENTS) : null;
            Date endDate = d.getDate(COL_FINANCIAL_ENDDATE_STATEMENTS) != null ? d.getDate(COL_FINANCIAL_ENDDATE_STATEMENTS) : null;
            this.getModel().setValue(COL_FINANCIAL_SRARTDATE_STATEMENTS, (Object)startDate, index);
            this.getModel().setValue(COL_FINANCIAL_ENDDATE_STATEMENTS, (Object)endDate, index);
            this.getModel().setValue(COL_FINANCIAL_ENDDATE_FILTERCONDITION, (Object)d.getString(COL_FINANCIAL_ENDDATE_FILTERCONDITION), index);
            this.getModel().setValue(COL_DOWNLOAD, (Object)ResManager.loadKDString((String)"\u4e0b\u8f7d", (String)"MultiImportDeclareReportPlugin_49", (String)"taxc-bdtaxr", (Object[])new Object[]{index}));
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENT_FINANCIAL_STATEMENTS);
        declareReportImportService = DeclareReportImportFactory.createHandler(templateType);
        if (declareReportImportService != null && declareReportImportService.isSupportRefreshData()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"isrefresh"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isrefresh"});
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        Map businessMap = (Map)this.getView().getFormShowParameter().getCustomParam("businessMap");
        int index = hyperLinkClickEvent.getRowIndex();
        long id = (Long)this.getModel().getValue("id", index);
        String templateType = (String)this.getModel().getValue("typeid");
        DeclareReportService declareReportService = DeclareReportFactory.createHandler((String)templateType);
        if (declareReportService != null) {
            this.moduleId = declareReportService.getModleId();
        }
        Map cellTypeFormulas = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CELLTYPE_FORMULAS, (Object[])new Object[]{id, null});
        Map fieldMap = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_ALL_FIELDS_TYPE_SHOW, (Object[])new Object[]{this.moduleId});
        try {
            String name = (String)this.getModel().getValue(COL_FINANCIAL_STATEMENTS, index);
            String urls = ExportService.getbuildExcelPath("IMPORT", id, fieldMap, cellTypeFormulas, name, businessMap);
            this.getView().openUrl(urls);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnupload".equals(control.getKey())) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENT_FINANCIAL_STATEMENTS);
            int[] rows = entry.getSelectRows();
            if (rows.length != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u6a21\u677f\u7c7b\u578b\u3002", (String)"MultiImportDeclareReportPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            UploadOption opt = new UploadOption();
            opt.setMultiple(true);
            opt.setTitle(ResManager.loadKDString((String)"\u4e0a\u4f20\u6570\u636e\u6587\u4ef6", (String)"MultiImportDeclareReportPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            opt.setSuffix(".xlsx");
            opt.setLimitSize(0x1400000L);
            this.getView().showUpload(opt, "btnupload");
        } else if ("buttondownload".equals(control.getKey())) {
            Object field = this.getModel().getValue("templatetype");
            if (field == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5148\u9009\u62e9\u9700\u8981\u4e0b\u8f7d\u7684\u6a21\u677f\u7c7b\u578b", (String)"MultiImportDeclareReportPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        } else if ("btndel".equals(control.getKey())) {
            IDataModel model = this.getModel();
            int i = model.getEntryCurrentRowIndex("upload_urls");
            String cacheUrls = this.getPageCache().get(this.FILELIST);
            List<Map> filelist = kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
            String url = (String)model.getValue("url", i);
            filelist.removeIf(f -> f.get("url").equals(url));
            this.getPageCache().put(this.FILELIST, SerializationUtils.serializeToBase64(filelist));
            model.deleteEntryRow("upload_urls", i);
            if (filelist.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"urlsflex"});
            }
        } else if (BTN_OK.equals(control.getKey())) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENT_FINANCIAL_STATEMENTS);
            int[] rows = entry.getSelectRows();
            if (rows.length != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u6a21\u677f\u7c7b\u578b\u3002", (String)"MultiImportDeclareReportPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            String file_list = this.getPageCache().get(this.FILELIST);
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)file_list)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0a\u4f20\u6587\u4ef6", (String)"MultiImportDeclareReportPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            List filelist = (List)SerializationUtils.deSerializeFromBase64((String)file_list);
            if (filelist.size() > 3 || filelist.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0d\u591a\u4e8e3\u4e2a\u6587\u4ef6\u4e0a\u4f20", (String)"MultiImportDeclareReportPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            this.RECACHELIST.clear();
            this.BILLCACHELIST.clear();
            this.MARKWORDS = "";
            this.BILLMARKWORDS = "";
            StringBuilder message = new StringBuilder();
            FileService service = FileServiceFactory.getAttachmentFileService();
            this.templateId = (Long)this.getModel().getValue("id", rows[0]);
            this.typeId = (String)this.getModel().getValue("typeid", rows[0]);
            DynamicObject templateObj = BusinessDataServiceHelper.loadSingle((Object)this.templateId, (String)"tpo_template");
            this.templateEntityMap = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_TEMPLATE_FEILD, (Object[])new Object[]{templateObj});
            this.sheetsMaps = this.templateEntityMap.entrySet().stream().collect(Collectors.groupingBy(s -> ((String)s.getKey()).split("#")[0]));
            if (this.templateEntityMap.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u6a21\u677f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u5408\u6cd5\u6027", (String)"MultiImportDeclareReportPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            for (int i = 0; i < filelist.size(); ++i) {
                Map fileMap = (Map)filelist.get(i);
                String file_url = (String)fileMap.get("url");
                String fileName = (String)fileMap.get("name");
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)file_url)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e", (String)"MultiImportDeclareReportPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
                InputStream inputStream = service.getInputStream(file_url);
                Workbook hssfWorkbook = this.getWorkbook(inputStream);
                this.excelDataMap = this.readDataToMap(hssfWorkbook, Boolean.FALSE);
                declareReportImportService = DeclareReportImportFactory.createHandler(this.typeId);
                try {
                    ValidDataResultVo validExcelType = declareReportImportService.validExcelType(this.excelDataMap, templateObj);
                    if (!validExcelType.getSuccess()) {
                        throw new KDBizException(validExcelType.getMessage());
                    }
                    Map<String, String> map = this.readDataToMap(hssfWorkbook, Boolean.TRUE);
                    this.handleInputStream(declareReportImportService, this.excelDataMap, this.templateEntityMap, this.sheetsMaps, templateObj, this.typeId, this.offsets);
                    continue;
                }
                catch (RuntimeException e) {
                    logger.error((Throwable)e);
                    message.append(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5bfc\u5165\u5931\u8d25\u3002\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"MultiImportDeclareReportPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]), fileName, e.getMessage())).append("\r\n");
                    continue;
                }
                finally {
                    if (inputStream != null) {
                        FileUtils.safeClose((InputStream)inputStream);
                    }
                }
            }
            this.afterImportHandle(message);
        } else if ("next".equals(control.getKey()) || "step2".equals(control.getKey())) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENT_FINANCIAL_STATEMENTS);
            int[] rows = entry.getSelectRows();
            if (rows.length != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u6a21\u677f\u7c7b\u578b\u3002", (String)"MultiImportDeclareReportPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            this.isClearTemplate(rows);
            Label templatename = (Label)this.getControl("templatename");
            templatename.setText(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u6a21\u677f\uff1a%s", (String)"MultiImportDeclareReportPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.getModel().getValue(COL_FINANCIAL_STATEMENTS, rows[0])));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"twostepflex", "back", BTN_OK});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"onestepflex", "btncancel", "next"});
            this.setStyle("step1", "step2", "label1", "label2");
        } else if ("back".equals(control.getKey()) || "step1".equals(control.getKey())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"twostepflex", "back", BTN_OK});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"onestepflex", "btncancel", "next"});
            this.setStyle("step2", "step1", "label2", "label1");
        }
    }

    private void isClearTemplate(int[] rows) {
        Long id = (Long)this.getModel().getValue("id", rows[0]);
        String oldId = this.getPageCache().get(this.TEMPLATEID);
        this.getPageCache().put(this.TEMPLATEID, String.valueOf(id));
        if (oldId == null || Long.parseLong(oldId) == id) {
            return;
        }
        String cacheUrls = this.getPageCache().get(this.FILELIST);
        List filelist = kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        AttachmentPanel attachmentpanelap = (AttachmentPanel)this.getControl("attachmentpanelap");
        for (Map data : filelist) {
            attachmentpanelap.remove(data);
        }
    }

    private void setStyle(String step1, String step2, String lable1, String lable2) {
        HashMap<String, Object> colorMap1 = new HashMap<String, Object>();
        HashMap<String, Object> colorMap2 = new HashMap<String, Object>();
        String stepColor1 = "#CCCCCC";
        String linestyle1 = "1px_solid_#CCCCCC";
        colorMap1.put("followTheme", Boolean.FALSE);
        colorMap1.put("fc", stepColor1);
        HashMap style1 = new HashMap();
        HashMap<String, String> border1 = new HashMap<String, String>();
        border1.put("t", linestyle1);
        border1.put("l", linestyle1);
        border1.put("r", linestyle1);
        border1.put("b", linestyle1);
        style1.put("b", border1);
        colorMap1.put("s", style1);
        String stepColor2 = "themeColor";
        String linestyle2 = "1px_solid_themeColor";
        colorMap2.put("followTheme", Boolean.TRUE);
        colorMap2.put("fc", stepColor2);
        HashMap style2 = new HashMap();
        HashMap<String, String> border2 = new HashMap<String, String>();
        border2.put("t", linestyle2);
        border2.put("l", linestyle2);
        border2.put("r", linestyle2);
        border2.put("b", linestyle2);
        style2.put("b", border2);
        colorMap2.put("s", style2);
        this.getView().updateControlMetadata(step1, colorMap1);
        this.getView().updateControlMetadata(step2, colorMap2);
        String statusColor1 = "#CCCCCC";
        String statusColor2 = "themeColor";
        HashMap<String, String> labColorMap1 = new HashMap<String, String>();
        HashMap<String, String> labColorMap2 = new HashMap<String, String>();
        labColorMap1.put("fc", statusColor1);
        labColorMap2.put("fc", statusColor2);
        this.getView().updateControlMetadata(lable1, labColorMap1);
        this.getView().updateControlMetadata(lable2, labColorMap2);
    }

    public Workbook getWorkbook(InputStream inputStream) {
        Workbook hssfWorkbook;
        try {
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            hssfWorkbook = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u683c\u5f0f\u6587\u4ef6", (String)"MultiImportDeclareReportPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        return hssfWorkbook;
    }

    private void afterImportHandle(StringBuilder message) {
        if (message.length() > 0 && !"null".equals(message.toString()) && !"".equals(message.toString())) {
            this.getView().showErrorNotification(message.toString());
        }
        if (this.RECACHELIST.size() > 0 && (this.MARKWORDS.length() > 0 || this.INTERRUPT_WORDS.length() > 0)) {
            if (this.INTERRUPT_WORDS.length() > 0) {
                this.getView().showErrorNotification(this.INTERRUPT_WORDS);
                return;
            }
            String reCache = JSONArray.toJSONString(this.RECACHELIST);
            this.getPageCache().put(this.RECACHE, reCache);
            ConfirmCallBackListener callBack = new ConfirmCallBackListener("sbboverridereport", (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\r\n%s\u8bf7\u786e\u8ba4\u662f\u5426\u8986\u76d6\uff1f", (String)"MultiImportDeclareReportPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.MARKWORDS), MessageBoxOptions.OKCancel, callBack);
            return;
        }
        if (this.BILLCACHELIST.size() > 0 && this.BILLMARKWORDS.length() > 0) {
            String billCache = JSONArray.toJSONString(this.BILLCACHELIST);
            this.getPageCache().put(this.BILLCACHE, billCache);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u653e\u5f03\u5f15\u5165", (String)"MultiImportDeclareReportPlugin_11", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u5f15\u5165", (String)"MultiImportDeclareReportPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("draftoverride", (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u5c5e\u671f\u5e95\u7a3f\u4e2d\u5b58\u5728\u7f16\u8f91\u7684\u5e95\u7a3f\u6570\u636e\uff0c\u7ee7\u7eed\u64cd\u4f5c\u5c06\u5220\u9664\u5e95\u7a3f\u6570\u636e\uff0c\u53ef\u9009\u62e9\u4ee5\u4e0b\u64cd\u4f5c", (String)"MultiImportDeclareReportPlugin_13", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.BILLMARKWORDS), "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        }
    }

    private Map<String, String> readDataToMap(Workbook hssfWorkbook, Boolean includeBlank) {
        Iterator it = hssfWorkbook.sheetIterator();
        LinkedHashMap<String, String> excelDataMap = new LinkedHashMap<String, String>();
        while (it.hasNext()) {
            Sheet sheet = (Sheet)it.next();
            String sheetName = sheet.getSheetName();
            for (Row row : sheet) {
                int rowNum = row.getRowNum();
                for (Cell cell : row) {
                    int columnIndex = cell.getColumnIndex();
                    String key = sheetName + "#" + rowNum + "#" + columnIndex;
                    String text = "";
                    DecimalFormat decimalFormat = null;
                    try {
                        text = ExcelUtils.getStringValueFromCell((Cell)cell, decimalFormat);
                    }
                    catch (Exception e) {
                        logger.error("\u7b2c{}\u884c\u7b2c{}\u5217\u5355\u5143\u683c\u6570\u636e\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (Object)(cell.getRowIndex() + 1), (Object)(cell.getColumnIndex() + 1));
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7b2c%2$s\u5217\u5355\u5143\u683c\u6570\u636e\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"MultiImportDeclareReportPlugin_14", (String)"taxc-bdtaxr", (Object[])new Object[0]), cell.getRowIndex() + 1, cell.getColumnIndex() + 1));
                    }
                    if (includeBlank.booleanValue()) {
                        excelDataMap.put(key, text);
                        continue;
                    }
                    if (text == null || "".equals(text)) continue;
                    excelDataMap.put(key, text);
                }
            }
        }
        return excelDataMap;
    }

    private void paraseDynMap(List<Map.Entry<String, EntityField>> dynEntry, DynRowVo dynRow, Map.Entry<String, EntityField> entry) {
        if (dynRow.getRowSize() < 1) {
            return;
        }
        HashMap<String, EntityField> dynMap = new HashMap<String, EntityField>(dynRow.getRowSize());
        int rowNo = Integer.parseInt(entry.getKey().split("#")[1]);
        for (int i = 0; i < dynRow.getRowSize(); ++i) {
            String newKey = DynamicRowService.getNewKey((String)entry.getKey(), (long)(rowNo + i));
            EntityField newField = (EntityField)entry.getValue().clone();
            newField.setFieldId(DynamicRowService.getNewKey((String)newField.getFieldId(), (long)(i + 1)));
            newField.setEwblxh(String.valueOf(i + 1));
            dynMap.put(newKey, newField);
        }
        for (Map.Entry e : dynMap.entrySet()) {
            dynEntry.add(e);
        }
    }

    private DynamicRowModel getDynamicRowListByDynRowNo(List<DynamicRowModel> dynamicRows, String dynamicRowKey) {
        if (CollectionUtils.isEmpty(dynamicRows) || StringUtil.isBlank((CharSequence)dynamicRowKey)) {
            return null;
        }
        if (dynamicRowKey.contains("#")) {
            dynamicRowKey = dynamicRowKey.split("#")[0];
        }
        for (DynamicRowModel d : dynamicRows) {
            String matchKey = d.getDynRowNo();
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)matchKey) && matchKey.contains("#")) {
                matchKey = matchKey.split("#")[0];
            }
            if (!dynamicRowKey.equals(matchKey)) continue;
            return d;
        }
        return null;
    }

    private void changeMap(List<Map.Entry<String, EntityField>> dynEntry, int rowNo, int newRowNo, Map.Entry<String, EntityField> entry) {
        if (newRowNo == rowNo) {
            dynEntry.add(entry);
            return;
        }
        HashMap<String, EntityField> dynMap = new HashMap<String, EntityField>(1);
        String newKey = entry.getKey().replace("#" + rowNo + "#", "#" + newRowNo + "#");
        String newFieldId = entry.getValue().getFieldId().replace("#" + rowNo + "#", "#" + newRowNo + "#");
        entry.getValue().setFieldId(newFieldId);
        dynMap.put(newKey, entry.getValue());
        for (Map.Entry e : dynMap.entrySet()) {
            dynEntry.add(e);
        }
    }

    private int getRowNoByKey(String key) {
        return Integer.parseInt(key.split("#")[1]);
    }

    private void handleInputStream(DeclareReportImportService handler, Map<String, String> excelDataMap, Map<String, EntityField> templateEntityMap, Map<String, List<Map.Entry<String, EntityField>>> sheetsMaps, DynamicObject templateObj, String typeId, Map<String, Integer> offsets) {
        ValidDataResultVo validDataResultVo;
        this.templateId = templateObj.getLong("id");
        DeclareReportService declareReportService = DeclareReportFactory.createHandler((String)typeId);
        if (declareReportService == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u65f6\u627e\u4e0d\u5230\u83b7\u53d6\u4f53\u7cfb\u7b49\u4fe1\u606f\u63a5\u53e3\u3002", (String)"MultiImportDeclareReportPlugin_15", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        this.moduleId = declareReportService.getModleId();
        Map formulaVoMap = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CELLTYPE_FORMULAS, (Object[])new Object[]{this.templateId, null});
        Map typeMap = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_ALL_FIELDS_TYPE_SHOW, (Object[])new Object[]{this.moduleId});
        for (EntityField entity : templateEntityMap.values()) {
            Object e2;
            String key = entity.getFieldId();
            String[] keys = key.split("#");
            if (StringUtil.isEmpty((CharSequence)key) || (e2 = (MultiEntityField)typeMap.get(keys[keys.length - 1])) == null) continue;
            entity.setFieldName(((MultiEntityField)e2).getFieldName());
            entity.setFieldType(((MultiEntityField)e2).getFieldType());
            entity.setFormatStr(((MultiEntityField)e2).getFormat());
            entity.setScale(((MultiEntityField)e2).getScale());
            entity.setMaxLength(((MultiEntityField)e2).getMaxLength());
        }
        List dynRowNoList = DynamicRowService.getDynRowNoList((Long)this.templateId);
        HashMap<String, String> resultMap = new HashMap<String, String>(templateEntityMap.size());
        ImportDataVo importDataVo = new ImportDataVo();
        ArrayList<DynamicRowModel> dynamicRows = new ArrayList<DynamicRowModel>();
        for (Map.Entry entry : sheetsMaps.entrySet()) {
            String sheetName = (String)entry.getKey();
            if ("TEMPLATE_ID".equals(sheetName)) continue;
            List sheetValue = (List)entry.getValue();
            sheetValue = sheetValue.stream().sorted(Comparator.comparing(s -> Integer.parseInt(((String)s.getKey()).split("#")[1]))).collect(Collectors.toList());
            List<DynRowVo> dynRowList = handler.getDynRowList(sheetName, excelDataMap);
            dynRowList = dynRowList.stream().sorted(Comparator.comparing(DynRowVo::getIndex)).collect(Collectors.toList());
            for (DynRowVo dynRowVo : dynRowList) {
                dynRowVo.setOffset(dynRowVo.getRowSize() - 1);
                Map.Entry map = sheetValue.stream().filter(e -> dynRowVo.getDynRowKey().equals(((EntityField)e.getValue()).getFieldId().split("#")[0])).findFirst().orElse(null);
                dynRowVo.setDynRowNo(Integer.parseInt(((String)map.getKey()).split("#")[1]));
                DynamicRowModel model = new DynamicRowModel();
                model.setStartRow(Long.valueOf(1L));
                model.setDynRowNo(dynRowVo.getDynRowKey());
                dynamicRows.add(model);
            }
            Iterator tempIterator = sheetValue.iterator();
            String cellKey = "";
            while (tempIterator.hasNext()) {
                int rowNo;
                Map.Entry entry2 = (Map.Entry)tempIterator.next();
                cellKey = (String)entry2.getKey();
                EntityField value = (EntityField)entry2.getValue();
                String string = value.getFieldId().split("#")[0];
                DynRowVo dynRow = dynRowList.stream().filter(e -> e.getDynRowKey().equals(matchKey)).findFirst().orElse(null);
                int newRowNo = rowNo = Integer.parseInt(cellKey.split("#")[1]);
                int dynRowCount = -1;
                for (DynRowVo dyn : dynRowList) {
                    if (dyn.getDynRowKey().equals(string)) {
                        dynRowCount = dyn.getRowSize();
                    }
                    if (dyn.getDynRowNo() >= rowNo) continue;
                    newRowNo += dyn.getOffset();
                }
                if (dynRowCount == 0) continue;
                ArrayList<Map.Entry<String, EntityField>> cellEntry = new ArrayList<Map.Entry<String, EntityField>>();
                this.changeMap(cellEntry, rowNo, newRowNo, entry2);
                if (dynRow != null) {
                    ArrayList<Map.Entry<String, EntityField>> dynEntry = new ArrayList<Map.Entry<String, EntityField>>();
                    DynamicRowModel model = this.getDynamicRowListByDynRowNo(dynamicRows, dynRow.getDynRowKey());
                    ArrayList rowList = model == null ? null : model.getRowList();
                    this.paraseDynMap(dynEntry, dynRow, (Map.Entry)cellEntry.get(0));
                    for (Map.Entry entry3 : dynEntry) {
                        int index;
                        String fieldId = ((EntityField)entry3.getValue()).getFieldId();
                        String inputValue = StringUtil.trim((String)excelDataMap.get(entry3.getKey()));
                        this.setResultMap(formulaVoMap, resultMap, importDataVo, (EntityField)entry3.getValue(), inputValue, fieldId, (String)entry3.getKey());
                        if (rowList == null) {
                            rowList = new ArrayList();
                        }
                        if ((index = Integer.parseInt(((EntityField)entry3.getValue()).getEwblxh())) <= rowList.size()) {
                            ((Map)rowList.get(index - 1)).put(fieldId, inputValue);
                            continue;
                        }
                        HashMap<String, String> rowMap = new HashMap<String, String>(16);
                        rowMap.put(fieldId, inputValue);
                        rowList.add(rowMap);
                    }
                    if (model == null) {
                        model = new DynamicRowModel();
                    }
                    model.setRowList((List)rowList);
                    continue;
                }
                cellEntry.forEach(e -> this.setResultMap(formulaVoMap, resultMap, importDataVo, (EntityField)e.getValue(), StringUtil.trim((String)((String)excelDataMap.get(e.getKey()))), ((EntityField)e.getValue()).getFieldId(), (String)e.getKey()));
            }
        }
        TaxResult result = null;
        String string = importDataVo.getNsrsbh();
        String orgNumber = importDataVo.getOrgNumber();
        String taxSystem = importDataVo.getTaxsystem();
        logger.info("Import Params: Nsrsbh --- {}, OrgNumber --- {}, TaxSystem --- {}", new Object[]{string, orgNumber, taxSystem});
        result = StringUtil.isNotBlank((CharSequence)string) ? TaxcMainDataServiceHelper.queryTaxcMainByUnifiedsocialCode((String)string, StringUtil.isBlank((CharSequence)taxSystem) ? null : Long.valueOf(Long.parseLong(taxSystem))) : TaxcMainDataServiceHelper.queryTaxcMainByOrgNum((String)orgNumber, StringUtil.isBlank((CharSequence)taxSystem) ? null : Long.valueOf(Long.parseLong(taxSystem)));
        if (result != null) {
            if (!result.isSuccess()) {
                throw new KDBizException(result.getMessage());
            }
            if (EmptyCheckUtils.isEmpty((Object)result.getData())) {
                String errorMsg = StringUtil.isNotBlank((CharSequence)importDataVo.getNsrsbh()) ? ResManager.loadKDString((String)"\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38\uff0c\u6ca1\u6709\u67e5\u5230\u76f8\u5173\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u7684\u6b63\u786e\u6027\u3002", (String)"MultiImportDeclareReportPlugin_22", (String)"taxc-bdtaxr", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38\uff0c\u6ca1\u6709\u67e5\u5230\u76f8\u5173\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u7f16\u7801\u7684\u6b63\u786e\u6027\u3002", (String)"MultiImportDeclareReportPlugin_23", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            DynamicObject dobj = (DynamicObject)result.getData();
            String orgid = dobj.getString("taxorg.id");
            importDataVo.setOrgId(orgid);
            importDataVo.setOrgNumber(dobj.getString("taxorg.org.number"));
            String orgName = dobj.getString("taxorg.org.name");
            importDataVo.setOrgName(orgName);
            Date registerTime = dobj.getDate("registertime");
            importDataVo.setRegisterTime(registerTime);
        }
        handler.initImportData(importDataVo, resultMap);
        Long sbbid = null;
        String mainTable = "";
        if (declareReportService != null) {
            DeclareTable declareTable = MultiTableEnum.getDeclareTable((Long)this.moduleId);
            mainTable = declareTable.getMainTable();
        }
        resultMap.put(mainTable + "#templatetype", typeId);
        resultMap.put(mainTable + "#templateid", String.valueOf(this.templateId));
        resultMap.put(mainTable + "#org", importDataVo.getOrgId());
        resultMap.put(mainTable + "#orgnumber", importDataVo.getOrgNumber());
        resultMap.put(mainTable + "#datatype", "2");
        resultMap.put(mainTable + "#paystatus", "unpaid");
        resultMap.put(mainTable + "#declarestatus", "editing");
        resultMap.putAll(YbnsrServiceHelper.getAdditionalInfo((String)mainTable, (boolean)true));
        resultMap.put(mainTable + "#billstatus", "C");
        HashMap<String, String> mainDataMap = new HashMap<String, String>();
        HashMap<String, String> requestParams = new HashMap<String, String>();
        for (Map.Entry entry : resultMap.entrySet()) {
            if (!((String)entry.getKey()).startsWith(mainTable + "#")) continue;
            mainDataMap.put((String)entry.getKey(), (String)entry.getValue());
            String[] keys = ((String)entry.getKey()).split("#");
            requestParams.put(keys[keys.length - 1], (String)entry.getValue());
        }
        String orgid = importDataVo.getOrgId();
        requestParams.put("orgid", orgid);
        String string2 = (String)mainDataMap.get(mainTable + "#skssqq");
        String skssqz = (String)mainDataMap.get(mainTable + "#skssqz");
        Date startDate = DateUtils.stringToDate((String)string2);
        Date endDate = DateUtils.stringToDate((String)skssqz);
        boolean customValidateDates = declareReportImportService.validateDates(orgid, typeId, this.templateId, startDate, endDate, importDataVo.getRegisterTime(), resultMap);
        if (!customValidateDates) {
            if ("Overseas_VAT".equals(typeId) || "Overseas_CIT".equals(typeId) || "USA_CIT".equals(typeId)) {
                this.validateDatesForOverseas(orgid, typeId, this.templateId, startDate, endDate, importDataVo.getRegisterTime(), resultMap);
            } else {
                this.validateDates(orgid, typeId, this.templateId, startDate, endDate, importDataVo.getRegisterTime());
            }
        }
        if (typeId.equals("USA_CIT")) {
            mainDataMap.putAll(excelDataMap);
        }
        if (!(validDataResultVo = declareReportImportService.validExcelData(mainDataMap, templateObj)).getSuccess()) {
            throw new KDBizException(validDataResultVo.getMessage());
        }
        sbbid = declareReportService.getSbbId(requestParams);
        String uniKey = declareReportService.getUniKey(requestParams);
        boolean existReport = true;
        if (sbbid == null) {
            existReport = false;
            sbbid = TaxDeclarePluginService.generateSBBId(null);
            String billNumber = declareReportService.getBillNumber(startDate, endDate, orgid, requestParams);
            resultMap.put(mainTable + "#billno", billNumber);
        }
        if (MultiTableEnum.TSCOO1.getDeclareMainTable().equals(mainTable)) {
            if (existReport) {
                DynamicObject sbb = QueryServiceHelper.queryOne((String)mainTable, (String)"versiontype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sbbid)});
                String oldVersionType = sbb != null ? sbb.getString("versiontype") : "zcsb";
                resultMap.put(mainTable + "#versiontype", oldVersionType);
            } else {
                resultMap.put(mainTable + "#versiontype", "zcsb");
            }
        }
        Object taxLimit = null;
        Map excelLastLineMap = TemplateImportServiceHelper.getLastLine(excelDataMap);
        String string3 = DateUtils.format((Date)startDate);
        String enddateStr = DateUtils.format((Date)endDate);
        if (existReport) {
            HashMap<String, String> cacheMap = new HashMap<String, String>();
            cacheMap.put("orgid", orgid);
            cacheMap.put(COL_FINANCIAL_SRARTDATE_STATEMENTS, string3);
            cacheMap.put(COL_FINANCIAL_ENDDATE_STATEMENTS, enddateStr);
            cacheMap.put("typeid", typeId);
            cacheMap.put("taxlimit", (String)taxLimit);
            cacheMap.put("moduleId", String.valueOf(this.moduleId));
            cacheMap.put("templateId", String.valueOf(this.templateId));
            cacheMap.put("taxauthority", (String)resultMap.get("tcvat_nsrxx#1#taxauthority"));
            cacheMap.put("businessno", (String)resultMap.get("tcvat_nsrxx#1#businessno"));
            cacheMap.put("reportId", sbbid.toString());
            cacheMap.put("resultMap", SerializationUtils.toJsonString(resultMap));
            cacheMap.put("dynamicRows", SerializationUtils.toJsonString(dynamicRows));
            cacheMap.put("extendsParams", SerializationUtils.toJsonString(requestParams));
            cacheMap.put("sheetNames", String.join((CharSequence)",", excelLastLineMap.keySet()));
            this.RECACHELIST.add(cacheMap);
            String dataFormat = InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId());
            String sDate = DateUtils.format((Date)startDate, (String)dataFormat);
            String eDate = DateUtils.format((Date)endDate, (String)dataFormat);
            if ("etrscsum".equals(typeId)) {
                this.INTERRUPT_WORDS = this.INTERRUPT_WORDS + String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u3010%3$s\u3011\u7684\u7533\u62a5\u8868\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u8986\u76d6\u3002", (String)"MultiImportDeclareReportPlugin_17", (String)"taxc-bdtaxr", (Object[])new Object[0]), importDataVo.getOrgName(), sDate, eDate);
            }
            if ("drawback".equals(typeId)) {
                String batchNo = (String)resultMap.get("tcetr_declare_main#1#batchno");
                this.INTERRUPT_WORDS = this.INTERRUPT_WORDS + String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u3010%3$s\u3011\u3010%4$s\u3011\u7684\u7533\u62a5\u8868\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u8986\u76d6\u3002", (String)"MultiImportDeclareReportPlugin_18", (String)"taxc-bdtaxr", (Object[])new Object[0]), importDataVo.getOrgName(), sDate, eDate, batchNo);
            } else if ("qtsf_tysbb".equals(typeId) || "qtsf_fsstysbb".equals(typeId)) {
                this.INTERRUPT_WORDS = this.INTERRUPT_WORDS + String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u3010%3$s\u3011\u7684\u7533\u62a5\u8868\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u8986\u76d6\u3002", (String)"MultiImportDeclareReportPlugin_17", (String)"taxc-bdtaxr", (Object[])new Object[0]), importDataVo.getOrgName(), sDate, eDate);
            } else {
                this.MARKWORDS = String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011\u3010%3$s\u3011\u3010%4$s\u3011\u7684\u7533\u62a5\u8868\uff0c", (String)"MultiImportDeclareReportPlugin_19", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.MARKWORDS, importDataVo.getOrgName(), sDate, eDate);
            }
        } else {
            String customEvent = "add";
            TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)typeId);
            if (templateEnum != null) {
                DynamicObject object = StatusUtils.queryOne((String)templateEnum.getDraftType(), (String)orgid, (String)string3, (String)enddateStr, (String)"nssb");
                if (object != null) {
                    HashMap<String, String> cacheMap = new HashMap<String, String>();
                    cacheMap.put("orgid", orgid);
                    cacheMap.put(COL_FINANCIAL_SRARTDATE_STATEMENTS, string3);
                    cacheMap.put(COL_FINANCIAL_ENDDATE_STATEMENTS, enddateStr);
                    cacheMap.put("typeid", typeId);
                    cacheMap.put("taxlimit", (String)taxLimit);
                    cacheMap.put("moduleId", String.valueOf(this.moduleId));
                    cacheMap.put("templateId", String.valueOf(this.templateId));
                    cacheMap.put("reportId", sbbid.toString());
                    cacheMap.put("resultMap", SerializationUtils.toJsonString(resultMap));
                    cacheMap.put("dynamicRows", SerializationUtils.toJsonString(dynamicRows));
                    cacheMap.put("extendsParams", SerializationUtils.toJsonString(requestParams));
                    cacheMap.put("sheetNames", String.join((CharSequence)",", excelLastLineMap.keySet()));
                    this.BILLCACHELIST.add(cacheMap);
                    TaxResult dynamicObjectTaxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)Long.parseLong(orgid));
                    this.BILLMARKWORDS = this.BILLMARKWORDS + "\u3010" + ((DynamicObject)dynamicObjectTaxResult.getData()).getString("taxpayer") + "\u3011\u3010" + string3 + "\u3011\u3010" + enddateStr + "\u3011\r\n";
                } else {
                    this.saveDataAndRefresh(this.moduleId, this.templateId, typeId, new ArrayList<String>(excelLastLineMap.keySet()), resultMap, sbbid.toString(), orgid, string3, enddateStr, templateEntityMap, customEvent, uniKey, requestParams, dynamicRows);
                }
            } else {
                this.saveDataAndRefresh(this.moduleId, this.templateId, typeId, new ArrayList<String>(excelLastLineMap.keySet()), resultMap, sbbid.toString(), orgid, string3, enddateStr, templateEntityMap, customEvent, uniKey, requestParams, dynamicRows);
            }
        }
    }

    private void validOperatorno(String typeId, DynamicObject template, Map<String, String> resultMap) {
        String operatorno;
        String number = template.getString("number");
        if ((typeId.equals("qtsf_tysbb") || typeId.equals("qtsf_fsstysbb") || typeId.equals("qysdsjb") && ("CITQR2021".equals(number) || "CITQR2023".equals(number))) && StringUtil.isNotEmpty((CharSequence)(operatorno = resultMap.get("tcvat_nsrxx#1#operatorno"))) && !MultiImportDeclareReportPlugin.isIDCard18(operatorno)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ecf\u529e\u4eba\u8eab\u4efd\u8bc1\u4e0d\u5408\u6cd5\u3002", (String)"MultiImportDeclareReportPlugin_20", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    private void setResultMap(Map<String, FormulaVo> formulaVoMap, Map<String, String> resultMap, ImportDataVo importDataVo, EntityField value, String inputValue, String rKey, String excelDataKey) {
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)inputValue) && "Decimal".equals(value.getFieldType())) {
            resultMap.put(rKey, "0");
            return;
        }
        String fieldId = rKey.split("#")[1];
        Object result = null;
        if (NSRSBH_FIELD_ID.equals(fieldId)) {
            importDataVo.setNsrsbh(inputValue);
        } else if ("orgnumber".equals(fieldId)) {
            importDataVo.setOrgNumber(inputValue);
        } else if ("month".equals(fieldId)) {
            String regex = "^\\d{6}$";
            if (!inputValue.matches(regex)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u5e74\u6708\u586b\u5199\u9519\u8bef\u3002", (String)"MultiImportDeclareReportPlugin_21", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            Date startDate = DateUtils.stringToDate((String)inputValue, (String)"yyyyMM");
            Date endDate = DateUtils.getLastDateOfMonth((Date)startDate);
            importDataVo.setStartDate(startDate);
            importDataVo.setEndDate(endDate);
            resultMap.put("tcetr_declare_main#1#month", DateUtils.format((Date)startDate));
            resultMap.put("tcetr_declare_main#1#skssqq", DateUtils.format((Date)startDate));
            resultMap.put("tcetr_declare_main#1#skssqz", DateUtils.format((Date)endDate));
        } else if ("taxsystem".equals(fieldId)) {
            this.setValue(formulaVoMap, resultMap, value, inputValue, rKey, excelDataKey);
            importDataVo.setTaxsystem(resultMap.get(rKey));
        } else {
            this.setValue(formulaVoMap, resultMap, value, inputValue, rKey, excelDataKey);
        }
    }

    private DynamicObject queryOrg(String orgNumber) {
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)orgNumber)) {
            return null;
        }
        QFilter idFilter = new QFilter("number", "=", (Object)orgNumber);
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{idFilter});
        return org;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if ("sbboverridereport".equals(callBackId) || "draftoverride".equals(callBackId)) {
            if (MessageBoxResult.Yes == e.getResult()) {
                IPageCache pageCache = this.getPageCache();
                String jsonCache = "";
                if ("sbboverridereport".equals(callBackId)) {
                    jsonCache = pageCache.get(this.RECACHE);
                }
                if ("draftoverride".equals(callBackId)) {
                    jsonCache = pageCache.get(this.BILLCACHE);
                }
                List cacheList = JSON.parseArray((String)jsonCache, Map.class);
                for (Map cacheMap : cacheList) {
                    String orgid = (String)cacheMap.get("orgid");
                    String startdate = (String)cacheMap.get(COL_FINANCIAL_SRARTDATE_STATEMENTS);
                    Date skssqq = DateUtils.stringToDate((String)startdate);
                    String enddate = (String)cacheMap.get(COL_FINANCIAL_ENDDATE_STATEMENTS);
                    Date skssqz = DateUtils.stringToDate((String)enddate);
                    String typeid = (String)cacheMap.get("typeid");
                    String taxlimit = (String)cacheMap.get("taxlimit");
                    String businessno = (String)cacheMap.get("businessno");
                    String taxauthority = (String)cacheMap.get("taxauthority");
                    Map extendsParams = (Map)SerializationUtils.fromJsonString((String)((String)cacheMap.get("extendsParams")), Map.class);
                    List<String> sheetNames = Arrays.asList(String.valueOf(cacheMap.get("sheetNames")).split(","));
                    TemplateUtils.deleteReport((ImportDataVo)new ImportDataVo(orgid, typeid, skssqq, skssqz, taxlimit, taxauthority, businessno));
                    TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)typeid);
                    if (templateEnum != null) {
                        StatusUtils.delete((String)templateEnum.getDraftType(), (String)orgid, (String)startdate, (String)enddate, (String)"nssb");
                        StatusUtils.deleteDraftByTemplateType((TemplateEnum)templateEnum, (String)orgid, (String)startdate, (String)enddate, (String)"nssb");
                    }
                    String templateId = (String)cacheMap.get("templateId");
                    String reportId = (String)cacheMap.get("reportId");
                    this.moduleId = Long.parseLong((String)cacheMap.get("moduleId"));
                    Map resultMap = (Map)SerializationUtils.fromJsonString((String)((String)cacheMap.get("resultMap")), Map.class);
                    List dynamicRows = SerializationUtils.fromJsonStringToList((String)((String)cacheMap.get("dynamicRows")), DynamicRowModel.class);
                    String customEvent = "edit";
                    this.saveDataAndRefresh(this.moduleId, Long.parseLong(templateId), typeid, sheetNames, resultMap, reportId, orgid, startdate, enddate, this.templateEntityMap, customEvent, null, extendsParams, dynamicRows);
                }
            }
        } else if ("justContinue".equals(callBackId)) {
            StringBuilder message = new StringBuilder();
            if (MessageBoxResult.Yes == e.getResult()) {
                String file_url = e.getCustomVaule();
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)file_url)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e", (String)"MultiImportDeclareReportPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
                InputStream inputStream = this.getInputStream(file_url);
                try {
                    EntryGrid entry = (EntryGrid)this.getControl(ENTRYENT_FINANCIAL_STATEMENTS);
                    int[] rows = entry.getSelectRows();
                    Workbook hssfWorkbook = this.getWorkbook(inputStream);
                    this.templateId = (Long)this.getModel().getValue("id", rows[0]);
                    this.typeId = (String)this.getModel().getValue("typeid", rows[0]);
                    DynamicObject templateObj = BusinessDataServiceHelper.loadSingle((Object)this.templateId, (String)"tpo_template");
                    this.templateEntityMap = TemplateShowUtils.queryTemplateField((Long)this.templateId, (String)"tpo_template");
                    this.sheetsMaps = this.templateEntityMap.entrySet().stream().collect(Collectors.groupingBy(s -> ((String)s.getKey()).split("#")[0]));
                    this.excelDataMap = this.readDataToMap(hssfWorkbook, Boolean.FALSE);
                    this.offsets = declareReportImportService.getOffsetsWithTemplate(this.templateId, this.sheetsMaps, this.excelDataMap, templateObj);
                    this.handleInputStream(declareReportImportService, this.excelDataMap, this.templateEntityMap, this.sheetsMaps, templateObj, this.typeId, this.offsets);
                }
                catch (RuntimeException ex) {
                    logger.error((Throwable)ex);
                    String error = ex.getMessage();
                    message.append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u9519\u8bef\u4fe1\u606f\uff1a", (String)"MultiImportDeclareReportPlugin_24", (String)"taxc-bdtaxr", (Object[])new Object[0])).append(error).append("\r\n");
                }
                finally {
                    if (inputStream != null) {
                        FileUtils.safeClose((InputStream)inputStream);
                    }
                }
                this.afterImportHandle(message);
                this.getView().close();
            }
        }
    }

    private void saveDataAndRefresh(long moduleId, long templateId, String templatetype, List<String> sheetNames, Map<String, String> resultMap, String reportId, String orgid, String startDate, String endDate, Map<String, EntityField> templateEntityMap, String customEvent, String uniKey, Map<String, String> extendsParams, List<DynamicRowModel> dynamicRows) {
        BaseResult saveResult;
        DeclareDataCheckVo declareDataCheckVo;
        CheckResult checkResult;
        boolean isRefresh;
        DeclareRequestModel requestModel = declareService.getRequestModelMulti(orgid, templatetype, startDate, endDate, templateId);
        requestModel.setModelId(Long.valueOf(moduleId));
        requestModel.setId(Long.valueOf(Long.parseLong(reportId)));
        DeleteServiceHelper.delete((String)"tctb_declare_his", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)reportId)});
        Map typeMap = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_FIELDS_TYPE_SHOW_BY_VERSION, (Object[])new Object[]{moduleId, templateId, dynamicRows, startDate, endDate});
        declareReportImportService = DeclareReportImportFactory.createHandler(templatetype);
        if (declareReportImportService != null && (isRefresh = ((Boolean)this.getModel().getValue("isrefresh")).booleanValue()) && declareReportImportService.isSupportRefreshData()) {
            DeclareResponseModel declareResponseModel = this.refreshData(templatetype, requestModel, resultMap, dynamicRows, typeMap, extendsParams);
            resultMap.putAll(declareResponseModel.getData());
        }
        if (!(checkResult = DeclareReportHelpService.checkBeforeSave(declareDataCheckVo = new DeclareDataCheckVo(resultMap, requestModel, dynamicRows, typeMap, null))).isSuccess()) {
            throw new KDBizException(checkResult.getReason());
        }
        TaxDeclareSaveDataDto saveDataDto = new TaxDeclareSaveDataDto();
        saveDataDto.setModelId(Long.valueOf(moduleId));
        saveDataDto.setOrgId(Long.parseLong(orgid));
        saveDataDto.setSbbId(Long.valueOf(Long.parseLong(reportId)));
        saveDataDto.setSkssqq(startDate);
        saveDataDto.setSkssqz(endDate);
        saveDataDto.setTemplateType(templatetype);
        saveDataDto.setCustomEvent(customEvent);
        saveDataDto.setCurrMap(resultMap);
        saveDataDto.setUpdateMap(resultMap);
        saveDataDto.setRemarkMap(null);
        saveDataDto.setTypeMap(typeMap);
        saveDataDto.setNewMaps(resultMap);
        saveDataDto.setUniKey(uniKey);
        if (!CollectionUtils.isEmpty(extendsParams)) {
            Map<String, String> extendsParamsObj = saveDataDto.getExtendParams() == null ? new HashMap(extendsParams.size()) : saveDataDto.getExtendParams();
            extendsParamsObj.putAll(extendsParams);
            saveDataDto.setExtendParams(extendsParamsObj);
        }
        if ((saveResult = (BaseResult)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.SAVE_DECLARE_DATA, (Object[])new Object[]{saveDataDto})) == null || saveResult.getData() == null || !BaseResult.OK.equals(saveResult.getCode())) {
            throw new KDBizException("save fail!");
        }
        DeleteServiceHelper.delete((String)"tctb_declare_his", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)reportId)});
        DeclareReportSaveService declareReportSaveService = DeclareReportSaveFactory.createHandler(templatetype);
        if (declareReportSaveService != null) {
            HashMap<String, Object> requestMap = new HashMap<String, Object>(1);
            requestMap.put("orgId", orgid);
            requestMap.put("skssqq", startDate);
            requestMap.put("skssqz", endDate);
            requestMap.put("Id", reportId);
            requestMap.putAll(saveDataDto.getExtendParams());
            Map saveResultMap = (Map)saveResult.getData();
            HashMap<String, Object> resultMap1 = new HashMap<String, Object>(saveResultMap);
            BaseResult baseResult = declareReportSaveService.saveBusinessData(requestMap, resultMap1);
        }
        if ((declareReportImportService = DeclareReportImportFactory.createHandler(templatetype)) != null) {
            declareReportImportService.sendImportSheets(requestModel, sheetNames);
        }
        String entityName = OverSeaMQSender.getEntityName((IFormView)this.getView().getParentView());
        OverSeaMQSender.sendMQ(Collections.singletonList(Long.parseLong(reportId)), (Long)moduleId, (String)DeclareMQEvent.IMPORT.name().toLowerCase(), (String)entityName);
        TableTypeMapTemplateTypeEnum typeEnum = TableTypeMapTemplateTypeEnum.getEnumByTemplateType((String)templatetype);
        if (null != typeEnum || Arrays.asList(ImportDataConstant.getFinancialTypes()).contains(templatetype)) {
            // empty if block
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"MultiImportDeclareReportPlugin_25", (String)"taxc-bdtaxr", (Object[])new Object[0]));
    }

    private DeclareResponseModel refreshData(String templatetype, DeclareRequestModel requestModel, Map<String, String> resultMap, List<DynamicRowModel> dynamicRows, Map<String, EntityField> typeMap, Map<String, String> extendsParams) {
        Map initParams;
        declareReportImportService = DeclareReportImportFactory.createHandler(templatetype);
        if (declareReportImportService != null) {
            declareReportImportService.setRequestModelParams(templatetype, requestModel, resultMap, dynamicRows);
        }
        if (!CollectionUtils.isEmpty((Map)(initParams = InitParamsService.getInitParams((String)requestModel.getTemplateType()).buildBizParam(requestModel)))) {
            requestModel.getBusinessMap().putAll(initParams);
        }
        FormulaCollectionVo allFormulas = (FormulaCollectionVo)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CAL_FORMULAS, (Object[])new Object[]{requestModel, dynamicRows});
        Map cellTypeFormulas = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CELLTYPE_FORMULAS, (Object[])new Object[]{requestModel.getTemplateId(), dynamicRows});
        allFormulas.setCelltypeFormulas(cellTypeFormulas);
        return DeclareReportHelpService.refreshData(requestModel, allFormulas, dynamicRows, typeMap);
    }

    private void setValue(Map<String, FormulaVo> formulaVoMap, Map<String, String> resultMap, EntityField value, String inputValue, String rKey, String excelDataKey) {
        String ewblName = value.getEwblName();
        String fieldName = value.getFieldName();
        String[] keys = excelDataKey.split("#");
        String sheetName = keys[0];
        int rowIndex = Integer.parseInt(keys[1]) + 1;
        int columnIndex = Integer.parseInt(keys[2]) + 1;
        this.checkFieldTypeVolid(value, inputValue, fieldName, excelDataKey);
        inputValue = DataFormatUtils.dataFormatByFieldType((Object)inputValue, (EntityField)value);
        FormulaVo formulaVo = formulaVoMap.get(rKey);
        if (null == formulaVo) {
            String[] split = rKey.split("#");
            String regex = split[0] + "#" + split[split.length - 1];
            Optional<Map.Entry> first = formulaVoMap.entrySet().stream().filter(s -> ((String)s.getKey()).matches(regex)).findFirst();
            FormulaVo formulaVo2 = formulaVo = first.isPresent() ? (FormulaVo)first.get().getValue() : null;
        }
        if (formulaVo != null && "3".equals(formulaVo.getFormulaType())) {
            String celltype = formulaVo.getCellType();
            if ("5".equals(celltype)) {
                Map itemMap = TemplateShowUtils.parseCellTypeMap((String)formulaVo.getFormulaName());
                if (null == itemMap) {
                    return;
                }
                boolean customImport = declareReportImportService.queryImportBasedata(itemMap, resultMap, inputValue, rKey);
                if (!customImport) {
                    this.queryBaseData(itemMap, resultMap, inputValue, rKey);
                }
            } else if ("2".equals(celltype) || "3".equals(celltype) || "4".equals(celltype)) {
                Map comboMap = TemplateShowUtils.parseCellType((String)formulaVo.getFormulaName());
                boolean isMatch = false;
                for (Map.Entry entry : comboMap.entrySet()) {
                    if (!kd.bos.dataentity.utils.StringUtils.deleteWhitespace((String)((String)entry.getValue())).equals(kd.bos.dataentity.utils.StringUtils.deleteWhitespace((String)inputValue))) continue;
                    resultMap.put(rKey, (String)entry.getKey());
                    isMatch = true;
                    break;
                }
                if (!isMatch && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)inputValue)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u7b2c%3$s\u5217,\u201c%4$s\u201d\u5217\uff1a\u5339\u914d\u4e0d\u5230\u503c\uff1a%5$s\u3002", (String)"MultiImportDeclareReportPlugin_48", (String)"taxc-bdtaxr", (Object[])new Object[0]), sheetName, rowIndex, columnIndex, fieldName, inputValue));
                }
            } else {
                resultMap.put(rKey, inputValue);
            }
        } else {
            resultMap.put(rKey, inputValue);
        }
        inputValue = resultMap.get(rKey);
    }

    private void checkFieldTypeVolid(EntityField value, String inputValue, String fieldName, String excelDataKey) {
        String fieldTypeStr;
        String[] keys = excelDataKey.split("#");
        String sheetName = keys[0];
        int rowIndex = Integer.parseInt(keys[1]) + 1;
        int columnIndex = Integer.parseInt(keys[2]) + 1;
        String string = fieldTypeStr = value.getFieldType() == null ? "" : value.getFieldType().trim();
        if (("decimal".equalsIgnoreCase(fieldTypeStr) || "integer".equalsIgnoreCase(fieldTypeStr)) && this.filterSpecialCharacter(inputValue)) {
            if (!(inputValue = inputValue.replaceAll(",", "")).matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
                logger.info("Excel\u5355\u5143\u683c\u6570\u636e\u6821\u9a8c\uff1a{}", (Object)inputValue);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u7b2c%3$s\u5217,\u201c%4$s\u201d\u5217\uff1a\u6570\u636e\u683c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u6570\u503c\u7c7b\u578b\u5355\u5143\u683c\u53ea\u80fd\u662f\u963f\u62c9\u4f2f\u6570\u5b57\uff0c\u4e14\u6570\u5b57\u4e2d\u4e0d\u80fd\u5e26\u6709\u4efb\u4f55\u7b26\u53f7\uff08\u975e\u4e2d\u6587\u8f93\u5165\u6cd5\u5f55\u5165\u7684\u5c0f\u6570\u70b9\uff0c\u8d1f\u53f7\u9664\u5916\uff09\u3002\u8bf7\u4e25\u683c\u6309\u7167\u4e0a\u8ff0\u6a21\u677f\u683c\u5f0f\u5f15\u5165\u3002", (String)"MultiImportDeclareReportPlugin_26", (String)"taxc-bdtaxr", (Object[])new Object[0]), sheetName, rowIndex, columnIndex, fieldName));
            }
        } else if ("text".equalsIgnoreCase(fieldTypeStr)) {
            if (inputValue.length() > value.getMaxLength()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u7b2c%3$s\u5217,\u201c%4$s\u201d\u5217\uff1a\u5f55\u5165\u6587\u672c\u5b57\u7b26\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MultiImportDeclareReportPlugin_27", (String)"taxc-bdtaxr", (Object[])new Object[0]), sheetName, rowIndex, columnIndex, fieldName));
            }
        } else if ("date".equalsIgnoreCase(fieldTypeStr) && !StringUtil.isBlank((CharSequence)inputValue)) {
            String format = value.getFormatStr();
            try {
                if (StringUtil.isBlank((CharSequence)format)) {
                    format = "yyyy-MM-dd";
                }
                DateUtils.stringToDate((String)inputValue, (String)format);
            }
            catch (Exception e) {
                String fieldId = value.getFieldName();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u7b2c%3$s\u5217,\u201c%4$s\u201d\u5217\u65e5\u671f[%5$s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%6$s\u3002", (String)"MultiImportDeclareReportPlugin_47", (String)"taxc-bdtaxr", (Object[])new Object[0]), sheetName, rowIndex, columnIndex, fieldId, inputValue, format));
            }
        }
    }

    private String getLanguage(Map<String, String> itemMap) {
        String language = declareReportImportService.getLanguage();
        if (StringUtil.isEmpty((CharSequence)language)) {
            language = itemMap.get("language");
        }
        return language;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void queryBaseData(Map<String, String> itemMap, Map<String, String> resultMap, String inputValue, String rKey) {
        QFilter[] filters;
        String[] split;
        ArrayList<String> valueList;
        DynamicObject table;
        List selectFieldList;
        String language;
        boolean multiselect;
        String tableName;
        block35: {
            ArrayList<Long> idList;
            block36: {
                if (StringUtil.isEmpty((CharSequence)inputValue)) {
                    return;
                }
                tableName = itemMap.get("val");
                String fieldName = itemMap.get("text");
                multiselect = "true".equals(itemMap.get("multiselect"));
                language = this.getLanguage(itemMap);
                selectFieldList = TemplateShowUtils.parseBaseDataFieldList((String)fieldName);
                table = BusinessDataServiceHelper.newDynamicObject((String)tableName);
                String[] values = inputValue.split("\u3001");
                idList = new ArrayList<Long>(10);
                valueList = new ArrayList<String>(10);
                for (String value : values) {
                    if (value.contains("|")) {
                        String[] items = value.split("\\|");
                        valueList.add(items[0]);
                        continue;
                    }
                    try {
                        Long id = Long.parseLong(inputValue);
                        idList.add(id);
                    }
                    catch (Exception e) {
                        logger.error("id\u683c\u5f0f\u4e0d\u6b63\u786e\u3002");
                        valueList.add(value);
                    }
                }
                split = values[0].split("\\|");
                if (split.length <= 1) break block36;
                String selectFiels = (String)selectFieldList.get(1);
                if (selectFiels.contains("|")) {
                    String[] fields = selectFiels.split("\\|");
                    filters = new QFilter[]{this.getInFilter("id", idList).or(fields[0], "in", valueList).or(this.getInFilter(fields[1], valueList))};
                    break block35;
                } else if ("gtcp_fetchitem".equals(tableName)) {
                    QFilter filter = this.getInFilter((String)selectFieldList.get(1), valueList).and("enable", "=", (Object)"1");
                    long taxtypeId = 0L;
                    if (StringUtils.isNotEmpty((CharSequence)resultMap.get("tpo_declare_main_tsd#taxsystem"))) {
                        filter.and("taxationsys", "=", (Object)Long.parseLong(resultMap.get("tpo_declare_main_tsd#taxsystem")));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)resultMap.get("tpo_declare_main_tsd#taxtype"))) {
                        taxtypeId = Long.parseLong(resultMap.get("tpo_declare_main_tsd#taxtype"));
                        if (taxtypeId == 1641493001807107072L) {
                            filter.and("taxcategory", "in", Arrays.asList(1641493001807107072L, 1809480249910520832L, 1809480669449971712L, 1809480431255448576L, 1809479652222199808L, 1809479939372640256L));
                        } else if (taxtypeId == 1641486689354421248L) {
                            filter.and("taxcategory", "in", Arrays.asList(1641486689354421248L, 1809481079233472512L, 1809480893786516480L));
                        } else {
                            filter.and("taxcategory", "=", (Object)Long.parseLong(resultMap.get("tpo_declare_main_tsd#taxtype")));
                        }
                    }
                    if (StringUtils.isNotEmpty((CharSequence)resultMap.get("tpo_declare_main_tsd#taxareagroup")) && taxtypeId != 1641488655174373376L) {
                        filter.and("taxareagroup", "=", (Object)Long.parseLong(resultMap.get("tpo_declare_main_tsd#taxareagroup")));
                    }
                    filters = filter.toArray();
                    break block35;
                } else {
                    filters = new QFilter[]{this.getInFilter((String)selectFieldList.get(1), valueList)};
                }
                break block35;
            }
            if (tableName.equals("itp_fetchitem")) {
                filters = new QFilter[]{this.getInFilter("id", idList).or(this.getInFilter((String)selectFieldList.get(1), valueList)).or(this.getInFilter("number", valueList)).and("enable", "=", (Object)"1")};
            } else if ("gtcp_fetchitem".equals(tableName)) {
                QFilter filter = this.getInFilter("id", idList).or(this.getInFilter("number", valueList)).and("enable", "=", (Object)"1");
                long taxtypeId = 0L;
                if (StringUtils.isNotEmpty((CharSequence)resultMap.get("tpo_declare_main_tsd#taxsystem"))) {
                    filter.and("taxationsys", "=", (Object)Long.parseLong(resultMap.get("tpo_declare_main_tsd#taxsystem")));
                }
                if (StringUtils.isNotEmpty((CharSequence)resultMap.get("tpo_declare_main_tsd#taxtype"))) {
                    taxtypeId = Long.parseLong(resultMap.get("tpo_declare_main_tsd#taxtype"));
                    if (taxtypeId == 1641493001807107072L) {
                        filter.and("taxcategory", "in", Arrays.asList(1641493001807107072L, 1809480249910520832L, 1809480669449971712L, 1809480431255448576L, 1809479652222199808L, 1809479939372640256L));
                    } else if (taxtypeId == 1641486689354421248L) {
                        filter.and("taxcategory", "in", Arrays.asList(1641486689354421248L, 1809481079233472512L, 1809480893786516480L));
                    } else {
                        filter.and("taxcategory", "=", (Object)Long.parseLong(resultMap.get("tpo_declare_main_tsd#taxtype")));
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)resultMap.get("tpo_declare_main_tsd#taxareagroup")) && taxtypeId != 1641488655174373376L) {
                    filter.and("taxareagroup", "=", (Object)Long.parseLong(resultMap.get("tpo_declare_main_tsd#taxareagroup")));
                }
                filters = filter.toArray();
            } else {
                filters = new QFilter[]{this.getInFilter("id", idList).or(this.getInFilter((String)selectFieldList.get(1), valueList))};
            }
        }
        if (table.containsProperty("enable")) {
            List<QFilter> collect = Arrays.stream(filters).collect(Collectors.toList());
            collect.add(new QFilter("enable", "=", (Object)"1"));
            filters = collect.toArray(new QFilter[0]);
        }
        DynamicObjectCollection objectList = TemplateShowUtils.queryData((String)tableName, (String)String.join((CharSequence)",", selectFieldList), (QFilter[])filters, (String)language);
        if (multiselect) {
            if (null != objectList && objectList.size() == valueList.size()) {
                resultMap.put(rKey, objectList.stream().map(v -> v.getString("id")).collect(Collectors.joining("\u3001")));
                return;
            }
            String value = valueList.stream().collect(Collectors.joining("\u3001"));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u57fa\u7840\u8d44\u6599\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MultiImportDeclareReportPlugin_33", (String)"taxc-bdtaxr", (Object[])new Object[0]), value));
        }
        if (null != objectList && objectList.size() == 1) {
            resultMap.put(rKey, ((DynamicObject)objectList.get(0)).getString("id"));
            return;
        }
        if (objectList != null && objectList.size() > 1) {
            if (split.length < 2) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801:\u3010%s\u3011\u5bf9\u5e94\u591a\u6761\u57fa\u7840\u8d44\u6599", (String)"MultiImportDeclareReportPlugin_30", (String)"taxc-bdtaxr", (Object[])new Object[0]), split[0]));
            }
            DynamicObjectCollection keywordList = QueryServiceHelper.query((String)"tpo_taxdeductionkeyword", (String)"id,number,name,keyword", (QFilter[])new QFilter[]{new QFilter((String)selectFieldList.get(1), "=", (Object)split[0])});
            String name = split[1];
            Optional<DynamicObject> keywordObj = keywordList.stream().filter(keyword -> name.contains(keyword.getString("keyword"))).findFirst();
            if (!keywordObj.isPresent()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u57fa\u7840\u8d44\u6599\u4ee3\u7801\u5b58\u5728\u591a\u4e2a\u540d\u79f0\uff0c\u8bf7\u6309\u683c\u5f0f\u8981\u6c42\u6b63\u786e\u586b\u5199\u8d44\u6599\u540d\u79f0\u3002\u3010\u586b\u5199\u683c\u5f0f\uff1a\u8d44\u6599\u4ee3\u7801|\u8d44\u6599\u540d\u79f0\u3011", (String)"MultiImportDeclareReportPlugin_32", (String)"taxc-bdtaxr", (Object[])new Object[0]), split[0]));
            }
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)tableName, (String)String.join((CharSequence)",", selectFieldList), (QFilter[])new QFilter[]{new QFilter((String)selectFieldList.get(1), "=", (Object)split[0]), new QFilter((String)selectFieldList.get(2), "=", (Object)keywordObj.get().getString("name")), new QFilter("enable", "=", (Object)"1")});
            if (dynamicObject != null) {
                resultMap.put(rKey, dynamicObject.getString("id"));
                return;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u57fa\u7840\u8d44\u6599\u4ee3\u7801\u6570\u636e\u7ef4\u62a4\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u6280\u672f\u4eba\u5458\u8fdb\u884c\u4fee\u6539\u3002", (String)"MultiImportDeclareReportPlugin_31", (String)"taxc-bdtaxr", (Object[])new Object[0]), split[0]));
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u57fa\u7840\u8d44\u6599\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MultiImportDeclareReportPlugin_33", (String)"taxc-bdtaxr", (Object[])new Object[0]), split[0]));
    }

    private QFilter getInFilter(String field, List valueList) {
        QFilter filter = null;
        filter = valueList.size() > 0 ? new QFilter(field, "in", (Object)valueList) : new QFilter("1", "!=", (Object)1);
        return filter;
    }

    private boolean filterSpecialCharacter(String inputValue) {
        return kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)inputValue) && !inputValue.equals("--") && !inputValue.equals("*");
    }

    private void validateDates(String orgid, String typeId, long templateId, Date skssqq, Date skssqz, Date fregistertime) {
        logger.info("typeId:" + typeId);
        logger.info("templateId:" + templateId);
        logger.info("skssqq:" + skssqq);
        logger.info("skssqz:" + skssqz);
        logger.info("orgid:" + orgid);
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)orgid) || "0".equals(orgid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u6216\u7ec4\u7ec7\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7ec4\u7ec7\u7f16\u7801\u3002", (String)"MultiImportDeclareReportPlugin_34", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if (skssqq == null || skssqz == null || skssqq.compareTo(skssqz) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\u3002", (String)"MultiImportDeclareReportPlugin_35", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)skssqq);
        if (skssqq.compareTo(firstDateOfMonth) != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\u3002", (String)"MultiImportDeclareReportPlugin_35", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        String[] types = (String[])ImportDataConstant.getPeriodTypeMap().get(typeId);
        if (types != null) {
            boolean validDate = false;
            String[] stringArray = types;
            int n = stringArray.length;
            block12: for (int i = 0; i < n; ++i) {
                String type;
                switch (type = stringArray[i]) {
                    case "year": {
                        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)skssqz);
                        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)skssqq);
                        if (firstDateOfYear.compareTo(skssqq) != 0 || !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfYear))) continue block12;
                        validDate = true;
                        continue block12;
                    }
                    case "halfyear": {
                        Date firstDateOfHalfYear = DateUtils.getFirstDateOfHalfYear((Date)skssqq);
                        Date lastDateOfHalfYear = DateUtils.getLastDateOfHalfYear((Date)skssqq);
                        if (firstDateOfHalfYear.compareTo(skssqq) != 0 || !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfHalfYear))) continue block12;
                        validDate = true;
                        continue block12;
                    }
                    case "season": {
                        Date firstDateOfSeason = DateUtils.getFirstDateOfSeason((Date)skssqq);
                        Date lastDateOfSeason = DateUtils.getLastDateOfSeason((Date)skssqq);
                        Date lastDateOfMonth1 = DateUtils.getLastDateOfMonth((Date)skssqq);
                        if ((!DateUtils.format((Date)skssqq).equals(DateUtils.format((Date)firstDateOfSeason)) || !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfSeason))) && !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfMonth1))) continue block12;
                        validDate = true;
                        continue block12;
                    }
                    case "first_three_quarter": {
                        Date firstDate = DateUtils.getFirstDateOfYear((Date)skssqq);
                        Date endDate = DateUtils.addMonth((Date)firstDate, (int)8);
                        endDate = DateUtils.getDayFirst((Date)DateUtils.getLastDateOfMonth((Date)endDate));
                        if (!DateUtils.format((Date)skssqq).equals(DateUtils.format((Date)firstDate)) || !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)endDate))) continue block12;
                        validDate = true;
                        continue block12;
                    }
                    default: {
                        Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)skssqq);
                        if (!DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfMonth))) continue block12;
                        validDate = true;
                    }
                }
            }
            if (!validDate) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\u3002", (String)"MultiImportDeclareReportPlugin_35", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        } else {
            Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)skssqq);
            if (!DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)lastDateOfMonth))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\u3002", (String)"MultiImportDeclareReportPlugin_35", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        }
        DynamicObject template = QueryServiceHelper.queryOne((String)"tpo_template", (String)"startdate,enddate,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        Date tempStartDate = template.getDate(COL_FINANCIAL_SRARTDATE_STATEMENTS);
        Date tempEndDate = template.getDate(COL_FINANCIAL_ENDDATE_STATEMENTS);
        ArrayList endNumbers = Lists.newArrayList((Object[])new String[]{"RT2020", "YYS001", "CCS001", "EPT2018", "stamp-tax", "tcret2019"});
        if (endNumbers.contains(template.getString("number")) ? tempEndDate != null && skssqz.compareTo(tempEndDate) > 0 : tempStartDate.compareTo(skssqz) > 0 || tempEndDate != null && tempEndDate.compareTo(skssqq) < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e\u5c5e\u671f\u4e0d\u5728\u6a21\u677f\u6709\u6548\u671f\u8303\u56f4\u5185\u3002", (String)"MultiImportDeclareReportPlugin_36", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if (Objects.nonNull(fregistertime) && fregistertime.after(skssqz)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u7a0e\u6b3e\u6240\u5c5e\u671f\u4e0d\u5f97\u65e9\u4e8e\u4f01\u4e1a\u767b\u8bb0\u65f6\u95f4\u3002", (String)"MultiImportDeclareReportPlugin_37", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    private void validateDatesForOverseas(String orgid, String typeId, long templateId, Date skssqq, Date skssqz, Date fregistertime, Map<String, String> resultMap) {
        logger.info("typeId:" + typeId);
        logger.info("templateId:" + templateId);
        logger.info("skssqq:" + skssqq);
        logger.info("skssqz:" + skssqz);
        logger.info("orgid:" + orgid);
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)orgid) || "0".equals(orgid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u6216\u7ec4\u7ec7\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7ec4\u7ec7\u7f16\u7801\u3002", (String)"MultiImportDeclareReportPlugin_34", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if (skssqq == null || skssqz == null || skssqq.compareTo(skssqz) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\u3002", (String)"MultiImportDeclareReportPlugin_35", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        String taxsystem = resultMap.get("tpo_declare_main_tsd#taxsystem");
        if (StringUtils.isEmpty((CharSequence)taxsystem)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"MultiImportDeclareReportPlugin_38", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        String taxtype = resultMap.get("tpo_declare_main_tsd#taxtype");
        if (StringUtils.isEmpty((CharSequence)taxtype)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u79cd\u4e0d\u5b58\u5728\u3002", (String)"MultiImportDeclareReportPlugin_46", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        String entityId = (String)this.getView().getParentView().getFormShowParameter().getCustomParams().get("billFormId");
        String draftpurpose = resultMap.get("tpo_declare_main_tsd#draftpurpose");
        if ("gtcp_normal_jt_list".equals(entityId) && "nssb".equals(draftpurpose)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u5e95\u7a3f\u7528\u9014\u586b\u5199\u9519\u8bef\u3002", (String)"MultiImportDeclareReportPlugin_40", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if ("gtcp_normal_draft_list".equals(entityId) && "sjjt".equals(draftpurpose)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u5e95\u7a3f\u7528\u9014\u586b\u5199\u9519\u8bef\u3002", (String)"MultiImportDeclareReportPlugin_40", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        Date newStartDate = MultiImportDeclareReportPlugin.getTaxPeriodStartDate(Long.parseLong(orgid), Long.parseLong(taxsystem), Long.parseLong(taxtype));
        if ("nssb".equals(draftpurpose) && newStartDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7eb3\u7a0e\u671f\u95f4\u3002", (String)"MultiImportDeclareReportPlugin_39", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if (Objects.nonNull(fregistertime) && fregistertime.after(skssqz)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u7a0e\u6b3e\u6240\u5c5e\u671f\u4e0d\u5f97\u65e9\u4e8e\u4f01\u4e1a\u767b\u8bb0\u65f6\u95f4\u3002", (String)"MultiImportDeclareReportPlugin_37", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        ImmutablePair<Date, Date> dateImmutablePair = this.calDate(newStartDate, skssqq, skssqz, draftpurpose);
        if (dateImmutablePair == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u8d77\u6b62\u4e0e\u9002\u7528\u7684\u7eb3\u7a0e\u671f\u95f4\u53ca\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MultiImportDeclareReportPlugin_41", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        this.validateDates(orgid, typeId, templateId, (Date)dateImmutablePair.left, (Date)dateImmutablePair.right, fregistertime);
    }

    private ImmutablePair<Date, Date> calDate(Date taxYearStartDate, Date modelStartDate, Date modelEndDate, String draftpurpose) {
        if (taxYearStartDate == null || modelStartDate == null || modelEndDate == null) {
            return null;
        }
        if ("sjjt".equals(draftpurpose)) {
            return ImmutablePair.of((Object)modelStartDate, (Object)modelEndDate);
        }
        int monthInt = 1 - DateUtils.getMonthOfDate((Date)taxYearStartDate);
        int dataInt = 1 - DateUtils.getDayOfDate((Date)taxYearStartDate);
        Date offSetStartDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)modelStartDate, (int)monthInt), (int)dataInt);
        Integer monthBetweenInOneYear = this.getMonthBetweenInOneYear(modelStartDate, modelEndDate);
        if (monthBetweenInOneYear != null) {
            Date offSetEndDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)offSetStartDate, (int)monthBetweenInOneYear), (int)-1);
            return ImmutablePair.of((Object)offSetStartDate, (Object)offSetEndDate);
        }
        return null;
    }

    public Integer getMonthBetweenInOneYear(Date minDate, Date maxDate) {
        int result;
        if (minDate == null || maxDate == null || maxDate.compareTo(minDate) <= 0) {
            return null;
        }
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        min.setTime(minDate);
        max.setTime(maxDate);
        for (result = 0; min.before(max) && result < 12; ++result) {
            min.add(2, 1);
        }
        min.add(5, -1);
        if (result <= 12 && min.equals(max)) {
            return result;
        }
        return null;
    }

    public static Date getTaxPeriodStartDate(Long orgId, Long taxSysId, Long taxTypeId) {
        Map rowMap;
        List resultList;
        Date newStartDate = null;
        if (orgId == 0L || taxSysId == null || taxSysId == 0L) {
            return newStartDate;
        }
        ArrayList list = new ArrayList();
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("key_orgId", orgId);
        map.put("key_taxationsysId", taxSysId);
        map.put("key_taxcategoryId", taxTypeId);
        list.add(map);
        TaxResult taxResult = TaxcYearDataServiceHelper.queryTaxcyearsByPriority(list);
        if (taxResult.isSuccess() && ObjectUtils.isNotEmpty((Object)(resultList = (List)taxResult.getData())) && ObjectUtils.isNotEmpty((Object)(rowMap = (Map)resultList.get(0))) && ObjectUtils.isNotEmpty(rowMap.get("key_taxyear"))) {
            newStartDate = ((DynamicObject)rowMap.get("key_taxyear")).getDate(COL_FINANCIAL_SRARTDATE_STATEMENTS);
        }
        return newStartDate;
    }

    private Date formatDateStr(String dateStr) {
        Date date;
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)dateStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\u3002", (String)"MultiImportDeclareReportPlugin_35", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        String format = "yyyy-MM-dd";
        if (dateStr.contains(ResManager.loadKDString((String)"\u65e5", (String)"MultiImportDeclareReportPlugin_42", (String)"taxc-bdtaxr", (Object[])new Object[0]))) {
            format = DateUtils.YYYYMMDD_CHINESE;
        }
        this.checkLeapYear(dateStr, format);
        try {
            date = DateUtils.stringToDate((String)dateStr);
        }
        catch (Exception e) {
            try {
                date = DateUtils.stringToDate((String)dateStr, (String)DateUtils.YYYYMMDD_CHINESE);
            }
            catch (Exception e1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u8bf7\u4e25\u683c\u6309\u7167\u6a21\u677f\u683c\u5f0f\u5f15\u5165\uff0c\u5408\u6cd5\u65e5\u671f\u683c\u5f0f xxxx\u5e74xx\u6708xx\u65e5\u6216yyyy-MM-dd", (String)"MultiImportDeclareReportPlugin_43", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        }
        return date;
    }

    private void checkLeapYear(String dateStr, String format) {
        try {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
            LocalDate localDate = LocalDate.parse(dateStr, dateTimeFormatter);
            if (!localDate.isLeapYear() && (dateStr.endsWith("-02-29") || dateStr.endsWith(ResManager.loadKDString((String)"\u5e7402\u670829\u65e5", (String)"MultiImportDeclareReportPlugin_44", (String)"taxc-bdtaxr", (Object[])new Object[0])))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u8bf7\u4e25\u683c\u6309\u7167\u6a21\u677f\u683c\u5f0f\u5f15\u5165\uff0c\u5408\u6cd5\u65e5\u671f\u683c\u5f0f xxxx\u5e74xx\u6708xx\u65e5\u6216yyyy-MM-dd", (String)"MultiImportDeclareReportPlugin_43", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u8bf7\u4e25\u683c\u6309\u7167\u6a21\u677f\u683c\u5f0f\u5f15\u5165\uff0c\u5408\u6cd5\u65e5\u671f\u683c\u5f0f xxxx\u5e74xx\u6708xx\u65e5\u6216yyyy-MM-dd", (String)"MultiImportDeclareReportPlugin_43", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    private void autoRefreshElement(DynamicObjectCollection nsrxxCollection, TableTypeMapTemplateTypeEnum typeEnum) {
        if (CollectionUtils.isEmpty((Collection)nsrxxCollection)) {
            return;
        }
        String tableType = typeEnum != null ? typeEnum.getTableType() : "2";
        DeclareMQSender.sendMQ((DynamicObjectCollection)nsrxxCollection, (String)tableType, (String)DeclareMQType.DECLARE.name(), (String)DeclareMQEvent.IMPORT.name());
    }

    public void remove(UploadEvent evt) {
        String cacheUrls = this.getPageCache().get(this.FILELIST);
        List<Map> filelist = kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        for (Object url : evt.getUrls()) {
            filelist.removeIf(f -> f.get("uid").equals(((Map)url).get("uid")));
        }
        this.getPageCache().put(this.FILELIST, SerializationUtils.serializeToBase64(filelist));
    }

    public void upload(UploadEvent evt) {
        IDataModel model = this.getModel();
        this.getView().setVisible(Boolean.TRUE, new String[]{"urlsflex"});
        String cacheUrls = this.getPageCache().get(this.FILELIST);
        List<Map> filelist = kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        Object[] urls = evt.getUrls();
        logger.info("\u83b7\u5f97\u4e0a\u4f20\u6587\u4ef6urls\uff1a{}", (Object)Arrays.toString(urls));
        model.beginInit();
        for (int i = 0; i < urls.length; ++i) {
            if (urls[i] == null) continue;
            String urlStr = (String)((Map)urls[i]).get("url");
            String name = (String)((Map)urls[i]).get("name");
            if (!kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)urlStr)) continue;
            filelist.add((Map)urls[i]);
            int index = model.createNewEntryRow("upload_urls");
            model.setValue("name", (Object)name, index);
            model.setValue("url", (Object)urlStr, index);
        }
        model.endInit();
        this.getView().updateView("upload_urls");
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_OK});
        this.getPageCache().put(this.FILELIST, SerializationUtils.serializeToBase64(filelist));
    }

    public void afterUpload(UploadEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStream(String fileUrl) {
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inStream = null;
        try {
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>(queryParams.length);
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
            inStream = content.getInputStream();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return inStream;
    }

    private String getParam(String param) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return (String)customParams.get(param);
    }

    private static void confirmTips(String itemKey, String msg, String customValue, IFormView getView, IFormPlugin plugin) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(itemKey, plugin);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String ikonw = ResManager.loadKDString((String)"\u7ee7\u7eed\u5bfc\u5165", (String)"MultiImportDeclareReportPlugin_45", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ikonw);
        getView.showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, customValue);
    }

    public static boolean isIDCard18(CharSequence input) {
        Matcher matcher = Pattern.compile(REGEX_ID_CARD18).matcher(input);
        return matcher.matches();
    }

    static {
        declareService = new DeclareService();
    }
}

