/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare.importdeclare;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AttachmentMarkListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.upload.UploadOption;
import kd.taxc.bdtaxr.business.multidideclare.ExportService;
import kd.taxc.bdtaxr.business.multidideclare.UnifiedDeclareBizBusiness;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.DeclareReportImportFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportimport.service.DeclareReportImportService;
import kd.taxc.bdtaxr.common.enums.DeclareServiceEnum;
import kd.taxc.bdtaxr.common.enums.tpo.ModelVersionEnum;
import kd.taxc.bdtaxr.common.helper.tpo.MultiDeclareDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TemplateTypeMappingEnum;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.DeclareReportFactory;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.formplugin.taxdeclare.helper.DeclareReportImportHelper;
import kd.taxc.bdtaxr.formplugin.taxdeclare.helper.impl.MultiDeclareReportImportHelper;
import kd.taxc.bdtaxr.formplugin.taxdeclare.helper.impl.SingleDeclareReportImportHelper;

public class UnifiedImportDeclareReportPlugin
extends AbstractFormPlugin
implements UploadListener,
HyperLinkClickListener,
AttachmentMarkListener {
    private static Log logger = LogFactory.getLog(UnifiedImportDeclareReportPlugin.class);
    private static final String BTN_OK = "btnok";
    private static final String ENTRYENT_FINANCIAL_STATEMENTS = "entryent";
    private static final String COL_FINANCIAL_STATEMENTS = "textfield";
    private static final String COL_FINANCIAL_SRARTDATE_STATEMENTS = "startdate";
    private static final String COL_FINANCIAL_ENDDATE_STATEMENTS = "enddate";
    private static final String COL_FINANCIAL_ENDDATE_FILTERCONDITION = "filtercondition";
    private static final String FINANCIAL_TYPE_STATEMENTS = "selecttype";
    private static final String COL_DOWNLOAD = "download";
    private String TEMPLATEID = "templateid";
    private String FILELIST = "_file_list_";
    private static final String PARAM_TYPE = "source";
    private static DeclareReportImportService declareReportImportService;
    private long moduleId;
    private DeclareReportImportHelper declareReportImportHelper = null;

    public DeclareReportImportHelper getDeclareReportImportHelper(String type) {
        ModelVersionEnum version = UnifiedDeclareBizBusiness.getModelVersionByType(type);
        if (version != null) {
            if (ModelVersionEnum.MODEL3.getVersion().equals(version.getVersion()) && this.declareReportImportHelper instanceof MultiDeclareDataServiceHelper) {
                return this.declareReportImportHelper;
            }
            if (ModelVersionEnum.MODEL2.getVersion().equals(version.getVersion()) && this.declareReportImportHelper instanceof SingleDeclareReportImportHelper) {
                return this.declareReportImportHelper;
            }
            if (ModelVersionEnum.MODEL3.getVersion().equals(version.getVersion())) {
                this.declareReportImportHelper = new MultiDeclareReportImportHelper(this.getView(), (IFormPlugin)this);
            } else if (ModelVersionEnum.MODEL2.getVersion().equals(version.getVersion())) {
                this.declareReportImportHelper = new SingleDeclareReportImportHelper(this.getView(), (IFormPlugin)this);
            }
        } else {
            this.declareReportImportHelper = new MultiDeclareReportImportHelper(this.getView(), (IFormPlugin)this);
        }
        return this.declareReportImportHelper;
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, "btnupload", "btndownload", "btndel", "buttondownload", FINANCIAL_TYPE_STATEMENTS, "next", "back", "step1", "step2"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
        EntryGrid tempGrid = (EntryGrid)this.getView().getControl(ENTRYENT_FINANCIAL_STATEMENTS);
        tempGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (FINANCIAL_TYPE_STATEMENTS.equals(name)) {
            ChangeData[] changeSet = e.getChangeSet();
            String templateType = (String)changeSet[0].getNewValue();
            this.getModel().deleteEntryData(ENTRYENT_FINANCIAL_STATEMENTS);
            this.queryEntityData(templateType);
        }
    }

    public void afterCreateNewData(EventObject evt) {
        String paramtype = this.getParam(PARAM_TYPE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"urlsflex"});
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(FINANCIAL_TYPE_STATEMENTS);
        this.initPage();
        if (paramtype != null && "declare".equals(paramtype.trim())) {
            List<String> templatetypelist = (List<String>)this.getView().getFormShowParameter().getCustomParam("templatetypelist");
            if (EmptyCheckUtils.isEmpty((Object)templatetypelist)) {
                templatetypelist = UnifiedDeclareBizBusiness.getAllReportTemplateTypeList();
            }
            if (EmptyCheckUtils.isNotEmpty(templatetypelist)) {
                ArrayList data = new ArrayList();
                templatetypelist.forEach(type -> {
                    if (StringUtils.isNotEmpty((CharSequence)TemplateTypeMappingEnum.getDescByCode((String)type))) {
                        data.add(new ComboItem(new LocaleString(TemplateTypeMappingEnum.getDescByCode((String)type)), type));
                    }
                });
                comboEdit.setComboItems(data);
                String templateType = ((ComboItem)data.get(0)).getValue();
                this.getModel().setValue(FINANCIAL_TYPE_STATEMENTS, (Object)templateType);
                this.queryEntityData(templateType);
            }
        }
    }

    private String getParam(String param) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return (String)customParams.get(param);
    }

    private void queryEntityData(String templateType) {
        DynamicObjectCollection dcs = UnifiedDeclareBizBusiness.queryTemplateListByType(templateType);
        if (dcs == null || dcs.isEmpty()) {
            return;
        }
        logger.info(dcs.toString());
        this.getModel().beginInit();
        List collect = dcs.stream().filter(e -> e.getString("conditionjson") == null || !e.getString("conditionjson").contains("zerodeclare")).collect(Collectors.toList());
        for (DynamicObject d : collect) {
            int index = this.getModel().createNewEntryRow(ENTRYENT_FINANCIAL_STATEMENTS);
            this.getModel().setValue("id", (Object)d.getLong("id"), index);
            this.getModel().setValue("typeid", (Object)d.getString("typeid"), index);
            String name = d.getString(COL_FINANCIAL_STATEMENTS);
            this.getModel().setValue(COL_FINANCIAL_STATEMENTS, (Object)name, index);
            Date startDate = d.getDate(COL_FINANCIAL_SRARTDATE_STATEMENTS) != null ? d.getDate(COL_FINANCIAL_SRARTDATE_STATEMENTS) : null;
            Date endDate = d.getDate(COL_FINANCIAL_ENDDATE_STATEMENTS) != null ? d.getDate(COL_FINANCIAL_ENDDATE_STATEMENTS) : null;
            this.getModel().setValue(COL_FINANCIAL_SRARTDATE_STATEMENTS, (Object)startDate, index);
            this.getModel().setValue(COL_FINANCIAL_ENDDATE_STATEMENTS, (Object)endDate, index);
            this.getModel().setValue(COL_FINANCIAL_ENDDATE_FILTERCONDITION, (Object)d.getString(COL_FINANCIAL_ENDDATE_FILTERCONDITION), index);
            this.getModel().setValue(COL_DOWNLOAD, (Object)ResManager.loadKDString((String)"\u4e0b\u8f7d", (String)"UnifiedImportDeclareReportPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[]{index}));
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENT_FINANCIAL_STATEMENTS);
        declareReportImportService = DeclareReportImportFactory.createHandler(templateType);
        if (declareReportImportService != null && declareReportImportService.isSupportRefreshData()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"isrefresh"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isrefresh"});
        }
    }

    private void initPage() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"twostepflex", "back", BTN_OK});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"onestepflex", "btncancel", "next"});
        this.setStyle("step2", "step1", "label2", "label1");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENT_FINANCIAL_STATEMENTS);
        if (entity.size() == 1) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENT_FINANCIAL_STATEMENTS);
            entryGrid.selectRows(new int[]{0}, 0);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        Map businessMap = (Map)this.getView().getFormShowParameter().getCustomParam("businessMap");
        int index = hyperLinkClickEvent.getRowIndex();
        long id = (Long)this.getModel().getValue("id", index);
        String templateType = (String)this.getModel().getValue("typeid");
        ModelVersionEnum version = UnifiedDeclareBizBusiness.getModelVersionByType(templateType);
        if (version != null && ModelVersionEnum.MODEL3.getVersion().equals(version.getVersion())) {
            DeclareReportService declareReportService = DeclareReportFactory.createHandler((String)templateType);
            if (declareReportService != null) {
                this.moduleId = declareReportService.getModleId();
            }
            Map cellTypeFormulas = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CELLTYPE_FORMULAS, (Object[])new Object[]{id, null});
            Map fieldMap = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_ALL_FIELDS_TYPE_SHOW, (Object[])new Object[]{this.moduleId});
            try {
                String name = (String)this.getModel().getValue(COL_FINANCIAL_STATEMENTS, index);
                String urls = ExportService.getbuildExcelPath("IMPORT", id, fieldMap, cellTypeFormulas, name, businessMap);
                this.getView().openUrl(urls);
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
            }
        }
        try (InputStream in = TemplateShowUtils.getbuildExcel((String)"IMPORT", (Long)id);){
            String name = (String)this.getModel().getValue(COL_FINANCIAL_STATEMENTS, index);
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(name + ".xlsx", in, 5000);
            this.getView().openUrl(urls);
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnupload".equals(control.getKey())) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENT_FINANCIAL_STATEMENTS);
            int[] rows = entry.getSelectRows();
            if (rows.length != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u6a21\u677f\u7c7b\u578b\u3002", (String)"UnifiedImportDeclareReportPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            UploadOption opt = new UploadOption();
            opt.setMultiple(true);
            opt.setTitle(ResManager.loadKDString((String)"\u4e0a\u4f20\u6570\u636e\u6587\u4ef6", (String)"UnifiedImportDeclareReportPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            opt.setSuffix(".xlsx");
            opt.setLimitSize(0x1400000L);
            this.getView().showUpload(opt, "btnupload");
        } else if ("buttondownload".equals(control.getKey())) {
            Object field = this.getModel().getValue("templatetype");
            if (field == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5148\u9009\u62e9\u9700\u8981\u4e0b\u8f7d\u7684\u6a21\u677f\u7c7b\u578b", (String)"UnifiedImportDeclareReportPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        } else if ("btndel".equals(control.getKey())) {
            IDataModel model = this.getModel();
            int i = model.getEntryCurrentRowIndex("upload_urls");
            String cacheUrls = this.getPageCache().get(this.FILELIST);
            List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
            String url = (String)model.getValue("url", i);
            filelist.removeIf(f -> f.get("url").equals(url));
            this.getPageCache().put(this.FILELIST, SerializationUtils.serializeToBase64(filelist));
            model.deleteEntryRow("upload_urls", i);
            if (filelist.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"urlsflex"});
            }
        } else if (BTN_OK.equals(control.getKey())) {
            EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRYENT_FINANCIAL_STATEMENTS);
            int[] rows = entry.getSelectRows();
            if (rows.length != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u6a21\u677f\u7c7b\u578b\u3002", (String)"UnifiedImportDeclareReportPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            String file_list = this.getView().getPageCache().get(this.FILELIST);
            if (StringUtils.isEmpty((CharSequence)file_list)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0a\u4f20\u6587\u4ef6", (String)"UnifiedImportDeclareReportPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            List filelist = (List)SerializationUtils.deSerializeFromBase64((String)file_list);
            if (filelist.size() > 3 || filelist.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0d\u591a\u4e8e3\u4e2a\u6587\u4ef6\u4e0a\u4f20", (String)"UnifiedImportDeclareReportPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            String typeId = (String)this.getView().getModel().getValue("typeid", rows[0]);
            this.getDeclareReportImportHelper(typeId).doImport();
        } else if ("next".equals(control.getKey()) || "step2".equals(control.getKey())) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENT_FINANCIAL_STATEMENTS);
            int[] rows = entry.getSelectRows();
            if (rows.length != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u6a21\u677f\u7c7b\u578b\u3002", (String)"UnifiedImportDeclareReportPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            this.isClearTemplate(rows);
            Label templatename = (Label)this.getControl("templatename");
            templatename.setText(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u6a21\u677f\uff1a%s", (String)"UnifiedImportDeclareReportPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.getModel().getValue(COL_FINANCIAL_STATEMENTS, rows[0])));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"twostepflex", "back", BTN_OK});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"onestepflex", "btncancel", "next"});
            this.setStyle("step1", "step2", "label1", "label2");
        } else if ("back".equals(control.getKey()) || "step1".equals(control.getKey())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"twostepflex", "back", BTN_OK});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"onestepflex", "btncancel", "next"});
            this.setStyle("step2", "step1", "label2", "label1");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if ("sbboverridereport".equals(callBackId) || "draftoverride".equals(callBackId)) {
            if (MessageBoxResult.Yes == e.getResult()) {
                EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRYENT_FINANCIAL_STATEMENTS);
                int[] rows = entry.getSelectRows();
                String typeId = (String)this.getView().getModel().getValue("typeid", rows[0]);
                this.getDeclareReportImportHelper(typeId).doOverride(callBackId);
            }
        } else if ("justContinue".equals(callBackId)) {
            StringBuilder message = new StringBuilder();
            if (MessageBoxResult.Yes == e.getResult()) {
                String file_url = e.getCustomVaule();
                if (StringUtils.isBlank((CharSequence)file_url)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e", (String)"UnifiedImportDeclareReportPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
                EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRYENT_FINANCIAL_STATEMENTS);
                int[] rows = entry.getSelectRows();
                String typeId = (String)this.getView().getModel().getValue("typeid", rows[0]);
                this.getDeclareReportImportHelper(typeId).doContinue(file_url);
            }
        }
    }

    private void isClearTemplate(int[] rows) {
        Long id = (Long)this.getModel().getValue("id", rows[0]);
        String oldId = this.getPageCache().get(this.TEMPLATEID);
        this.getPageCache().put(this.TEMPLATEID, String.valueOf(id));
        if (oldId == null || Long.parseLong(oldId) == id) {
            return;
        }
        String cacheUrls = this.getPageCache().get(this.FILELIST);
        List filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        AttachmentPanel attachmentpanelap = (AttachmentPanel)this.getControl("attachmentpanelap");
        for (Map data : filelist) {
            attachmentpanelap.remove(data);
        }
    }

    private void setStyle(String step1, String step2, String lable1, String lable2) {
        HashMap<String, Object> colorMap1 = new HashMap<String, Object>();
        HashMap<String, Object> colorMap2 = new HashMap<String, Object>();
        String stepColor1 = "#CCCCCC";
        String linestyle1 = "1px_solid_#CCCCCC";
        colorMap1.put("followTheme", Boolean.FALSE);
        colorMap1.put("fc", stepColor1);
        HashMap style1 = new HashMap();
        HashMap<String, String> border1 = new HashMap<String, String>();
        border1.put("t", linestyle1);
        border1.put("l", linestyle1);
        border1.put("r", linestyle1);
        border1.put("b", linestyle1);
        style1.put("b", border1);
        colorMap1.put("s", style1);
        String stepColor2 = "themeColor";
        String linestyle2 = "1px_solid_themeColor";
        colorMap2.put("followTheme", Boolean.TRUE);
        colorMap2.put("fc", stepColor2);
        HashMap style2 = new HashMap();
        HashMap<String, String> border2 = new HashMap<String, String>();
        border2.put("t", linestyle2);
        border2.put("l", linestyle2);
        border2.put("r", linestyle2);
        border2.put("b", linestyle2);
        style2.put("b", border2);
        colorMap2.put("s", style2);
        this.getView().updateControlMetadata(step1, colorMap1);
        this.getView().updateControlMetadata(step2, colorMap2);
        String statusColor1 = "#CCCCCC";
        String statusColor2 = "themeColor";
        HashMap<String, String> labColorMap1 = new HashMap<String, String>();
        HashMap<String, String> labColorMap2 = new HashMap<String, String>();
        labColorMap1.put("fc", statusColor1);
        labColorMap2.put("fc", statusColor2);
        this.getView().updateControlMetadata(lable1, labColorMap1);
        this.getView().updateControlMetadata(lable2, labColorMap2);
    }

    public void remove(UploadEvent evt) {
        String cacheUrls = this.getPageCache().get(this.FILELIST);
        List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        for (Object url : evt.getUrls()) {
            filelist.removeIf(f -> f.get("uid").equals(((Map)url).get("uid")));
        }
        this.getPageCache().put(this.FILELIST, SerializationUtils.serializeToBase64(filelist));
    }

    public void upload(UploadEvent evt) {
        IDataModel model = this.getModel();
        this.getView().setVisible(Boolean.TRUE, new String[]{"urlsflex"});
        String cacheUrls = this.getPageCache().get(this.FILELIST);
        List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        Object[] urls = evt.getUrls();
        logger.info("\u83b7\u5f97\u4e0a\u4f20\u6587\u4ef6urls\uff1a{}", (Object)Arrays.toString(urls));
        model.beginInit();
        for (int i = 0; i < urls.length; ++i) {
            if (urls[i] == null) continue;
            String urlStr = (String)((Map)urls[i]).get("url");
            String name = (String)((Map)urls[i]).get("name");
            if (!StringUtils.isNotBlank((CharSequence)urlStr)) continue;
            filelist.add((Map)urls[i]);
            int index = model.createNewEntryRow("upload_urls");
            model.setValue("name", (Object)name, index);
            model.setValue("url", (Object)urlStr, index);
        }
        model.endInit();
        this.getView().updateView("upload_urls");
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_OK});
        this.getPageCache().put(this.FILELIST, SerializationUtils.serializeToBase64(filelist));
    }

    public void afterUpload(UploadEvent evt) {
    }
}

