/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare.querylist;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.CacheFactory;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.bdtaxr.business.service.taxdeclare.BaseDataService;
import kd.taxc.bdtaxr.business.service.taxdeclare.ChangeDataService;
import kd.taxc.bdtaxr.business.service.taxdeclare.DeclareExportTask;
import kd.taxc.bdtaxr.business.service.taxdeclare.TaxDeclareDataService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.BaseDataServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.ChangeDataServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxDeclareDataServiceImpl;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.service.DeclareReportHideService;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.declare.helper.DeclareCustomParamsHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclarePageOpenHelper;
import kd.taxc.bdtaxr.common.declare.helper.TemplateFormulaServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TaxTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.taxorg.TaxNameUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.CommonInfoUtil;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.JobUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.exception.ThrowableHelper;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.json.JsonUtil;

public class TaxDeclareQueryListPlugin
extends AbstractListPlugin {
    private static Log LOGGER = LogFactory.getLog(TaxDeclareQueryListPlugin.class);
    private static final String ORGID_KEY = "orgid";
    private static final String ORGNAME_KEY = "orgname";
    private static final String ITEM_KEY = "itemKey";
    private static final String BILL_LIST = "billlistap";
    private static final String DIRECT_DECLARE = "directdeclare";
    private static final String DIRECT_PAY = "fastpay";
    private static final String VIEWLOG_KEY = "viewlog";
    private static final String DEFER_PAY_KEY = "applydeferpay";
    private static final String APPLY = "apply";
    private static final String NEW = "new";
    private static final String VIEWHISTORYSBB = "viewhistorysbb";
    private static final String INVALID = "invalid";
    private static final String RECTIFY = "rectify";
    private static final String EXPORT = "export";
    private static final String IMPORT = "import";
    private static final String CANCELAPPLY = "cancelapply";
    private static final String PAY = "pay";
    private static final String CANCELPAY = "cancelpay";
    private static final String SUBMIT = "submit";
    private static final String UNSUBMIT = "unsubmit";
    private static final String AUDIT = "audit";
    private static final String UNAUDIT = "unaudit";
    private static final String VIEWFLOWCHART = "viewflowchart";
    private static final String VIEWLOG = "viewlog";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private DeclareReportHideService declareReportHideService;
    private static TaxDeclareDataService taxDeclareDataService = new TaxDeclareDataServiceImpl();
    private static ChangeDataService changeDataService = new ChangeDataServiceImpl();
    private static BaseDataService baseDataService = new BaseDataServiceImpl();

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void initialize() {
        BillList billlist = (BillList)this.getControl(BILL_LIST);
        this.getView().setVisible(Boolean.FALSE, new String[]{"enddate"});
        List<String> list = this.getTemplateTypeList();
        if (!CollectionUtils.isEmpty(list)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{DIRECT_DECLARE});
            this.getView().setVisible(Boolean.FALSE, new String[]{DIRECT_PAY});
            this.getView().setVisible(Boolean.FALSE, new String[]{"viewlog"});
            QFilter qFilter = new QFilter("type", "in", list);
            billlist.setFilter(qFilter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            protected void initContext(int start, int limit) {
                super.initContext(start, limit);
                IDataEntityProperty taxtypes = MetadataServiceHelper.getDataEntityType((String)this.getQueryBuilder().getEntityType().getName()).findProperty("taxtypes");
                if (taxtypes != null && taxtypes.getParent() != null && "entryentity".equals(taxtypes.getParent().getName())) {
                    this.getQueryBuilder().setOrderBys(StringUtil.isBlank((CharSequence)this.getQueryBuilder().getOrderBys()) ? "entryentity.taxtypes asc" : this.getQueryBuilder().getOrderBys() + ",entryentity.taxtypes asc");
                }
            }
        });
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        CommonFilterColumn typeColumn;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List filterColumnList = args.getCommonFilterColumns();
        List schemeColumnList = args.getSchemeFilterColumns();
        List<String> templates = this.getTemplateTypeList();
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(templates.size());
        for (String template : templates) {
            ComboItem item = new ComboItem();
            item.setValue(template);
            item.setCaption(new LocaleString((String)TemplateTypeConstant.getNsrtypemap().get(template)));
            combos.add(item);
        }
        for (FilterColumn column : filterColumnList) {
            String nolimit;
            if (!"type".equals(column.getFieldName())) continue;
            typeColumn = (CommonFilterColumn)column;
            String querytype = (String)customParams.get("querytype");
            if (!StringUtils.isEmpty((CharSequence)querytype)) {
                typeColumn.setDefaultValue(querytype);
            }
            if ("false".equals(nolimit = (String)customParams.get("nolimit"))) {
                typeColumn.setMustInput(true);
            }
            typeColumn.setComboItems(combos);
        }
        for (FilterColumn column : schemeColumnList) {
            if (!"type".equals(column.getFieldName())) continue;
            typeColumn = (SchemeFilterColumn)column;
            typeColumn.setComboItems(combos);
            break;
        }
        QFilter typeFilter = new QFilter("type", "in", templates);
        BillList billlist = (BillList)this.getControl(BILL_LIST);
        billlist.getFilterParameter().setFilter(typeFilter);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterMap = args.getSearchClickEvent().getFilterValues();
        List customList = (List)filterMap.get("customfilter");
        if (null != customList && customList.size() > 0) {
            for (Map map : customList) {
                List fileName = (List)map.get("FieldName");
                int index = fileName.indexOf("skssqq");
                if (index == -1) continue;
                List valueList = (List)map.get("Value");
                this.getPageCache().put("skssqq", SerializationUtils.toJsonString((Object)valueList));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        ArrayList<QFilter> resultFilter = new ArrayList<QFilter>();
        for (QFilter eQFilter : e.getQFilters()) {
            for (QFilter filter : eQFilter.recombine()) {
                if ("skssqq".equals(filter.getProperty())) {
                    if ("<".equals(filter.getCP())) {
                        resultFilter.add(new QFilter("skssqz", "<", filter.getValue()));
                        continue;
                    }
                    resultFilter.add(filter);
                    continue;
                }
                resultFilter.add(filter);
            }
        }
        e.getQFilters().clear();
        e.getQFilters().addAll(resultFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        BillList billlist = (BillList)this.getControl(BILL_LIST);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (args.getSource() instanceof Donothing && (SUBMIT.equals(operateKey = ((Donothing)args.getSource()).getOperateKey()) || UNSUBMIT.equals(operateKey) || AUDIT.equals(operateKey) || UNAUDIT.equals(operateKey) || PAY.equals(operateKey) || APPLY.equals(operateKey) || CANCELAPPLY.equals(operateKey) || CANCELPAY.equals(operateKey) || VIEWHISTORYSBB.equals(operateKey) || INVALID.equals(operateKey) || RECTIFY.equals(operateKey))) {
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (INVALID.equals(operateKey) || RECTIFY.equals(operateKey)) {
                String keyStr;
                Object source = args.getSource();
                String opreateType = "";
                try {
                    FormOperate operate = (FormOperate)source;
                    opreateType = operate.getOption().getVariableValue("type");
                }
                catch (Exception operate) {
                    // empty catch block
                }
                if ("msgInput".equals(opreateType)) {
                    return;
                }
                Set collect = list.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                String string = keyStr = INVALID.equals(operateKey) ? ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"TaxDeclareQueryListPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u66f4\u6b63", (String)"TaxDeclareQueryListPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                if (collect.size() != 1) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e%s\u7533\u62a5\u3002", (String)"TaxDeclareQueryListPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]), keyStr));
                    args.setCancel(true);
                    return;
                }
                String msg = DeclareUtils.checkGzZfInfo((String)operateKey, (Object)list.get(0).getPrimaryKeyValue());
                if (msg != null) {
                    this.getView().showErrorNotification(msg);
                    args.setCancel(true);
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u4e0d\u53ef\u64a4\u9500\uff0c\u5982\u786e\u8ba4\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5f55\u5165\u539f\u56e0\u8bf4\u660e\u3002", (String)"TaxDeclareQueryListPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
                args.setCancel(true);
                return;
            }
            if (VIEWHISTORYSBB.equals(operateKey)) {
                args.setCancel(true);
                Set collect = list.stream().map(a -> a.getPrimaryKeyValue()).collect(Collectors.toSet());
                if (collect.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u591a\u4efd\u5386\u53f2\u7248\u672c\uff0c\u8bf7\u4ec5\u52fe\u9009\u4e00\u6761\u7533\u62a5\u8868\u6570\u636e\u518d\u8fdb\u884c\u67e5\u770b\u3002", (String)"TaxDeclareQueryListPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                Object sbbid = list.get(0).getPrimaryKeyValue();
                if (!QueryServiceHelper.exists((String)"bdtaxr_history_sbb", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", sbbid)})) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u7533\u62a5\u8868\u65e0\u5386\u53f2\u7248\u672c\u3002", (String)"TaxDeclareQueryListPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> customParams = new HashMap<String, Object>(4);
                customParams.put("sbbid", sbbid);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"bdtaxr_history_sbb_view", (IFormView)this.getView(), customParams, (IFormPlugin)this);
            }
        }
        if (args.getSource() instanceof Delete || args.getSource() instanceof Donothing && (SUBMIT.equals(((Donothing)args.getSource()).getOperateKey()) || UNSUBMIT.equals(((Donothing)args.getSource()).getOperateKey()) || AUDIT.equals(((Donothing)args.getSource()).getOperateKey()) || UNAUDIT.equals(((Donothing)args.getSource()).getOperateKey()))) {
            Set strCollect = list.stream().map(a -> String.valueOf(a.getPrimaryKeyValue())).collect(Collectors.toSet());
            DynamicObjectCollection mutexCollection = QueryServiceHelper.query((String)"bos_datalock", (String)"objectid,user.name", (QFilter[])new QFilter[]{new QFilter("objectid", "in", strCollect)});
            if (mutexCollection == null) {
                return;
            }
            Map<Long, String> mutexMap = mutexCollection.stream().collect(Collectors.toMap(e -> Long.valueOf(e.getString("objectid")), e -> e.getString("user.name"), (k, v) -> k));
            DynamicObjectCollection nsrxxCollection = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", mutexMap.keySet())});
            ArrayList errList = new ArrayList();
            StringBuilder stringBuilder = new StringBuilder();
            nsrxxCollection.stream().forEach(e -> {
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u7f16\u8f91%2$s\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002\r\n", (String)"TaxDeclareQueryListPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]), mutexMap.get(e.getLong("id")), e.getString("billno"));
                errList.add(msg);
                stringBuilder.append(msg);
            });
            if (errList.size() > 0) {
                args.setCancel(true);
                if (errList.size() == 1) {
                    this.getView().showTipNotification((String)errList.get(0));
                } else {
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TaxDeclareQueryListPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    MessageBoxOptions options = MessageBoxOptions.OK;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"TaxDeclareQueryListPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]), stringBuilder.toString(), options, ConfirmTypes.Save, null, btnNameMaps);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        OperationResult opResult = evt.getOperationResult();
        String operateKey = evt.getOperateKey();
        String appId = this.getView().getFormShowParameter().getAppId();
        if (opResult == null) {
            return;
        }
        if (!opResult.isSuccess() && (SUBMIT.equals(operateKey) || UNSUBMIT.equals(operateKey) || AUDIT.equals(operateKey) || UNAUDIT.equals(operateKey) || PAY.equals(operateKey) || APPLY.equals(operateKey) || CANCELAPPLY.equals(operateKey) || CANCELPAY.equals(operateKey) || INVALID.equals(operateKey) || RECTIFY.equals(operateKey))) {
            if (opResult.getAllErrorInfo().size() > 0 || opResult.getAllErrorOrValidateInfo().size() > 0) {
                String msg = opResult.getMessage();
                String[] messages = msg.split(SEPARATOR);
                ArrayList<OperateErrorInfo> list = new ArrayList<OperateErrorInfo>(16);
                for (String m : messages) {
                    if (m.contains(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"TaxDeclareQueryListPlugin_43", (String)"taxc-bdtaxr", (Object[])new Object[0]))) continue;
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                    operateErrorInfo.setLevel(opResult.getAllErrorInfo().size() > 0 ? ((OperateErrorInfo)opResult.getAllErrorInfo().get(0)).getLevel() : ErrorLevel.FatalError);
                    operateErrorInfo.setMessage(m);
                    list.add(operateErrorInfo);
                }
                opResult.setAllErrorInfo(list);
                return;
            }
            String msg = opResult.getMessage();
            if (msg != null) {
                if (msg.contains("fzybhz:")) {
                    msg = msg.substring(msg.indexOf("fzybhz:"));
                    this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(APPLY, (IFormPlugin)this));
                    return;
                }
                String[] messages = msg.split(SEPARATOR);
                if (messages.length == 1) {
                    this.getView().showErrorNotification(msg);
                } else {
                    this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                    OperationResult operationResult = new OperationResult();
                    operationResult.setSuccess(false);
                    operationResult.setMessage(msg);
                    this.getView().showOperationResult(operationResult);
                }
                return;
            }
        }
        String querytype = Optional.ofNullable(this.getView().getFormShowParameter().getCustomParams()).map(s -> (String)s.get("querytype")).orElseGet(() -> {
            List<String> templateTypeList = this.getTemplateTypeList();
            if ("newfss".equals(evt.getOperateKey())) {
                return templateTypeList.get(1);
            }
            return templateTypeList.get(0);
        });
        if (NEW.equals(operateKey) || "newfss".equals(evt.getOperateKey())) {
            HashMap<String, Object> custom = new HashMap<String, Object>(16);
            custom.put("type", querytype);
            this.showDeclarePage(querytype, custom, null, null);
        } else if (EXPORT.equals(operateKey)) {
            boolean zerodeclare;
            String orgName;
            BillList billlist = (BillList)this.getControl(BILL_LIST);
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
            if (collect.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5bfc\u51fa\u591a\u4efd\u7533\u62a5\u8868\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u7533\u62a5\u8bb0\u5f55\u518d\u64cd\u4f5c\u5bfc\u51fa\u3002", (String)"TaxDeclareQueryListPlugin_11", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            String pk = list.get(0).getPrimaryKeyValue().toString();
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"tcvat_nsrxx");
            DynamicObject org = obj.getDynamicObject("org");
            Long l = org.getLong("id");
            String type = obj.getString("type");
            String billno = obj.getString("billno");
            String string = orgName = org != null ? org.getString("name") : "";
            if (!"qtsf_tysbb".equals(type) && !"qtsf_fsstysbb".equals(type) && (zerodeclare = obj.getBoolean("zerodeclare"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u7533\u62a5\u8868\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u8868\uff0c\u4e0d\u652f\u6301\u5f15\u51fa\u3002", (String)"TaxDeclareQueryListPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter("type", "=", (Object)type);
            boolean isNewTemplate = QueryServiceHelper.exists((String)"bdtaxr_template_main", (QFilter[])new QFilter[]{qFilter});
            String fileName = TemplateTypeConstant.getNsrtypemap().getOrDefault(type, type) + "_" + orgName;
            Date date = (Date)obj.get("skssqq");
            Date endDate = (Date)obj.get("skssqz");
            DynamicObject template = null;
            String templateid = obj.getString("templateid");
            if (StringUtils.isNotEmpty((CharSequence)templateid)) {
                DynamicObject dynamicObject = template = isNewTemplate ? TemplateUtils.getTemplateObjectById((String)type, (String)templateid) : TemplateUtilsOld.getTemplateObjectById((String)type, (String)templateid);
            }
            if (template == null && org != null) {
                DynamicObject dynamicObject = template = isNewTemplate ? TemplateUtils.getTemplateObjectByConfig((String)type, (String)org.getString("id"), (Date)date, (Date)date) : TemplateUtilsOld.getTemplateObjectByConfig((String)type, (String)org.getString("id"), (Date)date, (Date)date);
            }
            if (template == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728\u3002", (String)"TaxDeclareQueryListPlugin_13", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isEmpty((CharSequence)templateid)) {
                templateid = template.getString("id");
            }
            fileName = fileName + DateUtils.format((Date)date, (String)"yyyy-MM");
            String operateName = ResManager.loadKDString((String)"\u5f15\u51fa", (String)"TaxDeclareQueryListPlugin_14", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u7533\u62a5\u8868,\u5f15\u51fa\u6210\u529f\u3002", (String)"TaxDeclareQueryListPlugin_15", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno);
            String taxName = TaxNameUtil.getTaxName((String)appId);
            OperatorDialogUtils.operateDialog((String)taxName, (String)((String)this.getView().getFormShowParameter().getCustomParams().get("billFormId")), (String)operateName, (String)operateDescription);
            Long reportId = obj.getLong("id");
            DeclareRequestModel requestModel = new DeclareRequestModel();
            requestModel.setId(reportId);
            requestModel.setOrgId(l);
            requestModel.setTemplateId(Long.valueOf(templateid));
            requestModel.setTemplateType(type);
            requestModel.setTemplateNumber(template.getString("number"));
            requestModel.setSkssqq(DateUtils.format((Date)date));
            requestModel.setSkssqz(DateUtils.format((Date)endDate));
            Map metaMap = TemplateFormulaServiceHelper.getMetaDataListByTmpId((Long)Long.valueOf(templateid));
            requestModel.setMetaDataMap(metaMap);
            Object valMap = null;
            Object typeMap = null;
            Object cellTypeFormulas = null;
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("requestModel", JsonUtil.toJson((Object)requestModel));
            params.put("fileName", fileName);
            params.put("isNewTemplate", isNewTemplate);
            String taskName = ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u4efb\u52a1", (String)"TaxDeclareQueryListPlugin_42", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            kd.taxc.bdtaxr.common.utils.job.JobUtils.dispatch((IFormView)this.getView(), params, (String)taskName, (String)DeclareExportTask.class.getName(), (String)EXPORT, (String)this.getPluginName(), null);
        } else if (APPLY.equals(operateKey)) {
            BillList billlist = (BillList)this.getControl(BILL_LIST);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaxDeclareQueryListPlugin_16", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            billlist.refresh();
        } else if (CANCELAPPLY.equals(operateKey) || INVALID.equals(operateKey)) {
            BillList billlist = (BillList)this.getControl(BILL_LIST);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaxDeclareQueryListPlugin_16", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            billlist.refresh();
        } else if (RECTIFY.equals(operateKey)) {
            BillList billlist = (BillList)this.getControl(BILL_LIST);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u201c\u672a\u7f34\u6b3e\u201d\u4e14\u201c\u672a\u751f\u6210\u51ed\u8bc1\u201d\u7684\u7a0e\u91d1\u7f34\u7eb3\u5355\u4e5f\u5df2\u540c\u6b65\u5220\u9664\u3002", (String)"TaxDeclareQueryListPlugin_41", (String)"taxc-bdtaxr", (Object[])new Object[0]), Integer.valueOf(5000));
            billlist.refresh();
        } else if (PAY.equals(operateKey)) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bdtaxr_paydate_confirm");
            param.getOpenStyle().setShowType(ShowType.NonModal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payDateConfirm");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
        } else if (CANCELPAY.equals(operateKey)) {
            BillList billlist = (BillList)this.getControl(BILL_LIST);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaxDeclareQueryListPlugin_16", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            billlist.refresh();
        } else if (IMPORT.equals(operateKey)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("bdtaxr_import_dialog_new");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORT));
            parameter.setCustomParam("source", (Object)"declare");
            parameter.setCustomParam("templatetypelist", this.getTemplateTypeList());
            String operateName = ResManager.loadKDString((String)"\u5f15\u5165", (String)"TaxDeclareQueryListPlugin_17", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            String operateDescription = String.format(ResManager.loadKDString((String)"\u6253\u5f00\u5f15\u5165\u7533\u62a5\u8868\u6570\u636e\u5f39\u7a97\u6210\u529f\u3002", (String)"TaxDeclareQueryListPlugin_18", (String)"taxc-bdtaxr", (Object[])new Object[0]), new Object[0]);
            String taxName = TaxNameUtil.getTaxName((String)appId);
            OperatorDialogUtils.operateDialog((String)taxName, (String)((String)this.getView().getFormShowParameter().getCustomParams().get("billFormId")), (String)operateName, (String)operateDescription);
            this.getView().showForm(parameter);
        } else if (SUBMIT.equals(operateKey) || UNSUBMIT.equals(operateKey) || AUDIT.equals(operateKey) || UNAUDIT.equals(operateKey)) {
            BillList billlist = (BillList)this.getControl(BILL_LIST);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaxDeclareQueryListPlugin_16", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            billlist.refresh();
        } else if (VIEWFLOWCHART.equals(operateKey)) {
            BillList billlist = (BillList)this.getControl(BILL_LIST);
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u67e5\u770b\u7684\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_19", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
            if (collect.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u591a\u4e2a\u6d41\u7a0b\u8bb0\u5f55\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u7533\u62a5\u8bb0\u5f55\u518d\u64cd\u4f5c\u3002", (String)"TaxDeclareQueryListPlugin_20", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.MainNewTabPage);
            try {
                WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)list.get(0).getPrimaryKeyValue(), (OpenStyle)openStyle);
            }
            catch (Exception e2) {
                LOGGER.error(ThrowableHelper.toString((Exception)e2));
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"TaxDeclareQueryListPlugin_21", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        } else if ("viewlog".equals(operateKey)) {
            BillList billlist = (BillList)this.getControl(BILL_LIST);
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u67e5\u770b\u7684\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_19", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
            if (collect.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u67e5\u770b\u65e5\u5fd7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxDeclareQueryListPlugin_22", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            Object pkId = list.get(0).getPrimaryKeyValue();
            DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"tcvat_nsrxx");
            if (declare != null) {
                HashMap<String, Object> customerParams = new HashMap<String, Object>();
                String string = declare.getDynamicObject("org").getString("id");
                String type = declare.getString("type");
                ArrayList<String> skssq = new ArrayList<String>();
                skssq.add(DateUtils.format((Date)declare.getDate("skssqq"), (String)"yyyy-MM-dd"));
                skssq.add(DateUtils.format((Date)declare.getDate("skssqz"), (String)"yyyy-MM-dd"));
                customerParams.put("org", string);
                customerParams.put("types", type);
                customerParams.put("skssqq", skssq);
                OpenStyle openStyle = new OpenStyle();
                openStyle.setShowType(ShowType.MainNewTabPage);
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"tsate_declare_record", (boolean)false, (int)0, (boolean)false);
                showParameter.setOpenStyle(openStyle);
                showParameter.setCustomParams(customerParams);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        } else if (DIRECT_DECLARE.equals(operateKey)) {
            BillList billlist = (BillList)this.getControl(BILL_LIST);
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            JSONArray jsonArray = new JSONArray();
            Object[] declarePkIds = list.stream().map(ListSelectedRow::getPrimaryKeyValue).map(Object::toString).toArray();
            DynamicObject[] declareData = BusinessDataServiceHelper.load((Object[])declarePkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvat_nsrxx"));
            StringBuilder message = new StringBuilder();
            for (DynamicObject declare : declareData) {
                DynamicObject org = declare.getDynamicObject("org");
                String type = declare.getString("type");
                String typeName = (String)TemplateTypeConstant.getNsrtypemap().get(type);
                String skssqq = DateUtils.format((Date)declare.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE);
                String skssqz = DateUtils.format((Date)declare.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE);
                String billStatus = declare.getString("billstatus");
                if (!"C".equals(billStatus)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u63d0\u4ea4\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_23", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    continue;
                }
                if (!"editing".equals(declare.getString("declarestatus")) && !"declarefailed".equals(declare.getString("declarestatus"))) {
                    message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u672a\u7533\u62a5\u6216\u7533\u62a5\u5931\u8d25\u72b6\u6001\u53ef\u53d1\u9001\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_24", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    continue;
                }
                if (!"zzsybnsr".equals(type)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u6682\u53ea\u652f\u6301\u589e\u503c\u7a0e\u4e00\u822c\u7eb3\u7a0e\u4eba\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_25", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    continue;
                }
                JSONObject customMap = new JSONObject();
                customMap.put("sbbid", (Object)declare.getString("id"));
                customMap.put("type", (Object)declare.getString("type"));
                customMap.put("nsrsbh", (Object)declare.getString("nsrsbh"));
                customMap.put(ORGID_KEY, (Object)org.getString("id"));
                Date skssqqDate = declare.getDate("skssqq");
                customMap.put("skssqq", (Object)DateUtils.format((Date)skssqqDate, (String)"yyyy-MM-dd"));
                Date skssqzDate = declare.getDate("skssqz");
                customMap.put("skssqz", (Object)DateUtils.format((Date)skssqzDate, (String)"yyyy-MM-dd"));
                customMap.put("address", (Object)declare.getString("scjydz"));
                customMap.put(ITEM_KEY, (Object)DIRECT_DECLARE);
                jsonArray.add((Object)customMap);
            }
            if (!jsonArray.isEmpty()) {
                this.directDeclareConfirmTips(jsonArray, operateKey, ResManager.loadKDString((String)"\u53d1\u9001\u7533\u62a5\u540e\u65e0\u6cd5\u64a4\u9500\uff0c\u786e\u5b9a\u7533\u62a5\u5417\uff1f", (String)"TaxDeclareQueryListPlugin_26", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                String[] stringArray = message.toString().split(System.getProperty("line.separator"));
                if (stringArray.length == 1) {
                    this.getView().showErrorNotification(message.toString());
                } else {
                    this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                    OperationResult operationResult = new OperationResult();
                    operationResult.setSuccess(false);
                    operationResult.setMessage(message.toString());
                    this.getView().showOperationResult(operationResult);
                }
            }
        } else if (DIRECT_PAY.equals(operateKey)) {
            BillList billlist = (BillList)this.getControl(BILL_LIST);
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            JSONArray jsonArray = new JSONArray();
            Object[] declarePkIds = list.stream().map(ListSelectedRow::getPrimaryKeyValue).map(Object::toString).toArray();
            DynamicObject[] declareData = BusinessDataServiceHelper.load((Object[])declarePkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvat_nsrxx"));
            StringBuilder message = new StringBuilder();
            for (DynamicObject declare : declareData) {
                DynamicObject org = declare.getDynamicObject("org");
                String type = declare.getString("type");
                String typeName = (String)TemplateTypeConstant.getNsrtypemap().get(type);
                String skssqq = DateUtils.format((Date)declare.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE);
                String skssqz = DateUtils.format((Date)declare.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE);
                String billStatus = declare.getString("billstatus");
                if (!"C".equals(billStatus)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u63d0\u4ea4\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_27", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    continue;
                }
                if (!"declared".equals(declare.getString("declarestatus"))) {
                    message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u7533\u62a5\u6210\u529f\u53ef\u53d1\u9001\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_28", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    continue;
                }
                if (!"unpaid".equals(declare.getString("paystatus")) && !"payfailed".equals(declare.getString("paystatus"))) {
                    message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u672a\u7f34\u6b3e\u6216\u7f34\u6b3e\u5931\u8d25\u53ef\u53d1\u9001\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_29", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    continue;
                }
                if (!"zzsybnsr".equals(type)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u6682\u53ea\u652f\u6301\u589e\u503c\u7a0e\u4e00\u822c\u7eb3\u7a0e\u4eba\u7533\u62a5,%1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_30", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    continue;
                }
                JSONObject customMap = new JSONObject();
                customMap.put("sbbid", (Object)declare.getString("id"));
                customMap.put("type", (Object)declare.getString("type"));
                customMap.put("nsrsbh", (Object)declare.getString("nsrsbh"));
                customMap.put(ORGID_KEY, (Object)org.getString("id"));
                Date skssqqDate = declare.getDate("skssqq");
                customMap.put("skssqq", (Object)DateUtils.format((Date)skssqqDate, (String)"yyyy-MM-dd"));
                Date skssqzDate = declare.getDate("skssqz");
                customMap.put("skssqz", (Object)DateUtils.format((Date)skssqzDate, (String)"yyyy-MM-dd"));
                customMap.put("address", (Object)declare.getString("scjydz"));
                customMap.put(ITEM_KEY, (Object)DIRECT_PAY);
                jsonArray.add((Object)customMap);
            }
            if (!jsonArray.isEmpty()) {
                this.directDeclareConfirmTips(jsonArray, operateKey, ResManager.loadKDString((String)"\u53d1\u9001\u7f34\u6b3e\u540e\u65e0\u6cd5\u64a4\u9500\uff0c\u786e\u5b9a\u7f34\u6b3e\u5417\uff1f", (String)"TaxDeclareQueryListPlugin_31", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                String[] stringArray = message.toString().split(System.getProperty("line.separator"));
                if (stringArray.length == 1) {
                    this.getView().showErrorNotification(message.toString());
                } else {
                    this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                    OperationResult operationResult = new OperationResult();
                    operationResult.setSuccess(false);
                    operationResult.setMessage(message.toString());
                    this.getView().showOperationResult(operationResult);
                }
            }
        } else if (DEFER_PAY_KEY.equals(operateKey)) {
            OperationResult operationResult1 = evt.getOperationResult();
            if (operationResult1 != null && (!operationResult1.isSuccess() || operationResult1.getSuccessPkIds().isEmpty())) {
                operationResult1.setSuccessPkIds(Collections.emptyList());
                return;
            }
            BillList billlist = (BillList)this.getControl(BILL_LIST);
            ListSelectedRowCollection list = billlist.getSelectedRows();
            FormShowParameter parameter = new FormShowParameter();
            if (list != null && !list.isEmpty()) {
                void var12_70;
                List pkIds = Arrays.stream(list.getPrimaryKeyValues()).distinct().collect(Collectors.toList());
                if ("tcvat".equals(appId)) {
                    DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)"id as sbbid,billno,org,org.name as orgname,skssqq,skssqz,type,declarestatus,paystatus,entryentity.id,entryentity.deferpayapply1", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
                } else {
                    DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)"id as sbbid,billno,org,org.name as orgname,skssqq,skssqz,type,declarestatus,paystatus,deferpayapply", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
                }
                String uniqueKey = null;
                JSONArray jsonArray = new JSONArray();
                StringBuilder message = new StringBuilder();
                StringBuilder fzybhzMessage = new StringBuilder();
                List<Object> sbbid = new ArrayList();
                for (void declare : var12_70) {
                    String orgId = declare.getDynamicObject("org").getString("id");
                    String skssqq = declare.getString("skssqq");
                    String skssqz = declare.getString("skssqz");
                    String payStatus = declare.getString("paystatus");
                    String type = declare.getString("type");
                    String orgname = declare.getDynamicObject("org").getString("name");
                    String typeName = (String)TemplateTypeConstant.getNsrtypemap().get(type);
                    if (declare.getDynamicObjectType().getProperties().containsKey((Object)"entryentity")) {
                        sbbid.addAll(declare.getDynamicObjectCollection("entryentity").stream().map(e -> e.getLong("id")).collect(Collectors.toList()));
                    }
                    OrgUtils.getfzybqyMessage((String)type, (String)orgId, (String)DateUtils.format((Date)declare.getDate("skssqq")), (String)DateUtils.format((Date)declare.getDate("skssqz")), (StringBuilder)fzybhzMessage);
                    if (!"declared".equals(declare.getString("declarestatus"))) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u7533\u62a5\u6210\u529f\u7684\u6570\u636e\u53ef\u7533\u8bf7\u7f13\u7f34: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_32", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgname, skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    if (!"unpaid".equals(payStatus) && !StringUtils.isBlank((CharSequence)declare.getString("paystatus"))) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u672a\u7f34\u6b3e\u7684\u6570\u636e\u53ef\u7533\u8bf7\u7f13\u7f34: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxDeclareQueryListPlugin_33", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgname, skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    if (uniqueKey == null) {
                        uniqueKey = orgId + skssqq + skssqz;
                    } else if (!uniqueKey.equals(orgId + skssqq + skssqz)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3001\u6240\u5c5e\u7a0e\u671f\u76f8\u540c\u7684\u7533\u62a5\u8bb0\u5f55\u3002", (String)"TaxDeclareQueryListPlugin_34", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                        return;
                    }
                    String billno = declare.getString("billno");
                    String nsrtype = declare.getString("type");
                    if (StringUtils.trimToEmpty((String)nsrtype).startsWith("zzs")) {
                        OperatorDialogUtils.operateDialog((String)"zzs", (String)TemplateEnum.getEnumByDeclareType((String)nsrtype).getDeclarePage(), (String)ResManager.loadKDString((String)"\u7533\u8bf7\u7f13\u7f34", (String)"TaxDeclareQueryListPlugin_35", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7f34\u6b3e\u8868\u7533\u8bf7\u7f13\u7f34", (String)"TaxDeclareQueryListPlugin_36", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno));
                        continue;
                    }
                    if (!StringUtils.trimToEmpty((String)nsrtype).startsWith("qysds")) continue;
                    OperatorDialogUtils.operateDialog((String)"qysds", (String)TemplateEnum.getEnumByDeclareType((String)nsrtype).getDeclarePage(), (String)ResManager.loadKDString((String)"\u7533\u8bf7\u7f13\u7f34", (String)"TaxDeclareQueryListPlugin_35", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7f34\u6b3e\u8868\u7533\u8bf7\u7f13\u7f34", (String)"TaxDeclareQueryListPlugin_36", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno));
                }
                if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                    String[] messages = message.toString().split(System.getProperty("line.separator"));
                    if (messages.length == 1) {
                        this.getView().showErrorNotification(message.toString());
                    } else {
                        this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                        OperationResult operationResult = new OperationResult();
                        operationResult.setSuccess(false);
                        operationResult.setMessage(message.toString());
                        this.getView().showOperationResult(operationResult);
                    }
                    return;
                }
                if ("tcvat".equals(appId)) {
                    parameter.setCustomParam("sbbEntryIds", sbbid);
                } else {
                    sbbid = Arrays.stream(var12_70).map(e -> e.getLong("id")).collect(Collectors.toList());
                    parameter.setCustomParam("sbbIds", sbbid);
                }
                if (StringUtils.isNotBlank((CharSequence)fzybhzMessage.toString())) {
                    JSONObject customMap = new JSONObject();
                    customMap.put("sbbIds", sbbid);
                    jsonArray.add((Object)customMap);
                    this.directDeclareConfirmTips(jsonArray, operateKey, fzybhzMessage.toString());
                    return;
                }
            }
            parameter.setFormId("bdtaxr_deferpay_dialog");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, DEFER_PAY_KEY);
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        if (currentSelectedRowInfo == null) {
            return;
        }
        if ("taxrefundstatus".equals(args.getFieldName())) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tcvat_zzs_declare_list");
            if ("ysq".equals(object.getString("taxrefundstatus")) || "zyts".equals(object.getString("taxrefundstatus")) || "yts".equals(object.getString("taxrefundstatus"))) {
                paramMap.put(ORGID_KEY, object.getDynamicObject("org").getString("id"));
                paramMap.put("skssqq", object.getString("skssqq"));
                paramMap.put("skssqz", object.getString("skssqz"));
                PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)"tcvat_tax_refund_apply", (IFormView)this.getView(), paramMap);
            } else {
                paramMap.put("sbbid", currentSelectedRowInfo.getPrimaryKeyValue().toString());
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_taxrefund_result_de", (IFormView)this.getView(), paramMap, (IFormPlugin)this);
            }
            return;
        }
        if ("riskcontent".equals(args.getFieldName())) {
            DeclareUtils.showRiskDialog((String)currentSelectedRowInfo.getPrimaryKeyValue().toString(), (IFormView)this.getView());
        } else {
            DeclarePageOpenHelper.linkDeclarePageByPkId((IFormView)this.getView(), (Object)currentSelectedRowInfo.getPrimaryKeyValue());
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String type = data.getString("type");
        if ("type".equals(columnDesc.getKey())) {
            e.setFormatValue((Object)TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""));
        } else if ("skssqq".equals(columnDesc.getKey())) {
            String date = DateUtils.getStartToEndDate((Date)data.getDate("skssqq"), (Date)data.getDate("skssqz"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)date);
        } else if ("startdate".equals(columnDesc.getKey())) {
            try {
                String date = DateUtils.getStartToEndDate((Date)data.getDate("entryentity.startdate"), (Date)data.getDate("entryentity.enddate"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
                e.setFormatValue((Object)date);
            }
            catch (Exception exception) {}
        } else if ("riskcontent".equals(columnDesc.getKey()) && "normal".equals(e.getFormatValue())) {
            e.getNoLinkKey().add("riskcontent");
        }
        if ("taxrefundstatus".equals(columnDesc.getKey()) && ("--".equals(e.getFormatValue()) || "wsq".equals(e.getFormatValue()))) {
            e.getNoLinkKey().add("taxrefundstatus");
        }
    }

    private List<String> getTemplateTypeList() {
        String taxtype = (String)this.getView().getFormShowParameter().getCustomParam("taxtype");
        String querytype = (String)this.getView().getFormShowParameter().getCustomParam("querytype");
        if (EmptyCheckUtils.isNotEmpty((Object)taxtype)) {
            return Arrays.stream(taxtype.split(",")).map(String::trim).collect(Collectors.toList());
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        if (EmptyCheckUtils.isEmpty((Object)appId)) {
            LOGGER.info("taxDeclareQueryParams --- appid: {}", (Object)appId);
            appId = (String)this.getView().getFormShowParameter().getCustomParam("appid");
        } else if ("qysdsjb".equals(querytype)) {
            appId = "tccit_yj";
        } else if ("qysdsnb".equals(querytype)) {
            appId = "tccit_hj";
        } else if ("lat".equals(querytype)) {
            appId = "tcret_lat";
        }
        LOGGER.info("taxDeclareQueryParams --- taxtype: {}, appid: {}", (Object)taxtype, (Object)appId);
        TaxTypeEnum taxTypeEnum = TaxTypeEnum.valueOfAppId((String)appId);
        if (taxTypeEnum != null) {
            return Stream.of(taxTypeEnum.getTemplates()).collect(Collectors.toList());
        }
        return new ArrayList<String>(TemplateTypeConstant.getNsrtypemap().keySet());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        TaskInfo taskInfo;
        Map result;
        String taskInfoStr;
        Object returnData;
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals(IMPORT) || DEFER_PAY_KEY.equals(actionId)) {
            Object returnData2;
            BillList billList = (BillList)this.getView().getControl(BILL_LIST);
            billList.refresh();
            if (DEFER_PAY_KEY.equals(actionId) && (returnData2 = closedCallBackEvent.getReturnData()) != null) {
                this.getView().showSuccessNotification((String)returnData2);
            }
        } else if (actionId.equals("payDateConfirm")) {
            Date payDate = (Date)closedCallBackEvent.getReturnData();
            if (payDate == null) {
                return;
            }
            BillList billList = (BillList)this.getView().getControl(BILL_LIST);
            ListSelectedRowCollection list = billList.getSelectedRows();
            Object[] pkIds = list.getPrimaryKeyValues();
            DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)(DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING + ",entryentity.deferpayapply1"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
            this.pay(billList, declares, payDate);
        } else if (EXPORT.equals(actionId) && EmptyCheckUtils.isNotEmpty((Object)closedCallBackEvent.getReturnData()) && (returnData = closedCallBackEvent.getReturnData()) instanceof Map && StringUtil.isNotBlank((CharSequence)(taskInfoStr = (String)(result = (Map)returnData).get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            Map customs = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            String templateHtml = (String)customs.get("templateHtml");
            String fileName = (String)customs.get("fileName");
            if (templateHtml != null && !"".equals(templateHtml)) {
                try {
                    FileService fileService = FileServiceFactory.getAttachmentFileService();
                    InputStream in = fileService.getInputStream(templateHtml);
                    String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", in, 5000);
                    String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
                    String entityNum = ((IListView)this.getView()).getBillFormId();
                    PermissionUtils.putTempFilePermissionCache((String)urls, (String)serviceAppId, (String)entityNum, (String)"4730fc9f000004ae");
                    this.getView().openUrl(urls);
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
                }
            }
        }
    }

    private void pay(BillList billlist, DynamicObject[] declares, Date payDate) {
        if (declares != null && declares.length > 0) {
            ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(declares.length);
            String appId = this.getView().getFormShowParameter().getAppId();
            for (DynamicObject declare : declares) {
                declare.set("paystatus", (Object)"paid");
                declare.set("modifytime", (Object)new Date());
                declare.set("modifier", (Object)RequestContext.get().getUserId());
                declare.set("paytype", (Object)"0");
                declare.set("paydate", (Object)payDate);
                declare.set("payer", (Object)RequestContext.get().getUserId());
                modifyDynamicObjects.add(declare);
            }
            if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[0]));
                List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"manualPay", (Object[])new Object[]{sbbIds});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaxDeclareQueryListPlugin_16", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                billlist.refresh();
                this.calcElement(modifyDynamicObjects, PAY);
                if (EmptyCheckUtils.isNotEmpty(modifyDynamicObjects)) {
                    DynamicObject[] saveObjects = modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]);
                    DeclareMainServiceHelper.fireModel2DeclareMainChangeEvent((DynamicObject[])saveObjects, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)PAY));
                }
            }
        }
    }

    private void directDeclareConfirmTips(JSONArray jSONArray, String key, String msg) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(key, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TaxDeclareQueryListPlugin_37", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TaxDeclareQueryListPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, JSONArray.toJSONString((Object)jSONArray));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        JSONArray customMaps;
        String customVaule;
        BillList billlist;
        ListSelectedRowCollection list;
        Object[] pkIds;
        DynamicObject[] declares;
        String appId = this.getView().getFormShowParameter().getAppId();
        if (PAY.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bdtaxr_paydate_confirm");
            param.getOpenStyle().setShowType(ShowType.NonModal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payDateConfirm");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
        }
        if (APPLY.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes && (declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)(pkIds = (list = (billlist = (BillList)this.getControl(BILL_LIST)).getSelectedRows()).getPrimaryKeyValues()))})) != null && declares.length > 0) {
            ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(declares.length);
            for (DynamicObject declare : declares) {
                BigDecimal bqybtse = declare.getBigDecimal("bqybtse");
                this.setPayStatus(bqybtse, declare, appId);
                declare.set("declarestatus", (Object)"declared");
                declare.set("modifytime", (Object)new Date());
                declare.set("modifier", (Object)RequestContext.get().getUserId());
                declare.set("declaretype", (Object)"0");
                declare.set("sbrq", (Object)new Date());
                declare.set("declarer", (Object)RequestContext.get().getUserId());
                modifyDynamicObjects.add(declare);
            }
            if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                List sbbIds = modifyDynamicObjects.stream().filter(d -> !"nopay".equals(d.getString("paystatus"))).map(d -> d.getLong("id")).collect(Collectors.toList());
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"manualDeclare", (Object[])new Object[]{sbbIds});
                SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaxDeclareQueryListPlugin_16", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                billlist.refresh();
            }
        }
        if (DEFER_PAY_KEY.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            customVaule = event.getCustomVaule();
            JSONArray.parseArray((String)customVaule);
            customMaps = JSONArray.parseArray((String)customVaule);
            JSONObject customMap = (JSONObject)customMaps.get(0);
            List sbbid = (List)customMap.get((Object)"sbbIds");
            FormShowParameter parameter = new FormShowParameter();
            if ("tcvat".equals(appId)) {
                parameter.setCustomParam("sbbEntryIds", (Object)sbbid);
            } else {
                parameter.setCustomParam("sbbIds", (Object)sbbid);
            }
            parameter.setFormId("bdtaxr_deferpay_dialog");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, DEFER_PAY_KEY);
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        }
        if ((DIRECT_DECLARE.equals(event.getCallBackId()) || DIRECT_PAY.equals(event.getCallBackId())) && event.getResult() == MessageBoxResult.Yes) {
            customVaule = event.getCustomVaule();
            JSONArray.parseArray((String)customVaule);
            customMaps = JSONArray.parseArray((String)customVaule);
            for (Object obj : customMaps) {
                JSONObject customMap = (JSONObject)obj;
                String sbbid = customMap.getString("sbbid");
                String type = customMap.getString("type");
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("messageId", UUID.randomUUID().toString().replaceAll("-", ""));
                paramMap.put("transrc", DIRECT_DECLARE);
                paramMap.put("businessId", sbbid);
                paramMap.put("type", type);
                String skssqq = customMap.getString("skssqq");
                String skssqz = customMap.getString("skssqz");
                paramMap.put("skssqq", skssqq);
                paramMap.put("skssqz", skssqz);
                paramMap.put("nsrsbh", customMap.getString("nsrsbh"));
                if (DIRECT_DECLARE.equals(event.getCallBackId())) {
                    paramMap.put("operationType", "declare");
                } else if (DIRECT_PAY.equals(event.getCallBackId())) {
                    paramMap.put("operationType", DIRECT_PAY);
                }
                String dqdm = CommonInfoUtil.getAreaInfo((String)paramMap.get("nsrsbh").toString(), (String)"number");
                if (StringUtils.isNotBlank((CharSequence)dqdm)) {
                    paramMap.put("sbdq", dqdm);
                }
                try {
                    DynamicObject recordObj;
                    DynamicObject[] recordLog;
                    DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(sbbid), (String)"tcvat_nsrxx");
                    if (DIRECT_DECLARE.equals(event.getCallBackId())) {
                        declare.set("declarestatus", (Object)"declaring");
                        recordLog = TaxDeclareQueryListPlugin.assembleDeclareRecord(customMap.getLong(ORGID_KEY), type, DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz), "1");
                        recordObj = recordLog[0];
                        paramMap.put("id", recordObj.getLong("id"));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{declare});
                        paramMap.put("key", event.getCallBackId());
                        JobUtils.submitJob(paramMap);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u7533\u62a5\uff01", (String)"TaxDeclareQueryListPlugin_38", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    } else if (DIRECT_PAY.equals(event.getCallBackId())) {
                        declare.set("paystatus", (Object)"paying");
                        recordLog = TaxDeclareQueryListPlugin.assembleDeclareRecord(customMap.getLong(ORGID_KEY), type, DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz), "2");
                        recordObj = recordLog[0];
                        paramMap.put("id", recordObj.getLong("id"));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{declare});
                        paramMap.put("key", event.getCallBackId());
                        JobUtils.submitJob(paramMap);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u7f34\u6b3e\uff01", (String)"TaxDeclareQueryListPlugin_39", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                        DeclareMQSender.sendMQ((DynamicObject)declare, (Date)TaxDeclareQueryListPlugin.getPayDate(declare), (String)DeclareMQType.PAY.name(), (String)DIRECT_PAY);
                    }
                    BillList billlist2 = (BillList)this.getControl(BILL_LIST);
                    billlist2.refresh();
                }
                catch (Exception e) {
                    LOGGER.error("invokeBizSerivce error:" + e);
                }
            }
        }
        if ((INVALID.equals(event.getCallBackId()) || RECTIFY.equals(event.getCallBackId())) && event.getResult() == MessageBoxResult.Yes) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            String keyStr = INVALID.equals(event.getCallBackId()) ? ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"TaxDeclareQueryListPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u66f4\u6b63", (String)"TaxDeclareQueryListPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            customParams.put("customCaption", String.format(ResManager.loadKDString((String)"%s\u7533\u62a5", (String)"TaxDeclareQueryListPlugin_40", (String)"taxc-bdtaxr", (Object[])new Object[0]), keyStr));
            customParams.put("inputType", event.getCallBackId());
            BillList billlist3 = (BillList)this.getControl(BILL_LIST);
            ListSelectedRowCollection list2 = billlist3.getSelectedRows();
            Object[] pkIds2 = list2.getPrimaryKeyValues();
            customParams.put("pkid", pkIds2[0]);
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"bdtaxr_declare_msg_input", (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    private void showDeclarePage(String type, Map<String, Object> customParams, String declarestatus, DynamicObject object) {
        String billstatus;
        FormShowParameter param = new FormShowParameter();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        String datatype = object != null ? object.getString("datatype") : null;
        String string = billstatus = object != null ? object.getString("billstatus") : null;
        if ("ccxws".equals(type)) {
            if ("declared".equals(declarestatus) || "2".equals(datatype)) {
                if ("2".equals(datatype) && "A".equals(billstatus)) {
                    param.setFormId("tcret_declare_import_edit");
                } else {
                    param.setFormId(templateEnum.getDeclareShowPage());
                    param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
                }
            } else {
                param.setFormId(templateEnum.getDeclarePage());
            }
        } else if ("declared".equals(declarestatus)) {
            param.setFormId(templateEnum.getDeclareShowPage());
            param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
            DeclareCustomParamsHelper.setDeclareRequestData((DynamicObject)object, customParams);
        } else {
            param.setFormId(templateEnum.getDeclarePage());
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    private static DynamicObject[] assembleDeclareRecord(Long orgId, String type, Date skssqq, Date skssqz, String executeType2) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_record");
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        dynamicObject.set("org", (Object)orgId);
        dynamicObject.set("skssqq", (Object)skssqq);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
        dynamicObject.set("executestatus", (Object)"1");
        dynamicObject.set("skssqz", (Object)skssqz);
        dynamicObject.set("type", (Object)type);
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("executetype", (Object)executeType2);
        DynamicObject[] objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        dynamicObject = objs[0];
        String number = codeRuleService.getNumber("tsate_declare_record", dynamicObject, null);
        dynamicObject.set("billno", (Object)number);
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private void calcElement(List<DynamicObject> modifyDynamicObjects, String act) {
    }

    private static Date getPayDate(DynamicObject modifyob) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bdtaxr_pay_record", (String)"paydate", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)modifyob.getString("id"))});
        return null == obj ? null : obj.getDate("paydate");
    }

    private void setPayStatus(BigDecimal bqybtse, DynamicObject declare, String appId) {
        String type = declare.getString("type");
        String declareAppId = this.getAppId(type, appId);
        if ("tcvat".equals(declareAppId) || "tccit".equals(declareAppId) || "szys_a".equals(type) || "szys_b".equals(type)) {
            if (BigDecimal.ONE.compareTo(bqybtse) >= 0) {
                declare.set("paystatus", (Object)"nopay");
            }
        } else if ("tcret".equals(declareAppId)) {
            DynamicObjectCollection entryentity = declare.getDynamicObjectCollection("entryentity");
            Map<String, List<DynamicObject>> taxtypeMap = entryentity.stream().collect(Collectors.groupingBy(o -> o.getString("taxtype")));
            boolean allLessOne = true;
            for (List<DynamicObject> datums : taxtypeMap.values()) {
                BigDecimal ybse = datums.stream().map(o -> o.getBigDecimal("ybse")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                allLessOne = allLessOne && BigDecimal.ONE.compareTo(ybse) >= 0;
            }
            if (allLessOne) {
                declare.set("paystatus", (Object)"nopay");
            }
        } else if (BigDecimal.ZERO.compareTo(bqybtse) >= 0) {
            declare.set("paystatus", (Object)"nopay");
        }
    }

    private String getAppId(String declareType, String appId) {
        if ("tam".equals(appId) && (appId = Arrays.stream(TaxTypeEnum.values()).filter(e -> Arrays.asList(e.getTemplates()).contains(declareType) && !"tam".equals(e.getAppId()) && !"tsate".equals(e.getAppId())).map(TaxTypeEnum::getAppId).findFirst().orElse(appId)).contains("_")) {
            appId = appId.substring(0, appId.indexOf("_"));
        }
        return appId;
    }
}

