/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare.vo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;

public class MultiTctrcwarningVo {
    private static Log LOGGER = LogFactory.getLog(MultiTctrcwarningVo.class);
    private boolean haslicense;
    private String id;
    private String title;
    private String tip;
    private String metricsType;
    private String indexValue;
    private String targetValue;
    private List<Map<String, String>> involvingData;

    public MultiTctrcwarningVo(boolean haslicense, String id, String title, String tip, String metricsType, String indexValue, String targetValue, List<Map<String, String>> involvingData) {
        this.haslicense = haslicense;
        this.id = id;
        this.title = title;
        this.tip = tip;
        this.metricsType = metricsType;
        this.indexValue = indexValue;
        this.targetValue = targetValue;
        this.involvingData = involvingData;
    }

    public static List<MultiTctrcwarningVo> createMultiTctrcwarningVoList(List<Map<String, String>> tctrcResultMapList, boolean haslicense) {
        ArrayList<MultiTctrcwarningVo> multiTctrcwarningVoList = new ArrayList<MultiTctrcwarningVo>(16);
        if (CollectionUtils.isEmpty(tctrcResultMapList)) {
            return multiTctrcwarningVoList;
        }
        for (Map<String, String> map : tctrcResultMapList) {
            String id = map.getOrDefault("id", "0");
            String title = map.getOrDefault("title", "");
            String tip = map.getOrDefault("tip", "");
            String metricsType = map.getOrDefault("metricsType", "-1");
            String indexValue = map.getOrDefault("indexValue", "");
            String targetValue = map.getOrDefault("targetValue", "");
            List<Map<String, String>> involvingData = MultiTctrcwarningVo.parseInvolvingData(map.get("involvingData"));
            MultiTctrcwarningVo multiTctrcwarningVo = new MultiTctrcwarningVo(haslicense, id, title, tip, metricsType, indexValue, targetValue, involvingData);
            multiTctrcwarningVoList.add(multiTctrcwarningVo);
        }
        return multiTctrcwarningVoList;
    }

    public static List<Map<String, String>> parseInvolvingData(String jsonStr) {
        if (jsonStr == null || jsonStr.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            return (List)JSON.parseObject((String)jsonStr, (TypeReference)new TypeReference<List<Map<String, String>>>(){}, (Feature[])new Feature[0]);
        }
        catch (JSONException e) {
            LOGGER.error("parse json data error: " + e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public MultiTctrcwarningVo() {
    }

    public boolean getHaslicense() {
        return this.haslicense;
    }

    public void setHaslicense(boolean haslicense) {
        this.haslicense = haslicense;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTip() {
        return this.tip;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public String getMetricsType() {
        return this.metricsType;
    }

    public void setMetricsType(String metricsType) {
        this.metricsType = metricsType;
    }

    public String getIndexValue() {
        return this.indexValue;
    }

    public void setIndexValue(String indexValue) {
        this.indexValue = indexValue;
    }

    public String getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    public List<Map<String, String>> getInvolvingData() {
        return this.involvingData;
    }

    public void setInvolvingData(List<Map<String, String>> involvingData) {
        this.involvingData = involvingData;
    }
}

